/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.dlna.protocolinfo.DLNAOrgFlags;
import net.pms.dlna.protocolinfo.ProtocolInfo;
import net.pms.dlna.protocolinfo.ProtocolInfoAttribute;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.support.model.Protocol;

public abstract class DLNAOrgOperations
implements ProtocolInfoAttribute {
    private static final long serialVersionUID = 1L;
    public static final ProtocolInfoAttributeName NAME = ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_OP;
    public static final DLNAOrgOperationsFactory FACTORY = new DLNAOrgOperationsFactory();
    protected final byte state;

    protected DLNAOrgOperations(boolean flagA, boolean flagB) {
        this.state = DLNAOrgOperations.packFlags(flagA, flagB);
    }

    @Override
    public ProtocolInfoAttributeName getName() {
        return NAME;
    }

    @Override
    public String getNameString() {
        return NAME.getName();
    }

    @Override
    public String getValue() {
        return this.state > 0 ? ((this.state & 2) > 0 ? "1" : "0") + ((this.state & 1) > 0 ? "1" : "0") : "";
    }

    @Override
    public String getAttributeString() {
        String result = this.getValue();
        return StringUtils.isBlank(result) ? "" : String.valueOf(NAME) + "=" + result;
    }

    public boolean validate(DLNAOrgFlags flags) {
        return flags == null || this.state <= 0 || !flags.isS0Increasing() && !flags.isLimitedOperationsTimeBasedSeek() && !flags.isLimitedOperationsByteBasedSeek();
    }

    public boolean validate(ProtocolInfo protocolInfo) {
        return this.validate(protocolInfo.getFlags());
    }

    protected static byte packFlags(boolean flagA, boolean flagB) {
        return (byte)((flagA ? 2 : 0) | (flagB ? 1 : 0));
    }

    public static class DLNAOrgOperationsFactory {
        protected static final Pattern STRING_PATTERN = Pattern.compile("^\\s*([01])([01])\\s*$");

        protected DLNAOrgOperationsFactory() {
        }

        public DLNAOrgOperations getOperations(Protocol protocol, String value) throws ParseException {
            if (protocol == null) {
                return null;
            }
            if (StringUtils.isBlank(value)) {
                return this.getOperations(protocol, false, false);
            }
            Matcher matcher = STRING_PATTERN.matcher(value);
            if (!matcher.find()) {
                throw new ParseException("Unable to parse \"" + value + "\" as a DLNA operations value");
            }
            return this.getOperations(protocol, "1".equals(matcher.group(1)), "1".equals(matcher.group(2)));
        }

        public DLNAOrgOperations getOperations(Protocol protocol, DLNAOrgOperationsFlags ... flags) {
            boolean flagA = false;
            boolean flagB = false;
            if (flags != null && protocol == Protocol.HTTP_GET) {
                for (DLNAOrgOperationsFlags flag : flags) {
                    flagA = flag == DLNAOrgOperationsFlags.TIME_SEEK;
                    flagB = flag == DLNAOrgOperationsFlags.HEADER;
                }
            } else if (flags != null && protocol == Protocol.RTSP_RTP_UDP) {
                for (DLNAOrgOperationsFlags flag : flags) {
                    flagA = flag == DLNAOrgOperationsFlags.HEADER;
                }
            } else {
                return null;
            }
            return this.getOperations(protocol, flagA, flagB);
        }

        public DLNAOrgOperations getOperations(Protocol protocol, boolean flagA, boolean flagB) {
            if (protocol == Protocol.HTTP_GET) {
                return switch (DLNAOrgOperations.packFlags(flagA, flagB)) {
                    case 1 -> DLNAOrgOperationsHTTP.HTTP_HEADER;
                    case 2 -> DLNAOrgOperationsHTTP.HTTP_TIME_SEEK;
                    case 3 -> DLNAOrgOperationsHTTP.HTTP_BOTH;
                    default -> DLNAOrgOperationsHTTP.NONE;
                };
            }
            if (protocol == Protocol.RTSP_RTP_UDP) {
                return switch (DLNAOrgOperations.packFlags(flagA, flagB)) {
                    case 2 -> DLNAOrgOperationsRTP.RTP_HEADER;
                    default -> DLNAOrgOperationsRTP.NONE;
                };
            }
            return null;
        }
    }

    public static enum DLNAOrgOperationsFlags {
        TIME_SEEK,
        HEADER;

    }

    public static class DLNAOrgOperationsRTP
    extends DLNAOrgOperations {
        private static final long serialVersionUID = 1L;
        public static final DLNAOrgOperations NONE = new DLNAOrgOperationsRTP(false);
        public static final DLNAOrgOperations RTP_HEADER = new DLNAOrgOperationsRTP(true);

        protected DLNAOrgOperationsRTP(boolean rangeHeader) {
            super(rangeHeader, false);
        }
    }

    public static class DLNAOrgOperationsHTTP
    extends DLNAOrgOperations {
        private static final long serialVersionUID = 1L;
        public static final DLNAOrgOperations NONE = new DLNAOrgOperationsHTTP(false, false);
        public static final DLNAOrgOperations HTTP_TIME_SEEK = new DLNAOrgOperationsHTTP(true, false);
        public static final DLNAOrgOperations HTTP_HEADER = new DLNAOrgOperationsHTTP(false, true);
        public static final DLNAOrgOperations HTTP_BOTH = new DLNAOrgOperationsHTTP(true, true);

        protected DLNAOrgOperationsHTTP(boolean timeSeekRange, boolean rangeHttpHeader) {
            super(timeSeekRange, rangeHttpHeader);
        }
    }
}

