/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableVideoMetadataAwards
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadataAwards.class);
    public static final String TABLE_NAME = "VIDEO_METADATA_AWARDS";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_AWARD = "AWARD";
    private static final String TABLE_COL_FILEID = "VIDEO_METADATA_AWARDS.FILEID";
    private static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA_AWARDS.TVSERIESID";
    private static final String TABLE_COL_AWARD = "VIDEO_METADATA_AWARDS.AWARD";
    private static final String SQL_GET_AWARD_FILEID = "SELECT VIDEO_METADATA_AWARDS.AWARD FROM VIDEO_METADATA_AWARDS WHERE VIDEO_METADATA_AWARDS.FILEID = ? LIMIT 1";
    private static final String SQL_GET_AWARD_TVSERIESID = "SELECT VIDEO_METADATA_AWARDS.AWARD FROM VIDEO_METADATA_AWARDS WHERE VIDEO_METADATA_AWARDS.TVSERIESID = ? LIMIT 1";
    private static final String SQL_GET_TVSERIESID_EXISTS = "SELECT ID FROM VIDEO_METADATA_AWARDS WHERE VIDEO_METADATA_AWARDS.TVSERIESID = ? AND VIDEO_METADATA_AWARDS.AWARD = ? LIMIT 1";
    private static final String SQL_GET_FILEID_EXISTS = "SELECT ID FROM VIDEO_METADATA_AWARDS WHERE VIDEO_METADATA_AWARDS.FILEID = ? AND VIDEO_METADATA_AWARDS.AWARD = ? LIMIT 1";
    private static final String SQL_INSERT_TVSERIESID = "INSERT INTO VIDEO_METADATA_AWARDS (TVSERIESID, AWARD) VALUES (?, ?)";
    private static final String SQL_INSERT_FILEID = "INSERT INTO VIDEO_METADATA_AWARDS (FILEID, AWARD) VALUES (?, ?)";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadataAwards.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableVideoMetadataAwards.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableVideoMetadataAwards.dropTable(connection, TABLE_NAME);
                MediaTableVideoMetadataAwards.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableVideoMetadataAwards.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "DROP INDEX IF EXISTS FILENAME_AWARD_TVSERIESID_IDX");
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS ADD COLUMN IF NOT EXISTS FILEID INTEGER");
                    if (MediaTableVideoMetadataAwards.isColumnExist(connection, TABLE_NAME, "FILENAME")) {
                        MediaTableVideoMetadataAwards.executeUpdate(connection, "UPDATE VIDEO_METADATA_AWARDS SET FILEID = (SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = VIDEO_METADATA_AWARDS.FILENAME) WHERE VIDEO_METADATA_AWARDS.FILENAME != ''");
                        MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS DROP COLUMN IF EXISTS FILENAME");
                    }
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS ALTER COLUMN IF EXISTS TVSERIESID DROP  DEFAULT ");
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "UPDATE VIDEO_METADATA_AWARDS SET FILEID = NULL WHERE VIDEO_METADATA_AWARDS.FILEID = -1");
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "UPDATE VIDEO_METADATA_AWARDS SET TVSERIESID = NULL WHERE VIDEO_METADATA_AWARDS.TVSERIESID = -1");
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS ADD CONSTRAINT VIDEO_METADATA_AWARDS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE");
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS ADD CONSTRAINT VIDEO_METADATA_AWARDS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE");
                    continue block4;
                }
                case 2: {
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS ALTER COLUMN IF EXISTS FILEID BIGINT");
                    MediaTableVideoMetadataAwards.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_AWARDS ALTER COLUMN IF EXISTS TVSERIESID BIGINT");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadataAwards.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadataAwards.execute(connection, "CREATE TABLE VIDEO_METADATA_AWARDS(ID IDENTITY PRIMARY KEY, TVSERIESID BIGINT, FILEID BIGINT, AWARD VARCHAR(1024) NOT NULL, CONSTRAINT VIDEO_METADATA_AWARDS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE, CONSTRAINT VIDEO_METADATA_AWARDS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)");
    }

    public static void set(Connection connection, Long fileId, String awards, Long tvSeriesID) {
        block33: {
            long id;
            String sqlInsert;
            String sqlSelect;
            if (StringUtils.isBlank(awards)) {
                return;
            }
            if (tvSeriesID != null) {
                sqlSelect = SQL_GET_TVSERIESID_EXISTS;
                sqlInsert = SQL_INSERT_TVSERIESID;
                id = tvSeriesID;
            } else if (fileId != null) {
                sqlSelect = SQL_GET_FILEID_EXISTS;
                sqlInsert = SQL_INSERT_FILEID;
                id = fileId;
            } else {
                return;
            }
            try (PreparedStatement ps = connection.prepareStatement(sqlSelect);){
                ps.setLong(1, id);
                ps.setString(2, StringUtils.left(awards, 1024));
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        LOGGER.trace("Record already exists {} {} {}", tvSeriesID, fileId, awards);
                        break block33;
                    }
                    try (PreparedStatement insertStatement = connection.prepareStatement(sqlInsert, 1);){
                        insertStatement.clearParameters();
                        insertStatement.setLong(1, id);
                        insertStatement.setString(2, StringUtils.left(awards, 1024));
                        insertStatement.executeUpdate();
                        try (ResultSet rs2 = insertStatement.getGeneratedKeys();){
                            if (rs2.next()) {
                                LOGGER.trace("Set new entry successfully in VIDEO_METADATA_AWARDS with \"{}\", \"{}\" and \"{}\"", fileId, tvSeriesID, awards);
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, fileId, e.getMessage());
                LOGGER.trace("", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getValueForFile(Connection connection, Long fileId) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_AWARD_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_AWARDS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getValueForTvSeries(Connection connection, Long tvSerieId) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_AWARD_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_AWARDS for \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }
}

