/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.SQLException;
import net.pms.Messages;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableRegexpRules
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableRegexpRules.class);
    public static final String TABLE_NAME = "REGEXP_RULES";
    private static final int TABLE_VERSION = 2;
    private static final String COL_ID = "ID";
    private static final String COL_REGEXP_RULE = "REGEXP_RULE";
    private static final String COL_REGEXP_ORDER = "REGEXP_ORDER";
    public static final String TABLE_COL_ID = "REGEXP_RULES.ID";
    public static final String TABLE_COL_REGEXP_ORDER = "REGEXP_RULES.REGEXP_ORDER";
    public static final String TABLE_COL_REGEXP_RULE = "REGEXP_RULES.REGEXP_RULE";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableRegexpRules.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 2) {
                MediaTableRegexpRules.upgradeTable(connection, version);
            } else if (version > 2) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableRegexpRules.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 2);
        block5: for (int version = currentVersion.intValue(); version < 2; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    if (MediaTableRegexpRules.isColumnExist(connection, TABLE_NAME, "RULE")) {
                        LOGGER.trace("Renaming column name RULE to REGEXP_RULE");
                        MediaTableRegexpRules.executeUpdate(connection, "ALTER TABLE REGEXP_RULES ALTER COLUMN `RULE` RENAME TO REGEXP_RULE");
                    }
                    if (!MediaTableRegexpRules.isColumnExist(connection, TABLE_NAME, "ORDR")) continue block5;
                    LOGGER.trace("Renaming column name ORDR to REGEXP_ORDER");
                    MediaTableRegexpRules.executeUpdate(connection, "ALTER TABLE REGEXP_RULES ALTER COLUMN `ORDR` RENAME TO REGEXP_ORDER");
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(MediaTableRegexpRules.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 2));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.debug("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableRegexpRules.execute(connection, "CREATE TABLE REGEXP_RULES ( ID VARCHAR(255) PRIMARY KEY, REGEXP_RULE VARCHAR(255), REGEXP_ORDER NUMERIC)", "INSERT INTO REGEXP_RULES VALUES ( '###', '(?i)^\\W.+', 0 )", "INSERT INTO REGEXP_RULES VALUES ( '0-9', '(?i)^\\d.+', 1 )");
        String[] chars = Messages.getConfigurationString("Alphabet").split(",");
        for (int i = 0; i < chars.length; ++i) {
            MediaTableRegexpRules.executeUpdate(connection, "INSERT INTO REGEXP_RULES VALUES ( '" + chars[i] + "', '(?i)^" + chars[i] + ".+', " + (i + 2) + " );");
        }
    }
}

