/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.UUID;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.external.musicbrainz.api.MusicBrainzTagInfo;
import net.pms.media.audio.metadata.MusicBrainzAlbum;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableMusicBrainzReleases
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableMusicBrainzReleases.class);
    public static final String TABLE_NAME = "MUSIC_BRAINZ_RELEASES";
    private static final int TABLE_VERSION = 5;
    private static final String COL_ID = "ID";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_MBID = "MBID";
    private static final String COL_ARTIST = "ARTIST";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_MEDIA_YEAR = "MEDIA_YEAR";
    private static final String COL_GENRE = "GENRE";
    private static final String COL_ARTIST_ID = "ARTIST_ID";
    private static final String COL_RATING = "RATING";
    private static final String SQL_GET_MBID = "SELECT * FROM MUSIC_BRAINZ_RELEASES WHERE MBID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableMusicBrainzReleases.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 5) {
                    MediaTableMusicBrainzReleases.upgradeTable(connection, version);
                } else if (version > 5) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableMusicBrainzReleases.dropTable(connection, TABLE_NAME);
                MediaTableMusicBrainzReleases.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 5);
            }
        } else {
            MediaTableMusicBrainzReleases.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 5);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 5);
        block6: for (int version = currentVersion; version < 5; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ALTER COLUMN IF EXISTS ARTIST VARCHAR(1000)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ALTER COLUMN IF EXISTS TITLE VARCHAR(1000)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ALTER COLUMN IF EXISTS `YEAR` VARCHAR(20)");
                    continue block6;
                }
                case 2: {
                    if (!MediaTableMusicBrainzReleases.isColumnExist(connection, TABLE_NAME, "YEAR")) continue block6;
                    LOGGER.trace("Renaming column name YEAR to MEDIA_YEAR");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ALTER COLUMN IF EXISTS `YEAR` RENAME TO MEDIA_YEAR");
                    continue block6;
                }
                case 3: {
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ALTER COLUMN IF EXISTS MBID UUID");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ALTER COLUMN IF EXISTS ARTIST_ID UUID");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ADD COLUMN IF NOT EXISTS GENRE VARCHAR(1000)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES ADD COLUMN IF NOT EXISTS RATING INTEGER");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES DROP COLUMN IF EXISTS TRACK_ID");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "ALTER TABLE MUSIC_BRAINZ_RELEASES DROP COLUMN IF EXISTS ALBUM");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_MBID_IDX ON MUSIC_BRAINZ_RELEASES(MBID)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_GENRE_IDX ON MUSIC_BRAINZ_RELEASES(GENRE)");
                    continue block6;
                }
                case 4: {
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "DROP INDEX IF EXISTS ARTIST_IDX");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "DROP INDEX IF EXISTS ARTIST_ID_IDX");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "DROP INDEX IF EXISTS MBID_IDX");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "DROP INDEX IF EXISTS GENRE_IDX");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_ARTIST_IDX ON MUSIC_BRAINZ_RELEASES(ARTIST)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_ARTIST_ID_IDX ON MUSIC_BRAINZ_RELEASES(ARTIST_ID)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_MBID_IDX ON MUSIC_BRAINZ_RELEASES(MBID)");
                    MediaTableMusicBrainzReleases.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_GENRE_IDX ON MUSIC_BRAINZ_RELEASES(GENRE)");
                    continue block6;
                }
                default: {
                    throw new IllegalStateException(MediaTableMusicBrainzReleases.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 5));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 5);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.debug("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableMusicBrainzReleases.execute(connection, "CREATE TABLE MUSIC_BRAINZ_RELEASES(ID IDENTITY, MODIFIED TIMESTAMP, MBID UUID, ARTIST VARCHAR(1000), TITLE VARCHAR(1000), MEDIA_YEAR VARCHAR(20), GENRE VARCHAR(1000), ARTIST_ID UUID, RATING INTEGER)", "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_ARTIST_IDX ON MUSIC_BRAINZ_RELEASES(ARTIST)", "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_ARTIST_ID_IDX ON MUSIC_BRAINZ_RELEASES(ARTIST_ID)", "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_MBID_IDX ON MUSIC_BRAINZ_RELEASES(MBID)", "CREATE INDEX IF NOT EXISTS MUSIC_BRAINZ_RELEASES_GENRE_IDX ON MUSIC_BRAINZ_RELEASES(GENRE)");
    }

    private static String constructTagWhere(MusicBrainzTagInfo tagInfo, boolean includeAll) {
        StringBuilder where = new StringBuilder(" WHERE ");
        String and = " AND ";
        boolean added = false;
        if (includeAll || StringUtil.hasValue(tagInfo.artistId)) {
            where.append(COL_ARTIST_ID).append(MediaTableMusicBrainzReleases.sqlNullIfBlank(tagInfo.artistId, true, false));
            added = true;
        }
        if (includeAll || !StringUtil.hasValue(tagInfo.artistId) && StringUtil.hasValue(tagInfo.artist)) {
            if (added) {
                where.append(" AND ");
            }
            where.append(COL_ARTIST).append(MediaTableMusicBrainzReleases.sqlNullIfBlank(tagInfo.artist, true, false));
            added = true;
        }
        if (includeAll || StringUtil.hasValue(tagInfo.title) && (StringUtil.hasValue(tagInfo.artist) || StringUtil.hasValue(tagInfo.artistId))) {
            if (added) {
                where.append(" AND ");
            }
            where.append(COL_TITLE).append(MediaTableMusicBrainzReleases.sqlNullIfBlank(tagInfo.title, true, false));
            added = true;
        }
        if (StringUtil.hasValue(tagInfo.year)) {
            if (added) {
                where.append(" AND ");
            }
            where.append(COL_MEDIA_YEAR).append(MediaTableMusicBrainzReleases.sqlNullIfBlank(tagInfo.year, true, false));
        }
        return where.toString();
    }

    public static void writeMBID(Connection connection, String mBID, MusicBrainzTagInfo tagInfo) {
        boolean trace = LOGGER.isTraceEnabled();
        try {
            String query = "SELECT * FROM MUSIC_BRAINZ_RELEASES" + MediaTableMusicBrainzReleases.constructTagWhere(tagInfo, true) + " LIMIT 1";
            if (trace) {
                LOGGER.trace("Searching for release MBID with \"{}\" before update", (Object)query);
            }
            try (Statement statement = connection.createStatement(1005, 1008);
                 ResultSet result = statement.executeQuery(query);){
                if (result.next()) {
                    if (StringUtil.hasValue(mBID) || !StringUtil.hasValue(result.getString(COL_MBID))) {
                        if (trace) {
                            LOGGER.trace("Updating row {} to MBID \"{}\"", (Object)result.getInt(COL_ID), (Object)mBID);
                        }
                        result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                        if (StringUtil.hasValue(mBID)) {
                            result.updateString(COL_MBID, mBID);
                        } else {
                            result.updateNull(COL_MBID);
                        }
                        result.updateRow();
                    } else if (trace) {
                        LOGGER.trace("Leaving row {} alone since previous information seems better", (Object)result.getInt(COL_ID));
                    }
                } else {
                    if (trace) {
                        LOGGER.trace("Inserting new row for MBID '{}':\n\tArtist    \"{}\"\n\tTitle     \"{}\"\n\tYear      \"{}\"\n\tArtist ID \"{}\"\n\tTrack ID  \"{}\"\n", mBID, tagInfo.artist, tagInfo.title, tagInfo.year, tagInfo.artistId, tagInfo.trackId);
                    }
                    result.moveToInsertRow();
                    result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                    if (StringUtil.hasValue(mBID)) {
                        result.updateString(COL_MBID, mBID);
                    }
                    if (StringUtil.hasValue(tagInfo.artist)) {
                        result.updateString(COL_ARTIST, StringUtils.left(tagInfo.artist, 1000));
                    }
                    if (StringUtil.hasValue(tagInfo.title)) {
                        result.updateString(COL_TITLE, StringUtils.left(tagInfo.title, 1000));
                    }
                    if (StringUtil.hasValue(tagInfo.year)) {
                        result.updateString(COL_MEDIA_YEAR, StringUtils.left(tagInfo.year, 20));
                    }
                    if (StringUtil.hasValue(tagInfo.artistId)) {
                        result.updateString(COL_ARTIST_ID, tagInfo.artistId);
                    }
                    result.insertRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\" for \"{}\": {}", "medias", "writing Music Brainz ID", mBID, TABLE_NAME, tagInfo, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static MusicBrainzReleasesResult findMBID(Connection connection, MusicBrainzTagInfo tagInfo) {
        MusicBrainzReleasesResult result;
        boolean trace = LOGGER.isTraceEnabled();
        try {
            String query = "SELECT MBID, MODIFIED FROM MUSIC_BRAINZ_RELEASES" + MediaTableMusicBrainzReleases.constructTagWhere(tagInfo, false) + " LIMIT 1";
            if (trace) {
                LOGGER.trace("Searching for release MBID with \"{}\"", (Object)query);
            }
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(query);){
                result = resultSet.next() ? new MusicBrainzReleasesResult(true, resultSet.getTimestamp(COL_MODIFIED), resultSet.getString(COL_MBID)) : new MusicBrainzReleasesResult(false, null, null);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "looking up Music Brainz ID", TABLE_NAME, tagInfo, e.getMessage());
            LOGGER.trace("", e);
            result = new MusicBrainzReleasesResult();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MusicBrainzAlbum getMusicBrainzAlbum(String mbid) {
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();
             PreparedStatement updateStatement = connection.prepareStatement(SQL_GET_MBID, 1003);){
            UUID mbidRecord = UUID.fromString(StringUtils.trimToEmpty(mbid));
            updateStatement.setObject(1, mbidRecord);
            try (ResultSet rs = updateStatement.executeQuery();){
                if (rs.next()) {
                    MusicBrainzAlbum musicBrainzAlbum = new MusicBrainzAlbum(mbid, rs.getString(COL_TITLE), rs.getString(COL_ARTIST), rs.getString(COL_MEDIA_YEAR), rs.getString(COL_GENRE));
                    return musicBrainzAlbum;
                }
                LOGGER.debug("mbid not found in database : " + mbid);
                return null;
            }
        }
        catch (SQLException e) {
            LOGGER.error("getMusicBrainzAlbum : Database error in MUSIC_BRAINZ_RELEASES for \"{}\": {}", (Object)mbid, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static void storeMusicBrainzAlbum(MusicBrainzAlbum album) {
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();
             PreparedStatement updateStatement = connection.prepareStatement(SQL_GET_MBID, 1003, 1008);){
            UUID mbidRecord = UUID.fromString(StringUtils.trimToEmpty(album.getMbReleaseid()));
            updateStatement.setObject(1, mbidRecord);
            try (ResultSet rs = updateStatement.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !rs.next();
                if (isCreatingNewRecord) {
                    rs.moveToInsertRow();
                }
                MediaTableMusicBrainzReleases.updateAudioMetadata(rs, album);
                if (isCreatingNewRecord) {
                    rs.insertRow();
                } else {
                    rs.updateRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in MUSIC_BRAINZ_RELEASES for \"{}\": {}", (Object)album, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    private static void updateAudioMetadata(ResultSet result, MusicBrainzAlbum album) throws SQLException {
        try {
            UUID mbidRecord = UUID.fromString(StringUtils.trimToEmpty(album.getMbReleaseid()));
            result.updateObject(COL_MBID, (Object)mbidRecord);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("invalid UUID. Cannot add album information.", e);
            return;
        }
        MediaTableMusicBrainzReleases.updateString(result, COL_ARTIST, album.getArtist(), 1000);
        MediaTableMusicBrainzReleases.updateString(result, COL_TITLE, album.getAlbum(), 1000);
        MediaTableMusicBrainzReleases.updateString(result, COL_MEDIA_YEAR, album.getYear(), 1000);
        MediaTableMusicBrainzReleases.updateString(result, COL_GENRE, album.getGenre(), 1000);
    }

    public static class MusicBrainzReleasesResult {
        private final boolean found;
        private final Timestamp modified;
        private final String mBID;

        public MusicBrainzReleasesResult() {
            this(false, null, null);
        }

        public MusicBrainzReleasesResult(boolean found, Timestamp modified, String mBID) {
            this.found = found;
            this.modified = modified;
            this.mBID = mBID;
        }

        public boolean isFound() {
            return this.found;
        }

        public long getModifiedTime() {
            return this.modified.getTime();
        }

        public boolean hasMusicBrainzId() {
            return StringUtils.isNotBlank(this.mBID);
        }

        public String getMusicBrainzId() {
            return this.mBID;
        }
    }
}

