/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableAudiotracks
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableAudiotracks.class);
    public static final String TABLE_NAME = "AUDIOTRACKS";
    private static final int TABLE_VERSION = 13;
    private static final String COL_ID = "ID";
    public static final String COL_FILEID = "FILEID";
    private static final String COL_LANG = "LANG";
    private static final String COL_STREAMID = "STREAMID";
    private static final String COL_DEFAULT_FLAG = "DEFAULT_FLAG";
    private static final String COL_FORCED_FLAG = "FORCED_FLAG";
    private static final String COL_OPTIONALID = "OPTIONALID";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_CODEC = "CODEC";
    private static final String COL_VIDEODELAY = "VIDEODELAY";
    private static final String COL_MUXINGMODE = "MUXINGMODE";
    private static final String COL_BITRATE = "BITRATE";
    private static final String COL_SAMPLERATE = "SAMPLERATE";
    private static final String COL_BITDEPTH = "BITDEPTH";
    private static final String COL_NRAUDIOCHANNELS = "NRAUDIOCHANNELS";
    public static final String TABLE_COL_ID = "AUDIOTRACKS.ID";
    public static final String TABLE_COL_FILEID = "AUDIOTRACKS.FILEID";
    private static final String SQL_GET_ALL_FILEID = "SELECT * FROM AUDIOTRACKS WHERE AUDIOTRACKS.FILEID = ?";
    private static final String SQL_GET_ALL_FILEID_ID = "SELECT * FROM AUDIOTRACKS WHERE AUDIOTRACKS.FILEID = ? AND AUDIOTRACKS.ID = ?";
    private static final String SQL_DELETE_BY_FILEID_ID_GREATER_OR_EQUAL = "DELETE FROM AUDIOTRACKS WHERE AUDIOTRACKS.FILEID = ? AND AUDIOTRACKS.ID >= ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableAudiotracks.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 13) {
                MediaTableAudiotracks.upgradeTable(connection, version);
            } else if (version > 13) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS.", (Object)"medias", (Object)TABLE_NAME);
            }
        } else {
            MediaTableAudiotracks.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 13);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 13);
        block11: for (int version = currentVersion.intValue(); version < 13; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: 
                case 2: {
                    continue block11;
                }
                case 3: {
                    MediaTableAudiotracks.executeUpdate(connection, "DROP INDEX IF EXISTS IDXYEAR");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS DROP COLUMN IF EXISTS `YEAR`");
                    continue block11;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    continue block11;
                }
                case 8: {
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS RENAME CONSTRAINT IF EXISTS PKAUDIO TO AUDIOTRACKS_PK");
                    continue block11;
                }
                case 9: 
                case 10: {
                    continue block11;
                }
                case 11: {
                    String[] indexes;
                    for (String index : indexes = new String[]{"IDX_MBID", "IDXALBUM", "IDXARTIST", "IDXALBUMARTIST", "IDXGENRE", "IDXRATING", "IDX_LIKE_SONG", "IDX_AUDIOTRACK_ID", "IDX_COMPOSER", "IDX_CONDUCTOR", "IDX_AUDIO_YEAR"}) {
                        MediaTableAudiotracks.executeUpdate(connection, "DROP INDEX IF EXISTS " + index);
                    }
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ALTER COLUMN IF EXISTS NRAUDIOCHANNELS SET DATA TYPE INTEGER");
                    continue block11;
                }
                case 12: {
                    if (MediaTableAudiotracks.isColumnExist(connection, TABLE_NAME, "CONDUCTOR")) {
                        MediaTableAudiotracks.executeUpdate(connection, "INSERT INTO AUDIO_METADATA (FILEID, ALBUM, ARTIST, ALBUMARTIST, SONGNAME, GENRE, MEDIA_YEAR, MBID_RECORD,MBID_TRACK, TRACK, DISC, RATING, COMPOSER, CONDUCTOR) SELECT FILEID, ALBUM, ARTIST, ALBUMARTIST, SONGNAME, GENRE, MEDIA_YEAR, MBID_RECORD,MBID_TRACK, TRACK, DISC, RATING, COMPOSER, CONDUCTOR FROM AUDIOTRACKS WHERE AUDIOTRACKS.ID = 0");
                        MediaTableAudiotracks.executeUpdate(connection, "DELETE FROM AUDIO_METADATA WHERE ALBUM = '' AND ARTIST = '' AND SONGNAME = '' AND GENRE = '' AND COMPOSER = '' AND CONDUCTOR = '' AND MEDIA_YEAR = 0 AND TRACK = 0 AND MBID_RECORD IS NULL AND MBID_TRACK IS NULL");
                    }
                    String[] columns = new String[]{"ALBUM", "ARTIST", "ALBUMARTIST", "SONGNAME", "GENRE", "MEDIA_YEAR", "MBID_RECORD", "MBID_TRACK", "TRACK", "DISC", "LIKE_SONG", "LIKESONG", "RATING", "COMPOSER", "CONDUCTOR"};
                    for (String column : columns) {
                        MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS DROP COLUMN IF EXISTS " + column);
                    }
                    for (String column : columns) {
                        MediaTableAudiotracks.executeUpdate(connection, "DROP INDEX IF EXISTS AUDIOTRACKS_" + column + "_IDX");
                    }
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ALTER COLUMN IF EXISTS DELAY RENAME TO VIDEODELAY");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ALTER COLUMN IF EXISTS CODECA RENAME TO CODEC");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ALTER COLUMN IF EXISTS BITSPERSAMPLE RENAME TO BITDEPTH");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ADD COLUMN IF NOT EXISTS SAMPLERATE INTEGER");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ADD COLUMN IF NOT EXISTS STREAMID INTEGER");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ADD COLUMN IF NOT EXISTS OPTIONALID BIGINT");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ADD COLUMN IF NOT EXISTS DEFAULT_FLAG BOOLEAN DEFAULT FALSE");
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS ADD COLUMN IF NOT EXISTS FORCED_FLAG BOOLEAN DEFAULT FALSE");
                    if (MediaTableAudiotracks.isColumnExist(connection, TABLE_NAME, "SAMPLEFREQ")) {
                        MediaTableAudiotracks.executeUpdate(connection, "UPDATE AUDIOTRACKS SET SAMPLERATE = CAST(SAMPLEFREQ AS INT)");
                    }
                    MediaTableAudiotracks.executeUpdate(connection, "ALTER TABLE AUDIOTRACKS DROP COLUMN IF EXISTS SAMPLEFREQ");
                    continue block11;
                }
                default: {
                    throw new IllegalStateException(MediaTableAudiotracks.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 13));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 13);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableAudiotracks.execute(connection, "CREATE TABLE AUDIOTRACKS (ID INTEGER NOT NULL, FILEID BIGINT NOT NULL, LANG VARCHAR(3), STREAMID INTEGER, OPTIONALID BIGINT, DEFAULT_FLAG BOOLEAN DEFAULT FALSE, FORCED_FLAG BOOLEAN DEFAULT FALSE, TITLE VARCHAR(255), NRAUDIOCHANNELS INTEGER, SAMPLERATE INTEGER, CODEC VARCHAR(32), BITDEPTH INTEGER, VIDEODELAY INTEGER, MUXINGMODE VARCHAR(32), BITRATE INTEGER, CONSTRAINT AUDIOTRACKS_PK PRIMARY KEY(FILEID, ID, LANG), CONSTRAINT AUDIOTRACKS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES FILES(ID) ON DELETE CASCADE)");
    }

    protected static void insertOrUpdateAudioTracks(Connection connection, long fileId, MediaInfo media) throws SQLException {
        if (connection == null || fileId < 0L || media == null) {
            return;
        }
        int trackCount = media.getAudioTrackCount();
        try (PreparedStatement updateStatment = connection.prepareStatement(SQL_DELETE_BY_FILEID_ID_GREATER_OR_EQUAL);){
            updateStatment.setLong(1, fileId);
            updateStatment.setInt(2, trackCount);
            updateStatment.executeUpdate();
        }
        if (trackCount == 0) {
            return;
        }
        updateStatment = connection.prepareStatement(SQL_GET_ALL_FILEID_ID, 1003, 1008);
        try {
            for (MediaAudio audioTrack : media.getAudioTracks()) {
                updateStatment.clearParameters();
                updateStatment.setLong(1, fileId);
                updateStatment.setInt(2, audioTrack.getId());
                ResultSet result = updateStatment.executeQuery();
                try {
                    boolean isCreatingNewRecord;
                    boolean bl = isCreatingNewRecord = !result.next();
                    if (isCreatingNewRecord) {
                        result.moveToInsertRow();
                        result.updateLong(COL_FILEID, fileId);
                        result.updateInt(COL_ID, audioTrack.getId());
                    }
                    MediaTableAudiotracks.updateAudioTrack(result, audioTrack);
                    if (isCreatingNewRecord) {
                        result.insertRow();
                        continue;
                    }
                    result.updateRow();
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
        }
        finally {
            if (updateStatment != null) {
                updateStatment.close();
            }
        }
    }

    private static void updateAudioTrack(ResultSet result, MediaAudio audioTrack) throws SQLException {
        MediaTableAudiotracks.updateInteger(result, COL_STREAMID, audioTrack.getStreamOrder());
        result.updateBoolean(COL_DEFAULT_FLAG, audioTrack.isDefault());
        result.updateBoolean(COL_FORCED_FLAG, audioTrack.isForced());
        if (audioTrack.getLang() == null) {
            result.updateString(COL_LANG, "");
        } else {
            MediaTableAudiotracks.updateString(result, COL_LANG, audioTrack.getLang(), 3);
        }
        result.updateString(COL_TITLE, StringUtils.left(audioTrack.getTitle(), 255));
        result.updateString(COL_CODEC, StringUtils.left(audioTrack.getCodec(), 32));
        MediaTableAudiotracks.updateLong(result, COL_OPTIONALID, audioTrack.getOptionalId());
        result.updateString(COL_MUXINGMODE, StringUtils.left(StringUtils.trimToEmpty(audioTrack.getMuxingMode()), 32));
        result.updateInt(COL_SAMPLERATE, audioTrack.getSampleRate());
        result.updateInt(COL_BITDEPTH, audioTrack.getBitDepth());
        result.updateInt(COL_NRAUDIOCHANNELS, audioTrack.getNumberOfChannels());
        result.updateInt(COL_VIDEODELAY, audioTrack.getVideoDelay());
        result.updateInt(COL_BITRATE, audioTrack.getBitRate());
    }

    protected static List<MediaAudio> getAudioTracks(Connection connection, long fileId) {
        ArrayList<MediaAudio> result = new ArrayList<MediaAudio>();
        if (connection == null || fileId < 0L) {
            return result;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_FILEID);){
            stmt.setLong(1, fileId);
            try (ResultSet elements = stmt.executeQuery();){
                while (elements.next()) {
                    MediaAudio audio = MediaTableAudiotracks.getAudioTrack(elements);
                    LOGGER.trace("Adding audio from the database: {}", (Object)audio.toString());
                    result.add(audio);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in AUDIOTRACKS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    private static MediaAudio getAudioTrack(ResultSet resultset) throws SQLException {
        MediaAudio audio = new MediaAudio();
        audio.setId(resultset.getInt(COL_ID));
        audio.setLang(resultset.getString(COL_LANG));
        audio.setStreamOrder(MediaTableAudiotracks.toInteger(resultset, COL_STREAMID));
        audio.setDefault(resultset.getBoolean(COL_DEFAULT_FLAG));
        audio.setForced(resultset.getBoolean(COL_FORCED_FLAG));
        audio.setOptionalId(MediaTableAudiotracks.toLong(resultset, COL_OPTIONALID));
        audio.setTitle(resultset.getString(COL_TITLE));
        audio.setNumberOfChannels(resultset.getInt(COL_NRAUDIOCHANNELS));
        audio.setSampleRate(resultset.getInt(COL_SAMPLERATE));
        audio.setCodec(resultset.getString(COL_CODEC));
        audio.setBitDepth(resultset.getInt(COL_BITDEPTH));
        audio.setVideoDelay(resultset.getInt(COL_VIDEODELAY));
        audio.setMuxingMode(resultset.getString(COL_MUXINGMODE));
        audio.setBitRate(resultset.getInt(COL_BITRATE));
        return audio;
    }
}

