/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.MediaInfo;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableAudioMetadata
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableAudioMetadata.class);
    public static final String TABLE_NAME = "AUDIO_METADATA";
    private static final int TABLE_VERSION = 2;
    public static final String COL_FILEID = "FILEID";
    private static final String COL_DISC = "DISC";
    public static final String COL_COMPOSER = "COMPOSER";
    public static final String COL_CONDUCTOR = "CONDUCTOR";
    private static final String COL_ALBUM = "ALBUM";
    private static final String COL_ARTIST = "ARTIST";
    private static final String COL_ALBUMARTIST = "ALBUMARTIST";
    private static final String COL_GENRE = "GENRE";
    private static final String COL_MEDIA_YEAR = "MEDIA_YEAR";
    private static final String COL_TRACK = "TRACK";
    private static final String COL_SONGNAME = "SONGNAME";
    private static final String COL_MBID_RECORD = "MBID_RECORD";
    private static final String COL_MBID_TRACK = "MBID_TRACK";
    private static final String COL_AUDIOTRACK_ID = "AUDIOTRACK_ID";
    private static final String COL_RATING = "RATING";
    public static final String TABLE_COL_FILEID = "AUDIO_METADATA.FILEID";
    public static final String TABLE_COL_MBID_RECORD = "AUDIO_METADATA.MBID_RECORD";
    public static final String TABLE_COL_MBID_TRACK = "AUDIO_METADATA.MBID_TRACK";
    public static final String TABLE_COL_MEDIA_YEAR = "AUDIO_METADATA.MEDIA_YEAR";
    public static final String TABLE_COL_GENRE = "AUDIO_METADATA.GENRE";
    public static final String TABLE_COL_ALBUM = "AUDIO_METADATA.ALBUM";
    public static final String TABLE_COL_TRACK = "AUDIO_METADATA.TRACK";
    public static final String TABLE_COL_ALBUMARTIST = "AUDIO_METADATA.ALBUMARTIST";
    public static final String TABLE_COL_ARTIST = "AUDIO_METADATA.ARTIST";
    public static final String TABLE_COL_COMPOSER = "AUDIO_METADATA.COMPOSER";
    public static final String TABLE_COL_CONDUCTOR = "AUDIO_METADATA.CONDUCTOR";
    private static final String TABLE_COL_RATING = "AUDIO_METADATA.RATING";
    public static final String REFERENCE_TABLE_COL_FILE_ID = "AUDIO_METADATA(FILEID)";
    private static final String SQL_GET_AUDIO_METADATA_BY_FILEID = "SELECT * FROM AUDIO_METADATA WHERE FILEID = ? LIMIT 1";
    private static final String SQL_GET_RATING_BY_MBID_TRACK = "SELECT AUDIO_METADATA.RATING FROM AUDIO_METADATA WHERE MBID_TRACK = ? LIMIT 1";
    private static final String SQL_UPDATE_RATING_BY_AUDIOTRACK_ID = "UPDATE AUDIO_METADATA SET RATING = ? WHERE AUDIOTRACK_ID = ?";
    private static final String SQL_UPDATE_RATING_BY_MBID_TRACK = "UPDATE AUDIO_METADATA SET RATING = ? WHERE MBID_TRACK = ?";
    private static final String SQL_GET_FILENAME_BY_AUDIOTRACK_ID = "SELECT FILES.FILENAME FROM FILES LEFT JOIN AUDIO_METADATA ON FILES.ID = AUDIO_METADATA.FILEID WHERE AUDIOTRACK_ID = ? LIMIT 1";
    private static final String SQL_GET_FILENAMES_BY_MBID_TRACK = "SELECT FILES.FILENAME FROM FILES LEFT JOIN AUDIO_METADATA ON FILES.ID = AUDIO_METADATA.FILEID WHERE MBID_TRACK = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableAudioMetadata.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 2) {
                MediaTableAudioMetadata.upgradeTable(connection, version);
            } else if (version > 2) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableAudioMetadata.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 2);
        block5: for (int version = currentVersion.intValue(); version < 2; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableAudioMetadata.executeUpdate(connection, "ALTER TABLE AUDIO_METADATA ALTER COLUMN IF EXISTS FILEID BIGINT");
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(MediaTableAudioMetadata.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 2));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableAudioMetadata.execute(connection, "CREATE TABLE AUDIO_METADATA (FILEID BIGINT PRIMARY KEY, AUDIOTRACK_ID INTEGER AUTO_INCREMENT, ALBUM VARCHAR(255), ARTIST VARCHAR(255), ALBUMARTIST VARCHAR(255), SONGNAME VARCHAR(255), GENRE VARCHAR(255), MEDIA_YEAR INTEGER, MBID_RECORD UUID, MBID_TRACK UUID, TRACK INTEGER, DISC INTEGER, RATING INTEGER, COMPOSER VARCHAR(1024), CONDUCTOR VARCHAR(1024), CONSTRAINT AUDIO_METADATA_FILEID_FK FOREIGN KEY(FILEID) REFERENCES FILES(ID) ON DELETE CASCADE)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_ARTIST_IDX ON AUDIO_METADATA (ARTIST ASC)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_ALBUMARTIST_IDX ON AUDIO_METADATA (ALBUMARTIST ASC)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_ALBUM_IDX ON AUDIO_METADATA (ALBUM ASC)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_GENRE_IDX ON AUDIO_METADATA (GENRE ASC)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_RATING_IDX ON AUDIO_METADATA (RATING)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_AUDIOTRACK_ID_IDX ON AUDIO_METADATA (AUDIOTRACK_ID)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_COMPOSER_IDX ON AUDIO_METADATA (COMPOSER)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_CONDUCTOR_IDX ON AUDIO_METADATA (CONDUCTOR)", "CREATE INDEX IF NOT EXISTS AUDIO_METADATA_MEDIA_YEAR_IDX ON AUDIO_METADATA (MEDIA_YEAR)");
    }

    public static void insertOrUpdateAudioMetadata(Connection connection, Long fileId, MediaInfo media) throws SQLException {
        if (connection == null || fileId == null || media == null || !media.hasAudioMetadata()) {
            return;
        }
        MediaAudioMetadata audioMetadata = media.getAudioMetadata();
        try (PreparedStatement updateStatement = connection.prepareStatement(SQL_GET_AUDIO_METADATA_BY_FILEID, 1003, 1008);){
            updateStatement.setLong(1, fileId);
            try (ResultSet rs = updateStatement.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !rs.next();
                if (isCreatingNewRecord) {
                    rs.moveToInsertRow();
                    rs.updateLong(COL_FILEID, (long)fileId);
                }
                MediaTableAudioMetadata.updateAudioMetadata(rs, audioMetadata);
                if (isCreatingNewRecord) {
                    rs.insertRow();
                } else {
                    rs.updateRow();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaAudioMetadata getAudioMetadataByFileId(Connection connection, long fileId) {
        if (connection == null) return null;
        if (fileId < 0L) {
            return null;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_AUDIO_METADATA_BY_FILEID);){
            selectStatement.setLong(1, fileId);
            if (trace) {
                LOGGER.trace("Searching AUDIO_METADATA with \"{}\"", (Object)selectStatement);
            }
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                MediaAudioMetadata mediaAudioMetadata = MediaTableAudioMetadata.resultSetToAudioMetadata(rs);
                return mediaAudioMetadata;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in AUDIO_METADATA for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    private static void updateAudioMetadata(ResultSet result, MediaAudioMetadata audioMetadata) throws SQLException {
        if (StringUtils.isEmpty(audioMetadata.getMbidRecord())) {
            result.updateNull(COL_MBID_RECORD);
        } else {
            try {
                UUID mbidRecord = UUID.fromString(StringUtils.trimToEmpty(audioMetadata.getMbidRecord()));
                result.updateObject(COL_MBID_RECORD, (Object)mbidRecord);
            }
            catch (IllegalArgumentException e) {
                LOGGER.trace("UUID {} not well formatted, store null value", (Object)audioMetadata.getMbidRecord());
                result.updateNull(COL_MBID_RECORD);
            }
        }
        if (StringUtils.isEmpty(audioMetadata.getMbidTrack())) {
            result.updateNull(COL_MBID_TRACK);
        } else {
            try {
                UUID mbidTrack = UUID.fromString(StringUtils.trimToEmpty(audioMetadata.getMbidTrack()));
                result.updateObject(COL_MBID_TRACK, (Object)mbidTrack);
            }
            catch (IllegalArgumentException e) {
                LOGGER.trace("UUID {} not well formatted, store null value", (Object)audioMetadata.getMbidTrack());
                result.updateNull(COL_MBID_TRACK);
            }
        }
        MediaTableAudioMetadata.updateString(result, COL_ALBUM, audioMetadata.getAlbum(), 255);
        MediaTableAudioMetadata.updateString(result, COL_ARTIST, audioMetadata.getArtist(), 255);
        MediaTableAudioMetadata.updateString(result, COL_COMPOSER, audioMetadata.getComposer(), 1024);
        MediaTableAudioMetadata.updateString(result, COL_CONDUCTOR, audioMetadata.getConductor(), 1024);
        MediaTableAudioMetadata.updateString(result, COL_ALBUMARTIST, audioMetadata.getAlbumArtist(), 255);
        MediaTableAudioMetadata.updateString(result, COL_SONGNAME, audioMetadata.getSongname(), 255);
        MediaTableAudioMetadata.updateString(result, COL_GENRE, audioMetadata.getGenre(), 255);
        result.updateInt(COL_MEDIA_YEAR, audioMetadata.getYear());
        result.updateInt(COL_TRACK, audioMetadata.getTrack());
        result.updateInt(COL_DISC, audioMetadata.getDisc());
        MediaTableAudioMetadata.updateInteger(result, COL_RATING, audioMetadata.getRating());
    }

    private static MediaAudioMetadata resultSetToAudioMetadata(ResultSet resultset) throws SQLException {
        MediaAudioMetadata audioMetadata = new MediaAudioMetadata();
        audioMetadata.setAlbum(resultset.getString(COL_ALBUM));
        audioMetadata.setArtist(resultset.getString(COL_ARTIST));
        audioMetadata.setAlbumArtist(resultset.getString(COL_ALBUMARTIST));
        audioMetadata.setSongname(resultset.getString(COL_SONGNAME));
        audioMetadata.setGenre(resultset.getString(COL_GENRE));
        audioMetadata.setYear(resultset.getInt(COL_MEDIA_YEAR));
        audioMetadata.setTrack(resultset.getInt(COL_TRACK));
        audioMetadata.setDisc(resultset.getInt(COL_DISC));
        audioMetadata.setRating(MediaTableAudioMetadata.toInteger(resultset, COL_RATING));
        audioMetadata.setAudiotrackId(resultset.getInt(COL_AUDIOTRACK_ID));
        audioMetadata.setMbidRecord(resultset.getString(COL_MBID_RECORD));
        audioMetadata.setMbidTrack(resultset.getString(COL_MBID_TRACK));
        audioMetadata.setComposer(resultset.getString(COL_COMPOSER));
        audioMetadata.setConductor(resultset.getString(COL_CONDUCTOR));
        return audioMetadata;
    }

    public static void updateRatingByMusicbrainzTrackId(Connection connection, int ratingInStars, String musicBrainzTrackId) throws SQLException {
        if (connection == null || StringUtils.isEmpty(musicBrainzTrackId)) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_RATING_BY_MBID_TRACK);){
            ps.setInt(1, ratingInStars);
            ps.setString(2, musicBrainzTrackId);
            ps.executeUpdate();
        }
    }

    public static Integer getRatingByAudiotrackId(Connection connection, Integer audiotrackId) throws SQLException {
        if (connection == null || audiotrackId == null) {
            return null;
        }
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_RATING_BY_MBID_TRACK);){
            selectStatement.setInt(1, audiotrackId);
            try (ResultSet rs = selectStatement.executeQuery();){
                if (rs.next()) {
                    Integer n = MediaTableAudioMetadata.toInteger(rs, COL_RATING);
                    return n;
                }
            }
        }
        return null;
    }

    public static void updateRatingByAudiotrackId(Connection connection, int ratingInStars, Integer audiotrackId) throws SQLException {
        if (connection == null || audiotrackId == null) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_RATING_BY_AUDIOTRACK_ID);){
            ps.setInt(1, ratingInStars);
            ps.setInt(2, audiotrackId);
            ps.executeUpdate();
            connection.commit();
        }
    }

    public static Integer getRatingByMusicbrainzTrackId(Connection connection, String musicBrainzTrackId) throws SQLException {
        if (connection == null || StringUtils.isEmpty(musicBrainzTrackId)) {
            return null;
        }
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_RATING_BY_MBID_TRACK);){
            selectStatement.setString(1, musicBrainzTrackId);
            try (ResultSet rs = selectStatement.executeQuery();){
                if (rs.next()) {
                    Integer n = MediaTableAudioMetadata.toInteger(rs, COL_RATING);
                    return n;
                }
            }
        }
        return null;
    }

    public static String getFilenameByAudiotrackId(Connection connection, Integer audiotrackId) throws SQLException {
        if (connection == null || audiotrackId == null) {
            return null;
        }
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_FILENAME_BY_AUDIOTRACK_ID);){
            selectStatement.setInt(1, audiotrackId);
            try (ResultSet rs = selectStatement.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString("FILENAME");
                    return string;
                }
            }
        }
        return null;
    }

    public static List<String> getFilenamesByMusicbrainzTrackId(Connection connection, String musicBrainzTrackId) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        if (connection == null || StringUtils.isEmpty(musicBrainzTrackId)) {
            return result;
        }
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_FILENAMES_BY_MBID_TRACK);){
            selectStatement.setString(1, musicBrainzTrackId);
            try (ResultSet rs = selectStatement.executeQuery();){
                if (rs.next()) {
                    result.add(rs.getString("FILENAME"));
                }
            }
        }
        return result;
    }
}

