/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.sharedcontent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.configuration.old.OldConfigurationImporter;
import net.pms.configuration.sharedcontent.ApertureContent;
import net.pms.configuration.sharedcontent.FileTypeAdapter;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.IPhotoContent;
import net.pms.configuration.sharedcontent.ITunesContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentArray;
import net.pms.configuration.sharedcontent.SharedContentListener;
import net.pms.configuration.sharedcontent.SharedContentTypeAdapter;
import net.pms.configuration.sharedcontent.VirtualFolderContent;
import net.pms.network.webguiserver.WebSocketDispatcher;
import net.pms.platform.PlatformUtils;
import net.pms.util.FileWatcher;
import org.apache.commons.lang.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedContentConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedContentConfiguration.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)SharedContent.class), new SharedContentTypeAdapter()).registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter()).create();
    private static final List<SharedContentListener> LISTENERS = new ArrayList<SharedContentListener>();
    private static final SharedContentArray SHARED_CONTENT_ARRAY = new SharedContentArray();
    private static final String ERROR_CONF_FILE = "Error in shared content configuration file : ";
    private static boolean isWritingConfiguration = false;
    public static final FileWatcher.Listener RELOAD_WATCHER = (filename, event, watch, isDir) -> SharedContentConfiguration.reloadConfiguration();

    private SharedContentConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedContentArray getSharedContentArray() {
        SharedContentArray sharedContentArray = SHARED_CONTENT_ARRAY;
        synchronized (sharedContentArray) {
            return (SharedContentArray)SerializationUtils.clone(SHARED_CONTENT_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getSharedFolders() {
        SharedContentArray sharedContentArray = SHARED_CONTENT_ARRAY;
        synchronized (sharedContentArray) {
            return SharedContentConfiguration.getSharedFolders(SHARED_CONTENT_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getSharedFolders(int groupId) {
        SharedContentArray sharedContentArray = SHARED_CONTENT_ARRAY;
        synchronized (sharedContentArray) {
            return SharedContentConfiguration.getSharedFolders(SHARED_CONTENT_ARRAY, groupId);
        }
    }

    private static List<File> getSharedFolders(List<SharedContent> sharedContents) {
        ArrayList<File> files = new ArrayList<File>();
        for (SharedContent sharedContent : sharedContents) {
            VirtualFolderContent folders;
            FolderContent folder;
            if (sharedContent instanceof FolderContent && (folder = (FolderContent)sharedContent).getFile() != null) {
                files.add(folder.getFile());
                continue;
            }
            if (!(sharedContent instanceof VirtualFolderContent) || (folders = (VirtualFolderContent)sharedContent).getChilds() == null) continue;
            files.addAll(SharedContentConfiguration.getSharedFolders(folders.getChilds()));
        }
        return files;
    }

    private static List<File> getSharedFolders(List<SharedContent> sharedContents, int groupId) {
        ArrayList<File> files = new ArrayList<File>();
        for (SharedContent sharedContent : sharedContents) {
            VirtualFolderContent folders;
            FolderContent folder;
            if (!sharedContent.isGroupAllowed(groupId)) continue;
            if (sharedContent instanceof FolderContent && (folder = (FolderContent)sharedContent).getFile() != null) {
                files.add(folder.getFile());
                continue;
            }
            if (!(sharedContent instanceof VirtualFolderContent) || (folders = (VirtualFolderContent)sharedContent).getChilds() == null) continue;
            files.addAll(SharedContentConfiguration.getSharedFolders(folders.getChilds()));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getMonitoredFolders() {
        SharedContentArray sharedContentArray = SHARED_CONTENT_ARRAY;
        synchronized (sharedContentArray) {
            return SharedContentConfiguration.getMonitoredFolders(SHARED_CONTENT_ARRAY);
        }
    }

    public static List<File> getMonitoredFolders(List<SharedContent> sharedContents) {
        ArrayList<File> files = new ArrayList<File>();
        for (SharedContent sharedContent : sharedContents) {
            VirtualFolderContent folders;
            FolderContent folder;
            if (sharedContent instanceof FolderContent && (folder = (FolderContent)sharedContent).isMonitored() && folder.getFile() != null) {
                files.add(folder.getFile());
                continue;
            }
            if (!(sharedContent instanceof VirtualFolderContent) || (folders = (VirtualFolderContent)sharedContent).getChilds() == null || folders.getChilds().isEmpty()) continue;
            files.addAll(SharedContentConfiguration.getMonitoredFolders(folders.getChilds()));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SharedContentListener listener) {
        List<SharedContentListener> list = LISTENERS;
        synchronized (list) {
            if (!LISTENERS.contains(listener)) {
                LISTENERS.add(listener);
            }
            listener.updateSharedContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSharedContent(SharedContentArray values, boolean save) {
        LOGGER.debug("New shared content configuration sent.");
        boolean updated = false;
        List<SharedContent> list = SHARED_CONTENT_ARRAY;
        synchronized (list) {
            if (!values.equals(SHARED_CONTENT_ARRAY)) {
                LOGGER.debug("Updating shared content configuration");
                SHARED_CONTENT_ARRAY.clear();
                for (SharedContent sharedContent : values) {
                    if (sharedContent instanceof FolderContent) {
                        FolderContent folderContent = (FolderContent)sharedContent;
                        if (folderContent.getFile() == null) continue;
                        SHARED_CONTENT_ARRAY.add(sharedContent);
                        continue;
                    }
                    if (sharedContent instanceof ITunesContent && !Platform.isMac() && !Platform.isWindows()) {
                        LOGGER.debug("ITunesContent not valid on this platform");
                        continue;
                    }
                    if (sharedContent instanceof IPhotoContent && !Platform.isMac()) {
                        LOGGER.debug("IPhotoContent not valid on this platform");
                        continue;
                    }
                    if (sharedContent instanceof ApertureContent && !Platform.isMac()) {
                        LOGGER.debug("ApertureContent not valid on this platform");
                        continue;
                    }
                    SHARED_CONTENT_ARRAY.add(sharedContent);
                }
                if (save) {
                    SharedContentConfiguration.writeConfiguration();
                }
                SharedContentConfiguration.sendWebGuiUpdate();
                if (PMS.isReady()) {
                    PMS.get().resetRenderersMediaStore();
                }
                updated = true;
            } else {
                LOGGER.debug("Current shared content configuration is already up to date.");
            }
        }
        if (updated) {
            list = LISTENERS;
            synchronized (list) {
                for (SharedContentListener listener : LISTENERS) {
                    if (listener == null) continue;
                    listener.updateSharedContent();
                }
            }
        }
    }

    public static synchronized JsonArray getAsJsonArray() {
        return GSON.toJsonTree(SHARED_CONTENT_ARRAY).getAsJsonArray();
    }

    public static void setFromJsonArray(JsonArray jsonArray) {
        SharedContentArray values = GSON.fromJson((JsonElement)jsonArray, SharedContentArray.class);
        SharedContentConfiguration.updateSharedContent(values, true);
    }

    public static void addFolderShared(File directory) {
        SharedContentArray values = SharedContentConfiguration.getSharedContentArray();
        values.add(new FolderContent(directory));
        SharedContentConfiguration.updateSharedContent(values, true);
    }

    private static synchronized void readAllConfigurations() {
        try {
            Path sharedConfFilePath = Paths.get(CONFIGURATION.getSharedConfPath(), new String[0]);
            if (Files.exists(sharedConfFilePath, new LinkOption[0])) {
                LOGGER.info("Getting shared content from configuration file : " + String.valueOf(sharedConfFilePath));
                String json = Files.readString(sharedConfFilePath, StandardCharsets.UTF_8);
                SharedContentArray values = GSON.fromJson(json, SharedContentArray.class);
                boolean updated = OldConfigurationImporter.ensureSettingsChanges(values);
                SharedContentConfiguration.updateSharedContent(values, updated);
            } else {
                LOGGER.info("Importing old shared content configuration files");
                SharedContentArray oldConfig = OldConfigurationImporter.getOldConfigurations();
                if (oldConfig.isEmpty()) {
                    oldConfig = SharedContentConfiguration.defaultConfiguration();
                }
                SharedContentConfiguration.updateSharedContent(oldConfig, true);
            }
        }
        catch (MalformedInputException ex) {
            LOGGER.info("Error in shared content configuration file : file is not UTF-8 charset");
            LOGGER.debug(null, ex);
            SharedContentConfiguration.updateSharedContent(new SharedContentArray(), false);
        }
        catch (JsonSyntaxException ex) {
            LOGGER.info("Error in shared content configuration file : json is malformed");
            LOGGER.debug(null, ex);
            SharedContentConfiguration.updateSharedContent(new SharedContentArray(), false);
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.info(ERROR_CONF_FILE + ex.getMessage());
            LOGGER.debug(null, ex);
            SharedContentConfiguration.updateSharedContent(new SharedContentArray(), false);
        }
    }

    private static synchronized SharedContentArray readConfiguration() {
        try {
            Path sharedConfFilePath = Paths.get(CONFIGURATION.getSharedConfPath(), new String[0]);
            LOGGER.debug("Reading shared content configuration file: " + String.valueOf(sharedConfFilePath));
            if (Files.exists(sharedConfFilePath, new LinkOption[0])) {
                String json = Files.readString(sharedConfFilePath, StandardCharsets.UTF_8);
                return GSON.fromJson(json, SharedContentArray.class);
            }
            LOGGER.trace("Shared content configuration file missing: " + String.valueOf(sharedConfFilePath));
        }
        catch (MalformedInputException ex) {
            LOGGER.info("Error in shared content configuration file : file is not UTF-8 charset");
            LOGGER.debug(null, ex);
        }
        catch (JsonSyntaxException ex) {
            LOGGER.info("Error in shared content configuration file : json is malformed");
            LOGGER.debug(null, ex);
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.info(ERROR_CONF_FILE + ex.getMessage());
            LOGGER.debug(null, ex);
        }
        return new SharedContentArray();
    }

    private static synchronized SharedContentArray defaultConfiguration() {
        SharedContentArray result = new SharedContentArray();
        for (Path path : PlatformUtils.INSTANCE.getDefaultFolders()) {
            File file = path.toFile();
            if (file == null) continue;
            result.add(new FolderContent(path.toFile()));
        }
        return result;
    }

    private static synchronized void writeConfiguration() {
        try {
            isWritingConfiguration = true;
            Path sharedConfFilePath = Paths.get(CONFIGURATION.getSharedConfPath(), new String[0]);
            LOGGER.debug("Writing shared content configuration file: " + String.valueOf(sharedConfFilePath));
            Files.writeString(sharedConfFilePath, (CharSequence)GSON.toJson(SHARED_CONTENT_ARRAY), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.debug("An error occurred while writing the shared content configuration file: {}", ex);
        }
        isWritingConfiguration = false;
    }

    private static synchronized void reloadConfiguration() {
        if (!isWritingConfiguration) {
            LOGGER.debug("Reloading shared content configuration file");
            SharedContentConfiguration.updateSharedContent(SharedContentConfiguration.readConfiguration(), false);
        }
    }

    private static synchronized void sendWebGuiUpdate() {
        if (WebSocketDispatcher.hasSharedSession()) {
            JsonObject jsonMessage = new JsonObject();
            jsonMessage.addProperty("action", "set_configuration_changed");
            JsonObject data = new JsonObject();
            data.add("shared_content", SharedContentConfiguration.getAsJsonArray());
            jsonMessage.add("data", data);
            WebSocketDispatcher.broadcastSharedMessage(jsonMessage.toString());
        }
    }

    static {
        SharedContentConfiguration.readAllConfigurations();
        FileWatcher.add(new FileWatcher.Watch(CONFIGURATION.getSharedConfPath(), RELOAD_WATCHER));
    }
}

