/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.sharedcontent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class SharedContent
implements Serializable {
    private boolean active = true;
    private List<Integer> groups = new ArrayList<Integer>();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public List<Integer> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Integer> value) {
        this.groups = value;
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public void addGroup(int value) {
        if (!this.groups.contains(value)) {
            this.groups.add(value);
        }
    }

    public void removeGroup(int value) {
        if (this.isGroupRestricted()) {
            this.groups.remove(value);
        }
    }

    public boolean isGroupAllowed(int value) {
        return !this.isGroupRestricted() || value == Integer.MAX_VALUE || this.groups.contains(value);
    }

    public boolean isGroupRestricted() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SharedContent) {
            SharedContent other = (SharedContent)o;
            if (this.active == other.active) {
                if (this.groups == null) {
                    if (other.groups != null) {
                        return false;
                    }
                } else {
                    if (other.groups == null || other.groups.size() != this.groups.size()) {
                        return false;
                    }
                    for (int group : this.groups) {
                        if (other.groups.contains(group)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.active ? 1 : 0);
        hash = 83 * hash + Objects.hashCode(this.groups);
        return hash;
    }

    public abstract String getType();

    public abstract boolean isExternalContent();
}

