/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.old;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.store.container.Feed;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSourcesConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSourcesConfiguration.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String KEY_WEB_CONF_PATH = "web_conf";
    private static final String DEFAULT_WEB_CONF_FILENAME = "WEB.conf";

    private WebSourcesConfiguration() {
    }

    public static synchronized List<WebSource> getWebSourcesFromConfiguration() {
        ArrayList<WebSource> result;
        block27: {
            result = new ArrayList<WebSource>();
            File webConf = new File(WebSourcesConfiguration.getWebConfPath());
            if (!webConf.exists()) {
                return result;
            }
            try {
                LineNumberReader br = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(webConf), StandardCharsets.UTF_8));
                block23: while (true) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.indexOf(61) <= -1) continue;
                        String key = line.substring(0, line.indexOf(61));
                        String value = line.substring(line.indexOf(61) + 1);
                        String[] keys = WebSourcesConfiguration.parseFeedKey(key);
                        String sourceType = keys[0];
                        String folderName = keys[1] == null ? null : keys[1];
                        try {
                            String resourceName;
                            if (!sourceType.equals("imagefeed") && !sourceType.equals("audiofeed") && !sourceType.equals("videofeed") && !sourceType.equals("audiostream") && !sourceType.equals("videostream")) continue block23;
                            String[] values = WebSourcesConfiguration.parseFeedValue(value);
                            String uri = Feed.getFeedUrl(values[0]);
                            String thumbnail = values.length > 2 ? values[2] : null;
                            String string = resourceName = values.length > 3 ? values[3] : null;
                            if (StringUtils.isBlank(resourceName)) {
                                try {
                                    switch (sourceType) {
                                        case "imagefeed": 
                                        case "videofeed": 
                                        case "audiofeed": {
                                            resourceName = Feed.getFeedTitle(uri);
                                            break;
                                        }
                                        case "videostream": 
                                        case "audiostream": {
                                            resourceName = values.length > 0 && values[0] != null ? values[0] : null;
                                            uri = values.length > 1 && values[1] != null ? values[1] : null;
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.debug("Error while getting feed title: " + String.valueOf(e));
                                }
                            }
                            result.add(new WebSource(sourceType, folderName, uri, resourceName, thumbnail));
                            continue block23;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            LOGGER.info("Error at line " + br.getLineNumber() + " of WEB.conf: " + e.getMessage());
                            LOGGER.debug(null, e);
                        }
                    }
                    break block27;
                    {
                        continue block23;
                        break;
                    }
                    break;
                }
                finally {
                    br.close();
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("Can't read web configuration file {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                LOGGER.warn("Unexpected error in WEB.conf: " + e.getMessage());
                LOGGER.debug("", e);
            }
        }
        return result;
    }

    private static String[] parseFeedKey(String spec) {
        String[] pair = StringUtils.split(spec, ".", 2);
        if (pair == null || pair.length < 2) {
            pair = new String[2];
        }
        if (pair[0] == null) {
            pair[0] = "";
        }
        return pair;
    }

    private static String[] parseFeedValue(String spec) {
        return spec.split(",");
    }

    public static String getWebConfPath() {
        String webConfPath = FileUtil.getFileLocation(CONFIGURATION.getString(KEY_WEB_CONF_PATH, null), UmsConfiguration.getProfileDirectory(), DEFAULT_WEB_CONF_FILENAME).getFilePath();
        return CONFIGURATION.getString(KEY_WEB_CONF_PATH, webConfPath);
    }

    public static class WebSource {
        private final String sourceType;
        private final String folderName;
        private final String uri;
        private final String resourceName;
        private final String thumbnail;

        public WebSource(String sourceType, String folderName, String uri, String resourceName, String thumbnail) {
            this.sourceType = sourceType;
            this.folderName = folderName;
            this.uri = uri;
            this.resourceName = resourceName;
            this.thumbnail = thumbnail;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getUri() {
            return this.uri;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getThumbnail() {
            return this.thumbnail;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WebSource) {
                WebSource source = (WebSource)obj;
                return Strings.CS.equals(this.sourceType, source.sourceType) && Strings.CS.equals(this.folderName, source.folderName) && Strings.CS.equals(this.uri, source.uri) && Strings.CS.equals(this.resourceName, source.resourceName) && Strings.CS.equals(this.thumbnail, source.thumbnail);
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.sourceType);
            hash = 97 * hash + Objects.hashCode(this.folderName);
            hash = 97 * hash + Objects.hashCode(this.uri);
            hash = 97 * hash + Objects.hashCode(this.resourceName);
            hash = 97 * hash + Objects.hashCode(this.thumbnail);
            return hash;
        }
    }
}

