/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.pms.configuration.RendererConfiguration;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.io.OutputParams;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.store.StoreItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatConfiguration.class);
    public static final String THREEGPP = "3gp";
    public static final String THREEGPP2 = "3g2";
    public static final String THREEGA = "3ga";
    public static final String AAC_LC = "aac-lc";
    public static final String AAC_LTP = "aac-ltp";
    public static final String AAC_MAIN = "aac-main";
    public static final String AAC_SSR = "aac-ssr";
    public static final String AC3 = "ac3";
    public static final String AC4 = "ac4";
    public static final String ACELP = "acelp";
    public static final String ADPCM = "adpcm";
    public static final String ADTS = "adts";
    public static final String AIFF = "aiff";
    public static final String ALAC = "alac";
    public static final String ALS = "als";
    public static final String AMR = "amr";
    public static final String ASF = "asf";
    public static final String ATMOS = "atmos";
    public static final String ATRAC = "atrac";
    public static final String AU = "au";
    public static final String AV1 = "av1";
    public static final String AVI = "avi";
    public static final String BMP = "bmp";
    public static final String CAF = "caf";
    public static final String CELP = "celp";
    public static final String CINEPAK = "cvid";
    public static final String COOK = "cook";
    public static final String CUR = "cur";
    public static final String DIVX = "divx";
    public static final String DFF = "dff";
    public static final String DSF = "dsf";
    public static final String DOLBYE = "dolbye";
    public static final String DTS = "dts";
    public static final String DTSHD = "dtshd";
    public static final String DV = "dv";
    public static final String EAC3 = "eac3";
    public static final String ER_BSAC = "erbsac";
    public static final String FFV1 = "ffv1";
    public static final String FLAC = "flac";
    public static final String FLV = "flv";
    public static final String G729 = "g729";
    public static final String GIF = "gif";
    public static final String H261 = "h261";
    public static final String H263 = "h263";
    public static final String H264 = "h264";
    public static final String H265 = "h265";
    public static final String HE_AAC = "he-aac";
    public static final String ICNS = "icns";
    public static final String ICO = "ico";
    public static final String INDEO = "indeo";
    public static final String ISO = "iso";
    public static final String JPG = "jpg";
    public static final String JPEG = "jpeg";
    public static final String JPEG2000 = "jpeg2000";
    public static final String LPCM = "lpcm";
    public static final String M4A = "m4a";
    public static final String M4V = "m4v";
    public static final String MKV = "mkv";
    public static final String MI_VBD = "vbd";
    public static final String MI_HDR = "hdr";
    public static final String MI_GMC = "gmc";
    public static final String MI_GOP = "gop";
    public static final String MI_QPEL = "qpel";
    public static final String MACE3 = "mace3";
    public static final String MACE6 = "mace6";
    public static final String MJPEG = "mjpeg";
    public static final String MKA = "mka";
    public static final String MLP = "mlp";
    public static final String MONKEYS_AUDIO = "ape";
    public static final String MOV = "mov";
    public static final String MP2 = "mp2";
    public static final String MP3 = "mp3";
    public static final String MP4 = "mp4";
    public static final String MPA = "mpa";
    public static final String MPC = "mpc";
    public static final String MPEG1 = "mpeg1";
    public static final String MPEG2 = "mpeg2";
    public static final String MPEGPS = "mpegps";
    public static final String MPEGTS = "mpegts";
    public static final String MPEGTS_HLS = "hls";
    public static final String NELLYMOSER = "nellymoser";
    public static final String OGG = "ogg";
    public static final String OGA = "oga";
    public static final String OPUS = "opus";
    public static final String PCX = "pcx";
    public static final String PNG = "png";
    public static final String PNM = "pnm";
    public static final String PSD = "psd";
    public static final String QCELP = "qcelp";
    public static final String QDESIGN = "qdmc";
    public static final String RA = "ra";
    public static final String RALF = "ralf";
    public static final String RAW = "raw";
    public static final String REALAUDIO_14_4 = "ra14.4";
    public static final String REALAUDIO_28_8 = "ra28.8";
    public static final String RGB = "rgb";
    public static final String RLE = "rle";
    public static final String RM = "rm";
    public static final String SHORTEN = "shn";
    public static final String SIPRO = "sipro";
    public static final String SLS = "sls";
    public static final String SORENSON = "sor";
    public static final String TGA = "tga";
    public static final String THEORA = "theora";
    public static final String TIFF = "tiff";
    public static final String TRUEHD = "truehd";
    public static final String TTA = "tta";
    public static final String VC1 = "vc1";
    public static final String VORBIS = "vorbis";
    public static final String VP6 = "vp6";
    public static final String VP7 = "vp7";
    public static final String VP8 = "vp8";
    public static final String VP9 = "vp9";
    public static final String WAV = "wav";
    public static final String WAVPACK = "wavpack";
    public static final String WBMP = "wbmp";
    public static final String WEBA = "weba";
    public static final String WEBM = "webm";
    public static final String WEBP = "webp";
    public static final String WMA = "wma";
    public static final String WMA10 = "wma10";
    public static final String WMALOSSLESS = "wmalossless";
    public static final String WMAPRO = "wmapro";
    public static final String WMAVOICE = "wmavoice";
    public static final String WMV = "wmv";
    public static final String YUV = "yuv";
    public static final String MIMETYPE_AUTO = "MIMETYPE_AUTO";
    public static final String UND = "und";
    private final ArrayList<SupportSpec> supportSpecs = new ArrayList();

    public FormatConfiguration(List<?> lines) {
        for (Object line : lines) {
            if (line == null) continue;
            SupportSpec supportSpec = FormatConfiguration.parseSupportLine(line.toString());
            if (supportSpec.isValid()) {
                this.supportSpecs.add(supportSpec);
                continue;
            }
            LOGGER.warn("Invalid configuration line: {}", line);
        }
    }

    public boolean isFormatSupported(String container) {
        return this.getMatchedMIMEtype(container, null, null) != null;
    }

    public boolean isDTSSupported() {
        return this.getMatchedMIMEtype(MPEGPS, null, DTS) != null || this.getMatchedMIMEtype(MPEGTS, null, DTS) != null;
    }

    public boolean isLPCMSupported() {
        return this.getMatchedMIMEtype(MPEGPS, null, LPCM) != null || this.getMatchedMIMEtype(MPEGTS, null, LPCM) != null;
    }

    public boolean isMpeg2Supported() {
        return this.getMatchedMIMEtype(MPEGPS, MPEG2, null) != null || this.getMatchedMIMEtype(MPEGTS, MPEG2, null) != null;
    }

    public String getMatchedMIMEtype(StoreItem item, RendererConfiguration renderer) {
        MediaInfo media = item.getMediaInfo();
        if (media == null) {
            return null;
        }
        int frameRate = 0;
        if (media.getFrameRate() != null) {
            try {
                frameRate = (int)Math.round(media.getFrameRate());
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse framerate \"{}\" for media {}: {}", media.getFrameRate(), media, e.getMessage());
                LOGGER.trace("", e);
            }
        }
        if (media.getDefaultAudioTrack() == null) {
            return this.getMatchedMIMEtype(media.getContainer(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getCodec() : null, null, 0, 0, media.getBitRate(), frameRate, media.getWidth(), media.getHeight(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getBitDepth() : 0, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatCompatibilityForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getExtras() : null, item.getMediaSubtitle() != null ? item.getMediaSubtitle().getType().toString() : null, item.getMediaSubtitle() != null && item.getMediaSubtitle().isExternal(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getMuxingMode() : null, renderer);
        }
        if (media.isSLS()) {
            MediaAudio audio = media.getDefaultAudioTrack();
            return this.getMatchedMIMEtype(media.getContainer(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getCodec() : null, audio.getCodec(), audio.getNumberOfChannels(), audio.getSampleRate(), audio.getBitRate(), frameRate, media.getWidth(), media.getHeight(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getBitDepth() : 0, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatCompatibilityForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getExtras() : null, item.getMediaSubtitle() != null ? item.getMediaSubtitle().getType().toString() : null, item.getMediaSubtitle() != null && item.getMediaSubtitle().isExternal(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getMuxingMode() : null, renderer);
        }
        String finalMimeType = null;
        for (MediaAudio audio : media.getAudioTracks()) {
            String mimeType;
            finalMimeType = mimeType = this.getMatchedMIMEtype(media.getContainer(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getCodec() : null, audio.getCodec(), audio.getNumberOfChannels(), audio.getSampleRate(), media.getBitRate(), frameRate, media.getWidth(), media.getHeight(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getBitDepth() : 0, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatCompatibilityForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getExtras() : null, item.getMediaSubtitle() != null ? item.getMediaSubtitle().getType().toString() : null, item.getMediaSubtitle() != null && item.getMediaSubtitle().isExternal(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getMuxingMode() : null, renderer);
            if (mimeType == null) continue;
            return finalMimeType;
        }
        return finalMimeType;
    }

    public String getMatchedMIMEtype(String container, String videoCodec, String audioCodec) {
        return this.getMatchedMIMEtype(container, videoCodec, audioCodec, 0, 0, 0, 0, 0, 0, 0, null, null, null, null, false, null, null);
    }

    public String getMatchedMIMEtype(MediaInfo media, OutputParams params) {
        return this.getMatchedMIMEtype(media.getContainer(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getCodec() : null, params.getAid() != null ? params.getAid().getCodec() : null, 0, 0, 0, 0, 0, 0, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getBitDepth() : 0, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatForRenderer() : null, media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getHDRFormatCompatibilityForRenderer() : null, null, params.getSid().getType().name(), params.getSid().isExternal(), media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getMuxingMode() : null, null);
    }

    public boolean supportsMimeType(String mimeType) {
        for (SupportSpec supportSpec : this.supportSpecs) {
            if (!supportSpec.mimeType.equalsIgnoreCase(mimeType)) continue;
            LOGGER.debug("renderer supports mime type {}", (Object)mimeType);
            return true;
        }
        LOGGER.debug("renderer doesn't support mime type {}", (Object)mimeType);
        return false;
    }

    public String getMatchedMIMEtype(String container, String videoCodec, String audioCodec, int nbAudioChannels, int frequency, int bitrate, int framerate, int videoWidth, int videoHeight, int videoBitDepth, String videoHdrFormatInRendererFormat, String videoHdrFormatCompatibilityInRendererFormat, Map<String, String> extras, String subsFormat, boolean isInternal, String muxingMode, RendererConfiguration renderer) {
        String matchedMimeType = null;
        for (SupportSpec supportSpec : this.supportSpecs) {
            if (!supportSpec.match(container, videoCodec, audioCodec, nbAudioChannels, frequency, bitrate, framerate, videoWidth, videoHeight, videoBitDepth, videoHdrFormatInRendererFormat, videoHdrFormatCompatibilityInRendererFormat, extras, subsFormat, isInternal, muxingMode, renderer)) continue;
            matchedMimeType = supportSpec.mimeType;
            break;
        }
        return matchedMimeType;
    }

    private static SupportSpec parseSupportLine(String line) {
        StringTokenizer st = new StringTokenizer(line, "\t ");
        SupportSpec supportSpec = new SupportSpec();
        supportSpec.supportLine = line;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("f:")) {
                supportSpec.format = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("v:")) {
                supportSpec.videoCodec = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("a:")) {
                supportSpec.audioCodec = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("n:")) {
                supportSpec.maxNbChannels = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("s:")) {
                supportSpec.maxFrequency = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("w:")) {
                supportSpec.maxVideoWidth = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("h:")) {
                supportSpec.maxVideoHeight = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("m:")) {
                supportSpec.mimeType = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("b:")) {
                supportSpec.maxBitrate = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("si:")) {
                supportSpec.supportedEmbeddedSubtitlesFormats = token.substring(3).trim();
                continue;
            }
            if (token.startsWith("se:")) {
                supportSpec.supportedExternalSubtitlesFormats = token.substring(3).trim();
                continue;
            }
            if (token.startsWith("fps:")) {
                supportSpec.maxFramerate = token.substring(4).trim();
                continue;
            }
            if (token.startsWith("mm:")) {
                supportSpec.supportedMuxingMode = token.substring(3).trim();
                continue;
            }
            if (!token.contains(":")) continue;
            if (supportSpec.miExtras == null) {
                supportSpec.miExtras = new HashMap<String, Pattern>();
            }
            String key = token.substring(0, token.indexOf(58));
            String value = token.substring(token.indexOf(58) + 1);
            supportSpec.miExtras.put(key, Pattern.compile(value));
        }
        return supportSpec;
    }

    private static class SupportSpec {
        private int iMaxBitrate = Integer.MAX_VALUE;
        private int iMaxFramerate = Integer.MAX_VALUE;
        private int iMaxFrequency = Integer.MAX_VALUE;
        private int iMaxNbChannels = Integer.MAX_VALUE;
        private int iMaxVideoHeight = Integer.MAX_VALUE;
        private int iMaxVideoWidth = Integer.MAX_VALUE;
        private Map<String, Pattern> miExtras;
        private Pattern pAudioCodec;
        private Pattern pFormat;
        private Pattern pVideoCodec;
        private String audioCodec;
        private String format;
        private String maxBitrate;
        private String maxFramerate;
        private String maxFrequency;
        private String maxNbChannels;
        private String maxVideoHeight;
        private String maxVideoWidth;
        private String mimeType = "MIMETYPE_AUTO";
        private String videoCodec;
        private String supportLine;
        private String supportedEmbeddedSubtitlesFormats;
        private String supportedExternalSubtitlesFormats;
        private String supportedMuxingMode;

        SupportSpec() {
        }

        boolean isValid() {
            if (StringUtils.isBlank(this.format)) {
                LOGGER.error("No format specified on line \"{}\"", (Object)this.supportLine);
                return false;
            }
            try {
                this.pFormat = Pattern.compile(this.format);
            }
            catch (PatternSyntaxException pse) {
                LOGGER.error("Error parsing format \"{}\" from line \"{}\": {}", this.format, this.supportLine, pse.getMessage());
                LOGGER.trace("", pse);
                return false;
            }
            if (StringUtils.isNotBlank(this.videoCodec)) {
                try {
                    this.pVideoCodec = Pattern.compile(this.videoCodec);
                }
                catch (PatternSyntaxException pse) {
                    LOGGER.error("Error parsing video codec \"{}\" from line \"{}\": {}", this.videoCodec, this.supportLine, pse.getMessage());
                    LOGGER.trace("", pse);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.audioCodec)) {
                try {
                    this.pAudioCodec = Pattern.compile(this.audioCodec);
                }
                catch (PatternSyntaxException pse) {
                    LOGGER.error("Error parsing audio codec \"{}\" from line \"{}\": {}", this.audioCodec, this.supportLine, pse.getMessage());
                    LOGGER.trace("", pse);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.maxNbChannels)) {
                try {
                    this.iMaxNbChannels = Integer.parseInt(this.maxNbChannels);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Error parsing number of channels \"{}\" from line \"{}\": {}", this.maxNbChannels, this.supportLine, nfe.getMessage());
                    LOGGER.trace("", nfe);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.maxFramerate)) {
                try {
                    this.iMaxFramerate = Integer.parseInt(this.maxFramerate);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Error parsing maximum framerate \"{}\" from line \"{}\": {}", this.maxFramerate, this.supportLine, nfe.getMessage());
                    LOGGER.trace("", nfe);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.maxFrequency)) {
                try {
                    this.iMaxFrequency = Integer.parseInt(this.maxFrequency);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Error parsing maximum frequency \"{}\" from line \"{}\": {}", this.maxFrequency, this.supportLine, nfe.getMessage());
                    LOGGER.trace("", nfe);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.maxBitrate)) {
                try {
                    this.iMaxBitrate = Integer.parseInt(this.maxBitrate);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Error parsing maximum bitrate \"{}\" from line \"{}\": {}", this.maxBitrate, this.supportLine, nfe.getMessage());
                    LOGGER.trace("", nfe);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.maxVideoWidth)) {
                try {
                    this.iMaxVideoWidth = Integer.parseInt(this.maxVideoWidth);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Error parsing maximum video width \"{}\" from line \"{}\": {}", this.maxVideoWidth, this.supportLine, nfe.getMessage());
                    LOGGER.trace("", nfe);
                    return false;
                }
            }
            if (StringUtils.isNotBlank(this.maxVideoHeight)) {
                try {
                    this.iMaxVideoHeight = Integer.parseInt(this.maxVideoHeight);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("Error parsing maximum video height \"{}\" from line \"{}\": {}", this.maxVideoHeight, this.supportLine, nfe.getMessage());
                    LOGGER.trace("", nfe);
                    return false;
                }
            }
            return true;
        }

        public boolean match(String format, String videoCodec, String audioCodec, int nbAudioChannels, int frequency, int bitrate, int framerate, int videoWidth, int videoHeight, int videoBitDepth, String videoHdrFormatInRendererFormat, String videoHdrFormatCompatibilityInRendererFormat, Map<String, String> extras, String subsFormat, boolean isExternalSubs, String muxingMode, RendererConfiguration renderer) {
            if (format == null && videoCodec == null && audioCodec == null && subsFormat == null) {
                return false;
            }
            if (format != null && !this.pFormat.matcher(format).matches()) {
                LOGGER.trace("Format \"{}\" failed to match supported line {}", (Object)format, (Object)this.supportLine);
                return false;
            }
            if (videoCodec != null && this.pVideoCodec != null && !this.pVideoCodec.matcher(videoCodec).matches()) {
                LOGGER.trace("Video codec \"{}\" failed to match support line {}", (Object)videoCodec, (Object)this.supportLine);
                return false;
            }
            if (audioCodec != null && this.pAudioCodec != null && !this.pAudioCodec.matcher(audioCodec).matches()) {
                LOGGER.trace("Audio codec \"{}\" failed to match support line {}", (Object)audioCodec, (Object)this.supportLine);
                return false;
            }
            if (nbAudioChannels > 0 && this.iMaxNbChannels > 0 && nbAudioChannels > this.iMaxNbChannels) {
                LOGGER.trace("Number of channels \"{}\" failed to match support line {}", (Object)nbAudioChannels, (Object)this.supportLine);
                return false;
            }
            if (framerate > 0 && this.iMaxFramerate > 0 && framerate > this.iMaxFramerate) {
                LOGGER.trace("Framerate \"{}\" failed to match support line {}", (Object)framerate, (Object)this.supportLine);
                return false;
            }
            if (frequency > 0 && this.iMaxFrequency > 0 && frequency > this.iMaxFrequency) {
                LOGGER.trace("Frequency \"{}\" failed to match support line {}", (Object)frequency, (Object)this.supportLine);
                return false;
            }
            if (bitrate > 0 && this.iMaxBitrate > 0 && bitrate > this.iMaxBitrate) {
                LOGGER.trace("Bit rate \"{}\" failed to match support line {}", (Object)bitrate, (Object)this.supportLine);
                return false;
            }
            if (videoWidth > 0 && this.iMaxVideoWidth > 0 && videoWidth > this.iMaxVideoWidth) {
                LOGGER.trace("Video width \"{}\" failed to match support line {}", (Object)videoWidth, (Object)this.supportLine);
                return false;
            }
            if (videoHeight > 0 && this.iMaxVideoHeight > 0 && videoHeight > this.iMaxVideoHeight) {
                LOGGER.trace("Video height \"{}\" failed to match support line {}", (Object)videoHeight, (Object)this.supportLine);
                return false;
            }
            if (videoBitDepth > 0) {
                if (this.miExtras != null && this.miExtras.get(FormatConfiguration.MI_VBD) != null && !this.miExtras.get(FormatConfiguration.MI_VBD).matcher(Integer.toString(videoBitDepth)).matches()) {
                    LOGGER.trace("Video Bit Depth value \"{}\" failed to match support line {}", (Object)videoBitDepth, (Object)this.supportLine);
                    return false;
                }
                if (renderer == null || !renderer.isVideoBitDepthSupportedForAllFiletypes(videoBitDepth)) {
                    LOGGER.trace("The video bit depth \"{}\" is not supported for this filetype, or all filetypes", (Object)videoBitDepth);
                    return false;
                }
            }
            if (muxingMode != null && Strings.CI.equals(muxingMode, "Packed bitstream") && this.supportedMuxingMode != null && this.supportedMuxingMode.equals("ub")) {
                LOGGER.trace("Muxing mode \"{}\" failed to match support line {}", (Object)muxingMode, (Object)this.supportLine);
                return false;
            }
            if (videoHdrFormatInRendererFormat != null && this.miExtras != null && this.miExtras.get(FormatConfiguration.MI_HDR) != null && !this.miExtras.get(FormatConfiguration.MI_HDR).matcher(videoHdrFormatInRendererFormat).matches()) {
                LOGGER.trace("Video HDR format value \"{}\" failed to match support line {}", (Object)videoHdrFormatInRendererFormat, (Object)this.supportLine);
                boolean isTsMuxeRVideoEngineActive = EngineFactory.isEngineActive(TsMuxeRVideo.ID);
                if (!Strings.CI.equals(format, FormatConfiguration.MPEGTS) && isTsMuxeRVideoEngineActive) {
                    boolean wouldBeCompatibleInTsContainer;
                    boolean bl = wouldBeCompatibleInTsContainer = renderer.getFormatConfiguration().getMatchedMIMEtype(FormatConfiguration.MPEGTS, videoCodec, audioCodec, nbAudioChannels, frequency, bitrate, framerate, videoWidth, videoHeight, videoBitDepth, videoHdrFormatInRendererFormat, null, extras, subsFormat, isExternalSubs, muxingMode, renderer) != null;
                    if (wouldBeCompatibleInTsContainer) {
                        LOGGER.trace("Video HDR format value \"{}\" is compatible in TS container, but not this container \"{}\", so will report it as incompatible to allow on-the-fly remuxing with tsMuxeR {}", videoHdrFormatInRendererFormat, format, this.supportLine);
                        return false;
                    }
                }
                if (videoHdrFormatCompatibilityInRendererFormat == null || !this.miExtras.get(FormatConfiguration.MI_HDR).matcher(videoHdrFormatCompatibilityInRendererFormat).matches()) {
                    LOGGER.trace("Video HDR format compatibility value \"{}\" also failed to match support line {}", (Object)videoHdrFormatCompatibilityInRendererFormat, (Object)this.supportLine);
                    return false;
                }
            }
            if (subsFormat != null) {
                if (isExternalSubs) {
                    if (this.supportedExternalSubtitlesFormats == null || !subsFormat.matches(this.supportedExternalSubtitlesFormats)) {
                        LOGGER.trace("External subtitles format \"{}\" failed to match support line {}", (Object)subsFormat, (Object)this.supportLine);
                        if (renderer == null || !renderer.isExternalSubtitlesFormatSupportedForAllFiletypes(subsFormat)) {
                            LOGGER.trace("And did not match any formats in the SupportedExternalSubtitlesFormats renderer configuration setting");
                            return false;
                        }
                        LOGGER.trace("But did match a format in the SupportedExternalSubtitlesFormats renderer configuration setting");
                    }
                } else if (this.supportedEmbeddedSubtitlesFormats == null || !subsFormat.matches(this.supportedEmbeddedSubtitlesFormats)) {
                    LOGGER.trace("Internal subtitles format \"{}\" failed to match support line {}", (Object)subsFormat, (Object)this.supportLine);
                    if (renderer == null || !renderer.isEmbeddedSubtitlesFormatSupportedForAllFiletypes(subsFormat)) {
                        LOGGER.trace("And did not match any formats in the SupportedInternalSubtitlesFormats renderer configuration setting");
                        return false;
                    }
                    LOGGER.trace("But did match a format in the SupportedInternalSubtitlesFormats renderer configuration setting");
                }
            }
            if (extras != null && this.miExtras != null) {
                Iterator<Map.Entry<String, String>> keyIt = extras.entrySet().iterator();
                while (keyIt.hasNext()) {
                    String key = keyIt.next().getKey();
                    String value = extras.get(key).toLowerCase();
                    if (key.equals(FormatConfiguration.MI_QPEL) && this.miExtras.get(FormatConfiguration.MI_QPEL) != null && !this.miExtras.get(FormatConfiguration.MI_QPEL).matcher(value).matches()) {
                        LOGGER.trace("QPel value \"{}\" failed to match support line {}", (Object)value, (Object)this.supportLine);
                        return false;
                    }
                    if (key.equals(FormatConfiguration.MI_GMC) && this.miExtras.get(FormatConfiguration.MI_GMC) != null && !this.miExtras.get(FormatConfiguration.MI_GMC).matcher(value).matches()) {
                        LOGGER.trace("GMC value \"{}\" failed to match support line {}", (Object)value, (Object)this.supportLine);
                        return false;
                    }
                    if (!key.equals(FormatConfiguration.MI_GOP) || this.miExtras.get(FormatConfiguration.MI_GOP) == null || !this.miExtras.get(FormatConfiguration.MI_GOP).matcher("static").matches() || !value.equals("variable")) continue;
                    LOGGER.trace("GOP value \"{}\" failed to match support line {}", (Object)value, (Object)this.supportLine);
                    return false;
                }
            }
            LOGGER.trace("Matched support line {}", (Object)this.supportLine);
            return true;
        }
    }
}

