/*
 * Decompiled with CFR 0.152.
 */
package net.pms;

import com.google.gson.JsonObject;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages {
    private static final String BUNDLE_NAME = "resources.i18n.messages";
    private static ReadWriteLock resourceBundleLock = new ReentrantReadWriteLock();
    private static ResourceBundle resourceBundle;
    private static final ResourceBundle ROOT_RESOURCE_BUNDLE;
    private static final Logger LOGGER;

    private Messages() {
    }

    public static void setLocaleBundle(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        resourceBundleLock.writeLock().lock();
        try {
            resourceBundle = Messages.isRootEnglish(locale) ? ROOT_RESOURCE_BUNDLE : ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
        finally {
            resourceBundleLock.writeLock().unlock();
        }
    }

    @Nonnull
    public static String getString(String key) {
        resourceBundleLock.readLock().lock();
        try {
            String string = Messages.getString(key, resourceBundle);
            return string;
        }
        finally {
            resourceBundleLock.readLock().unlock();
        }
    }

    @Nonnull
    public static String getGuiString(String key) {
        return Messages.getString(key);
    }

    @Nonnull
    public static String getConfigurationString(String key) {
        return Messages.getString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringsAsJson() {
        resourceBundleLock.readLock().lock();
        try {
            Enumeration<String> i18nKeys = resourceBundle.getKeys();
            JsonObject jsonObject = new JsonObject();
            while (i18nKeys.hasMoreElements()) {
                String key = i18nKeys.nextElement();
                String value = resourceBundle.getString(key);
                jsonObject.addProperty(key, value);
            }
            String string = jsonObject.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse translations to JSON: {} ", e);
        }
        finally {
            resourceBundleLock.readLock().unlock();
        }
        return null;
    }

    public static JsonObject getStringsAsJsonObject(Locale locale) {
        ResourceBundle rb = null;
        if (locale != null && !Messages.isRootEnglish(locale)) {
            rb = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }
        if (rb == null) {
            rb = ROOT_RESOURCE_BUNDLE;
        }
        JsonObject jsonObject = new JsonObject();
        try {
            Enumeration<String> i18nKeys = rb.getKeys();
            while (i18nKeys.hasMoreElements()) {
                String key = i18nKeys.nextElement();
                String value = rb.getString(key);
                jsonObject.addProperty(key, value);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse translations to JSON: {} ", e);
        }
        return jsonObject;
    }

    @Nonnull
    public static String getString(String key, Locale locale) {
        if (locale == null) {
            return Messages.getString(key);
        }
        if (Messages.isRootEnglish(locale)) {
            return Messages.getRootString(key);
        }
        ResourceBundle rb = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        if (rb == null) {
            rb = ROOT_RESOURCE_BUNDLE;
        }
        return Messages.getString(key, rb);
    }

    @Nonnull
    public static String getRootString(String key) {
        return Messages.getString(key, ROOT_RESOURCE_BUNDLE);
    }

    @Nonnull
    private static String getString(String key, ResourceBundle rb) {
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    private static boolean isRootEnglish(Locale locale) {
        return locale.getLanguage().toLowerCase(Locale.ENGLISH).equals("en") && !locale.getCountry().equals("GB");
    }

    static {
        LOGGER = LoggerFactory.getLogger(Messages.class);
        resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
        ROOT_RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.ROOT, new ResourceBundle.Control(){

            @Override
            public List<Locale> getCandidateLocales(String name, Locale locale) {
                return Collections.singletonList(Locale.ROOT);
            }
        });
    }
}

