/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.sfuhrm.radiobrowser4j.ConnectionParams;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.RestDelegate;
import de.sfuhrm.radiobrowser4j.Station;
import de.sfuhrm.radiobrowser4j.StationDeserializer;
import de.sfuhrm.radiobrowser4j.Stats;
import de.sfuhrm.radiobrowser4j.StatsDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestDelegateImpl
implements RestDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestDelegateImpl.class);
    private final URI endpoint;
    private final ConnectionParams connectionParams;
    private final Gson gson;

    RestDelegateImpl(ConnectionParams inConnectionParams) {
        this.endpoint = URI.create(inConnectionParams.getApiUrl());
        this.connectionParams = inConnectionParams;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Stats.class), new StatsDeserializer()).registerTypeAdapter((Type)((Object)Station.class), new StationDeserializer()).create();
    }

    private static Proxy getProxy(ConnectionParams connectionParams) {
        Proxy proxy = null;
        if (connectionParams.getProxyUri() != null) {
            URI proxyUri = URI.create(connectionParams.getProxyUri());
            proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(proxyUri.getHost(), proxyUri.getPort()));
        }
        return proxy;
    }

    private static Authenticator getProxyAuthenticator(final ConnectionParams connectionParams) {
        Authenticator auth = null;
        if (connectionParams.getProxyUri() != null && connectionParams.getProxyUser() != null && connectionParams.getProxyPassword() != null) {
            auth = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(connectionParams.getProxyUser(), connectionParams.getProxyPassword().toCharArray());
                }
            };
        }
        return auth;
    }

    private HttpURLConnection newClient(String path) throws IOException {
        HttpURLConnection connection;
        URI fullUri = this.endpoint.resolve(path);
        URL url = fullUri.toURL();
        log.debug("Connecting to {}", (Object)url.toExternalForm());
        if (null != this.connectionParams.getProxyUri()) {
            Proxy proxy = RestDelegateImpl.getProxy(this.connectionParams);
            Authenticator auth = RestDelegateImpl.getProxyAuthenticator(this.connectionParams);
            if (null != auth) {
                Authenticator.setDefault(auth);
            }
            connection = (HttpURLConnection)url.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        connection.setConnectTimeout(this.connectionParams.getTimeout());
        connection.setReadTimeout(this.connectionParams.getTimeout());
        return connection;
    }

    static Charset guessCharsetFor(String contentType) {
        if (null == contentType) {
            return StandardCharsets.UTF_8;
        }
        String[] parts = contentType.split(";");
        if (parts.length < 2) {
            return StandardCharsets.UTF_8;
        }
        for (String part : parts) {
            if (!part.trim().startsWith("charset=")) continue;
            String charsetName = part.trim().substring("charset=".length());
            try {
                return Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException e) {
                log.warn("Illegal charset name: {}", (Object)charsetName);
                return StandardCharsets.UTF_8;
            }
            catch (UnsupportedCharsetException e) {
                log.warn("Unsupported charset name: {}", (Object)charsetName);
                return StandardCharsets.UTF_8;
            }
        }
        return StandardCharsets.UTF_8;
    }

    private static Reader readerFor(HttpURLConnection connection) throws IOException {
        String encoding = connection.getContentEncoding();
        String contentType = connection.getContentType();
        Charset charset = RestDelegateImpl.guessCharsetFor(contentType);
        RestDelegateImpl.checkResponseStatus(connection);
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return new InputStreamReader((InputStream)new GZIPInputStream(connection.getInputStream()), charset);
        }
        return new InputStreamReader(connection.getInputStream(), charset);
    }

    @Override
    public <T> T get(String path, Class<T> resultClass) {
        return (T)this.retryLoop(() -> {
            try {
                HttpURLConnection connection = this.newClient(path);
                this.configure(connection);
                try {
                    Object t;
                    block11: {
                        Reader reader = RestDelegateImpl.readerFor(connection);
                        try {
                            t = this.gson.fromJson(reader, resultClass);
                            if (reader == null) break block11;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        reader.close();
                    }
                    return t;
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (IOException e) {
                throw new RadioBrowserException(e);
            }
        });
    }

    private <T> T retryLoop(Supplier<T> supplier) {
        int retries = this.connectionParams.getRetries();
        long retryInterval = this.connectionParams.getRetryInterval();
        while (true) {
            try {
                return supplier.get();
            }
            catch (HttpException e) {
                if (retries-- <= 0) {
                    throw e;
                }
                try {
                    log.debug("Got HTTP {}, retrying in {} ms", (Object)e.code, (Object)retryInterval);
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e1) {
                    throw new RadioBrowserException(e1);
                }
            }
        }
    }

    private void configure(HttpURLConnection connection) {
        connection.setRequestProperty("User-Agent", this.connectionParams.getUserAgent());
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Accept-Encoding", "gzip");
    }

    @Override
    public List<Station> postWithListOfStation(String path, Map<String, String> requestParams) {
        return this.post(path, requestParams, new TypeToken<List<Station>>(){});
    }

    @Override
    public List<Map<String, String>> postWithListOfMapOfString(String path, Map<String, String> requestParams) {
        return this.post(path, requestParams, new TypeToken<List<Map<String, String>>>(){});
    }

    private String asApplicationJson(Map<String, String> requestParams) throws UnsupportedEncodingException {
        String json = this.gson.toJson(requestParams);
        return json;
    }

    private static String asWwwFormUrlEncoded(Map<String, String> requestParams) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            sb.append("=");
            sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    private <T> T post(String path, Map<String, String> requestParams, TypeToken<T> resultClass) {
        return (T)this.retryLoop(() -> {
            try {
                HttpURLConnection connection = this.newClient(path);
                this.configure(connection);
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                this.sendXWWWFormUrlencodedRequest(connection, requestParams);
                try {
                    Object t;
                    block11: {
                        Reader reader = RestDelegateImpl.readerFor(connection);
                        try {
                            t = this.gson.fromJson(reader, resultClass);
                            if (reader == null) break block11;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        reader.close();
                    }
                    return t;
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (IOException e) {
                throw new RadioBrowserException(e);
            }
        });
    }

    private void sendXWWWFormUrlencodedRequest(HttpURLConnection connection, Map<String, String> requestParams) throws IOException {
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        String encoded = RestDelegateImpl.asWwwFormUrlEncoded(requestParams);
        log.debug("POST WWW-Form-UrlEncoded body: {}", (Object)encoded);
        connection.getOutputStream().write(encoded.getBytes(StandardCharsets.UTF_8));
        connection.getOutputStream().flush();
    }

    private void sendJsonRequest(HttpURLConnection connection, Map<String, String> requestParams) throws IOException {
        String json = this.asApplicationJson(requestParams);
        log.debug("POST JSON body: {}", (Object)json);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.getOutputStream().write(json.getBytes(StandardCharsets.UTF_8));
        connection.getOutputStream().flush();
    }

    @Override
    public <T> T post(String path, Map<String, String> requestParams, Class<T> resultClass) {
        return this.post(path, requestParams, TypeToken.get(resultClass));
    }

    private static void checkResponseStatus(HttpURLConnection response) throws IOException {
        RestDelegateImpl.logResponseStatus(response);
        if (response.getResponseCode() != 200) {
            throw new HttpException(response.getResponseCode(), response.getResponseMessage());
        }
    }

    private static void logResponseStatus(HttpURLConnection response) throws IOException {
        if (response.getResponseCode() != 200) {
            log.warn("Non HTTP OK/200 status: status={}, reason={}", (Object)response.getResponseCode(), (Object)response.getResponseMessage());
        } else {
            log.debug("HTTP response status={}, reason={}, length={}", response.getResponseCode(), response.getResponseMessage(), response.getContentLength());
        }
    }

    static class HttpException
    extends RadioBrowserException {
        private int code;
        private String message;

        HttpException(int inCode, String inMessage) {
            super("HTTP response " + inCode + " " + inMessage);
            this.code = inCode;
            this.message = inMessage;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Override
        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

