/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.search;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.person.PersonResultsSchema;
import java.util.HashMap;

public class SearchPersonEndpoint
extends Endpoint {
    private static final String V3_SEARCH_PERSON_ENDPOINT = "/3/search/person";
    private final String searchQuery;
    private boolean includeAdult;
    private String language;
    private int page;
    private String region;

    public SearchPersonEndpoint(TMDbClient tmdbClient, String searchQuery) {
        super(tmdbClient);
        this.searchQuery = searchQuery;
    }

    public SearchPersonEndpoint includeAdultContent(boolean value) {
        this.includeAdult = value;
        return this;
    }

    public SearchPersonEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public SearchPersonEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public SearchPersonEndpoint setRegion(String value) {
        this.region = value.toUpperCase();
        return this;
    }

    public PersonResultsSchema getResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("query", this.searchQuery);
        SearchPersonEndpoint.addQueryBoolean(query, "include_adult", this.includeAdult, false);
        SearchPersonEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        SearchPersonEndpoint.addQueryNumber(query, "page", this.page);
        SearchPersonEndpoint.addQueryString(query, "region", this.region);
        return this.tmdbClient.get(V3_SEARCH_PERSON_ENDPOINT, PersonResultsSchema.class, query);
    }
}

