/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.person;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.person.PersonIdAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.change.ChangesSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonCombinedCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonExternalIdsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonMovieCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonTaggedImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonTranslationsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonTvCreditsResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PersonIdEndpoint
extends Endpoint {
    private static final String V3_PERSON_ENDPOINT = "/3/person/";
    private static final String CHANGES_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.CHANGES);
    private static final String COMBINED_CREDITS_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.COMBINED_CREDITS);
    private static final String EXTERNAL_IDS_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.EXTERNAL_IDS);
    private static final String IMAGES_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.IMAGES);
    private static final String MOVIE_CREDITS_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.MOVIE_CREDITS);
    private static final String TAGGED_IMAGES_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.TAGGED_IMAGES);
    private static final String TRANSLATIONS_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.TRANSLATIONS);
    private static final String TV_CREDITS_ENDPOINT = "/" + String.valueOf((Object)PersonIdAppendToResponse.TV_CREDITS);
    private final long personId;
    private final List<PersonIdAppendToResponse> appendToResponse = new ArrayList<PersonIdAppendToResponse>();
    private final List<String> includeImageLanguage = new ArrayList<String>();
    private String language;
    private String startDate;
    private String endDate;
    private int page;

    public PersonIdEndpoint(TMDbClient tmdbClient, long personId) {
        super(tmdbClient);
        this.personId = personId;
    }

    public PersonIdEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public PersonIdEndpoint setStartDate(String value) {
        this.startDate = value;
        return this;
    }

    public PersonIdEndpoint setEndDate(String value) {
        this.endDate = value;
        return this;
    }

    public PersonIdEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public PersonIdEndpoint appendToResponse(PersonIdAppendToResponse ... values) {
        if (values != null) {
            PersonIdAppendToResponse[] personIdAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                PersonIdAppendToResponse value = personIdAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public PersonIdEndpoint includeImageLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String imageLanguage = stringArray[n2];
                if (!this.includeImageLanguage.contains(imageLanguage)) {
                    this.includeImageLanguage.add(imageLanguage);
                }
                ++n2;
            }
        }
        return this;
    }

    public PersonDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        PersonIdEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        PersonIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId, PersonDetailsSchema.class, query);
    }

    public ChangesSchema getChanges() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "start_date", this.startDate);
        PersonIdEndpoint.addQueryString(query, "end_date", this.endDate);
        PersonIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + CHANGES_ENDPOINT, ChangesSchema.class, query);
    }

    public PersonCombinedCreditsResponseSchema getCombinedCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + COMBINED_CREDITS_ENDPOINT, PersonCombinedCreditsResponseSchema.class, query);
    }

    public PersonExternalIdsResponseSchema getExternalIds() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + EXTERNAL_IDS_ENDPOINT, PersonExternalIdsResponseSchema.class, query);
    }

    public PersonImagesResponseSchema getImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        PersonIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + IMAGES_ENDPOINT, PersonImagesResponseSchema.class, query);
    }

    public PersonMovieCreditsResponseSchema getMovieCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + MOVIE_CREDITS_ENDPOINT, PersonMovieCreditsResponseSchema.class, query);
    }

    public PersonTaggedImagesResponseSchema getTaggedImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        PersonIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + TAGGED_IMAGES_ENDPOINT, PersonTaggedImagesResponseSchema.class, query);
    }

    public PersonTranslationsResponseSchema getTranslations() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + TRANSLATIONS_ENDPOINT, PersonTranslationsResponseSchema.class, query);
    }

    public PersonTvCreditsResponseSchema getTvCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_PERSON_ENDPOINT + this.personId + TV_CREDITS_ENDPOINT, PersonTvCreditsResponseSchema.class, query);
    }
}

