/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.account.tv;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.account.tv.TvSortBy;
import com.universalmediaserver.tmdbapi.schema.tv.TvShortResultsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvSimpleResultsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvTypedResultsSchema;
import java.util.HashMap;

public class AccountTvV4Endpoint
extends Endpoint {
    private static final String V4_ACCOUNT_ENDPOINT = "/4/account/";
    private static final String V4_ACCOUNT_TV_ENDPOINT = "/tv/";
    private static final String TV_FAVORITES_ENDPOINT = "/tv/favorites";
    private static final String TV_RECOMMENDATIONS_ENDPOINT = "/tv/recommendations";
    private static final String TV_WATCHLIST_ENDPOINT = "/tv/watchlist";
    private static final String TV_RATED_ENDPOINT = "/tv/rated";
    private final String accountId;
    private String sortBy;
    private int page;

    public AccountTvV4Endpoint(TMDbClient tmdbClient, String accountId) {
        super(tmdbClient);
        this.accountId = accountId;
    }

    public AccountTvV4Endpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public AccountTvV4Endpoint sortBy(TvSortBy value) {
        this.sortBy = value != null ? value.toString() : null;
        return this;
    }

    public TvSimpleResultsSchema getFavorites() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountTvV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountTvV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + TV_FAVORITES_ENDPOINT, TvSimpleResultsSchema.class, query);
    }

    public TvTypedResultsSchema getRecommendations() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountTvV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountTvV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + TV_RECOMMENDATIONS_ENDPOINT, TvTypedResultsSchema.class, query);
    }

    public TvSimpleResultsSchema getWatchlist() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountTvV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountTvV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + TV_WATCHLIST_ENDPOINT, TvSimpleResultsSchema.class, query);
    }

    public TvShortResultsSchema getRated() {
        HashMap<String, String> query = new HashMap<String, String>();
        AccountTvV4Endpoint.addQueryNumber(query, "page", this.page);
        AccountTvV4Endpoint.addQueryString(query, "sort_by", this.sortBy);
        return this.tmdbClient.get(V4_ACCOUNT_ENDPOINT + this.accountId + TV_RATED_ENDPOINT, TvShortResultsSchema.class, query);
    }
}

