/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.coverartarchive.api.endpoint.release;

import com.universalmediaserver.coverartarchive.api.CoverArtArchiveClient;
import com.universalmediaserver.coverartarchive.api.endpoint.Endpoint;
import com.universalmediaserver.coverartarchive.api.endpoint.ThumbnailSize;
import com.universalmediaserver.coverartarchive.api.schema.ResultSchema;

public class ReleaseEndpoint
extends Endpoint {
    protected static final String RELEASE_ENDPOINT = "release/";
    private final String musicBrainzId;

    public ReleaseEndpoint(CoverArtArchiveClient musicBrainzAPIClient, String musicBrainzId) {
        super(musicBrainzAPIClient);
        this.musicBrainzId = musicBrainzId;
    }

    public ResultSchema getDetails() {
        return this.client.get(RELEASE_ENDPOINT + this.musicBrainzId, ResultSchema.class, null);
    }

    public String getFrontImageLocation() {
        return this.client.getRedirectLocation(RELEASE_ENDPOINT + this.musicBrainzId + "/front");
    }

    public byte[] getFrontImageBytes() {
        return this.client.getJpegBytes(RELEASE_ENDPOINT + this.musicBrainzId + "/front");
    }

    public String getFrontImageLocation(ThumbnailSize size) {
        return this.client.getRedirectLocation(RELEASE_ENDPOINT + this.musicBrainzId + "/front-" + size);
    }

    public byte[] getFrontImageBytes(ThumbnailSize size) {
        return this.client.getJpegBytes(RELEASE_ENDPOINT + this.musicBrainzId + "/front-" + size);
    }

    public String getBackImageLocation() {
        return this.client.getRedirectLocation(RELEASE_ENDPOINT + this.musicBrainzId + "/back");
    }

    public byte[] getBackImageBytes() {
        return this.client.getJpegBytes(RELEASE_ENDPOINT + this.musicBrainzId + "/back");
    }

    public String getBackImageLocation(ThumbnailSize size) {
        return this.client.getRedirectLocation(RELEASE_ENDPOINT + this.musicBrainzId + "/back-" + size);
    }

    public byte[] getBackImageBytes(ThumbnailSize size) {
        return this.client.getJpegBytes(RELEASE_ENDPOINT + this.musicBrainzId + "/back-" + size);
    }

    public String getImageLocation(Long id) {
        return this.client.getRedirectLocation(RELEASE_ENDPOINT + this.musicBrainzId + "/" + id);
    }

    public byte[] getImageBytes(Long id) {
        return this.client.getJpegBytes(RELEASE_ENDPOINT + this.musicBrainzId + "/" + id);
    }

    public String getImageLocation(Long id, ThumbnailSize size) {
        return this.client.getRedirectLocation(RELEASE_ENDPOINT + this.musicBrainzId + "/" + id + "-" + size);
    }

    public byte[] getImageBytes(Long id, ThumbnailSize size) {
        return this.client.getJpegBytes(RELEASE_ENDPOINT + this.musicBrainzId + "/" + id + "-" + size);
    }
}

