/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSDAlphaChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDColorData;
import com.twelvemonkeys.imageio.plugins.psd.PSDDirectoryResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDDisplayInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDEXIF1Data;
import com.twelvemonkeys.imageio.plugins.psd.PSDGlobalLayerMask;
import com.twelvemonkeys.imageio.plugins.psd.PSDGridAndGuideInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDIPTCData;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDPixelAspectRatio;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlags;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlagsInformation;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintScale;
import com.twelvemonkeys.imageio.plugins.psd.PSDResolutionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUnicodeAlphaNames;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.plugins.psd.PSDVersionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDXMPData;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.FilterIterator;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public final class PSDMetadata
extends AbstractMetadata {
    static final String NATIVE_METADATA_FORMAT_NAME = "com_twelvemonkeys_imageio_psd_image_1.0";
    static final String NATIVE_METADATA_FORMAT_CLASS_NAME = "com.twelvemonkeys.imageio.plugins.psd.PSDMetadataFormat";
    PSDHeader header;
    PSDColorData colorData;
    int compression = -1;
    List<PSDImageResource> imageResources;
    PSDGlobalLayerMask globalLayerMask;
    List<PSDLayerInfo> layerInfo;
    int layerCount;
    long imageResourcesStart;
    long layerAndMaskInfoStart;
    long layersStart;
    long imageDataStart;
    static final String[] COLOR_MODES = new String[]{"MONOCHROME", "GRAYSCALE", "INDEXED", "RGB", "CMYK", null, null, "MULTICHANNEL", "DUOTONE", "LAB"};
    static final String[] DISPLAY_INFO_CS = new String[]{"RGB", "HSB", "CMYK", "PANTONE", "FOCOLTONE", "TRUMATCH", "TOYO", "LAB", "GRAYSCALE", null, "HKS", "DIC", null, "ANPA"};
    static final String[] DISPLAY_INFO_KINDS = new String[]{"selected", "protected"};
    static final String[] RESOLUTION_UNITS = new String[]{null, "pixels/inch", "pixels/cm"};
    static final String[] DIMENSION_UNITS = new String[]{null, "in", "cm", "pt", "picas", "columns"};
    static final String[] JAVA_CS = new String[]{"XYZ", "Lab", "Yuv", "YCbCr", "Yxy", "RGB", "GRAY", "HSV", "HLS", "CMYK", "CMY", "2CLR", "3CLR", "4CLR", "5CLR", "6CLR", "7CLR", "8CLR", "9CLR", "ACLR", "BCLR", "CCLR", "DCLR", "ECLR", "FCLR"};
    static final String[] GUIDE_ORIENTATIONS = new String[]{"vertical", "horizontal"};
    static final String[] PRINT_SCALE_STYLES = new String[]{"centered", "scaleToFit", "userDefined"};

    PSDMetadata() {
        super(true, NATIVE_METADATA_FORMAT_NAME, NATIVE_METADATA_FORMAT_CLASS_NAME, null, null);
    }

    @Override
    protected Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(NATIVE_METADATA_FORMAT_NAME);
        iIOMetadataNode.appendChild(this.createHeaderNode());
        if (this.header.mode == 2) {
            iIOMetadataNode.appendChild(this.createPaletteNode());
        }
        if (this.imageResources != null && !this.imageResources.isEmpty()) {
            iIOMetadataNode.appendChild(this.createImageResourcesNode());
        }
        if (this.layerInfo != null && !this.layerInfo.isEmpty()) {
            iIOMetadataNode.appendChild(this.createLayerInfoNode());
        }
        if (this.globalLayerMask != null && this.globalLayerMask != PSDGlobalLayerMask.NULL_MASK) {
            iIOMetadataNode.appendChild(this.createGlobalLayerMaskNode());
        }
        return iIOMetadataNode;
    }

    private Node createHeaderNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Header");
        iIOMetadataNode.setAttribute("type", "PSD");
        iIOMetadataNode.setAttribute("version", this.header.largeFormat ? "2" : "1");
        iIOMetadataNode.setAttribute("channels", Integer.toString(this.header.channels));
        iIOMetadataNode.setAttribute("height", Integer.toString(this.header.height));
        iIOMetadataNode.setAttribute("width", Integer.toString(this.header.width));
        iIOMetadataNode.setAttribute("bits", Integer.toString(this.header.bits));
        iIOMetadataNode.setAttribute("mode", COLOR_MODES[this.header.mode]);
        return iIOMetadataNode;
    }

    private Node createImageResourcesNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("ImageResources");
        for (PSDImageResource pSDImageResource : this.imageResources) {
            IIOMetadataNode iIOMetadataNode2;
            block41: {
                Object object;
                if (pSDImageResource instanceof ICCProfile) {
                    object = (ICCProfile)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("ICCProfile");
                    iIOMetadataNode2.setAttribute("colorSpaceType", JAVA_CS[((ICCProfile)object).getProfile().getColorSpaceType()]);
                    iIOMetadataNode2.setUserObject(((ICCProfile)object).getProfile());
                } else if (pSDImageResource instanceof PSDAlphaChannelInfo) {
                    object = (PSDAlphaChannelInfo)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("AlphaChannelInfo");
                    for (String string : ((PSDAlphaChannelInfo)object).names) {
                        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Name");
                        iIOMetadataNode3.setAttribute("value", string);
                        iIOMetadataNode2.appendChild(iIOMetadataNode3);
                    }
                } else if (pSDImageResource instanceof PSDDisplayInfo) {
                    object = (PSDDisplayInfo)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("DisplayInfo");
                    iIOMetadataNode2.setAttribute("colorSpace", DISPLAY_INFO_CS[((PSDDisplayInfo)object).colorSpace]);
                    StringBuilder stringBuilder = new StringBuilder();
                    short[] sArray = ((PSDDisplayInfo)object).colors;
                    int n = sArray.length;
                    for (int i = 0; i < n; ++i) {
                        short s = sArray[i];
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(Integer.toString(s));
                    }
                    iIOMetadataNode2.setAttribute("colors", stringBuilder.toString());
                    iIOMetadataNode2.setAttribute("opacity", Integer.toString(((PSDDisplayInfo)object).opacity));
                    iIOMetadataNode2.setAttribute("kind", DISPLAY_INFO_KINDS[((PSDDisplayInfo)object).kind]);
                } else if (pSDImageResource instanceof PSDGridAndGuideInfo) {
                    object = (PSDGridAndGuideInfo)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("GridAndGuideInfo");
                    iIOMetadataNode2.setAttribute("version", String.valueOf(((PSDGridAndGuideInfo)object).version));
                    iIOMetadataNode2.setAttribute("verticalGridCycle", String.valueOf(((PSDGridAndGuideInfo)object).gridCycleVertical));
                    iIOMetadataNode2.setAttribute("horizontalGridCycle", String.valueOf(((PSDGridAndGuideInfo)object).gridCycleHorizontal));
                    for (PSDGridAndGuideInfo.GuideResource guideResource : ((PSDGridAndGuideInfo)object).guides) {
                        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("Guide");
                        iIOMetadataNode4.setAttribute("location", Integer.toString(guideResource.location));
                        iIOMetadataNode4.setAttribute("orientation", GUIDE_ORIENTATIONS[guideResource.direction]);
                        iIOMetadataNode2.appendChild(iIOMetadataNode4);
                    }
                } else if (pSDImageResource instanceof PSDPixelAspectRatio) {
                    object = (PSDPixelAspectRatio)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
                    iIOMetadataNode2.setAttribute("version", String.valueOf(((PSDPixelAspectRatio)object).version));
                    iIOMetadataNode2.setAttribute("aspectRatio", String.valueOf(((PSDPixelAspectRatio)object).aspect));
                } else if (pSDImageResource instanceof PSDPrintFlags) {
                    object = (PSDPrintFlags)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("PrintFlags");
                    iIOMetadataNode2.setAttribute("labels", String.valueOf(((PSDPrintFlags)object).labels));
                    iIOMetadataNode2.setAttribute("cropMarks", String.valueOf(((PSDPrintFlags)object).cropMasks));
                    iIOMetadataNode2.setAttribute("colorBars", String.valueOf(((PSDPrintFlags)object).colorBars));
                    iIOMetadataNode2.setAttribute("registrationMarks", String.valueOf(((PSDPrintFlags)object).registrationMarks));
                    iIOMetadataNode2.setAttribute("negative", String.valueOf(((PSDPrintFlags)object).negative));
                    iIOMetadataNode2.setAttribute("flip", String.valueOf(((PSDPrintFlags)object).flip));
                    iIOMetadataNode2.setAttribute("interpolate", String.valueOf(((PSDPrintFlags)object).interpolate));
                    iIOMetadataNode2.setAttribute("caption", String.valueOf(((PSDPrintFlags)object).caption));
                } else if (pSDImageResource instanceof PSDPrintFlagsInformation) {
                    object = (PSDPrintFlagsInformation)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("PrintFlagsInformation");
                    iIOMetadataNode2.setAttribute("version", String.valueOf(((PSDPrintFlagsInformation)object).version));
                    iIOMetadataNode2.setAttribute("cropMarks", String.valueOf(((PSDPrintFlagsInformation)object).cropMasks));
                    iIOMetadataNode2.setAttribute("field", String.valueOf(((PSDPrintFlagsInformation)object).field));
                    iIOMetadataNode2.setAttribute("bleedWidth", String.valueOf(((PSDPrintFlagsInformation)object).bleedWidth));
                    iIOMetadataNode2.setAttribute("bleedScale", String.valueOf(((PSDPrintFlagsInformation)object).bleedScale));
                } else if (pSDImageResource instanceof PSDPrintScale) {
                    object = (PSDPrintScale)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("PrintScale");
                    iIOMetadataNode2.setAttribute("style", PRINT_SCALE_STYLES[((PSDPrintScale)object).style]);
                    iIOMetadataNode2.setAttribute("xLocation", String.valueOf(((PSDPrintScale)object).xLocation));
                    iIOMetadataNode2.setAttribute("yLocation", String.valueOf(((PSDPrintScale)object).ylocation));
                    iIOMetadataNode2.setAttribute("scale", String.valueOf(((PSDPrintScale)object).scale));
                } else if (pSDImageResource instanceof PSDResolutionInfo) {
                    object = (PSDResolutionInfo)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("ResolutionInfo");
                    iIOMetadataNode2.setAttribute("horizontalResolution", String.valueOf(((PSDResolutionInfo)object).hRes));
                    iIOMetadataNode2.setAttribute("horizontalResolutionUnit", RESOLUTION_UNITS[((PSDResolutionInfo)object).hResUnit]);
                    iIOMetadataNode2.setAttribute("widthUnit", DIMENSION_UNITS[((PSDResolutionInfo)object).widthUnit]);
                    iIOMetadataNode2.setAttribute("verticalResolution", String.valueOf(((PSDResolutionInfo)object).vRes));
                    iIOMetadataNode2.setAttribute("verticalResolutionUnit", RESOLUTION_UNITS[((PSDResolutionInfo)object).vResUnit]);
                    iIOMetadataNode2.setAttribute("heightUnit", DIMENSION_UNITS[((PSDResolutionInfo)object).heightUnit]);
                } else if (pSDImageResource instanceof PSDUnicodeAlphaNames) {
                    object = (PSDUnicodeAlphaNames)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("UnicodeAlphaNames");
                    for (String string : ((PSDUnicodeAlphaNames)object).names) {
                        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("Name");
                        iIOMetadataNode5.setAttribute("value", string);
                        iIOMetadataNode2.appendChild(iIOMetadataNode5);
                    }
                } else if (pSDImageResource instanceof PSDVersionInfo) {
                    object = (PSDVersionInfo)pSDImageResource;
                    iIOMetadataNode2 = new IIOMetadataNode("VersionInfo");
                    iIOMetadataNode2.setAttribute("version", String.valueOf(((PSDVersionInfo)object).version));
                    iIOMetadataNode2.setAttribute("hasRealMergedData", String.valueOf(((PSDVersionInfo)object).hasRealMergedData));
                    iIOMetadataNode2.setAttribute("writer", ((PSDVersionInfo)object).writer);
                    iIOMetadataNode2.setAttribute("reader", ((PSDVersionInfo)object).reader);
                    iIOMetadataNode2.setAttribute("fileVersion", String.valueOf(((PSDVersionInfo)object).fileVersion));
                } else {
                    if (pSDImageResource instanceof PSDThumbnail) {
                        try {
                            object = (PSDThumbnail)pSDImageResource;
                            iIOMetadataNode2 = new IIOMetadataNode("Thumbnail");
                            iIOMetadataNode2.setUserObject(((PSDThumbnail)object).getThumbnail());
                            break block41;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    if (pSDImageResource instanceof PSDIPTCData) {
                        object = (PSDIPTCData)pSDImageResource;
                        iIOMetadataNode2 = new IIOMetadataNode("DirectoryResource");
                        iIOMetadataNode2.setAttribute("type", "IPTC");
                        iIOMetadataNode2.setUserObject(((PSDIPTCData)object).data);
                        if (((PSDDirectoryResource)object).getDirectory() != null) {
                            this.appendEntries(iIOMetadataNode2, "IPTC", ((PSDDirectoryResource)object).getDirectory());
                        }
                    } else if (pSDImageResource instanceof PSDEXIF1Data) {
                        object = (PSDEXIF1Data)pSDImageResource;
                        iIOMetadataNode2 = new IIOMetadataNode("DirectoryResource");
                        iIOMetadataNode2.setAttribute("type", "TIFF");
                        iIOMetadataNode2.setUserObject(((PSDEXIF1Data)object).data);
                        if (((PSDDirectoryResource)object).getDirectory() != null) {
                            this.appendEntries(iIOMetadataNode2, "EXIF", ((PSDDirectoryResource)object).getDirectory());
                        }
                    } else if (pSDImageResource instanceof PSDXMPData) {
                        object = (PSDXMPData)pSDImageResource;
                        iIOMetadataNode2 = new IIOMetadataNode("DirectoryResource");
                        iIOMetadataNode2.setAttribute("type", "XMP");
                        iIOMetadataNode2.setUserObject(((PSDXMPData)object).data);
                        if (((PSDDirectoryResource)object).getDirectory() != null) {
                            this.appendEntries(iIOMetadataNode2, "XMP", ((PSDDirectoryResource)object).getDirectory());
                        }
                    } else {
                        iIOMetadataNode2 = new IIOMetadataNode("ImageResource");
                        object = PSDImageResource.resourceTypeForId(pSDImageResource.id);
                        if (!"UnknownResource".equals(object)) {
                            iIOMetadataNode2.setAttribute("name", (String)object);
                        }
                        iIOMetadataNode2.setAttribute("length", String.valueOf(pSDImageResource.size));
                    }
                }
            }
            iIOMetadataNode2.setAttribute("resourceId", String.format("0x%04x", pSDImageResource.id));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private void appendEntries(IIOMetadataNode iIOMetadataNode, String string, Directory directory) {
        for (Entry entry : directory) {
            Object object = entry.getIdentifier();
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Entry");
            iIOMetadataNode2.setAttribute("tag", String.format("%s", object));
            String string2 = entry.getFieldName();
            if (string2 != null) {
                iIOMetadataNode2.setAttribute("field", String.format("%s", string2));
            } else if ("IPTC".equals(string)) {
                iIOMetadataNode2.setAttribute("field", String.format("%s:%s", (Integer)object >> 8, (Integer)object & 0xFF));
            }
            if (entry.getValue() instanceof Directory) {
                this.appendEntries(iIOMetadataNode2, string, (Directory)entry.getValue());
                iIOMetadataNode2.setAttribute("type", "Directory");
            } else {
                iIOMetadataNode2.setAttribute("value", entry.getValueAsString());
                iIOMetadataNode2.setAttribute("type", entry.getTypeName());
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    private Node createLayerInfoNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Layers");
        for (PSDLayerInfo pSDLayerInfo : this.layerInfo) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("LayerInfo");
            iIOMetadataNode2.setAttribute("name", pSDLayerInfo.getLayerName());
            iIOMetadataNode2.setAttribute("top", String.valueOf(pSDLayerInfo.top));
            iIOMetadataNode2.setAttribute("left", String.valueOf(pSDLayerInfo.left));
            iIOMetadataNode2.setAttribute("bottom", String.valueOf(pSDLayerInfo.bottom));
            iIOMetadataNode2.setAttribute("right", String.valueOf(pSDLayerInfo.right));
            iIOMetadataNode2.setAttribute("layerId", String.valueOf(pSDLayerInfo.getLayerId()));
            if (pSDLayerInfo.groupId != -1) {
                iIOMetadataNode2.setAttribute("groupId", String.valueOf(pSDLayerInfo.groupId));
            }
            iIOMetadataNode2.setAttribute("blendMode", PSDUtil.intToStr(pSDLayerInfo.blendMode.blendMode));
            iIOMetadataNode2.setAttribute("opacity", String.valueOf(pSDLayerInfo.blendMode.opacity));
            iIOMetadataNode2.setAttribute("clipping", this.getClippingValue(pSDLayerInfo.blendMode.clipping));
            iIOMetadataNode2.setAttribute("flags", String.valueOf(pSDLayerInfo.blendMode.flags));
            if (pSDLayerInfo.isGroup) {
                iIOMetadataNode2.setAttribute("group", "true");
            }
            if (pSDLayerInfo.isDivider) {
                iIOMetadataNode2.setAttribute("sectionDivider", "true");
            }
            if ((pSDLayerInfo.blendMode.flags & 1) != 0) {
                iIOMetadataNode2.setAttribute("transparencyProtected", "true");
            }
            if ((pSDLayerInfo.blendMode.flags & 2) != 0) {
                iIOMetadataNode2.setAttribute("visible", "true");
            }
            if ((pSDLayerInfo.blendMode.flags & 4) != 0) {
                iIOMetadataNode2.setAttribute("obsolete", "true");
            }
            if ((pSDLayerInfo.blendMode.flags & 8) != 0 && (pSDLayerInfo.blendMode.flags & 0x10) != 0) {
                iIOMetadataNode2.setAttribute("pixelDataIrrelevant", "true");
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private String getClippingValue(int n) {
        switch (n) {
            case 0: {
                return "base";
            }
            case 1: {
                return "non-base";
            }
        }
        return String.valueOf(n);
    }

    private Node createGlobalLayerMaskNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("GlobalLayerMask");
        iIOMetadataNode.setAttribute("colorSpace", String.valueOf(this.globalLayerMask.colorSpace));
        iIOMetadataNode.setAttribute("colors", PSDMetadata.toListString(this.globalLayerMask.colors));
        iIOMetadataNode.setAttribute("opacity", String.valueOf(this.globalLayerMask.opacity));
        iIOMetadataNode.setAttribute("kind", this.getGlobalLayerMaskKind(this.globalLayerMask.kind));
        return iIOMetadataNode;
    }

    private String getGlobalLayerMaskKind(int n) {
        switch (n) {
            case 0: {
                return "selected";
            }
            case 1: {
                return "protected";
            }
            case 80: 
            case 128: {
                return "layer";
            }
        }
        return String.valueOf(n);
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        switch (this.header.mode) {
            case 0: 
            case 1: 
            case 8: {
                string = "GRAY";
                break;
            }
            case 2: 
            case 3: {
                string = "RGB";
                break;
            }
            case 4: {
                string = "CMYK";
                break;
            }
            case 7: {
                string = this.getMultiChannelCS(this.header.channels);
                break;
            }
            case 9: {
                string = "Lab";
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreachable");
            }
        }
        iIOMetadataNode2.setAttribute("name", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode3.setAttribute("value", Integer.toString(this.header.channels));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode4.setAttribute("value", "true");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        if (this.header.mode == 2) {
            IIOMetadataNode iIOMetadataNode5 = this.createPaletteNode();
            iIOMetadataNode.appendChild(iIOMetadataNode5);
        }
        return iIOMetadataNode;
    }

    private IIOMetadataNode createPaletteNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Palette");
        IndexColorModel indexColorModel = this.colorData.getIndexColorModel();
        for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PaletteEntry");
            iIOMetadataNode2.setAttribute("index", Integer.toString(i));
            iIOMetadataNode2.setAttribute("red", Integer.toString(indexColorModel.getRed(i)));
            iIOMetadataNode2.setAttribute("green", Integer.toString(indexColorModel.getGreen(i)));
            iIOMetadataNode2.setAttribute("blue", Integer.toString(indexColorModel.getBlue(i)));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private String getMultiChannelCS(short s) {
        if (s < 16) {
            return String.format("%xCLR", s);
        }
        throw new UnsupportedOperationException("Standard meta data format does not support more than 15 channels");
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        switch (this.compression) {
            case 0: {
                string = "none";
                break;
            }
            case 1: {
                string = "PackBits";
                break;
            }
            case 2: 
            case 3: {
                string = "Zip";
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreachable");
            }
        }
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.compression != 0) {
            iIOMetadataNode.appendChild(new IIOMetadataNode("Lossless"));
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", "PlaneInterleaved");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode3.setAttribute("value", this.header.mode == 2 ? "Index" : "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        String string = Integer.toString(this.header.bits);
        Object[] objectArray = new String[this.header.channels];
        Arrays.fill(objectArray, string);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode4.setAttribute("value", StringUtil.toCSVString(objectArray, " "));
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        Object object;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        float f = 1.0f;
        Iterator<PSDPixelAspectRatio> iterator = this.getResources(PSDPixelAspectRatio.class);
        if (iterator.hasNext()) {
            object = iterator.next();
            f = (float)((PSDPixelAspectRatio)object).aspect;
        }
        iIOMetadataNode2.setAttribute("value", Float.toString(f));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        object = this.getResources(PSDResolutionInfo.class);
        if (object.hasNext()) {
            PSDResolutionInfo pSDResolutionInfo = (PSDResolutionInfo)object.next();
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(PSDMetadata.asMM(pSDResolutionInfo.hResUnit, pSDResolutionInfo.hRes)));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(PSDMetadata.asMM(pSDResolutionInfo.vResUnit, pSDResolutionInfo.vRes)));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private static float asMM(short s, float f) {
        return (s == 1 ? 25.4f : 10.0f) / f;
    }

    @Override
    protected IIOMetadataNode getStandardDocumentNode() {
        PSDEXIF1Data pSDEXIF1Data;
        Entry entry;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", this.header.largeFormat ? "2" : "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        Iterator<PSDEXIF1Data> iterator = this.getResources(PSDEXIF1Data.class);
        if (iterator.hasNext() && (entry = (pSDEXIF1Data = iterator.next()).getDirectory().getEntryById(306)) != null) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ImageCreationTime");
            String string = entry.getValueAsString();
            iIOMetadataNode3.setAttribute("year", string.substring(0, 4));
            iIOMetadataNode3.setAttribute("month", string.substring(5, 7));
            iIOMetadataNode3.setAttribute("day", string.substring(8, 10));
            iIOMetadataNode3.setAttribute("hour", string.substring(11, 13));
            iIOMetadataNode3.setAttribute("minute", string.substring(14, 16));
            iIOMetadataNode3.setAttribute("second", string.substring(17, 19));
            iIOMetadataNode.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        Iterator<PSDImageResource> iterator = this.getResources(1028, 1058, 1060);
        if (!iterator.hasNext()) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        while (iterator.hasNext()) {
            PSDDirectoryResource pSDDirectoryResource;
            PSDImageResource pSDImageResource = iterator.next();
            if (pSDImageResource instanceof PSDIPTCData) {
                pSDDirectoryResource = (PSDIPTCData)pSDImageResource;
                this.appendTextEntriesFlat(iIOMetadataNode, pSDDirectoryResource.getDirectory(), new FilterIterator.Filter<Entry>(){

                    @Override
                    public boolean accept(Entry entry) {
                        Integer n = (Integer)entry.getIdentifier();
                        switch (n) {
                            case 592: 
                            case 627: 
                            case 628: 
                            case 632: {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                continue;
            }
            if (!(pSDImageResource instanceof PSDEXIF1Data)) continue;
            pSDDirectoryResource = (PSDEXIF1Data)pSDImageResource;
            this.appendTextEntriesFlat(iIOMetadataNode, pSDDirectoryResource.getDirectory(), new FilterIterator.Filter<Entry>(){

                @Override
                public boolean accept(Entry entry) {
                    Integer n = (Integer)entry.getIdentifier();
                    switch (n) {
                        case 270: 
                        case 305: 
                        case 315: 
                        case 33432: {
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        return iIOMetadataNode;
    }

    private void appendTextEntriesFlat(IIOMetadataNode iIOMetadataNode, Directory directory, FilterIterator.Filter<Entry> filter) {
        FilterIterator<Entry> filterIterator = new FilterIterator<Entry>(directory.iterator(), filter);
        while (filterIterator.hasNext()) {
            Entry entry = filterIterator.next();
            if (entry.getValue() instanceof Directory) {
                this.appendTextEntriesFlat(iIOMetadataNode, (Directory)entry.getValue(), filter);
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            String string = entry.getFieldName();
            if (string != null) {
                iIOMetadataNode2.setAttribute("keyword", string);
            } else {
                iIOMetadataNode2.setAttribute("keyword", String.format("%s", entry.getIdentifier()));
            }
            iIOMetadataNode2.setAttribute("value", entry.getValueAsString());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    @Override
    protected IIOMetadataNode getStandardTileNode() {
        return super.getStandardTileNode();
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.hasAlpha() ? "premultiplied" : "none");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    boolean hasAlpha() {
        return this.layerCount < 0;
    }

    int getLayerCount() {
        return Math.abs(this.layerCount);
    }

    private <T extends PSDImageResource> Iterator<T> getResources(final Class<T> clazz) {
        Iterator<PSDImageResource> iterator = this.imageResources.iterator();
        return new FilterIterator<PSDImageResource>(iterator, new FilterIterator.Filter<T>(){

            @Override
            public boolean accept(T t) {
                return clazz.isInstance(t);
            }
        });
    }

    private Iterator<PSDImageResource> getResources(final int ... nArray) {
        Iterator<PSDImageResource> iterator = this.imageResources.iterator();
        return new FilterIterator<PSDImageResource>(iterator, new FilterIterator.Filter<PSDImageResource>(){

            @Override
            public boolean accept(PSDImageResource pSDImageResource) {
                for (int n : nArray) {
                    if (n != pSDImageResource.id) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

