/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFEntry;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSDEXIF1Data;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageWriteParam;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.RasterUtils;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Collections;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public final class PSDImageWriter
extends ImageWriterBase {
    PSDImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new PSDImageWriteParam(this.getLocale());
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.assertOutput();
        this.imageOutput.setByteOrder(ByteOrder.BIG_ENDIAN);
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = renderedImage.getColorModel().getColorSpace().getNumComponents();
        int n2 = sampleModel.getNumBands();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        int n5 = PSDImageWriter.getBitsPerSample(sampleModel);
        int n6 = PSDImageWriter.getColorMode(renderedImage.getColorModel());
        boolean bl = n3 > 30000 || n4 > 30000;
        new PSDHeader(n2, n3, n4, n5, n6, bl).write(this.imageOutput);
        this.writeColorModeData(renderedImage, n6);
        this.writeImageResources(renderedImage, n6);
        if (bl) {
            this.imageOutput.writeLong(0L);
        } else {
            this.imageOutput.writeInt(0);
        }
        this.processImageStarted(0);
        int n7 = PSDImageWriteParam.getCompressionType(imageWriteParam);
        this.imageOutput.writeShort(n7);
        long l = this.imageOutput.getStreamPosition();
        int[] nArray = new int[n7 == 1 ? n4 * n2 : 0];
        this.imageOutput.skipBytes(nArray.length * (bl ? 4 : 2));
        Raster raster = sampleModel.getTransferType() == 3 && sampleModel instanceof SinglePixelPackedSampleModel ? RasterUtils.asByteRaster(renderedImage.getTile(0, 0)) : renderedImage.getTile(0, 0);
        for (int i = 0; i < n2; ++i) {
            Raster raster2 = raster.createChild(0, 0, n3, n4, 0, 0, new int[]{i});
            switch (n5) {
                case 1: 
                case 8: {
                    this.write8BitChannel(i, n, n6, n7, raster2, nArray);
                    break;
                }
                case 16: {
                    this.write16BitChannel(i, n, n6, n7, raster2, nArray);
                    break;
                }
                case 32: {
                    this.write32BitChannel(i, n, n6, n7, raster2, nArray);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.processImageProgress((float)i * 100.0f / (float)n2);
        }
        this.updateByteCounts(l, nArray, bl);
        this.processImageComplete();
    }

    private void updateByteCounts(long l, int[] nArray, boolean bl) throws IOException {
        if (nArray.length == 0) {
            return;
        }
        long l2 = this.imageOutput.getStreamPosition();
        this.imageOutput.seek(l);
        if (bl) {
            this.imageOutput.writeInts(nArray, 0, nArray.length);
        } else {
            for (int n : nArray) {
                this.imageOutput.writeShort(n);
            }
        }
        this.imageOutput.seek(l2);
    }

    private void writeColorModeData(RenderedImage renderedImage, int n) throws IOException {
        if (n == 2) {
            IndexColorModel indexColorModel = (IndexColorModel)renderedImage.getColorModel();
            this.imageOutput.writeInt(768);
            byte[] byArray = new byte[256];
            indexColorModel.getReds(byArray);
            this.imageOutput.write(byArray);
            indexColorModel.getGreens(byArray);
            this.imageOutput.write(byArray);
            indexColorModel.getBlues(byArray);
            this.imageOutput.write(byArray);
        } else {
            this.imageOutput.writeInt(0);
        }
    }

    private void writeImageResources(RenderedImage renderedImage, int n) throws IOException {
        Object object;
        this.imageOutput.writeInt(0);
        long l = this.imageOutput.getStreamPosition();
        if (n != 0 && n != 2 && !((ColorSpace)(object = renderedImage.getColorModel().getColorSpace())).isCS_sRGB() && object instanceof ICC_ColorSpace) {
            ICC_Profile iCC_Profile = ((ICC_ColorSpace)object).getProfile();
            ICCProfile.writeData(this.imageOutput, iCC_Profile);
        }
        object = new TIFFEntry(305, 2, "TwelveMonkeys ImageIO PSD writer " + this.originatingProvider.getVersion());
        PSDEXIF1Data.writeData(this.imageOutput, Collections.singleton(object));
        long l2 = this.imageOutput.getStreamPosition();
        this.imageOutput.seek(l - 4L);
        this.imageOutput.writeInt((int)(l2 - l));
        this.imageOutput.seek(l2);
    }

    private void write8BitChannel(int n, int n2, int n3, int n4, Raster raster, int[] nArray) throws IOException {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        byte[] byArray = null;
        for (int i = 0; i < n6; ++i) {
            byArray = (byte[])raster.getDataElements(0, i, n5, 1, byArray);
            if (n3 == 4 && n < n2) {
                for (int j = 0; j < byArray.length; ++j) {
                    byArray[j] = (byte)(255 - byArray[j] & 0xFF);
                }
            }
            if (n4 == 0) {
                this.imageOutput.write(byArray);
                continue;
            }
            if (n4 == 1) {
                long l = this.imageOutput.getStreamPosition();
                try (EncoderStream encoderStream = new EncoderStream(IIOUtil.createStreamAdapter(this.imageOutput), new PackBitsEncoder());){
                    ((OutputStream)encoderStream).write(byArray);
                }
                long l2 = this.imageOutput.getStreamPosition();
                nArray[i + n * n6] = (int)(l2 - l);
                continue;
            }
            throw new IIOException("PSD with ZIP compression not supported");
        }
    }

    private void write16BitChannel(int n, int n2, int n3, int n4, Raster raster, int[] nArray) throws IOException {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        short[] sArray = null;
        for (int i = 0; i < n6; ++i) {
            sArray = (short[])raster.getDataElements(0, i, n5, 1, sArray);
            if (n3 == 4 && n < n2) {
                for (int j = 0; j < sArray.length; ++j) {
                    sArray[j] = (short)(65535 - sArray[j] & 0xFFFF);
                }
            }
            if (n4 == 0) {
                this.imageOutput.writeShorts(sArray, 0, sArray.length);
                continue;
            }
            if (n4 == 1) {
                long l = this.imageOutput.getStreamPosition();
                try (DataOutputStream dataOutputStream = new DataOutputStream(new EncoderStream(IIOUtil.createStreamAdapter(this.imageOutput), new PackBitsEncoder()));){
                    for (short s : sArray) {
                        dataOutputStream.writeShort(s);
                    }
                }
                long l2 = this.imageOutput.getStreamPosition();
                nArray[i + n * n6] = (int)(l2 - l);
                continue;
            }
            throw new IIOException("PSD with ZIP compression not supported");
        }
    }

    private void write32BitChannel(int n, int n2, int n3, int n4, Raster raster, int[] nArray) throws IOException {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int[] nArray2 = null;
        for (int i = 0; i < n6; ++i) {
            nArray2 = (int[])raster.getDataElements(0, i, n5, 1, nArray2);
            if (n3 == 4 && n < n2) {
                for (int j = 0; j < nArray2.length; ++j) {
                    nArray2[j] = -1 - nArray2[j];
                }
            }
            if (n4 == 0) {
                this.imageOutput.writeInts(nArray2, 0, nArray2.length);
                continue;
            }
            if (n4 == 1) {
                long l = this.imageOutput.getStreamPosition();
                try (DataOutputStream dataOutputStream = new DataOutputStream(new EncoderStream(IIOUtil.createStreamAdapter(this.imageOutput), new PackBitsEncoder()));){
                    for (int n7 : nArray2) {
                        dataOutputStream.writeInt(n7);
                    }
                }
                long l2 = this.imageOutput.getStreamPosition();
                nArray[i + n * n6] = (int)(l2 - l);
                continue;
            }
            throw new IIOException("PSD with ZIP compression not supported");
        }
    }

    static int getColorMode(ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            if (colorModel.getPixelSize() == 1) {
                return 0;
            }
            return 2;
        }
        int n = colorModel.getColorSpace().getType();
        switch (n) {
            case 6: {
                if (colorModel.getPixelSize() == 1) {
                    return 0;
                }
                return 1;
            }
            case 5: {
                return 3;
            }
            case 9: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported color space type for PSD:  " + n);
    }

    static int getBitsPerSample(SampleModel sampleModel) {
        int n = sampleModel.getSampleSize(0);
        for (int i = 1; i < sampleModel.getNumBands(); ++i) {
            if (n == sampleModel.getSampleSize(i)) continue;
            throw new IllegalArgumentException("All samples must be of equal size for PSD: " + n);
        }
        switch (n) {
            case 1: 
            case 8: 
            case 16: 
            case 32: {
                return (short)n;
            }
        }
        throw new IllegalArgumentException("Unsupported sample size for PSD (expected 1, 8, 16 or 32): " + n);
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        ImageIO.write((RenderedImage)bufferedImage, "PSD", new File("test.psd"));
    }
}

