/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderWriter;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.IIOImage;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class PAMHeaderWriter
extends HeaderWriter {
    public PAMHeaderWriter(ImageOutputStream imageOutputStream) {
        super(imageOutputStream);
    }

    @Override
    public void writeHeader(IIOImage iIOImage, ImageWriterSpi imageWriterSpi) throws IOException {
        TupleType tupleType = PAMHeaderWriter.tupleType(iIOImage);
        this.imageOutput.writeShort(20535);
        this.imageOutput.write(10);
        this.writeComments(iIOImage.getMetadata(), imageWriterSpi);
        this.imageOutput.write(String.format("WIDTH %s\nHEIGHT %s\n", this.getWidth(iIOImage), this.getHeight(iIOImage)).getBytes(StandardCharsets.UTF_8));
        this.imageOutput.write(String.format("DEPTH %s\n", this.getNumBands(iIOImage)).getBytes(StandardCharsets.UTF_8));
        this.imageOutput.write(String.format("MAXVAL %s\n", this.getMaxVal(iIOImage)).getBytes(StandardCharsets.UTF_8));
        this.imageOutput.write(String.format("TUPLTYPE %s\nENDHDR\n", new Object[]{tupleType}).getBytes(StandardCharsets.UTF_8));
    }

    private static TupleType tupleType(IIOImage iIOImage) {
        TupleType tupleType;
        TupleType tupleType2 = tupleType = iIOImage.hasRaster() ? TupleType.forPAM(iIOImage.getRaster()) : TupleType.forPAM(ImageTypeSpecifiers.createFromRenderedImage(iIOImage.getRenderedImage()));
        if (tupleType == null) {
            throw new IllegalArgumentException("Unknown TupleType for " + (iIOImage.hasRaster() ? iIOImage.getRaster() : iIOImage.getRenderedImage()));
        }
        return tupleType;
    }
}

