/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.pict.BitMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.PICTImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.pict.PICTMetadata;
import com.twelvemonkeys.imageio.plugins.pict.PICTUtil;
import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import com.twelvemonkeys.imageio.plugins.pict.QuickDrawContext;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PICTImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.pict.debug"));
    private QuickDrawContext context;
    private Rectangle frame;
    private int version;
    private Point penPosition = new Point(0, 0);
    private Rectangle lastRectangle = new Rectangle(0, 0);
    private double screenImageXRatio;
    private double screenImageYRatio;
    private final List<BufferedImage> images = new ArrayList<BufferedImage>();
    private long imageStartStreamPos;
    protected int picSize;

    @Deprecated
    public PICTImageReader() {
        this(null);
    }

    protected PICTImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    protected void resetMembers() {
        this.context = null;
        this.frame = null;
        this.images.clear();
    }

    private Rectangle getPICTFrame() throws IOException {
        if (this.frame == null) {
            this.readPICTHeader(this.imageInput);
            if (DEBUG) {
                System.out.println("Done reading PICT header!");
            }
        }
        return this.frame;
    }

    private void readPICTHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        try {
            this.readPICTHeader0(imageInputStream);
        }
        catch (IIOException iIOException) {
            imageInputStream.seek(0L);
            PICTImageReaderSpi.skipNullHeader(imageInputStream);
            this.readPICTHeader0(imageInputStream);
        }
    }

    private void readPICTHeader0(ImageInputStream imageInputStream) throws IOException {
        this.picSize = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.println("picSize: " + this.picSize);
        }
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        this.frame = new Rectangle(n2, n, n4 - n2, n3 - n);
        if (this.frame.width < 0 || this.frame.height < 0) {
            throw new IIOException("Error in PICT header: Invalid frame " + this.frame);
        }
        if (DEBUG) {
            System.out.println("frame: " + this.frame);
        }
        this.screenImageXRatio = 1.0;
        this.screenImageYRatio = 1.0;
        boolean bl = false;
        short s = imageInputStream.readShort();
        if (DEBUG) {
            System.out.printf("PICT version: 0x%04x%n", s);
        }
        if (s == 4353) {
            this.version = 1;
        } else if (s == 17 && imageInputStream.readShort() == 767) {
            this.version = 2;
            if (imageInputStream.readShort() != 3072) {
                throw new IIOException("Error in PICT header: Invalid HeaderOp, expected 0x0c00");
            }
            int n5 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.printf("headerVersion: 0x%04x%n", n5);
            }
            if ((n5 & 0xFFFF0000) != -131072) {
                double d = PICTUtil.readFixedPoint(imageInputStream);
                double d2 = PICTUtil.readFixedPoint(imageInputStream);
                double d3 = PICTUtil.readFixedPoint(imageInputStream);
                double d4 = PICTUtil.readFixedPoint(imageInputStream);
                this.screenImageXRatio = (double)(n4 - n2) / (d3 - d2);
                this.screenImageYRatio = (double)(n3 - n) / (d4 - d);
                if (this.screenImageXRatio < 0.0 || this.screenImageYRatio < 0.0) {
                    throw new IIOException("Error in PICT header: Invalid bounds " + new Rectangle2D.Double(d2, d, d3 - d2, d4 - d));
                }
                if (DEBUG) {
                    System.out.println("bounding rect: " + new Rectangle2D.Double(d2, d, d3 - d2, d4 - d));
                }
                imageInputStream.skipBytes(4);
            } else {
                bl = true;
                double d = PICTUtil.readFixedPoint(imageInputStream);
                double d5 = PICTUtil.readFixedPoint(imageInputStream);
                if (DEBUG) {
                    System.out.println("xResolution: " + d);
                    System.out.println("yResolution: " + d5);
                }
                short s2 = imageInputStream.readShort();
                short s3 = imageInputStream.readShort();
                short s4 = imageInputStream.readShort();
                short s5 = imageInputStream.readShort();
                this.screenImageXRatio = (double)(n4 - n2) / (double)(s5 - s3);
                this.screenImageYRatio = (double)(n3 - n) / (double)(s4 - s2);
                if (this.screenImageXRatio < 0.0 || this.screenImageYRatio < 0.0) {
                    throw new IIOException("Error in PICT header: Invalid bounds " + new Rectangle2D.Double(s3, s2, s5 - s3, s4 - s2));
                }
                if (DEBUG) {
                    System.out.println("bounding rect: " + new Rectangle(s3, s2, s5 - s3, s4 - s2));
                }
                imageInputStream.skipBytes(4);
            }
            if (DEBUG) {
                System.out.println("screenImageXRatio: " + this.screenImageXRatio);
                System.out.println("screenImageYRatio: " + this.screenImageYRatio);
            }
        } else {
            throw new IIOException("Error in PICT header: Missing or unknown version information");
        }
        if (DEBUG) {
            System.out.println("Version: " + this.version + (bl ? " extended" : ""));
        }
        this.imageStartStreamPos = imageInputStream.getStreamPosition();
        imageInputStream.flushBefore(this.imageStartStreamPos);
    }

    private void drawOnto(Graphics2D graphics2D) throws IOException {
        this.context = new QuickDrawContext(graphics2D);
        this.readPICTopcodes(this.imageInput);
        if (DEBUG) {
            System.out.println("Done reading PICT body!");
        }
    }

    private void readPICTopcodes(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(this.imageStartStreamPos);
        byte[] byArray = new byte[6];
        Pattern pattern = QuickDraw.BLACK;
        Color color = Color.RED;
        Point point = new Point();
        Point point2 = new Point();
        Rectangle rectangle = new Rectangle();
        Polygon polygon = new Polygon();
        Area area = new Area();
        int n = 0;
        try {
            int n2;
            block195: do {
                if (this.version == 1) {
                    n2 = imageInputStream.readUnsignedByte();
                } else {
                    if ((imageInputStream.getStreamPosition() & 1L) > 0L) {
                        imageInputStream.readByte();
                    }
                    n2 = imageInputStream.readUnsignedShort();
                }
                switch (n2) {
                    case 0: {
                        if (!DEBUG) continue block195;
                        System.out.println("NOP");
                        break;
                    }
                    case 1: {
                        area = this.readRegion(imageInputStream, rectangle);
                        if (area == null) {
                            throw new IIOException("Could not read region");
                        }
                        if (!DEBUG) continue block195;
                        this.verboseRegionCmd("clipRgn", rectangle, area);
                        break;
                    }
                    case 2: {
                        this.context.setBackgroundPattern(PICTUtil.readPattern(imageInputStream));
                        if (!DEBUG) continue block195;
                        System.out.println("bkPat");
                        break;
                    }
                    case 3: {
                        byte[] byArray2 = new byte[2];
                        imageInputStream.readFully(byArray2, 0, 2);
                        if (!DEBUG) continue block195;
                        System.out.println("txFont: " + Arrays.toString(byArray2));
                        break;
                    }
                    case 4: {
                        int n3 = imageInputStream.readUnsignedByte();
                        this.context.setTextFace(n3);
                        if (!DEBUG) continue block195;
                        System.out.println("txFace: " + n3);
                        break;
                    }
                    case 5: {
                        byte[] byArray3 = new byte[2];
                        imageInputStream.readFully(byArray3, 0, byArray3.length);
                        if (!DEBUG) continue block195;
                        System.out.println("txMode: " + byArray3[0] + ", " + byArray3[1]);
                        break;
                    }
                    case 6: {
                        imageInputStream.readFully(new byte[4], 0, 4);
                        if (!DEBUG) continue block195;
                        System.out.println("spExtra");
                        break;
                    }
                    case 7: {
                        Dimension dimension = new Dimension(imageInputStream.readUnsignedShort(), imageInputStream.readUnsignedShort());
                        if (DEBUG) {
                            System.out.println("pnsize: " + dimension);
                        }
                        this.context.setPenSize(dimension);
                        break;
                    }
                    case 8: {
                        int n4 = imageInputStream.readUnsignedShort();
                        if (DEBUG) {
                            System.out.println("pnMode: " + n4);
                        }
                        this.context.setPenMode(n4);
                        break;
                    }
                    case 9: {
                        this.context.setPenPattern(PICTUtil.readPattern(imageInputStream, this.context.getForeground(), this.context.getBackground()));
                        if (!DEBUG) continue block195;
                        System.out.println("pnPat");
                        break;
                    }
                    case 10: {
                        pattern = PICTUtil.readPattern(imageInputStream);
                        if (!DEBUG) continue block195;
                        System.out.println("fillPat");
                        break;
                    }
                    case 11: {
                        int n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        point.setLocation(n6, n5);
                        if (!DEBUG) continue block195;
                        System.out.println("ovSize: " + point);
                        break;
                    }
                    case 12: {
                        int n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n6, n5);
                        if (!DEBUG) continue block195;
                        System.out.println("Origin: " + point3);
                        break;
                    }
                    case 13: {
                        int n7 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        this.context.setTextSize(n7);
                        if (!DEBUG) continue block195;
                        System.out.println("txSize: " + n7);
                        break;
                    }
                    case 14: {
                        imageInputStream.readInt();
                        if (!DEBUG) continue block195;
                        System.out.println("fgColor");
                        break;
                    }
                    case 15: {
                        imageInputStream.readInt();
                        if (!DEBUG) continue block195;
                        System.out.println("bgColor");
                        break;
                    }
                    case 16: {
                        imageInputStream.readFully(new byte[8], 0, 8);
                        if (!DEBUG) continue block195;
                        System.out.println("txRatio");
                        break;
                    }
                    case 17: {
                        imageInputStream.readFully(new byte[1], 0, 1);
                        if (!DEBUG) continue block195;
                        System.out.println("opVersion");
                        break;
                    }
                    case 18: {
                        Pattern pattern2 = PICTUtil.readColorPattern(imageInputStream);
                        this.context.setBackgroundPattern(pattern2);
                        if (!DEBUG) continue block195;
                        System.out.println("BkPixPat");
                        break;
                    }
                    case 19: {
                        Pattern pattern3 = PICTUtil.readColorPattern(imageInputStream);
                        this.context.setPenPattern(pattern3);
                        if (!DEBUG) continue block195;
                        System.out.println("PnPixPat");
                        break;
                    }
                    case 20: {
                        pattern = PICTUtil.readColorPattern(imageInputStream);
                        this.context.setFillPattern(pattern);
                        if (!DEBUG) continue block195;
                        System.out.println("FillPixPat");
                        break;
                    }
                    case 21: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block195;
                        System.out.println("opPnLocHFrac");
                        break;
                    }
                    case 22: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block195;
                        System.out.println("opChExtra");
                        break;
                    }
                    case 26: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        Color color2 = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (DEBUG) {
                            System.out.println("rgbFgColor: " + color2);
                        }
                        this.context.setForeground(color2);
                        break;
                    }
                    case 27: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        Color color3 = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (DEBUG) {
                            System.out.println("rgbBgColor: " + color3);
                        }
                        this.context.setBackground(color3);
                        break;
                    }
                    case 28: {
                        this.context.setPenPattern(new BitMapPattern(color));
                        if (!DEBUG) continue block195;
                        System.out.println("opHiliteMode");
                        break;
                    }
                    case 29: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        color = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block195;
                        System.out.println("opHiliteColor: " + color);
                        break;
                    }
                    case 30: {
                        color = Color.red;
                        if (!DEBUG) continue block195;
                        System.out.println("opDefHilite");
                        break;
                    }
                    case 31: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        if (!DEBUG) continue block195;
                        System.out.println("opOpColor");
                        break;
                    }
                    case 32: {
                        int n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n6, n5);
                        n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.penPosition.setLocation(n6, n5);
                        this.context.moveTo(point3);
                        this.context.lineTo(this.penPosition);
                        if (!DEBUG) continue block195;
                        System.out.println("line from: " + point3 + " to: " + this.penPosition);
                        break;
                    }
                    case 33: {
                        int n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.context.line(n6, n5);
                        if (!DEBUG) continue block195;
                        System.out.println("lineFrom to: " + this.penPosition);
                        break;
                    }
                    case 34: {
                        int n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n6, n5);
                        n6 = this.getXPtCoord(imageInputStream.readByte());
                        n5 = this.getYPtCoord(imageInputStream.readByte());
                        Point point4 = new Point(n6, n5);
                        this.context.moveTo(point3);
                        this.penPosition.setLocation(point3.x + point4.x, point3.y + point4.y);
                        this.context.lineTo(this.penPosition);
                        if (!DEBUG) continue block195;
                        System.out.println("Short line origin: " + point3 + ", dh,dv: " + point4);
                        break;
                    }
                    case 35: {
                        int n6 = this.getXPtCoord(imageInputStream.readByte());
                        int n5 = this.getYPtCoord(imageInputStream.readByte());
                        this.context.line(n6, n5);
                        if (!DEBUG) continue block195;
                        System.out.println("Short line from dh,dv: " + n6 + "," + n5);
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 47: {
                        int n8 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n8], 0, n8);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 40: {
                        Point point3;
                        int n5 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n6 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.penPosition = point3 = new Point(n6, n5);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block195;
                        System.out.println("longText origin: " + this.penPosition + ", text:" + string);
                        break;
                    }
                    case 41: {
                        int n9 = this.getXPtCoord(imageInputStream.readByte());
                        this.penPosition.translate(n9, 0);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block195;
                        System.out.println("DHText dh: " + n9 + ", text:" + string);
                        break;
                    }
                    case 42: {
                        int n10 = this.getYPtCoord(imageInputStream.readByte());
                        this.penPosition.translate(0, n10);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block195;
                        System.out.println("DVText dv: " + n10 + ", text:" + string);
                        break;
                    }
                    case 43: {
                        int n5 = this.getYPtCoord(imageInputStream.readByte());
                        int n6 = this.getXPtCoord(imageInputStream.readByte());
                        this.penPosition.translate(n6, n5);
                        this.context.moveTo(this.penPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.drawString(string);
                        if (!DEBUG) continue block195;
                        System.out.println("DHDVText penPosition: " + this.penPosition + ", text:" + string);
                        break;
                    }
                    case 44: {
                        imageInputStream.readShort();
                        imageInputStream.readUnsignedShort();
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.context.setTextFont(string);
                        if (!DEBUG) continue block195;
                        System.out.println("fontName: \"" + string + "\"");
                        break;
                    }
                    case 45: {
                        byte[] byArray4 = new byte[10];
                        imageInputStream.readFully(byArray4, 0, byArray4.length);
                        if (!DEBUG) continue block195;
                        System.out.println("opLineJustify");
                        break;
                    }
                    case 46: {
                        byte[] byArray5 = new byte[6];
                        imageInputStream.readFully(byArray5, 0, byArray5.length);
                        if (!DEBUG) continue block195;
                        System.out.println("glyphState: " + Arrays.toString(byArray5));
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: {
                        switch (n2) {
                            case 48: 
                            case 56: {
                                this.context.frameRect(this.lastRectangle);
                                break;
                            }
                            case 49: 
                            case 57: {
                                this.context.paintRect(this.lastRectangle);
                                break;
                            }
                            case 50: 
                            case 58: {
                                this.context.eraseRect(this.lastRectangle);
                                break;
                            }
                            case 51: 
                            case 59: {
                                this.context.invertRect(this.lastRectangle);
                                break;
                            }
                            case 52: 
                            case 60: {
                                this.context.fillRect(this.lastRectangle, pattern);
                            }
                        }
                        if (!DEBUG) continue block195;
                        switch (n2) {
                            case 48: {
                                System.out.println("frameRect: " + this.lastRectangle);
                                break;
                            }
                            case 49: {
                                System.out.println("paintRect: " + this.lastRectangle);
                                break;
                            }
                            case 50: {
                                System.out.println("eraseRect: " + this.lastRectangle);
                                break;
                            }
                            case 51: {
                                System.out.println("invertRect: " + this.lastRectangle);
                                break;
                            }
                            case 52: {
                                System.out.println("fillRect: " + this.lastRectangle);
                                break;
                            }
                            case 56: {
                                System.out.println("frameSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 57: {
                                System.out.println("paintSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 58: {
                                System.out.println("eraseSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 59: {
                                System.out.println("invertSameRect: " + this.lastRectangle);
                                break;
                            }
                            case 60: {
                                System.out.println("fillSameRect: " + this.lastRectangle);
                            }
                        }
                        continue block195;
                    }
                    case 61: 
                    case 62: 
                    case 63: {
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: {
                        switch (n2) {
                            case 64: 
                            case 72: {
                                this.context.frameRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 65: 
                            case 73: {
                                this.context.paintRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 66: 
                            case 74: {
                                this.context.eraseRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 67: 
                            case 75: {
                                this.context.invertRoundRect(this.lastRectangle, point.x, point.y);
                                break;
                            }
                            case 68: 
                            case 76: {
                                this.context.fillRoundRect(this.lastRectangle, point.x, point.y, pattern);
                            }
                        }
                        if (!DEBUG) continue block195;
                        switch (n2) {
                            case 64: {
                                System.out.println("frameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 65: {
                                System.out.println("paintRRect: " + this.lastRectangle);
                                break;
                            }
                            case 66: {
                                System.out.println("eraseRRect: " + this.lastRectangle);
                                break;
                            }
                            case 67: {
                                System.out.println("invertRRect: " + this.lastRectangle);
                                break;
                            }
                            case 68: {
                                System.out.println("fillRRect: " + this.lastRectangle);
                                break;
                            }
                            case 72: {
                                System.out.println("frameSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 73: {
                                System.out.println("paintSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 74: {
                                System.out.println("eraseSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 75: {
                                System.out.println("invertSameRRect: " + this.lastRectangle);
                                break;
                            }
                            case 76: {
                                System.out.println("fillSameRRect: " + this.lastRectangle);
                            }
                        }
                        continue block195;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: {
                        switch (n2) {
                            case 80: 
                            case 88: {
                                this.context.frameOval(this.lastRectangle);
                                break;
                            }
                            case 81: 
                            case 89: {
                                this.context.paintOval(this.lastRectangle);
                                break;
                            }
                            case 82: 
                            case 90: {
                                this.context.eraseOval(this.lastRectangle);
                                break;
                            }
                            case 83: 
                            case 91: {
                                this.context.invertOval(this.lastRectangle);
                                break;
                            }
                            case 84: 
                            case 92: {
                                this.context.fillOval(this.lastRectangle, pattern);
                            }
                        }
                        if (!DEBUG) continue block195;
                        switch (n2) {
                            case 80: {
                                System.out.println("frameOval: " + this.lastRectangle);
                                break;
                            }
                            case 81: {
                                System.out.println("paintOval: " + this.lastRectangle);
                                break;
                            }
                            case 82: {
                                System.out.println("eraseOval: " + this.lastRectangle);
                                break;
                            }
                            case 83: {
                                System.out.println("invertOval: " + this.lastRectangle);
                                break;
                            }
                            case 84: {
                                System.out.println("fillOval: " + this.lastRectangle);
                                break;
                            }
                            case 88: {
                                System.out.println("frameSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 89: {
                                System.out.println("paintSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 90: {
                                System.out.println("eraseSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 91: {
                                System.out.println("invertSameOval: " + this.lastRectangle);
                                break;
                            }
                            case 92: {
                                System.out.println("fillSameOval: " + this.lastRectangle);
                            }
                        }
                        continue block195;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 85: 
                    case 86: 
                    case 87: {
                        imageInputStream.readFully(new byte[8], 0, 8);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        this.readRectangle(imageInputStream, this.lastRectangle);
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        int n6 = imageInputStream.readUnsignedShort();
                        int n5 = imageInputStream.readUnsignedShort();
                        point2.setLocation(n6, n5);
                        switch (n2) {
                            case 96: 
                            case 104: {
                                this.context.frameArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 97: 
                            case 105: {
                                this.context.paintArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 98: 
                            case 106: {
                                this.context.eraseArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 99: 
                            case 107: {
                                this.context.invertArc(this.lastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 100: 
                            case 108: {
                                this.context.fillArc(this.lastRectangle, point2.x, point2.y, pattern);
                            }
                        }
                        if (!DEBUG) continue block195;
                        switch (n2) {
                            case 96: {
                                System.out.println("frameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 97: {
                                System.out.println("paintArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 98: {
                                System.out.println("eraseArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 99: {
                                System.out.println("invertArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 100: {
                                System.out.println("fillArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 104: {
                                System.out.println("frameSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 105: {
                                System.out.println("paintSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 106: {
                                System.out.println("eraseSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 107: {
                                System.out.println("invertSameArc: " + this.lastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 108: {
                                System.out.println("fillSameArc: " + this.lastRectangle + ", angles:" + point2);
                            }
                        }
                        continue block195;
                    }
                    case 101: 
                    case 102: 
                    case 103: {
                        imageInputStream.readFully(new byte[12], 0, 12);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 109: 
                    case 110: 
                    case 111: {
                        imageInputStream.readFully(new byte[4], 0, 4);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: {
                        polygon = this.readPoly(imageInputStream, rectangle);
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: {
                        switch (n2) {
                            case 112: 
                            case 120: {
                                this.context.framePoly(polygon);
                                break;
                            }
                            case 113: 
                            case 121: {
                                this.context.paintPoly(polygon);
                                break;
                            }
                            case 114: 
                            case 122: {
                                this.context.erasePoly(polygon);
                                break;
                            }
                            case 115: 
                            case 123: {
                                this.context.invertPoly(polygon);
                                break;
                            }
                            case 116: 
                            case 124: {
                                this.context.fillPoly(polygon, pattern);
                            }
                        }
                        if (!DEBUG) continue block195;
                        switch (n2) {
                            case 112: {
                                this.verbosePolyCmd("framePoly", rectangle, polygon);
                                break;
                            }
                            case 113: {
                                this.verbosePolyCmd("paintPoly", rectangle, polygon);
                                break;
                            }
                            case 114: {
                                this.verbosePolyCmd("erasePoly", rectangle, polygon);
                                break;
                            }
                            case 115: {
                                this.verbosePolyCmd("invertPoly", rectangle, polygon);
                                break;
                            }
                            case 116: {
                                this.verbosePolyCmd("fillPoly", rectangle, polygon);
                                break;
                            }
                            case 120: {
                                this.verbosePolyCmd("frameSamePoly", rectangle, polygon);
                                break;
                            }
                            case 121: {
                                this.verbosePolyCmd("paintSamePoly", rectangle, polygon);
                                break;
                            }
                            case 122: {
                                this.verbosePolyCmd("eraseSamePoly", rectangle, polygon);
                                break;
                            }
                            case 123: {
                                this.verbosePolyCmd("invertSamePoly", rectangle, polygon);
                                break;
                            }
                            case 124: {
                                this.verbosePolyCmd("fillSamePoly", rectangle, polygon);
                            }
                        }
                        continue block195;
                    }
                    case 125: 
                    case 126: 
                    case 127: {
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 117: 
                    case 118: 
                    case 119: {
                        polygon = this.readPoly(imageInputStream, rectangle);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: {
                        area = this.readRegion(imageInputStream, rectangle);
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: {
                        if (area != null && !area.getBounds().isEmpty()) {
                            switch (n2) {
                                case 128: 
                                case 136: {
                                    this.context.frameRegion(area);
                                    break;
                                }
                                case 129: 
                                case 137: {
                                    this.context.paintRegion(area);
                                    break;
                                }
                                case 130: 
                                case 138: {
                                    this.context.eraseRegion(area);
                                    break;
                                }
                                case 131: 
                                case 139: {
                                    this.context.invertRegion(area);
                                    break;
                                }
                                case 132: 
                                case 140: {
                                    this.context.fillRegion(area, pattern);
                                }
                            }
                        }
                        if (!DEBUG) continue block195;
                        switch (n2) {
                            case 128: {
                                this.verboseRegionCmd("frameRgn", rectangle, area);
                                break;
                            }
                            case 129: {
                                this.verboseRegionCmd("paintRgn", rectangle, area);
                                break;
                            }
                            case 130: {
                                this.verboseRegionCmd("eraseRgn", rectangle, area);
                                break;
                            }
                            case 131: {
                                this.verboseRegionCmd("invertRgn", rectangle, area);
                                break;
                            }
                            case 132: {
                                this.verboseRegionCmd("fillRgn", rectangle, area);
                                break;
                            }
                            case 136: {
                                this.verboseRegionCmd("frameSameRgn", rectangle, area);
                                break;
                            }
                            case 137: {
                                this.verboseRegionCmd("paintSameRgn", rectangle, area);
                                break;
                            }
                            case 138: {
                                this.verboseRegionCmd("eraseSameRgn", rectangle, area);
                                break;
                            }
                            case 139: {
                                this.verboseRegionCmd("invertSameRgn", rectangle, area);
                                break;
                            }
                            case 140: {
                                this.verboseRegionCmd("fillSameRgn", rectangle, area);
                            }
                        }
                        continue block195;
                    }
                    case 133: 
                    case 134: 
                    case 135: {
                        area = this.readRegion(imageInputStream, rectangle);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 144: {
                        this.readOpBits(imageInputStream, false);
                        break;
                    }
                    case 145: {
                        this.readOpBits(imageInputStream, true);
                        break;
                    }
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: {
                        int n8 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n8], 0, n8);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x - length: %d%n", "Reserved for Apple use.", n2, n8);
                        break;
                    }
                    case 152: {
                        this.readOpPackBits(imageInputStream, false, n++);
                        break;
                    }
                    case 153: {
                        this.readOpPackBits(imageInputStream, true, n++);
                        break;
                    }
                    case 154: {
                        this.readOpDirectBits(imageInputStream, false, n++);
                        break;
                    }
                    case 155: {
                        this.readOpDirectBits(imageInputStream, true, n++);
                        break;
                    }
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: {
                        int n8 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n8], 0, n8);
                        if (!DEBUG) continue block195;
                        System.out.printf("%s: 0x%04x%n", "Reserved for Apple use.", n2);
                        break;
                    }
                    case 160: {
                        byte[] byArray6 = new byte[2];
                        imageInputStream.readFully(byArray6, 0, 2);
                        if (!DEBUG) continue block195;
                        System.out.println("Short comment: " + Arrays.toString(byArray6));
                        break;
                    }
                    case 161: {
                        this.readLongComment(imageInputStream);
                        break;
                    }
                    case 255: {
                        break;
                    }
                    case 33280: {
                        this.readCompressedQT(imageInputStream);
                        break;
                    }
                    case 33281: {
                        int n8 = imageInputStream.readInt();
                        if (DEBUG) {
                            System.out.printf("unCompressedQuickTime, length %d%n", n8);
                        }
                        imageInputStream.readFully(new byte[n8], 0, n8);
                        break;
                    }
                    default: {
                        int n8;
                        if (n2 >= 162 && n2 <= 175) {
                            n8 = imageInputStream.readUnsignedShort();
                        } else if (n2 >= 176 && n2 <= 207) {
                            n8 = 0;
                        } else if (n2 >= 208 && n2 <= 254) {
                            n8 = imageInputStream.readInt();
                        } else if (n2 >= 256 && n2 <= Short.MAX_VALUE) {
                            n8 = (n2 & 0xFF00) >> 7;
                        } else if (n2 >= 32768 && n2 <= 33023) {
                            n8 = 0;
                        } else if (n2 >= 33024 && n2 <= 33279) {
                            n8 = imageInputStream.readInt();
                        } else if (n2 == 65535) {
                            n8 = imageInputStream.readInt();
                        } else {
                            throw new IIOException(String.format("Found unknown opcode: 0x%04x", n2));
                        }
                        if (DEBUG) {
                            System.out.printf("%s: 0x%04x - length: %s%n", "Reserved for Apple use.", n2, n8);
                        }
                        if (n8 == 0) continue block195;
                        imageInputStream.readFully(new byte[n8], 0, n8);
                    }
                }
            } while (n2 != 255);
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (EOFException eOFException) {
            String string;
            try {
                string = String.format("position %d", this.imageInput.getStreamPosition());
            }
            catch (IOException iOException) {
                string = "unknown position";
            }
            throw new IIOException(String.format("Error in PICT format: Unexpected end of File at %s", string), eOFException);
        }
        catch (IOException iOException) {
            throw new IIOException(String.format("Error in PICT format: %s", iOException.getMessage()), iOException);
        }
    }

    private void readCompressedQT(ImageInputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage;
        int n = imageInputStream.readInt();
        long l = imageInputStream.getStreamPosition();
        int n2 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print("compressedQuickTime");
            System.out.println(", size: " + n + ", version: " + n2);
        }
        int[] nArray = new int[9];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = imageInputStream.readInt();
        }
        if (DEBUG) {
            System.out.printf("matrix: %s%n", Arrays.toString(nArray));
        }
        long l2 = imageInputStream.readUnsignedInt();
        Rectangle rectangle = new Rectangle();
        this.readRectangle(imageInputStream, rectangle);
        int n3 = imageInputStream.readUnsignedShort();
        Rectangle rectangle2 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle2);
        int n4 = imageInputStream.readInt();
        int n5 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.print("matteSize: " + l2);
            System.out.print(", matteRect: " + rectangle);
            System.out.print(", mode: " + n3);
            System.out.print(", srcRect: " + rectangle2);
            System.out.print(", accuracy: " + n4);
            System.out.println(", maskSize: " + n5);
        }
        if ((bufferedImage = QuickTime.decompress(imageInputStream)) != null) {
            this.context.copyBits(bufferedImage, rectangle2, rectangle2, n3, null);
            imageInputStream.seek(l + (long)n);
            int n6 = imageInputStream.readInt();
            if (n6 == 458926) {
                int n7 = imageInputStream.readUnsignedShort();
                imageInputStream.skipBytes(n7);
            } else {
                imageInputStream.seek(l + (long)n);
            }
        } else {
            imageInputStream.seek(l + (long)n);
        }
    }

    private void readOpPackBits(ImageInputStream imageInputStream, boolean bl, int n) throws IOException {
        BufferedImage bufferedImage;
        Area area;
        IndexColorModel indexColorModel;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl2;
        int n6 = imageInputStream.readUnsignedShort();
        int n7 = n6 & Short.MAX_VALUE;
        boolean bl3 = bl2 = (n6 & 0x8000) > 0;
        if (DEBUG) {
            System.out.print(bl ? "packBitsRgn" : "packBitsRect");
            System.out.print(", rowBytes: " + n7);
            if (bl2) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        Rectangle rectangle = new Rectangle();
        int n8 = imageInputStream.readUnsignedShort();
        int n9 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n9, n8);
        n8 = imageInputStream.readUnsignedShort();
        n9 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n9 - rectangle.x, n8 - rectangle.y);
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
        }
        if (bl2) {
            int n10 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", pmVersion: " + n10);
            }
            int n11 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", packType: " + n11);
            }
            n5 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(", packSize: " + n5);
            }
            double d = PICTUtil.readFixedPoint(imageInputStream);
            double d2 = PICTUtil.readFixedPoint(imageInputStream);
            if (DEBUG) {
                System.out.print("hRes: " + d + ", vRes: " + d2);
            }
            n4 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                if (n4 == 0) {
                    System.out.print(", indexed pixels");
                } else {
                    System.out.print(", RGBDirect");
                }
            }
            n3 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", pixelSize:" + n3);
            }
            int n12 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", cmpCount:" + n12);
            }
            n2 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", cmpSize:" + n2);
            }
            int n13 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.print(", planeBytes:" + n13);
            }
            int n14 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.print(", clutId:" + n14);
            }
            imageInputStream.readInt();
            if (n11 != 0) {
                throw new IIOException("Unknown pack type: " + n11);
            }
            if (n4 != 0) {
                throw new IIOException("Unsupported pixel type: " + n4);
            }
            indexColorModel = PICTUtil.readColorTable(imageInputStream, n3);
        } else {
            n2 = 1;
            indexColorModel = QuickDraw.MONOCHROME;
        }
        Rectangle rectangle2 = new Rectangle();
        n8 = imageInputStream.readUnsignedShort();
        n9 = imageInputStream.readUnsignedShort();
        rectangle2.setLocation(n9, n8);
        n8 = imageInputStream.readUnsignedShort();
        n9 = imageInputStream.readUnsignedShort();
        rectangle2.setSize(n9 - rectangle2.x, n8 - rectangle2.y);
        if (DEBUG) {
            System.out.print(", srcRect:" + rectangle2);
        }
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        if (DEBUG) {
            System.out.print(", dstRect:" + rectangle3);
        }
        n5 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", mode: " + n5);
        }
        Rectangle rectangle4 = new Rectangle();
        Area area2 = area = bl ? this.readRegion(imageInputStream, rectangle4) : null;
        if (DEBUG) {
            if (bl) {
                this.verboseRegionCmd(", region", rectangle4, area);
            } else {
                System.out.println();
            }
        }
        byte[] byArray = new byte[rectangle2.height * n7];
        int n15 = 0;
        for (n4 = 0; n4 < rectangle2.height; ++n4) {
            if (n7 >= 8) {
                n3 = n7 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                PackBitsDecoder packBitsDecoder = new PackBitsDecoder();
                DataInputStream dataInputStream = new DataInputStream(new DecoderStream(IIOUtil.createStreamAdapter(imageInputStream, n3), packBitsDecoder));
                dataInputStream.readFully(byArray, n15, n7);
            } else {
                this.imageInput.readFully(byArray, n15, n7);
            }
            n15 += n7;
            this.processImageProgress((float)(n4 * 100) / (float)rectangle2.height);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            for (n3 = n4 + 1; n3 < rectangle2.height; ++n3) {
                int n16 = n7 < 8 ? n7 : (n7 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte());
                imageInputStream.readFully(new byte[n16], 0, n16);
                if (!DEBUG) continue;
                System.out.print("Skip " + n3 + ", byteCount: " + n16);
            }
            break;
        }
        if (this.images.size() <= n) {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n7 * 8 / n2, rectangle2.height, n2, null);
            BufferedImage bufferedImage2 = new BufferedImage(indexColorModel, writableRaster, indexColorModel.isAlphaPremultiplied(), null);
            this.images.add(bufferedImage2);
        }
        if ((bufferedImage = this.images.get(n)) != null) {
            rectangle2.setLocation(0, 0);
            this.context.copyBits(bufferedImage, rectangle2, rectangle3, n5, area);
        }
        if (DEBUG) {
            System.out.println();
        }
    }

    private void readOpDirectBits(ImageInputStream imageInputStream, boolean bl, int n) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        byte[] byArray;
        Area area;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl2;
        imageInputStream.readInt();
        int n6 = imageInputStream.readUnsignedShort();
        int n7 = n6 & Short.MAX_VALUE;
        boolean bl3 = bl2 = (n6 & 0x8000) > 0;
        if (DEBUG) {
            System.out.print(bl ? "directBitsRgn" : "directBitsRect");
            System.out.print(", rowBytes: " + n7);
            if (bl2) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        Rectangle rectangle = new Rectangle();
        int n8 = imageInputStream.readUnsignedShort();
        int n9 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n9, n8);
        n8 = imageInputStream.readUnsignedShort();
        n9 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n9 - rectangle.x, n8 - rectangle.y);
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
        }
        IndexColorModel indexColorModel = null;
        if (bl2) {
            int n10 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", pmVersion: " + n10);
            }
            n5 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", packType: " + n5);
            }
            int n11 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(", packSize: " + n11);
            }
            double d = PICTUtil.readFixedPoint(imageInputStream);
            double d2 = PICTUtil.readFixedPoint(imageInputStream);
            if (DEBUG) {
                System.out.print("hRes: " + d + ", vRes: " + d2);
            }
            int n12 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                if (n12 == 0) {
                    System.out.print(", indexed pixels");
                } else {
                    System.out.print(", RGBDirect");
                }
            }
            n4 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", pixelSize:" + n4);
            }
            n3 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", cmpCount:" + n3);
            }
            n2 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", cmpSize:" + n2);
            }
            imageInputStream.readInt();
            imageInputStream.readInt();
            imageInputStream.readInt();
        } else {
            n5 = 1;
            n3 = 1;
            indexColorModel = QuickDraw.MONOCHROME;
        }
        Rectangle rectangle2 = new Rectangle();
        n8 = imageInputStream.readUnsignedShort();
        n9 = imageInputStream.readUnsignedShort();
        rectangle2.setLocation(n9, n8);
        n8 = imageInputStream.readUnsignedShort();
        n9 = imageInputStream.readUnsignedShort();
        rectangle2.setSize(n9 - rectangle2.x, n8 - rectangle2.y);
        if (DEBUG) {
            System.out.print(", srcRect:" + rectangle2);
        }
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        if (DEBUG) {
            System.out.print(", dstRect:" + rectangle3);
        }
        int n13 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", mode: " + n13);
        }
        Area area2 = area = bl ? this.readRegion(imageInputStream, new Rectangle()) : null;
        if (DEBUG) {
            System.out.println(bl ? ", region: " + area : "");
        }
        if (n5 == 1 || n5 == 2 || n5 == 3) {
            byArray = new byte[n7];
        } else if (n5 == 4) {
            byArray = new byte[n3 * n7 / 4];
        } else {
            throw new IIOException("Unknown pack type: " + n5);
        }
        int[] nArray = null;
        short[] sArray = null;
        if (n5 == 3) {
            sArray = new short[rectangle2.height * (n7 + 1) / 2];
        } else {
            nArray = new int[rectangle2.height * (n7 + 3) / 4];
        }
        n4 = 0;
        for (int i = 0; i < rectangle2.height; ++i) {
            if (n5 > 2) {
                n2 = n7 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                if (DEBUG) {
                    System.out.print("Line " + i + ", byteCount: " + n2);
                    System.out.print(" dstBytes: " + byArray.length);
                    System.out.println();
                }
                PackBitsDecoder packBitsDecoder = n5 == 3 ? new PackBitsDecoder(2, false) : new PackBitsDecoder();
                object = new DataInputStream(new DecoderStream(IIOUtil.createStreamAdapter(imageInputStream, n2), packBitsDecoder, byArray.length));
                object.readFully(byArray);
            } else {
                this.imageInput.readFully(byArray);
            }
            if (n5 == 3) {
                for (int j = 0; j < rectangle2.width; ++j) {
                    sArray[n4 + j] = (short)((0xFF & byArray[2 * j]) << 8 | 0xFF & byArray[2 * j + 1]);
                }
            } else if (n3 == 3) {
                for (int j = 0; j < rectangle2.width; ++j) {
                    nArray[n4 + j] = 0xFF000000 | (byArray[j] & 0xFF) << 16 | (byArray[rectangle.width + j] & 0xFF) << 8 | byArray[2 * rectangle.width + j] & 0xFF;
                }
            } else if (n3 == 4) {
                for (int j = 0; j < rectangle2.width; ++j) {
                    nArray[n4 + j] = (byArray[j] & 0xFF) << 24 | (byArray[rectangle.width + j] & 0xFF) << 16 | (byArray[2 * rectangle.width + j] & 0xFF) << 8 | byArray[3 * rectangle.width + j] & 0xFF;
                }
            }
            n4 += rectangle2.width;
            this.processImageProgress((float)(i * 100) / (float)rectangle2.height);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            for (int j = i + 1; j < rectangle2.height; ++j) {
                n2 = n7 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                imageInputStream.readFully(new byte[n2], 0, n2);
                if (!DEBUG) continue;
                System.out.println();
                System.out.print("Skip " + j + ", byteCount: " + n2);
            }
            break;
        }
        if (this.images.size() <= n) {
            WritableRaster writableRaster;
            ColorModel colorModel;
            if (indexColorModel != null) {
                colorModel = indexColorModel;
                object = new DataBufferByte(byArray, byArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle2.width, rectangle2.height, 1, null);
            } else if (n5 == 3) {
                colorModel = new DirectColorModel(15, 31744, 992, 31);
                object = new DataBufferUShort(sArray, sArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle2.width, rectangle2.height, rectangle2.width, ((DirectColorModel)colorModel).getMasks(), null);
            } else {
                colorModel = ColorModel.getRGBdefault();
                object = new DataBufferInt(nArray, nArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle2.width, rectangle2.height, rectangle2.width, ((DirectColorModel)colorModel).getMasks(), null);
            }
            object = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.images.add((BufferedImage)object);
        }
        if ((bufferedImage = this.images.get(n)) != null) {
            rectangle2.setLocation(0, 0);
            this.context.copyBits(bufferedImage, rectangle2, rectangle3, n13, area);
        }
        if (DEBUG) {
            System.out.println();
        }
    }

    private void readOpBits(ImageInputStream imageInputStream, boolean bl) throws IOException {
        Area area;
        IndexColorModel indexColorModel;
        int n;
        int n2;
        boolean bl2;
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = n3 & Short.MAX_VALUE;
        boolean bl3 = bl2 = (n3 & 0x8000) > 0;
        if (DEBUG) {
            System.out.print(bl ? "bitsRgn" : "bitsRect");
            System.out.print(", rowBytes: " + n4);
            if (bl2) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        Rectangle rectangle = new Rectangle();
        int n5 = imageInputStream.readUnsignedShort();
        int n6 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n6, n5);
        n5 = imageInputStream.readUnsignedShort();
        n6 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n6 - rectangle.x, n5 - rectangle.y);
        if (bl2) {
            int n7 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", pmVersion: " + n7);
            }
            int n8 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", packType: " + n8);
            }
            n2 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(", packSize: " + n2);
            }
            double d = PICTUtil.readFixedPoint(imageInputStream);
            double d2 = PICTUtil.readFixedPoint(imageInputStream);
            if (DEBUG) {
                System.out.print("hRes: " + d + ", vRes: " + d2);
            }
            int n9 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                if (n9 == 0) {
                    System.out.print(", indexed pixels");
                } else {
                    System.out.print(", RGBDirect");
                }
            }
            int n10 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", pixelSize:" + n10);
            }
            int n11 = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", cmpCount:" + n11);
            }
            n = imageInputStream.readUnsignedShort();
            if (DEBUG) {
                System.out.print(", cmpSize:" + n);
            }
            int n12 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.print(", planeBytes:" + n12);
            }
            int n13 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.print(", clutId:" + n13);
            }
            imageInputStream.readInt();
            indexColorModel = PICTUtil.readColorTable(imageInputStream, n10);
        } else {
            indexColorModel = QuickDraw.MONOCHROME;
            n = 1;
        }
        Rectangle rectangle2 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle2);
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        n2 = imageInputStream.readUnsignedShort();
        Area area2 = area = bl ? this.readRegion(imageInputStream, new Rectangle()) : null;
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
            System.out.print(", srcRect: " + rectangle2);
            System.out.print(", dstRect: " + rectangle3);
            System.out.print(", mode: " + n2);
            System.out.print(bl ? ", region: " + area : "");
            System.out.println();
        }
        byte[] byArray = new byte[n4 * rectangle.height];
        for (int i = 0; i < rectangle.height; ++i) {
            imageInputStream.readFully(byArray, i * n4, n4);
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n4 * 8 / n, rectangle2.height, n, null);
        BufferedImage bufferedImage = new BufferedImage(indexColorModel, writableRaster, indexColorModel.isAlphaPremultiplied(), null);
        rectangle2.setLocation(0, 0);
        this.context.copyBits(bufferedImage, rectangle2, rectangle3, n2, area);
    }

    private void readRectangle(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        int n4 = dataInput.readUnsignedShort();
        rectangle.setLocation(this.getXPtCoord(n2), this.getYPtCoord(n));
        rectangle.setSize(this.getXPtCoord(n4 - n2), this.getYPtCoord(n3 - n));
    }

    private Area readRegion(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.readRectangle(dataInput, rectangle);
        int n2 = (n - 10) / 2;
        if (n2 == 0) {
            return new Area(rectangle);
        }
        Area area = new Area();
        boolean bl = true;
        short s = 0;
        for (int i = 0; i < n2; ++i) {
            short s2 = dataInput.readShort();
            if (bl) {
                if (s2 == Short.MAX_VALUE) break;
                s = s2;
                bl = false;
                continue;
            }
            if (s2 == Short.MAX_VALUE) {
                bl = true;
                continue;
            }
            short s3 = s2;
            area.exclusiveOr(new Area(new Rectangle(s3, s, rectangle.x + rectangle.width - s3, rectangle.y + rectangle.height - s)));
        }
        if (!rectangle.contains(area.getBounds())) {
            this.processWarningOccurred("Bad region, contains point(s) out of bounds " + rectangle + ": " + area);
        }
        return area;
    }

    private Polygon readPoly(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.readRectangle(dataInput, rectangle);
        int n2 = (n - 10) / 4;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getYPtCoord(dataInput.readShort());
            int n4 = this.getXPtCoord(dataInput.readShort());
            polygon.addPoint(n4, n3);
        }
        if (!rectangle.contains(polygon.getBounds())) {
            this.processWarningOccurred("Bad poly, contains point(s) out of bounds " + rectangle + ": " + polygon);
        }
        return polygon;
    }

    private byte[] readLongComment(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        int n = dataInput.readUnsignedShort();
        if (DEBUG) {
            System.out.println("Long comment: " + s + ", " + n + " bytes");
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        return byArray;
    }

    private int getXPtCoord(int n) {
        return (int)Math.round((double)n / this.screenImageXRatio);
    }

    private int getYPtCoord(int n) {
        return (int)Math.round((double)n / this.screenImageYRatio);
    }

    private void verbosePolyCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(string + ": " + rectangle);
        System.out.print("Polygon points: ");
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[0] + "," + polygon.ypoints[0] + ")");
        }
        for (int i = 1; polygon != null && i < polygon.npoints; ++i) {
            System.out.print(", (" + polygon.xpoints[i] + "," + polygon.ypoints[i] + ")");
        }
        System.out.println();
    }

    private void verboseRegionCmd(String string, Rectangle rectangle, Area area) {
        System.out.println(string + ": " + rectangle);
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        this.checkBounds(n);
        this.processImageStarted(n);
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n2 = imageReadParam.getSourceYSubsampling();
        } else {
            n3 = 1;
            n2 = 1;
        }
        Rectangle rectangle = this.getPICTFrame();
        BufferedImage bufferedImage = PICTImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.getXPtCoord(rectangle.width), this.getYPtCoord(rectangle.height));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setColor(new Color(0xFFFFFF, true));
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            AffineTransform affineTransform = new AffineTransform();
            if (imageReadParam != null && imageReadParam.getSourceRegion() != null) {
                Rectangle rectangle2 = imageReadParam.getSourceRegion();
                affineTransform.translate(-rectangle2.x, -rectangle2.y);
            }
            affineTransform.scale(this.screenImageXRatio / (double)n3, this.screenImageYRatio / (double)n2);
            affineTransform.translate(-rectangle.x, -rectangle.y);
            graphics2D.setTransform(affineTransform);
            this.drawOnto(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        this.processImageComplete();
        return bufferedImage;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        return this.getXPtCoord(this.getPICTFrame().width);
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        return this.getYPtCoord(this.getPICTFrame().height);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.checkBounds(n);
        return Collections.singletonList(ImageTypeSpecifiers.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, false)).iterator();
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        this.getPICTFrame();
        return new PICTMetadata(imageTypeSpecifier, this.version, this.screenImageXRatio, this.screenImageYRatio);
    }

    protected static void showIt(BufferedImage bufferedImage, String string) {
        ImageReaderBase.showIt(bufferedImage, string);
    }

    public static void main(String[] stringArray) {
        PICTImageReader pICTImageReader = new PICTImageReader(new PICTImageReaderSpi());
        for (String string : stringArray) {
            File file = new File(string);
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
                String string2 = file.getName();
                System.out.println("canRead: " + pICTImageReader.getOriginatingProvider().canDecodeInput(imageInputStream));
                pICTImageReader.setInput(imageInputStream);
                long l = System.currentTimeMillis();
                BufferedImage bufferedImage = pICTImageReader.read(0);
                System.out.println("time: " + (System.currentTimeMillis() - l));
                PICTImageReader.showIt(bufferedImage, string2);
                System.out.println("image = " + bufferedImage);
            }
            catch (IOException iOException) {
                System.err.println("Could not read " + file.getAbsolutePath() + ": " + iOException);
            }
        }
    }
}

