/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.exif.makernotes.SonyEncodedDataDirectoryBase;
import com.drew.metadata.exif.makernotes.SonyTag9050bDescriptor;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;

public class SonyTag9050bDirectory
extends SonyEncodedDataDirectoryBase {
    public static final int TAG_SHUTTER = 38;
    public static final int TAG_FLASH_STATUS = 57;
    public static final int TAG_SHUTTER_COUNT = 58;
    public static final int TAG_SONY_EXPOSURE_TIME = 70;
    public static final int TAG_SONY_F_NUMBER = 72;
    public static final int TAG_RELEASE_MODE_2 = 109;
    public static final int TAG_INTERNAL_SERIAL_NUMBER = 136;
    public static final int TAG_LENS_MOUNT = 261;
    public static final int TAG_LENS_FORMAT = 262;
    public static final int TAG_LENS_TYPE_2 = 263;
    public static final int TAG_DISTORTION_CORR_PARAMS_PRESENT = 267;
    public static final int TAG_APS_C_SIZE_CAPTURE = 276;
    public static final int TAG_LENS_SPEC_FEATURES = 278;
    public static final int TAG_SHUTTER_COUNT_3 = 415;
    @NotNull
    private static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public SonyTag9050bDirectory() {
        this.setDescriptor(new SonyTag9050bDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Sony 9050B";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    public static SonyTag9050bDirectory read(byte[] bytes) {
        SonyTag9050bDirectory dir2 = new SonyTag9050bDirectory();
        try {
            SonyTag9050bDirectory.decipherInPlace(bytes);
            ByteArrayReader reader = new ByteArrayReader(bytes);
            reader.setMotorolaByteOrder(false);
            int offset = 38;
            int shutter0 = reader.getUInt16(offset);
            int shutter1 = reader.getUInt16(offset + 2);
            int shutter2 = reader.getUInt16(offset + 4);
            dir2.setIntArray(38, new int[]{shutter0, shutter1, shutter2});
            offset = 57;
            short flashStatus = reader.getUInt8(offset);
            dir2.setInt(57, flashStatus);
            offset = 58;
            long shutterCount = reader.getUInt32(offset);
            dir2.setLong(58, shutterCount);
            offset = 70;
            int expTime = reader.getUInt16(offset);
            float expTimeFlt = (float)Math.pow(2.0, 16 - expTime / 256);
            DecimalFormat format = new DecimalFormat("0.#############");
            format.setRoundingMode(RoundingMode.HALF_UP);
            dir2.setFloat(70, expTimeFlt);
            offset = 72;
            int fNumber = reader.getUInt16(offset);
            dir2.setInt(72, fNumber);
            offset = 136;
            short serialNum0 = reader.getUInt8(offset);
            short serialNum1 = reader.getUInt8(offset + 1);
            short serialNum2 = reader.getUInt8(offset + 2);
            short serialNum3 = reader.getUInt8(offset + 3);
            short serialNum4 = reader.getUInt8(offset + 4);
            short serialNum5 = reader.getUInt8(offset + 5);
            int[] serialNumber = new int[]{serialNum0, serialNum1, serialNum2, serialNum3, serialNum4, serialNum5};
            dir2.setIntArray(136, serialNumber);
            offset = 261;
            short lensMount = reader.getUInt8(offset);
            dir2.setInt(261, lensMount);
            offset = 262;
            short lensFormat = reader.getUInt8(offset);
            dir2.setInt(262, lensFormat);
            offset = 263;
            int lensType2 = reader.getUInt16(offset);
            dir2.setInt(263, lensType2);
            offset = 267;
            short distortCorrParamsPresent = reader.getUInt8(offset);
            dir2.setInt(267, distortCorrParamsPresent);
            offset = 276;
            short apsCSizeCapture = reader.getUInt8(offset);
            dir2.setInt(276, apsCSizeCapture);
            offset = 278;
            byte[] lensSpecFeatures = reader.getBytes(offset, 2);
            dir2.setByteArray(276, lensSpecFeatures);
        }
        catch (IOException e) {
            dir2.addError(e.getMessage());
        }
        return dir2;
    }

    static {
        _tagNameMap.put(38, "Shutter");
        _tagNameMap.put(57, "Flash Status");
        _tagNameMap.put(58, "Shutter Count");
        _tagNameMap.put(70, "Sony Exposure Time");
        _tagNameMap.put(72, "Sony F Number");
        _tagNameMap.put(109, "Release Mode 2");
        _tagNameMap.put(136, "Internal Serial Number");
        _tagNameMap.put(261, "Lens Mount");
        _tagNameMap.put(262, "Lens Format");
        _tagNameMap.put(263, "Lens Type 2");
        _tagNameMap.put(267, "Distortion Corr Params Present");
        _tagNameMap.put(276, "APS-C Size Capture");
        _tagNameMap.put(278, "Lens Spec Features");
        _tagNameMap.put(415, "Shutter Count 3");
    }
}

