/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import su.litvak.chromecast.api.v2.Application;
import su.litvak.chromecast.api.v2.Channel;
import su.litvak.chromecast.api.v2.ChromeCastConnectionEventListener;
import su.litvak.chromecast.api.v2.ChromeCastException;
import su.litvak.chromecast.api.v2.ChromeCastSpontaneousEventListener;
import su.litvak.chromecast.api.v2.EventListenerHolder;
import su.litvak.chromecast.api.v2.Media;
import su.litvak.chromecast.api.v2.MediaStatus;
import su.litvak.chromecast.api.v2.Request;
import su.litvak.chromecast.api.v2.Response;
import su.litvak.chromecast.api.v2.Status;
import su.litvak.chromecast.api.v2.Util;
import su.litvak.chromecast.api.v2.Volume;

public class ChromeCast {
    public static final String SERVICE_TYPE = "_googlecast._tcp.local.";
    private final EventListenerHolder eventListenerHolder = new EventListenerHolder();
    private String name;
    private final String address;
    private final int port;
    private String appsURL;
    private String application;
    private Channel channel;
    private boolean autoReconnect = true;
    private String title;
    private String appTitle;
    private String model;

    ChromeCast(JmDNS mDNS, String name) {
        this.name = name;
        ServiceInfo serviceInfo = mDNS.getServiceInfo(SERVICE_TYPE, name);
        this.address = serviceInfo.getInet4Addresses()[0].getHostAddress();
        this.port = serviceInfo.getPort();
        this.appsURL = serviceInfo.getURLs().length == 0 ? null : serviceInfo.getURLs()[0];
        this.application = serviceInfo.getApplication();
        this.title = serviceInfo.getPropertyString("fn");
        this.appTitle = serviceInfo.getPropertyString("rs");
        this.model = serviceInfo.getPropertyString("md");
    }

    public ChromeCast(String address) {
        this(address, 8009);
    }

    public ChromeCast(String address, int port) {
        this.address = address;
        this.port = port;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getAppsURL() {
        return this.appsURL;
    }

    public final void setAppsURL(String appsURL) {
        this.appsURL = appsURL;
    }

    public final String getApplication() {
        return this.application;
    }

    public final void setApplication(String application) {
        this.application = application;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getAppTitle() {
        return this.appTitle;
    }

    public final String getModel() {
        return this.model;
    }

    private synchronized Channel channel() throws IOException {
        if (this.autoReconnect) {
            try {
                this.connect();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        return this.channel;
    }

    private String getTransportId(Application runningApp) {
        return runningApp.transportId == null ? runningApp.sessionId : runningApp.transportId;
    }

    public final synchronized void connect() throws IOException, GeneralSecurityException {
        if (this.channel == null || this.channel.isClosed()) {
            this.channel = new Channel(this.address, this.port, this.eventListenerHolder);
            this.channel.open();
        }
    }

    public final synchronized void disconnect() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.channel.close();
        this.channel = null;
    }

    public final boolean isConnected() {
        return this.channel != null && !this.channel.isClosed();
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.channel.setRequestTimeout(requestTimeout);
    }

    public final Status getStatus() throws IOException {
        return this.channel().getStatus();
    }

    public final Application getRunningApp() throws IOException {
        Status status = this.getStatus();
        return status.getRunningApp();
    }

    public final boolean isAppAvailable(String appId) throws IOException {
        return this.channel().isAppAvailable(appId);
    }

    public final boolean isAppRunning(String appId) throws IOException {
        Status status = this.getStatus();
        return status.getRunningApp() != null && appId.equals(status.getRunningApp().id);
    }

    public final Application launchApp(String appId) throws IOException {
        Status status = this.channel().launch(appId);
        return status == null ? null : status.getRunningApp();
    }

    public final void stopApp() throws IOException {
        Application runningApp = this.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        this.channel().stop(runningApp.sessionId);
    }

    public final void stopSession(String sessionId) throws IOException {
        this.channel().stop(sessionId);
    }

    public final void setVolume(float level) throws IOException {
        this.channel().setVolume(new Volume(Float.valueOf(level), false, Volume.DEFAULT_INCREMENT, Volume.DEFAULT_INCREMENT.doubleValue(), "attenuation"));
    }

    public final void setVolumeByIncrement(float level) throws IOException {
        block4: {
            float total;
            Volume volume;
            block3: {
                volume = this.getStatus().volume;
                total = volume.level.floatValue();
                if (volume.increment.floatValue() <= 0.0f) {
                    throw new ChromeCastException("Volume.increment is <= 0");
                }
                if (!(level > total)) break block3;
                while (total < level) {
                    total = Math.min(total + volume.increment.floatValue(), level);
                    this.setVolume(total);
                }
                break block4;
            }
            if (!(level < total)) break block4;
            while (total > level) {
                total = Math.max(total - volume.increment.floatValue(), level);
                this.setVolume(total);
            }
        }
    }

    public final void setMuted(boolean muted) throws IOException {
        this.channel().setVolume(new Volume(null, muted, Volume.DEFAULT_INCREMENT, Volume.DEFAULT_INCREMENT.doubleValue(), "attenuation"));
    }

    public final MediaStatus getMediaStatus() throws IOException {
        Application runningApp = this.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        return this.channel().getMediaStatus(this.getTransportId(runningApp));
    }

    public final void play() throws IOException {
        Status status = this.getStatus();
        Application runningApp = status.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        MediaStatus mediaStatus = this.channel().getMediaStatus(this.getTransportId(runningApp));
        if (mediaStatus == null) {
            throw new ChromeCastException("ChromeCast has invalid state to resume media playback");
        }
        this.channel().play(this.getTransportId(runningApp), runningApp.sessionId, mediaStatus.mediaSessionId);
    }

    public final void pause() throws IOException {
        Status status = this.getStatus();
        Application runningApp = status.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        MediaStatus mediaStatus = this.channel().getMediaStatus(this.getTransportId(runningApp));
        if (mediaStatus == null) {
            throw new ChromeCastException("ChromeCast has invalid state to pause media playback");
        }
        this.channel().pause(this.getTransportId(runningApp), runningApp.sessionId, mediaStatus.mediaSessionId);
    }

    public final void seek(double time) throws IOException {
        Status status = this.getStatus();
        Application runningApp = status.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        MediaStatus mediaStatus = this.channel().getMediaStatus(this.getTransportId(runningApp));
        if (mediaStatus == null) {
            throw new ChromeCastException("ChromeCast has invalid state to seek media playback");
        }
        this.channel().seek(this.getTransportId(runningApp), runningApp.sessionId, mediaStatus.mediaSessionId, time);
    }

    public final MediaStatus load(String url) throws IOException {
        return this.load(Util.getMediaTitle(url), null, url, Util.getContentType(url));
    }

    public final MediaStatus load(String mediaTitle, String thumb, String url, String contentType) throws IOException {
        Status status = this.getStatus();
        Application runningApp = status.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>(2);
        metadata.put("title", mediaTitle);
        metadata.put("thumb", thumb);
        return this.channel().load(this.getTransportId(runningApp), runningApp.sessionId, new Media(url, contentType == null ? Util.getContentType(url) : contentType, null, null, null, metadata, null, null), true, 0.0, null);
    }

    public final MediaStatus load(Media media) throws IOException {
        Status status = this.getStatus();
        Application runningApp = status.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        Media mediaToPlay = media.contentType == null ? new Media(media.url, Util.getContentType(media.url), media.duration, media.streamType, media.customData, media.metadata, media.textTrackStyle, media.tracks) : media;
        return this.channel().load(this.getTransportId(runningApp), runningApp.sessionId, mediaToPlay, true, 0.0, null);
    }

    public final <T extends Response> T send(String namespace, Request request, Class<T> responseClass) throws IOException {
        Status status = this.getStatus();
        Application runningApp = status.getRunningApp();
        if (runningApp == null) {
            throw new ChromeCastException("No application is running in ChromeCast");
        }
        return this.channel().sendGenericRequest(this.getTransportId(runningApp), namespace, request, responseClass);
    }

    public final void send(String namespace, Request request) throws IOException {
        this.send(namespace, request, null);
    }

    public final void registerListener(ChromeCastSpontaneousEventListener listener) {
        this.eventListenerHolder.registerListener(listener);
    }

    public final void unregisterListener(ChromeCastSpontaneousEventListener listener) {
        this.eventListenerHolder.unregisterListener(listener);
    }

    public final void registerConnectionListener(ChromeCastConnectionEventListener listener) {
        this.eventListenerHolder.registerConnectionListener(listener);
    }

    public final void unregisterConnectionListener(ChromeCastConnectionEventListener listener) {
        this.eventListenerHolder.unregisterConnectionListener(listener);
    }

    public final String toString() {
        return String.format("ChromeCast{name: %s, title: %s, model: %s, address: %s, port: %d}", this.name, this.title, this.model, this.address, this.port);
    }
}

