/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.AppEvent;
import su.litvak.chromecast.api.v2.CastChannel;
import su.litvak.chromecast.api.v2.ChromeCastException;
import su.litvak.chromecast.api.v2.EventListenerHolder;
import su.litvak.chromecast.api.v2.JacksonHelper;
import su.litvak.chromecast.api.v2.Media;
import su.litvak.chromecast.api.v2.MediaStatus;
import su.litvak.chromecast.api.v2.Message;
import su.litvak.chromecast.api.v2.RandomString;
import su.litvak.chromecast.api.v2.Request;
import su.litvak.chromecast.api.v2.Response;
import su.litvak.chromecast.api.v2.StandardMessage;
import su.litvak.chromecast.api.v2.StandardRequest;
import su.litvak.chromecast.api.v2.StandardResponse;
import su.litvak.chromecast.api.v2.Status;
import su.litvak.chromecast.api.v2.Util;
import su.litvak.chromecast.api.v2.Volume;
import su.litvak.chromecast.api.v2.X509TrustAllManager;

class Channel
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Channel.class);
    private static final long PING_PERIOD = 30000L;
    private static final long DEFAULT_REQUEST_TIMEOUT = 30000L;
    private static final String DEFAULT_RECEIVER_ID = "receiver-0";
    private final EventListenerHolder eventListener;
    private static final JsonSubTypes.Type[] STANDARD_RESPONSE_TYPES = StandardResponse.class.getAnnotation(JsonSubTypes.class).value();
    private Socket socket;
    private final InetSocketAddress address;
    private final String name;
    private Timer pingTimer;
    private ReadThread reader;
    private final AtomicLong requestCounter = new AtomicLong(1L);
    private final Map<Long, ResultProcessor<? extends Response>> requests = new ConcurrentHashMap<Long, ResultProcessor<? extends Response>>();
    private final ObjectMapper jsonMapper = JacksonHelper.createJSONMapper();
    private final Set<String> sessions = new HashSet<String>();
    private volatile boolean closed = true;
    private final Object closedSync = new Object();
    private volatile long requestTimeout = 30000L;

    private static void warn(String message, Exception ex) {
        LOG.warn("{}, caused by {}", (Object)message, (Object)ex.toString());
    }

    Channel(String host, EventListenerHolder eventListener) {
        this(host, 8009, eventListener);
    }

    Channel(String host, int port, EventListenerHolder eventListener) {
        this.address = new InetSocketAddress(host, port);
        this.name = "sender-" + new RandomString(10).nextString();
        this.eventListener = eventListener;
    }

    public void open() throws IOException, GeneralSecurityException {
        if (!this.closed) {
            throw new ChromeCastException("Channel already opened.");
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException, GeneralSecurityException {
        Object object = this.closedSync;
        synchronized (object) {
            if (this.socket == null || this.socket.isClosed()) {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{new X509TrustAllManager()}, new SecureRandom());
                this.socket = sc.getSocketFactory().createSocket();
                this.socket.connect(this.address);
            }
            CastChannel.DeviceAuthMessage authMessage = (CastChannel.DeviceAuthMessage)CastChannel.DeviceAuthMessage.newBuilder().setChallenge((CastChannel.AuthChallenge)CastChannel.AuthChallenge.newBuilder().build()).build();
            CastChannel.CastMessage msg = (CastChannel.CastMessage)CastChannel.CastMessage.newBuilder().setDestinationId(DEFAULT_RECEIVER_ID).setNamespace("urn:x-cast:com.google.cast.tp.deviceauth").setPayloadType(CastChannel.CastMessage.PayloadType.BINARY).setProtocolVersion(CastChannel.CastMessage.ProtocolVersion.CASTV2_1_0).setSourceId(this.name).setPayloadBinary(authMessage.toByteString()).build();
            this.write(msg);
            CastChannel.CastMessage response = this.read();
            CastChannel.DeviceAuthMessage authResponse = CastChannel.DeviceAuthMessage.parseFrom(response.getPayloadBinary());
            if (authResponse.hasError()) {
                throw new ChromeCastException("Authentication failed: " + authResponse.getError().getErrorType().toString());
            }
            PingThread pingThread = new PingThread();
            pingThread.run();
            this.write("urn:x-cast:com.google.cast.tp.connection", StandardMessage.connect(), DEFAULT_RECEIVER_ID);
            this.pingTimer = new Timer(this.name + " PING");
            this.pingTimer.schedule((TimerTask)pingThread, 1000L, 30000L);
            this.reader = new ReadThread();
            this.reader.start();
            if (this.closed) {
                this.closed = false;
                this.notifyListenerOfConnectionEvent(true);
            }
        }
    }

    private <T extends StandardResponse> T sendStandard(String namespace, StandardRequest message, String destinationId) throws IOException {
        return (T)this.send(namespace, message, destinationId, StandardResponse.class);
    }

    private <T extends Response> T send(String namespace, Request message, String destinationId, Class<T> responseClass) throws IOException {
        if (this.isClosed()) {
            try {
                this.connect();
            }
            catch (GeneralSecurityException gse) {
                throw new ChromeCastException("Unexpected security exception", gse);
            }
        }
        Long requestId = this.requestCounter.getAndIncrement();
        message.setRequestId(requestId);
        if (!requestId.equals(message.getRequestId())) {
            throw new IllegalStateException("Request Id getter/setter contract violation");
        }
        if (responseClass == null) {
            this.write(namespace, message, destinationId);
            return null;
        }
        ResultProcessor rp = new ResultProcessor(responseClass);
        this.requests.put(requestId, rp);
        this.write(namespace, message, destinationId);
        try {
            Object response = rp.get();
            if (response instanceof StandardResponse.Invalid) {
                StandardResponse.Invalid invalid = (StandardResponse.Invalid)response;
                throw new ChromeCastException("Invalid request: " + invalid.reason);
            }
            if (response instanceof StandardResponse.LoadFailed) {
                throw new ChromeCastException("Unable to load media");
            }
            if (response instanceof StandardResponse.LaunchError) {
                StandardResponse.LaunchError launchError = (StandardResponse.LaunchError)response;
                throw new ChromeCastException("Application launch error: " + launchError.reason);
            }
            Object t = response;
            return t;
        }
        catch (InterruptedException e) {
            throw new ChromeCastException("Interrupted while waiting for response", e);
        }
        catch (TimeoutException e) {
            throw new ChromeCastException("Waiting for response timed out", e);
        }
        finally {
            this.requests.remove(requestId);
        }
    }

    private void write(String namespace, Message message, String destinationId) throws IOException {
        this.write(namespace, this.jsonMapper.writeValueAsString(message), destinationId);
    }

    private void write(String namespace, String message, String destinationId) throws IOException {
        LOG.debug(" --> {}", (Object)message);
        CastChannel.CastMessage msg = (CastChannel.CastMessage)CastChannel.CastMessage.newBuilder().setProtocolVersion(CastChannel.CastMessage.ProtocolVersion.CASTV2_1_0).setSourceId(this.name).setDestinationId(destinationId).setNamespace(namespace).setPayloadType(CastChannel.CastMessage.PayloadType.STRING).setPayloadUtf8(message).build();
        this.write(msg);
    }

    private void write(CastChannel.CastMessage message) throws IOException {
        this.socket.getOutputStream().write(Util.toArray(message.getSerializedSize()));
        message.writeTo(this.socket.getOutputStream());
    }

    private CastChannel.CastMessage read() throws IOException {
        int nowRead;
        InputStream is = this.socket.getInputStream();
        byte[] buf = new byte[4];
        int read = 0;
        while (read < buf.length) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new ChromeCastException("Remote socket closed");
            }
            buf[read++] = (byte)nextByte;
        }
        int size = Util.fromArray(buf);
        buf = new byte[size];
        for (read = 0; read < size; read += nowRead) {
            nowRead = is.read(buf, read, buf.length - read);
            if (nowRead != -1) continue;
            throw new ChromeCastException("Remote socket closed");
        }
        return CastChannel.CastMessage.parseFrom(buf);
    }

    private void notifyListenerOfConnectionEvent(boolean connected) {
        if (this.eventListener != null) {
            this.eventListener.deliverConnectionEvent(connected);
        }
    }

    private void notifyListenersOfSpontaneousEvent(JsonNode json) throws IOException {
        if (this.eventListener != null) {
            this.eventListener.deliverEvent(json);
        }
    }

    private void notifyListenersAppEvent(AppEvent event) throws IOException {
        if (this.eventListener != null) {
            this.eventListener.deliverAppEvent(event);
        }
    }

    public Status getStatus() throws IOException {
        StandardResponse.Status status = (StandardResponse.Status)this.sendStandard("urn:x-cast:com.google.cast.receiver", StandardRequest.status(), DEFAULT_RECEIVER_ID);
        return status == null ? null : status.status;
    }

    public boolean isAppAvailable(String appId) throws IOException {
        StandardResponse.AppAvailability availability = (StandardResponse.AppAvailability)this.sendStandard("urn:x-cast:com.google.cast.receiver", StandardRequest.appAvailability(appId), DEFAULT_RECEIVER_ID);
        return availability != null && "APP_AVAILABLE".equals(availability.availability.get(appId));
    }

    public Status launch(String appId) throws IOException {
        StandardResponse.Status status = (StandardResponse.Status)this.sendStandard("urn:x-cast:com.google.cast.receiver", StandardRequest.launch(appId), DEFAULT_RECEIVER_ID);
        return status == null ? null : status.status;
    }

    public Status stop(String sessionId) throws IOException {
        StandardResponse.Status status = (StandardResponse.Status)this.sendStandard("urn:x-cast:com.google.cast.receiver", StandardRequest.stop(sessionId), DEFAULT_RECEIVER_ID);
        return status == null ? null : status.status;
    }

    private void startSession(String destinationId) throws IOException {
        if (!this.sessions.contains(destinationId)) {
            this.write("urn:x-cast:com.google.cast.tp.connection", StandardMessage.connect(), destinationId);
            this.sessions.add(destinationId);
        }
    }

    public MediaStatus load(String destinationId, String sessionId, Media media, boolean autoplay, double currentTime, Map<String, String> customData) throws IOException {
        this.startSession(destinationId);
        StandardResponse.MediaStatus status = (StandardResponse.MediaStatus)this.sendStandard("urn:x-cast:com.google.cast.media", StandardRequest.load(sessionId, media, autoplay, currentTime, customData), destinationId);
        return status == null || status.statuses.length == 0 ? null : status.statuses[0];
    }

    public MediaStatus play(String destinationId, String sessionId, long mediaSessionId) throws IOException {
        this.startSession(destinationId);
        StandardResponse.MediaStatus status = (StandardResponse.MediaStatus)this.sendStandard("urn:x-cast:com.google.cast.media", StandardRequest.play(sessionId, mediaSessionId), destinationId);
        return status == null || status.statuses.length == 0 ? null : status.statuses[0];
    }

    public MediaStatus pause(String destinationId, String sessionId, long mediaSessionId) throws IOException {
        this.startSession(destinationId);
        StandardResponse.MediaStatus status = (StandardResponse.MediaStatus)this.sendStandard("urn:x-cast:com.google.cast.media", StandardRequest.pause(sessionId, mediaSessionId), destinationId);
        return status == null || status.statuses.length == 0 ? null : status.statuses[0];
    }

    public MediaStatus seek(String destinationId, String sessionId, long mediaSessionId, double currentTime) throws IOException {
        this.startSession(destinationId);
        StandardResponse.MediaStatus status = (StandardResponse.MediaStatus)this.sendStandard("urn:x-cast:com.google.cast.media", StandardRequest.seek(sessionId, mediaSessionId, currentTime), destinationId);
        return status == null || status.statuses.length == 0 ? null : status.statuses[0];
    }

    public Status setVolume(Volume volume) throws IOException {
        StandardResponse.Status status = (StandardResponse.Status)this.sendStandard("urn:x-cast:com.google.cast.receiver", StandardRequest.setVolume(volume), DEFAULT_RECEIVER_ID);
        return status == null ? null : status.status;
    }

    public MediaStatus getMediaStatus(String destinationId) throws IOException {
        this.startSession(destinationId);
        StandardResponse.MediaStatus status = (StandardResponse.MediaStatus)this.sendStandard("urn:x-cast:com.google.cast.media", StandardRequest.status(), destinationId);
        return status == null || status.statuses.length == 0 ? null : status.statuses[0];
    }

    public <T extends Response> T sendGenericRequest(String destinationId, String namespace, Request request, Class<T> responseClass) throws IOException {
        this.startSession(destinationId);
        return this.send(namespace, request, destinationId, responseClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closedSync;
        synchronized (object) {
            if (this.closed) {
                throw new ChromeCastException("Channel already closed.");
            }
            this.closed = true;
            this.notifyListenerOfConnectionEvent(false);
            if (this.pingTimer != null) {
                this.pingTimer.cancel();
            }
            if (this.reader != null) {
                this.reader.stop = true;
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    private class PingThread
    extends TimerTask {
        private PingThread() {
        }

        @Override
        public void run() {
            try {
                Channel.this.write("urn:x-cast:com.google.cast.tp.heartbeat", StandardMessage.ping(), Channel.DEFAULT_RECEIVER_ID);
            }
            catch (IOException ioex) {
                Channel.warn("Error while sending 'PING'", ioex);
            }
        }
    }

    private class ReadThread
    extends Thread {
        volatile boolean stop;

        private ReadThread() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                JsonNode parsed = null;
                String jsonMSG = null;
                CastChannel.CastMessage message = null;
                try {
                    message = Channel.this.read();
                    if (message.getPayloadType() == CastChannel.CastMessage.PayloadType.STRING) {
                        LOG.debug(" <-- {}", (Object)message.getPayloadUtf8());
                        jsonMSG = message.getPayloadUtf8().replaceFirst("\"type\"", "\"responseType\"");
                        if (jsonMSG == null || jsonMSG.isEmpty()) {
                            LOG.warn(" <-- Received empty message. Ignore.");
                            continue;
                        }
                        parsed = Channel.this.jsonMapper.readTree(jsonMSG);
                    } else {
                        LOG.warn("Received unexpected {} message", (Object)message.getPayloadType());
                    }
                }
                catch (InvalidProtocolBufferException ipbe) {
                    Channel.warn("Error while processing protobuf", ipbe);
                }
                catch (JsonProcessingException jpe) {
                    Channel.warn("Error while processing json", jpe);
                }
                catch (IOException ioex) {
                    if (this.stop) {
                        LOG.debug("Got IOException while reading due to stream being closed (stop=true)", ioex);
                        continue;
                    }
                    Channel.warn("Error while reading", ioex);
                    String temp = message != null && message.getPayloadUtf8() != null ? message.getPayloadUtf8() : " null payload in message ";
                    LOG.warn(" <-- {}", (Object)temp);
                    try {
                        Channel.this.close();
                    }
                    catch (IOException e) {
                        Channel.warn("Error while closing channel", ioex);
                    }
                }
                catch (Exception e) {
                    Channel.warn("Unknown error while reading", e);
                    continue;
                }
                try {
                    if (message == null) continue;
                    if (this.isAppEvent(parsed)) {
                        AppEvent event = new AppEvent(message.getNamespace(), message.getPayloadUtf8());
                        Channel.this.notifyListenersAppEvent(event);
                        continue;
                    }
                    if (parsed.has("requestId")) {
                        Long requestId = parsed.get("requestId").asLong();
                        ResultProcessor rp = (ResultProcessor)Channel.this.requests.remove(requestId);
                        if (rp != null) {
                            rp.put(jsonMSG);
                            continue;
                        }
                        Channel.this.notifyListenersOfSpontaneousEvent(parsed);
                        continue;
                    }
                    if (parsed.has("responseType") && parsed.get("responseType").asText().equals("MEDIA_STATUS")) {
                        Channel.this.notifyListenersOfSpontaneousEvent(parsed);
                        continue;
                    }
                    if (parsed.has("responseType") && parsed.get("responseType").asText().equals("PING")) {
                        Channel.this.write("urn:x-cast:com.google.cast.tp.heartbeat", StandardMessage.pong(), Channel.DEFAULT_RECEIVER_ID);
                        continue;
                    }
                    if (!parsed.has("responseType") || !parsed.get("responseType").asText().equals("CLOSE")) continue;
                    Channel.this.notifyListenersOfSpontaneousEvent(parsed);
                }
                catch (Exception e) {
                    Channel.warn("Error while handling", e);
                }
            }
        }

        private boolean isAppEvent(JsonNode parsed) {
            if (parsed != null && parsed.has("responseType")) {
                String type = parsed.get("responseType").asText();
                for (JsonSubTypes.Type t : STANDARD_RESPONSE_TYPES) {
                    if (!t.name().equals(type)) continue;
                    return false;
                }
            }
            return parsed == null || !parsed.has("requestId");
        }
    }

    private class ResultProcessor<T extends Response> {
        final Class<T> responseClass;
        T result;

        private ResultProcessor(Class<T> responseClass) {
            if (responseClass == null) {
                throw new NullPointerException();
            }
            this.responseClass = responseClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String jsonMSG) throws IOException {
            ResultProcessor resultProcessor = this;
            synchronized (resultProcessor) {
                this.result = (Response)Channel.this.jsonMapper.readValue(jsonMSG, this.responseClass);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() throws InterruptedException, TimeoutException {
            ResultProcessor resultProcessor = this;
            synchronized (resultProcessor) {
                if (this.result != null) {
                    return this.result;
                }
                this.wait(Channel.this.requestTimeout);
                if (this.result == null) {
                    throw new TimeoutException();
                }
                return this.result;
            }
        }
    }
}

