/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.NoNetworkException;
import org.jupnp.util.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressFactoryImpl
implements NetworkAddressFactory {
    public static final int DEFAULT_TCP_HTTP_LISTEN_PORT = 0;
    public static final int DEFAULT_MULTICAST_RESPONSE_LISTEN_PORT = 0;
    private final Logger logger = LoggerFactory.getLogger(NetworkAddressFactoryImpl.class);
    protected final Set<String> useInterfaces = new HashSet<String>();
    protected final Set<String> useAddresses = new HashSet<String>();
    protected final List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    protected final List<InetAddress> bindAddresses = new ArrayList<InetAddress>();
    protected int streamListenPort;
    protected int multicastResponsePort;

    public NetworkAddressFactoryImpl() throws InitializationException {
        this(0, 0);
    }

    public NetworkAddressFactoryImpl(int streamListenPort, int multicastResponsePort) throws InitializationException {
        this(streamListenPort, multicastResponsePort, null);
    }

    public NetworkAddressFactoryImpl(int streamListenPort, int multicastResponsePort, String interfaces) throws InitializationException {
        String useAddressesString;
        String useInterfacesString;
        String string = useInterfacesString = interfaces != null && !interfaces.isBlank() ? interfaces : System.getProperty("org.jupnp.network.useInterfaces");
        if (useInterfacesString != null) {
            String[] userInterfacesStrings = useInterfacesString.split(",");
            this.useInterfaces.addAll(Arrays.asList(userInterfacesStrings));
        }
        if ((useAddressesString = System.getProperty("org.jupnp.network.useAddresses")) != null) {
            String[] useAddressesStrings = useAddressesString.split(",");
            this.useAddresses.addAll(Arrays.asList(useAddressesStrings));
        }
        this.discoverNetworkInterfaces();
        this.discoverBindAddresses();
        if (this.networkInterfaces.isEmpty() || this.bindAddresses.isEmpty()) {
            this.logger.warn("No usable network interface or addresses found");
            if (this.requiresNetworkInterface()) {
                throw new NoNetworkException("Could not discover any usable network interfaces and/or addresses");
            }
        }
        this.streamListenPort = streamListenPort;
        this.multicastResponsePort = multicastResponsePort;
    }

    protected boolean requiresNetworkInterface() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logInterfaceInformation() {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            if (this.networkInterfaces.isEmpty()) {
                this.logger.info("No network interface to display!");
                return;
            }
            for (NetworkInterface networkInterface : this.networkInterfaces) {
                try {
                    this.logInterfaceInformation(networkInterface);
                }
                catch (SocketException e) {
                    this.logger.warn("Exception while logging network interface information", e);
                }
            }
        }
    }

    @Override
    public InetAddress getMulticastGroup() {
        try {
            return InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMulticastPort() {
        return 1900;
    }

    @Override
    public int getMulticastResponsePort() {
        return this.multicastResponsePort > 0 ? this.multicastResponsePort : 0;
    }

    @Override
    public int getStreamListenPort() {
        return this.streamListenPort;
    }

    @Override
    public Iterator<NetworkInterface> getNetworkInterfaces() {
        return new Iterators.Synchronized<NetworkInterface>(this.networkInterfaces){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<NetworkInterface> list = NetworkAddressFactoryImpl.this.networkInterfaces;
                synchronized (list) {
                    NetworkAddressFactoryImpl.this.networkInterfaces.remove(index);
                }
            }
        };
    }

    @Override
    public Iterator<InetAddress> getBindAddresses() {
        return new Iterators.Synchronized<InetAddress>(this.bindAddresses){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<InetAddress> list = NetworkAddressFactoryImpl.this.bindAddresses;
                synchronized (list) {
                    NetworkAddressFactoryImpl.this.bindAddresses.remove(index);
                }
            }
        };
    }

    @Override
    public boolean hasUsableNetwork() {
        return !this.networkInterfaces.isEmpty() && !this.bindAddresses.isEmpty();
    }

    @Override
    public byte[] getHardwareAddress(InetAddress inetAddress) {
        try {
            NetworkInterface iface = NetworkInterface.getByInetAddress(inetAddress);
            return iface != null ? iface.getHardwareAddress() : null;
        }
        catch (Exception e) {
            this.logger.warn("Cannot get hardware address for: {}", (Object)inetAddress, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getBroadcastAddress(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress interfaceAddress : this.getInterfaceAddresses(iface)) {
                    if (interfaceAddress == null || !interfaceAddress.getAddress().equals(inetAddress)) continue;
                    return interfaceAddress.getBroadcast();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Short getAddressNetworkPrefixLength(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            InterfaceAddress interfaceAddress;
            Iterator<NetworkInterface> iterator = this.networkInterfaces.iterator();
            block3: while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                NetworkInterface iface = iterator.next();
                Iterator<InterfaceAddress> iterator2 = this.getInterfaceAddresses(iface).iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while ((interfaceAddress = iterator2.next()) == null || !interfaceAddress.getAddress().equals(inetAddress));
                break;
            }
            short prefix = interfaceAddress.getNetworkPrefixLength();
            if (prefix <= 0) return null;
            if (prefix >= 32) return null;
            return prefix;
        }
    }

    @Override
    public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) {
        InetAddress localIPInSubnet = this.getBindAddressInSubnetOf(remoteAddress);
        if (localIPInSubnet != null) {
            return localIPInSubnet;
        }
        this.logger.trace("Could not find local bind address in same subnet as: {}", (Object)remoteAddress.getHostAddress());
        for (InetAddress interfaceAddress : this.getInetAddresses(networkInterface)) {
            if (isIPv6 && interfaceAddress instanceof Inet6Address) {
                return interfaceAddress;
            }
            if (isIPv6 || !(interfaceAddress instanceof Inet4Address)) continue;
            return interfaceAddress;
        }
        throw new IllegalStateException("Can't find any IPv4 or IPv6 address on interface: " + networkInterface.getDisplayName());
    }

    protected List<InterfaceAddress> getInterfaceAddresses(NetworkInterface networkInterface) {
        return networkInterface.getInterfaceAddresses();
    }

    protected List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetAddress getBindAddressInSubnetOf(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress ifaceAddress : this.getInterfaceAddresses(iface)) {
                    List<InetAddress> list2 = this.bindAddresses;
                    synchronized (list2) {
                        if (ifaceAddress == null || !this.bindAddresses.contains(ifaceAddress.getAddress())) {
                            continue;
                        }
                    }
                    if (!this.isInSubnet(inetAddress.getAddress(), ifaceAddress.getAddress().getAddress(), ifaceAddress.getNetworkPrefixLength())) continue;
                    return ifaceAddress.getAddress();
                }
            }
        }
        return null;
    }

    protected boolean isInSubnet(byte[] ip, byte[] network, short prefix) {
        if (ip.length != network.length) {
            return false;
        }
        if (prefix / 8 > ip.length) {
            return false;
        }
        int i = 0;
        while (prefix >= 8 && i < ip.length) {
            if (ip[i] != network[i]) {
                return false;
            }
            ++i;
            prefix = (short)(prefix - 8);
        }
        if (i == ip.length) {
            return true;
        }
        byte mask = (byte)(~((1 << 8 - prefix) - 1));
        return (ip[i] & mask) == (network[i] & mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverNetworkInterfaces() throws InitializationException {
        try {
            Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(interfaceEnumeration)) {
                this.logger.trace("Analyzing network interface: {}", (Object)iface.getDisplayName());
                if (this.isUsableNetworkInterface(iface)) {
                    this.logger.trace("Discovered usable network interface: {}", (Object)iface.getDisplayName());
                    List<NetworkInterface> list = this.networkInterfaces;
                    synchronized (list) {
                        this.networkInterfaces.add(iface);
                        continue;
                    }
                }
                this.logger.trace("Ignoring non-usable network interface: {}", (Object)iface.getDisplayName());
            }
        }
        catch (Exception e) {
            throw new InitializationException("Could not not analyze local network interfaces", e);
        }
    }

    protected boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
        if (!iface.isUp()) {
            this.logger.trace("Skipping network interface (down): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (this.getInetAddresses(iface).isEmpty()) {
            this.logger.trace("Skipping network interface without bound IP addresses: {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.isPointToPoint()) {
            this.logger.trace("Skipping point-to-point network interface: {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vmnet") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ENGLISH).contains("vmnet")) {
            this.logger.trace("Skipping network interface (VMWare): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vnic")) {
            this.logger.trace("Skipping network interface (Parallels): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vboxnet")) {
            this.logger.trace("Skipping network interface (Virtual Box): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).contains("virtual")) {
            this.logger.trace("Skipping network interface (named '*virtual*'): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("ppp")) {
            this.logger.trace("Skipping network interface (PPP): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.isLoopback()) {
            this.logger.trace("Skipping network interface (ignoring loopback): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (!this.useInterfaces.isEmpty() && !this.useInterfaces.contains(iface.getName())) {
            this.logger.trace("Skipping unwanted network interface (OSGi parameter 'interfaces' or -D {}): {}", (Object)"org.jupnp.network.useInterfaces", (Object)iface.getName());
            return false;
        }
        if (!iface.supportsMulticast()) {
            this.logger.warn("Network interface may not be multicast capable: {}", (Object)iface.getDisplayName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverBindAddresses() throws InitializationException {
        try {
            List<NetworkInterface> list = this.networkInterfaces;
            synchronized (list) {
                Iterator<NetworkInterface> it = this.networkInterfaces.iterator();
                while (it.hasNext()) {
                    NetworkInterface networkInterface = it.next();
                    this.logger.trace("Discovering addresses of interface: {}", (Object)networkInterface.getDisplayName());
                    int usableAddresses = 0;
                    for (InetAddress inetAddress : this.getInetAddresses(networkInterface)) {
                        if (inetAddress == null) {
                            this.logger.warn("Network has a null address: {}", (Object)networkInterface.getDisplayName());
                            continue;
                        }
                        if (this.isUsableAddress(networkInterface, inetAddress)) {
                            this.logger.trace("Discovered usable network interface address: {}", (Object)inetAddress.getHostAddress());
                            ++usableAddresses;
                            List<InetAddress> list2 = this.bindAddresses;
                            synchronized (list2) {
                                this.bindAddresses.add(inetAddress);
                                continue;
                            }
                        }
                        this.logger.trace("Ignoring non-usable network interface address: {}", (Object)inetAddress.getHostAddress());
                    }
                    if (usableAddresses != 0) continue;
                    this.logger.trace("Network interface has no usable addresses, removing: {}", (Object)networkInterface.getDisplayName());
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            throw new InitializationException("Could not not analyze local network interfaces", e);
        }
    }

    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            this.logger.trace("Skipping unsupported non-IPv4 address: {}", (Object)address);
            return false;
        }
        if (address.isLoopbackAddress()) {
            this.logger.trace("Skipping loopback address: {}", (Object)address);
            return false;
        }
        if (!this.useAddresses.isEmpty() && !this.useAddresses.contains(address.getHostAddress())) {
            this.logger.trace("Skipping unwanted address: {}", (Object)address);
            return false;
        }
        return true;
    }

    protected void logInterfaceInformation(NetworkInterface networkInterface) throws SocketException {
        this.logger.info("---------------------------------------------------------------------------------");
        this.logger.info("Interface display name: {}", (Object)networkInterface.getDisplayName());
        if (networkInterface.getParent() != null) {
            this.logger.info("Parent Info: {}", (Object)networkInterface.getParent());
        }
        this.logger.info("Name: {}", (Object)networkInterface.getName());
        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            this.logger.info("InetAddress: {}", (Object)inetAddress);
        }
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            if (interfaceAddress == null) {
                this.logger.warn("Skipping null InterfaceAddress!");
                continue;
            }
            this.logger.info(" Interface Address");
            this.logger.info("  Address: {}", (Object)interfaceAddress.getAddress());
            this.logger.info("  Broadcast: {}", (Object)interfaceAddress.getBroadcast());
            this.logger.info("  Prefix length: {}", (Object)interfaceAddress.getNetworkPrefixLength());
        }
        Enumeration<NetworkInterface> subIfs = networkInterface.getSubInterfaces();
        for (NetworkInterface subIf : Collections.list(subIfs)) {
            if (subIf == null) {
                this.logger.warn("Skipping null NetworkInterface sub-interface");
                continue;
            }
            this.logger.info("\tSub Interface Display name: {}", (Object)subIf.getDisplayName());
            this.logger.info("\tSub Interface Name: {}", (Object)subIf.getName());
        }
        this.logger.info("Up? {}", (Object)networkInterface.isUp());
        this.logger.info("Loopback? {}", (Object)networkInterface.isLoopback());
        this.logger.info("PointToPoint? {}", (Object)networkInterface.isPointToPoint());
        this.logger.info("Supports multicast? {}", (Object)networkInterface.supportsMulticast());
        this.logger.info("Virtual? {}", (Object)networkInterface.isVirtual());
        this.logger.info("Hardware address: {}", (Object)Arrays.toString(networkInterface.getHardwareAddress()));
        this.logger.info("MTU: {}", (Object)networkInterface.getMTU());
    }
}

