/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.avtransport.impl;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.avtransport.AVTransportErrorCode;
import org.jupnp.support.avtransport.AVTransportException;
import org.jupnp.support.avtransport.AbstractAVTransportService;
import org.jupnp.support.avtransport.impl.AVTransportStateMachine;
import org.jupnp.support.avtransport.impl.state.AbstractState;
import org.jupnp.support.lastchange.LastChange;
import org.jupnp.support.model.AVTransport;
import org.jupnp.support.model.DeviceCapabilities;
import org.jupnp.support.model.MediaInfo;
import org.jupnp.support.model.PlayMode;
import org.jupnp.support.model.PositionInfo;
import org.jupnp.support.model.RecordQualityMode;
import org.jupnp.support.model.SeekMode;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.TransportAction;
import org.jupnp.support.model.TransportInfo;
import org.jupnp.support.model.TransportSettings;
import org.jupnp.util.statemachine.StateMachineBuilder;
import org.jupnp.util.statemachine.TransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AVTransportService<T extends AVTransport>
extends AbstractAVTransportService {
    private final Logger logger = LoggerFactory.getLogger(AVTransportService.class);
    private final Map<Long, AVTransportStateMachine> stateMachines = new ConcurrentHashMap<Long, AVTransportStateMachine>();
    final Class<? extends AVTransportStateMachine> stateMachineDefinition;
    final Class<? extends AbstractState<?>> initialState;
    final Class<? extends AVTransport> transportClass;

    public AVTransportService(Class<? extends AVTransportStateMachine> stateMachineDefinition, Class<? extends AbstractState<?>> initialState) {
        this(stateMachineDefinition, initialState, AVTransport.class);
    }

    public AVTransportService(Class<? extends AVTransportStateMachine> stateMachineDefinition, Class<? extends AbstractState<?>> initialState, Class<T> transportClass) {
        this.stateMachineDefinition = stateMachineDefinition;
        this.initialState = initialState;
        this.transportClass = transportClass;
    }

    @Override
    public void setAVTransportURI(UnsignedIntegerFourBytes instanceId, String currentURI, String currentURIMetaData) throws AVTransportException {
        URI uri;
        try {
            uri = new URI(currentURI);
        }
        catch (Exception e) {
            throw new AVTransportException(ErrorCode.INVALID_ARGS, "CurrentURI can not be null or malformed");
        }
        try {
            AVTransportStateMachine transportStateMachine = this.findStateMachine(instanceId, true);
            transportStateMachine.setTransportURI(uri, currentURIMetaData);
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void setNextAVTransportURI(UnsignedIntegerFourBytes instanceId, String nextURI, String nextURIMetaData) throws AVTransportException {
        URI uri;
        try {
            uri = new URI(nextURI);
        }
        catch (Exception e) {
            throw new AVTransportException(ErrorCode.INVALID_ARGS, "NextURI can not be null or malformed");
        }
        try {
            AVTransportStateMachine transportStateMachine = this.findStateMachine(instanceId, true);
            transportStateMachine.setNextTransportURI(uri, nextURIMetaData);
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void setPlayMode(UnsignedIntegerFourBytes instanceId, String newPlayMode) throws AVTransportException {
        Object transport = ((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport();
        try {
            ((AVTransport)transport).setTransportSettings(new TransportSettings(PlayMode.valueOf(newPlayMode), ((AVTransport)transport).getTransportSettings().getRecQualityMode()));
        }
        catch (IllegalArgumentException e) {
            throw new AVTransportException(AVTransportErrorCode.PLAYMODE_NOT_SUPPORTED, "Unsupported play mode: " + newPlayMode);
        }
    }

    @Override
    public void setRecordQualityMode(UnsignedIntegerFourBytes instanceId, String newRecordQualityMode) throws AVTransportException {
        Object transport = ((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport();
        try {
            ((AVTransport)transport).setTransportSettings(new TransportSettings(((AVTransport)transport).getTransportSettings().getPlayMode(), RecordQualityMode.valueOrExceptionOf(newRecordQualityMode)));
        }
        catch (IllegalArgumentException e) {
            throw new AVTransportException(AVTransportErrorCode.RECORDQUALITYMODE_NOT_SUPPORTED, "Unsupported record quality mode: " + newRecordQualityMode);
        }
    }

    @Override
    public MediaInfo getMediaInfo(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        return ((AVTransport)((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport()).getMediaInfo();
    }

    @Override
    public TransportInfo getTransportInfo(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        return ((AVTransport)((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport()).getTransportInfo();
    }

    @Override
    public PositionInfo getPositionInfo(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        return ((AVTransport)((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport()).getPositionInfo();
    }

    @Override
    public DeviceCapabilities getDeviceCapabilities(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        return ((AVTransport)((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport()).getDeviceCapabilities();
    }

    @Override
    public TransportSettings getTransportSettings(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        return ((AVTransport)((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport()).getTransportSettings();
    }

    @Override
    public void stop(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).stop();
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void play(UnsignedIntegerFourBytes instanceId, String speed) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).play(speed);
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void pause(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).pause();
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void record(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).record();
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void seek(UnsignedIntegerFourBytes instanceId, String unit, String target) throws AVTransportException {
        SeekMode seekMode;
        try {
            seekMode = SeekMode.valueOrExceptionOf(unit);
        }
        catch (IllegalArgumentException e) {
            throw new AVTransportException(AVTransportErrorCode.SEEKMODE_NOT_SUPPORTED, "Unsupported seek mode: " + unit);
        }
        try {
            this.findStateMachine(instanceId).seek(seekMode, target);
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void next(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).next();
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    public void previous(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).previous();
        }
        catch (TransitionException e) {
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, e.getMessage());
        }
    }

    @Override
    protected TransportAction[] getCurrentTransportActions(UnsignedIntegerFourBytes instanceId) throws Exception {
        AVTransportStateMachine stateMachine = this.findStateMachine(instanceId);
        try {
            return ((AbstractState)stateMachine.getCurrentState()).getCurrentTransportActions();
        }
        catch (TransitionException e) {
            return new TransportAction[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsignedIntegerFourBytes[] getCurrentInstanceIds() {
        Map<Long, AVTransportStateMachine> map = this.stateMachines;
        synchronized (map) {
            UnsignedIntegerFourBytes[] ids = new UnsignedIntegerFourBytes[this.stateMachines.size()];
            int i = 0;
            for (Long id : this.stateMachines.keySet()) {
                ids[i] = new UnsignedIntegerFourBytes(id);
                ++i;
            }
            return ids;
        }
    }

    protected AVTransportStateMachine findStateMachine(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        return this.findStateMachine(instanceId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AVTransportStateMachine findStateMachine(UnsignedIntegerFourBytes instanceId, boolean createDefaultTransport) throws AVTransportException {
        Map<Long, AVTransportStateMachine> map = this.stateMachines;
        synchronized (map) {
            long id = instanceId.getValue();
            AVTransportStateMachine stateMachine = this.stateMachines.get(id);
            if (stateMachine == null && id == 0L && createDefaultTransport) {
                this.logger.debug("Creating default transport instance with ID '0'");
                stateMachine = this.createStateMachine(instanceId);
                this.stateMachines.put(id, stateMachine);
            } else if (stateMachine == null) {
                throw new AVTransportException(AVTransportErrorCode.INVALID_INSTANCE_ID);
            }
            this.logger.debug("Found transport control with ID '{}'", (Object)id);
            return stateMachine;
        }
    }

    protected AVTransportStateMachine createStateMachine(UnsignedIntegerFourBytes instanceId) {
        return StateMachineBuilder.build(this.stateMachineDefinition, this.initialState, new Class[]{this.transportClass}, new Object[]{this.createTransport(instanceId, this.getLastChange())});
    }

    protected AVTransport createTransport(UnsignedIntegerFourBytes instanceId, LastChange lastChange) {
        return new AVTransport(instanceId, lastChange, StorageMedium.NETWORK);
    }
}

