/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingEventRequestMessage;
import org.jupnp.model.message.gena.OutgoingEventResponseMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.resource.ServiceEventCallbackResource;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingEvent
extends ReceivingSync<StreamRequestMessage, OutgoingEventResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingEvent.class);

    public ReceivingEvent(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected OutgoingEventResponseMessage executeSync() throws RouterException {
        ServiceEventCallbackResource resource;
        if (!((StreamRequestMessage)this.getInputMessage()).isContentTypeTextUDA()) {
            this.logger.warn("Received without or with invalid Content-Type: {}", this.getInputMessage());
        }
        if ((resource = this.getUpnpService().getRegistry().getResource(ServiceEventCallbackResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
            this.logger.trace("No local resource found: {}", this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.NOT_FOUND));
        }
        IncomingEventRequestMessage requestMessage = new IncomingEventRequestMessage((StreamRequestMessage)this.getInputMessage(), (RemoteService)resource.getModel());
        if (requestMessage.getSubscrptionId() == null) {
            this.logger.trace("Subscription ID missing in event request: {}", this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            this.logger.trace("Missing NT and/or NTS headers in event request: {}", this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.BAD_REQUEST));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            this.logger.trace("Invalid NT and/or NTS headers in event request: {}", this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (requestMessage.getSequence() == null) {
            this.logger.trace("Sequence missing in event request: {}", this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        try {
            this.getUpnpService().getConfiguration().getGenaEventProcessor().readBody(requestMessage);
        }
        catch (UnsupportedDataException e) {
            this.logger.trace("Can't read event message request body", e);
            RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getRemoteSubscription(requestMessage.getSubscrptionId());
            if (subscription != null) {
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> subscription.invalidMessage(e));
            }
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.INTERNAL_SERVER_ERROR));
        }
        RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getWaitRemoteSubscription(requestMessage.getSubscrptionId());
        if (subscription == null) {
            this.logger.debug("Invalid subscription ID, no active subscription: {}", (Object)requestMessage);
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> {
            this.logger.trace("Calling active subscription with event state variable values");
            subscription.receive(requestMessage.getSequence(), requestMessage.getStateVariableValues());
        });
        return new OutgoingEventResponseMessage();
    }
}

