/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="WebSocket Upgrade Filter")
public class WebSocketUpgradeFilter
implements Filter,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketUpgradeFilter.class);
    private static final AutoLock LOCK = new AutoLock();
    private final Configuration.ConfigurationCustomizer defaultCustomizer = new Configuration.ConfigurationCustomizer();
    private WebSocketMappings mappings;

    public static FilterHolder getFilter(ServletContext servletContext) {
        ContextHandler contextHandler = Objects.requireNonNull(ServletContextHandler.getServletContextHandler(servletContext));
        ServletHandler servletHandler = contextHandler.getDescendant(ServletHandler.class);
        return servletHandler.getFilter(WebSocketUpgradeFilter.class.getName());
    }

    public static FilterHolder ensureFilter(ServletContext servletContext) {
        try (AutoLock l = LOCK.lock();){
            FilterHolder existingFilter = WebSocketUpgradeFilter.getFilter(servletContext);
            if (existingFilter != null) {
                FilterHolder filterHolder = existingFilter;
                return filterHolder;
            }
            final ContextHandler contextHandler = Objects.requireNonNull(ServletContextHandler.getServletContextHandler(servletContext));
            final ServletHandler servletHandler = contextHandler.getDescendant(ServletHandler.class);
            String pathSpec = "/*";
            final FilterHolder holder = new FilterHolder(new WebSocketUpgradeFilter());
            holder.setName(WebSocketUpgradeFilter.class.getName());
            holder.setAsyncSupported(true);
            final FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec("/*");
            mapping.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            servletHandler.prependFilter(holder);
            servletHandler.prependFilterMapping(mapping);
            contextHandler.addEventListener(new LifeCycle.Listener(){

                @Override
                public void lifeCycleStopping(LifeCycle event) {
                    servletHandler.removeFilterHolder(holder);
                    servletHandler.removeFilterMapping(mapping);
                    contextHandler.removeEventListener(this);
                }

                public String toString() {
                    return String.format("%sCleanupListener", WebSocketUpgradeFilter.class.getSimpleName());
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding {} mapped to {} in {}", holder, "/*", servletContext);
            }
            FilterHolder filterHolder = holder;
            return filterHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(request);
        ServletContextResponse servletContextResponse = servletContextRequest.getServletContextResponse();
        if (this.mappings.getHandshaker().isWebSocketUpgradeRequest(servletContextRequest)) {
            FutureCallback callback = new FutureCallback();
            try {
                servletContextRequest.setAttribute("org.eclipse.jetty.websocket.wrappedRequest", request);
                servletContextRequest.setAttribute("org.eclipse.jetty.websocket.wrappedResponse", response);
                if (this.mappings.upgrade(servletContextRequest, servletContextResponse, callback, this.defaultCustomizer)) {
                    callback.block();
                    return;
                }
            }
            finally {
                servletContextRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedRequest");
                servletContextRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedResponse");
            }
        }
        if (response.isCommitted()) {
            return;
        }
        chain.doFilter(request, response);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.defaultCustomizer, this.mappings);
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        String autoFragment;
        ServletContext servletContext = config.getServletContext();
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler(servletContext);
        this.mappings = WebSocketMappings.ensureMappings(contextHandler);
        String max = config.getInitParameter("idleTimeout");
        if (max == null && (max = config.getInitParameter("maxIdleTime")) != null) {
            LOG.warn("'maxIdleTime' init param is deprecated, use 'idleTimeout' instead");
        }
        if (max != null) {
            this.defaultCustomizer.setIdleTimeout(Duration.ofMillis(Long.parseLong(max)));
        }
        if ((max = config.getInitParameter("maxTextMessageSize")) != null) {
            this.defaultCustomizer.setMaxTextMessageSize(Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("maxBinaryMessageSize")) != null) {
            this.defaultCustomizer.setMaxBinaryMessageSize(Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("inputBufferSize")) != null) {
            this.defaultCustomizer.setInputBufferSize(Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("outputBufferSize")) != null) {
            this.defaultCustomizer.setOutputBufferSize(Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("maxFrameSize")) == null) {
            max = config.getInitParameter("maxAllowedFrameSize");
        }
        if (max != null) {
            this.defaultCustomizer.setMaxFrameSize(Long.parseLong(max));
        }
        if ((autoFragment = config.getInitParameter("autoFragment")) != null) {
            this.defaultCustomizer.setAutoFragment(Boolean.parseBoolean(autoFragment));
        }
    }

    @Override
    public void destroy() {
    }
}

