/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.Blake3;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceIdentifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceIdentifier.class);
    private static final int BUFFER_COUNT = 1024;
    private static final int BLOCKS_COUNT = 5;
    private static final int BLOCKS_DIVIDER = 4;
    private static final int BUFFER_SIZE = 4096;
    private static final int PROCESS_BYTES = 0x1400000;
    private static final String LOG_RUID_CREATE = "Creating ruid ({}) for \"{}\"";
    private static final String LOG_RUID_RESULTS = "RUID for \"{}\": {}";
    private static final String LOG_RUID_ERROR = "Error creating ruid ({}) for \"{}\"";

    private ResourceIdentifier() {
    }

    public static String getResourceIdentifier(String uri) {
        if (StringUtils.isBlank(uri)) {
            return null;
        }
        File file = ResourceIdentifier.getFile(uri);
        if (file != null && file.exists() && file.isFile()) {
            long fileSize = file.length();
            if (fileSize > 0x1400000L) {
                return ResourceIdentifier.getBigFileIdentifier(file, fileSize);
            }
            return ResourceIdentifier.getSmallFileIdentifier(file, fileSize);
        }
        return ResourceIdentifier.getTextIdentifier(uri);
    }

    private static File getFile(String uri) {
        try {
            return new File(URI.create(uri));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Path.of(uri, new String[0]).toFile();
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
        }
    }

    private static String getBigFileIdentifier(File file, long fileSize) {
        String string;
        block9: {
            String pathname = file.getAbsolutePath();
            LOGGER.debug(LOG_RUID_CREATE, (Object)"big file", (Object)pathname);
            Blake3 blake3 = Blake3.initHash();
            InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                int read;
                blake3.update(ByteBuffer.wrap(new byte[8]).putLong(fileSize).array());
                long skipper = (fileSize - 0x1400000L) / 4L;
                int count = 0;
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) != -1) {
                    blake3.update(buffer, 0, read);
                    if (++count != 1024) continue;
                    count = 0;
                    is.skip(skipper);
                }
                byte[] hash = new byte[32];
                blake3.doFinalize(hash);
                String ruid = Hex.encodeHexString(hash);
                LOGGER.trace(LOG_RUID_RESULTS, (Object)pathname, (Object)ruid);
                string = ruid;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.error(LOG_RUID_ERROR, (Object)"big file", (Object)pathname);
                    LOGGER.trace("", ex);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private static String getSmallFileIdentifier(File file, long fileSize) {
        String string;
        block9: {
            String pathname = file.getAbsolutePath();
            LOGGER.debug(LOG_RUID_CREATE, (Object)"small file", (Object)pathname);
            Blake3 blake3 = Blake3.initHash();
            InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                int read;
                blake3.update(ByteBuffer.wrap(new byte[8]).putLong(fileSize).array());
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) != -1) {
                    blake3.update(buffer, 0, read);
                }
                byte[] hash = new byte[32];
                blake3.doFinalize(hash);
                String ruid = Hex.encodeHexString(hash);
                LOGGER.trace(LOG_RUID_RESULTS, (Object)pathname, (Object)ruid);
                string = ruid;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.error(LOG_RUID_ERROR, (Object)"small file", (Object)pathname);
                    LOGGER.trace("", ex);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private static String getTextIdentifier(String text) {
        String string;
        LOGGER.debug(LOG_RUID_CREATE, (Object)"text", (Object)text);
        Blake3 blake3 = Blake3.initHash();
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            int read;
            blake3.update(ByteBuffer.wrap(new byte[8]).putLong(bytes.length).array());
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) != -1) {
                blake3.update(buffer, 0, read);
            }
            byte[] hash = new byte[32];
            blake3.doFinalize(hash);
            String ruid = Hex.encodeHexString(hash);
            LOGGER.trace(LOG_RUID_RESULTS, (Object)text, (Object)ruid);
            string = ruid;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.error(LOG_RUID_ERROR, (Object)"text", (Object)text);
                LOGGER.trace("", ex);
                return null;
            }
        }
        ((InputStream)is).close();
        return string;
    }
}

