/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResettableInputStream
extends BufferedInputStream {
    protected int overriddenMarkpos = 0;

    public ResettableInputStream(InputStream in, int marklimit) {
        super(in);
        this.marklimit = marklimit;
        this.markpos = 0;
    }

    public ResettableInputStream(InputStream in, int size, int marklimit) {
        super(in, size);
        this.marklimit = marklimit;
        this.markpos = 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.overriddenMarkpos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        if (this.overriddenMarkpos < 0) {
            this.overriddenMarkpos = 0;
        }
        this.pos = this.overriddenMarkpos;
    }

    public synchronized boolean isFullResetAvailable() {
        return this.markpos == 0;
    }

    public synchronized void fullReset() throws IOException {
        super.reset();
        this.pos = 0;
    }
}

