/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import jakarta.annotation.Nullable;
import java.util.Locale;
import net.pms.Messages;
import org.apache.commons.lang3.StringUtils;

public enum ProgramExecutableType {
    BUNDLED,
    INSTALLED,
    CUSTOM;


    public String toString() {
        switch (this) {
            case BUNDLED: {
                return Messages.getString("ProgramExecutableType.Bundled");
            }
            case CUSTOM: {
                return Messages.getString("ProgramExecutableType.Custom");
            }
            case INSTALLED: {
                return Messages.getString("ProgramExecutableType.Installed");
            }
        }
        throw new IllegalStateException("ProgramExecutableType " + super.toString() + "isn't implemented");
    }

    public String toRootString() {
        switch (this) {
            case BUNDLED: {
                return Messages.getRootString("ProgramExecutableType.Bundled");
            }
            case CUSTOM: {
                return Messages.getRootString("ProgramExecutableType.Custom");
            }
            case INSTALLED: {
                return Messages.getRootString("ProgramExecutableType.Installed");
            }
        }
        throw new IllegalStateException("ProgramExecutableType " + super.toString() + "isn't implemented");
    }

    @Nullable
    public static ProgramExecutableType toProgramExecutableType(@Nullable String executableType, @Nullable ProgramExecutableType defaultExecutableType) {
        ProgramExecutableType result = ProgramExecutableType.toProgramExecutableType(executableType);
        return result != null ? result : defaultExecutableType;
    }

    @Nullable
    public static ProgramExecutableType toProgramExecutableType(@Nullable String executableType) {
        if (StringUtils.isBlank(executableType)) {
            return null;
        }
        return switch (executableType.toLowerCase(Locale.ROOT)) {
            case "bundled" -> BUNDLED;
            case "installed" -> INSTALLED;
            case "custom" -> CUSTOM;
            default -> null;
        };
    }

    public static enum DefaultExecutableType {
        CUSTOM,
        ORIGINAL,
        NONE;

    }
}

