/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.io.OutputStream;
import net.pms.util.FlowParserOutputStream;

public class PCMAudioOutputStream
extends FlowParserOutputStream {
    protected int nbchannels;
    protected int sampleFrequency;
    protected int bitsperSample;
    protected int blocksize;
    protected byte[] payload;
    protected boolean wavMode;
    protected boolean headerSent;

    public PCMAudioOutputStream(OutputStream source, int nbchannels, int sampleFrequency, int bitsperSample) {
        super(source, 600000);
        this.nbchannels = nbchannels;
        this.sampleFrequency = sampleFrequency;
        this.bitsperSample = bitsperSample;
        this.swapOrderBits = 2;
        this.init();
    }

    protected void init() {
        if (!this.wavMode) {
            this.blocksize = 2 * ((this.nbchannels + 1) / 2) * this.sampleFrequency * this.bitsperSample / 1600;
            this.payload = new byte[4];
            switch (this.nbchannels) {
                case 1: {
                    this.payload[2] = 17;
                    break;
                }
                case 2: {
                    this.payload[2] = 49;
                    break;
                }
                case 3: {
                    this.payload[2] = 65;
                    break;
                }
                case 4: {
                    this.payload[2] = 113;
                    break;
                }
                case 5: {
                    this.payload[2] = -127;
                    break;
                }
                case 6: {
                    this.payload[2] = -111;
                    break;
                }
                case 7: {
                    this.payload[2] = -95;
                    break;
                }
                case 8: {
                    this.payload[2] = -79;
                    break;
                }
            }
            this.payload[0] = (byte)(this.blocksize >> 8 & 0xFF);
            this.payload[1] = (byte)((this.blocksize + 256) % 256);
            if (this.sampleFrequency == 96000) {
                this.payload[2] = (byte)(this.payload[2] + 3);
            }
            if (this.sampleFrequency == 192000) {
                this.payload[2] = (byte)(this.payload[2] + 4);
            }
            this.payload[3] = (byte)(16 * (this.bitsperSample - 12));
        } else {
            int bytePerBloc = this.nbchannels * this.bitsperSample / 8;
            int bytePerSec = this.sampleFrequency * bytePerBloc;
            this.payload = new byte[44];
            this.payload[0] = 82;
            this.payload[1] = 73;
            this.payload[2] = 70;
            this.payload[3] = 70;
            this.payload[8] = 87;
            this.payload[9] = 65;
            this.payload[10] = 86;
            this.payload[11] = 69;
            this.payload[12] = 102;
            this.payload[13] = 109;
            this.payload[14] = 116;
            this.payload[15] = 32;
            this.payload[16] = 16;
            this.payload[20] = 1;
            this.payload[22] = (byte)this.nbchannels;
            this.payload[25] = (byte)(this.sampleFrequency & 0xFF);
            this.payload[24] = (byte)(this.sampleFrequency >> 8 & 0xFF);
            this.payload[30] = (byte)(bytePerSec & 0xFF);
            this.payload[29] = (byte)(bytePerSec >> 8 & 0xFF);
            this.payload[32] = (byte)(bytePerBloc & 0xFF);
            this.payload[34] = (byte)(this.bitsperSample & 0xFF);
            this.payload[36] = 100;
            this.payload[37] = 97;
            this.payload[38] = 116;
            this.payload[39] = 97;
            this.payload[40] = -1;
            this.payload[41] = -1;
            this.payload[42] = -1;
            this.payload[43] = -1;
        }
    }

    @Override
    protected void afterChunkSend() throws IOException {
    }

    @Override
    protected void analyzeBuffer(byte[] data, int off, int len) {
        this.streamableByteNumber = this.blocksize;
    }

    @Override
    protected void beforeChunkSend() throws IOException {
        if (!this.wavMode) {
            this.writePayload(this.payload);
        } else if (!this.headerSent) {
            this.writePayload(this.payload);
            this.headerSent = true;
        }
    }
}

