/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public final class Iso639 {
    private static final String LOCAL_ALIAS = "loc";
    private static final Map<String, Iso639Entry> LINKS = new HashMap<String, Iso639Entry>();
    private static final List<String> CODES;
    private static final Map<String, String> COMMON_MISSPELLINGS;
    private static final String LANGUAGE_REGEX = "(\\w{2,3})\\s\\(\\w{2,3}\\)";
    private static final Pattern LANGUAGE_REGEX_PATTERN;

    private Iso639() {
    }

    public static boolean codeIsValid(String code) {
        return StringUtils.isNotBlank(code) && CODES.contains(code.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isValid(String code) {
        if (StringUtils.isBlank(code)) {
            return false;
        }
        return CODES.contains(code = code.trim().toLowerCase(Locale.ROOT)) || LINKS.containsKey(code);
    }

    public static Iso639Entry get(String code) {
        return Iso639.get(code, false);
    }

    public static Iso639Entry get(String code, boolean containsName) {
        Iso639Entry result;
        if (StringUtils.isBlank(code)) {
            return null;
        }
        Matcher matcher = LANGUAGE_REGEX_PATTERN.matcher(code = code.trim());
        code = matcher.find() ? matcher.group(1) : code.toLowerCase(Locale.ROOT);
        if (LOCAL_ALIAS.equals(code) && StringUtils.isBlank(code = Iso639.normalize(code))) {
            code = "eng";
        }
        for (Iso639Entry entry : LINKS.values()) {
            if (!entry.matches(code)) continue;
            return entry;
        }
        String tmpCode = COMMON_MISSPELLINGS.get(code);
        if (tmpCode != null) {
            code = tmpCode;
        }
        if ((result = LINKS.get(code)) != null) {
            return result;
        }
        if (containsName && code.length() > 2) {
            for (Map.Entry<String, String> entry : COMMON_MISSPELLINGS.entrySet()) {
                if (!code.contains(entry.getKey())) continue;
                code = code.replace(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : LINKS.entrySet()) {
                if (!code.contains(entry.getKey())) continue;
                return (Iso639Entry)entry.getValue();
            }
        }
        return null;
    }

    public static String getFirstName(String code) {
        return Iso639.getFirstName(code, false);
    }

    public static String getFirstName(String code, boolean containsName) {
        Iso639Entry entry = Iso639.get(code, containsName);
        return entry == null ? null : entry.getFirstName();
    }

    public static String[] getNames(String code) {
        return Iso639.getNames(code, false);
    }

    public static String[] getNames(String code, boolean containsName) {
        Iso639Entry entry = Iso639.get(code, containsName);
        return entry == null ? null : entry.getNames();
    }

    public static String getISOCode(String code) {
        return Iso639.getISOCode(code, false);
    }

    public static String getISOCode(String code, boolean containsName) {
        Iso639Entry entry = Iso639.get(code, containsName);
        return entry == null ? null : (StringUtils.isNotBlank(entry.iso639_1) ? entry.iso639_1 : entry.iso639_2);
    }

    public static String getISO639_2Code(String code) {
        return Iso639.getISO639_2Code(code, false);
    }

    public static String getISO639_2Code(String code, boolean containsName) {
        Iso639Entry entry = Iso639.get(code, containsName);
        return entry == null ? null : entry.iso639_2;
    }

    private static String normalize(String isoCode) {
        if (LOCAL_ALIAS.equals(isoCode)) {
            String tag = PMS.getLocale().toLanguageTag();
            int idx = tag.indexOf(45);
            return idx > 0 ? tag.substring(0, idx) : tag;
        }
        return isoCode;
    }

    public static boolean isCodeMatching(String language, String code) {
        if (StringUtils.isBlank(language) || StringUtils.isBlank(code)) {
            return false;
        }
        code = Iso639.normalize(code.trim().toLowerCase(Locale.ROOT));
        Iso639Entry entry = LINKS.get(language.trim().toLowerCase(Locale.ROOT));
        if (entry == null) {
            return false;
        }
        return entry.matches(code);
    }

    public static boolean isCodesMatching(String code1, String code2) {
        if (StringUtils.isBlank(code1) || StringUtils.isBlank(code2)) {
            return false;
        }
        code1 = Iso639.normalize(code1.trim().toLowerCase(Locale.ROOT));
        code2 = Iso639.normalize(code2.trim().toLowerCase(Locale.ROOT));
        for (Iso639Entry entry : LINKS.values()) {
            if (!entry.matches(code1) || !entry.matches(code2)) continue;
            return true;
        }
        return false;
    }

    private static void registerLanguage(String name, String iso639_1, String iso639_2) {
        Iso639.registerLanguage(name, iso639_1, iso639_2, null);
    }

    private static void registerLanguage(String name, String iso639_1, String iso639_2, String altIso639_2) {
        String[] names = name.split("\\s*;\\s*");
        if (names.length == 0) {
            throw new IllegalArgumentException("name cannot be blank");
        }
        String[] keys = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            keys[i] = names[i].replaceAll("\\s*\\([^\\)]*\\)\\s*", "").toLowerCase(Locale.ROOT);
        }
        Iso639Entry entry = new Iso639Entry(names, iso639_1, iso639_2, altIso639_2);
        for (String key : keys) {
            LINKS.put(key, entry);
        }
    }

    private static ArrayList<String> initCodes() {
        ArrayList<String> result = new ArrayList<String>();
        for (Iso639Entry entry : LINKS.values()) {
            if (StringUtils.isNotBlank(entry.iso639_1)) {
                result.add(entry.iso639_1);
            }
            result.add(entry.iso639_2);
            if (!StringUtils.isNotBlank(entry.altIso639_2)) continue;
            result.add(entry.altIso639_2);
        }
        return result;
    }

    private static void initLinks() {
        Iso639.registerLanguage("Abkhazian", "ab", "abk");
        Iso639.registerLanguage("Achinese", null, "ace");
        Iso639.registerLanguage("Acoli", null, "ach");
        Iso639.registerLanguage("Adangme", null, "ada");
        Iso639.registerLanguage("Adyghe;Adygei", null, "ady");
        Iso639.registerLanguage("Afar", "aa", "aar");
        Iso639.registerLanguage("Afrihili", null, "afh");
        Iso639.registerLanguage("Afrikaans", "af", "afr");
        Iso639.registerLanguage("Afro-Asiatic languages", null, "afa");
        Iso639.registerLanguage("Ainu;Ainu (Japan)", null, "ain");
        Iso639.registerLanguage("Akan", "ak", "aka");
        Iso639.registerLanguage("Akkadian", null, "akk");
        Iso639.registerLanguage("Albanian", "sq", "alb", "sqi");
        Iso639.registerLanguage("Alemannic;Alsatian;Swiss German", null, "gsw");
        Iso639.registerLanguage("Aleut", null, "ale");
        Iso639.registerLanguage("Algonquian;Algonquian languages", null, "alg");
        Iso639.registerLanguage("Altaic;Altaic languages", null, "tut");
        Iso639.registerLanguage("Amharic", "am", "amh");
        Iso639.registerLanguage("Ancient Greek (to 1453)", null, "grc");
        Iso639.registerLanguage("Angika", null, "anp");
        Iso639.registerLanguage("Apache;Apache languages", null, "apa");
        Iso639.registerLanguage("Arabic", "ar", "ara");
        Iso639.registerLanguage("Aragonese", "an", "arg");
        Iso639.registerLanguage("Arapaho", null, "arp");
        Iso639.registerLanguage("Arawak", null, "arw");
        Iso639.registerLanguage("Armenian", "hy", "arm", "hye");
        Iso639.registerLanguage("Aromanian;Arumanian;Macedo-Romanian", null, "rup");
        Iso639.registerLanguage("Artificial languages", null, "art");
        Iso639.registerLanguage("Assamese", "as", "asm");
        Iso639.registerLanguage("Asturian;Asturleonese;Bable;Leonese", null, "ast");
        Iso639.registerLanguage("Athapascan;Athapascan languages", null, "ath");
        Iso639.registerLanguage("Australian;Australian languages", null, "aus");
        Iso639.registerLanguage("Austronesian;Austronesian languages", null, "map");
        Iso639.registerLanguage("Avaric", "av", "ava");
        Iso639.registerLanguage("Avestan", "ae", "ave");
        Iso639.registerLanguage("Awadhi", null, "awa");
        Iso639.registerLanguage("Aymara", "ay", "aym");
        Iso639.registerLanguage("Azerbaijani", "az", "aze");
        Iso639.registerLanguage("Balinese", null, "ban");
        Iso639.registerLanguage("Baltic;Baltic languages", null, "bat");
        Iso639.registerLanguage("Baluchi", null, "bal");
        Iso639.registerLanguage("Bambara", "bm", "bam");
        Iso639.registerLanguage("Bamileke;Bamileke languages", null, "bai");
        Iso639.registerLanguage("Banda;Banda languages", null, "bad");
        Iso639.registerLanguage("Bantu;Bantu languages", null, "bnt");
        Iso639.registerLanguage("Basa (Cameroon)", null, "bas");
        Iso639.registerLanguage("Bashkir", "ba", "bak");
        Iso639.registerLanguage("Basque", "eu", "baq", "eus");
        Iso639.registerLanguage("Batak;Batak languages", null, "btk");
        Iso639.registerLanguage("Bedawiyet;Beja", null, "bej");
        Iso639.registerLanguage("Belarusian", "be", "bel");
        Iso639.registerLanguage("Bemba (Zambia)", null, "bem");
        Iso639.registerLanguage("Bengali", "bn", "ben");
        Iso639.registerLanguage("Berber;Berber languages", null, "ber");
        Iso639.registerLanguage("Bhojpuri", null, "bho");
        Iso639.registerLanguage("Bihari;Bihari languages", "bh", "bih");
        Iso639.registerLanguage("Bikol", null, "bik");
        Iso639.registerLanguage("Bilin;Blin", null, "byn");
        Iso639.registerLanguage("Bini;Edo", null, "bin");
        Iso639.registerLanguage("Bislama", "bi", "bis");
        Iso639.registerLanguage("Bliss;Blissymbolics;Blissymbols", null, "zbl");
        Iso639.registerLanguage("Bosnian", "bs", "bos");
        Iso639.registerLanguage("Braj", null, "bra");
        Iso639.registerLanguage("Breton", "br", "bre");
        Iso639.registerLanguage("Buginese", null, "bug");
        Iso639.registerLanguage("Bulgarian", "bg", "bul");
        Iso639.registerLanguage("Buriat", null, "bua");
        Iso639.registerLanguage("Burmese", "my", "bur", "mya");
        Iso639.registerLanguage("Caddo", null, "cad");
        Iso639.registerLanguage("Castilian;Spanish", "es", "spa");
        Iso639.registerLanguage("Catalan;Valencian", "ca", "cat");
        Iso639.registerLanguage("Caucasian;Caucasian languages", null, "cau");
        Iso639.registerLanguage("Cebuano", null, "ceb");
        Iso639.registerLanguage("Celtic;Celtic languages", null, "cel");
        Iso639.registerLanguage("Central American Indian languages", null, "cai");
        Iso639.registerLanguage("Central Khmer;Khmer", "km", "khm");
        Iso639.registerLanguage("Chagatai", null, "chg");
        Iso639.registerLanguage("Chamic;Chamic languages", null, "cmc");
        Iso639.registerLanguage("Chamorro", "ch", "cha");
        Iso639.registerLanguage("Chechen", "ce", "che");
        Iso639.registerLanguage("Cherokee", null, "chr");
        Iso639.registerLanguage("Chewa;Chichewa;Nyanja", "ny", "nya");
        Iso639.registerLanguage("Cheyenne", null, "chy");
        Iso639.registerLanguage("Chibcha", null, "chb");
        Iso639.registerLanguage("Chinese", "zh", "chi", "zho");
        Iso639.registerLanguage("Chinook jargon", null, "chn");
        Iso639.registerLanguage("Chipewyan;Dene Suline", null, "chp");
        Iso639.registerLanguage("Choctaw", null, "cho");
        Iso639.registerLanguage("Chuang;Zhuang", "za", "zha");
        Iso639.registerLanguage("Church Slavic;Church Slavonic;Old Bulgarian;Old Church Slavonic;Old Slavonic", "cu", "chu");
        Iso639.registerLanguage("Chuukese", null, "chk");
        Iso639.registerLanguage("Chuvash", "cv", "chv");
        Iso639.registerLanguage("Classical Nepal Bhasa;Classical Newari;Old Newari", null, "nwc");
        Iso639.registerLanguage("Classical Syriac", null, "syc");
        Iso639.registerLanguage("Cook Islands Maori;Rarotongan", null, "rar");
        Iso639.registerLanguage("Coptic", null, "cop");
        Iso639.registerLanguage("Cornish", "kw", "cor");
        Iso639.registerLanguage("Corsican", "co", "cos");
        Iso639.registerLanguage("Cree", "cr", "cre");
        Iso639.registerLanguage("Creek", null, "mus");
        Iso639.registerLanguage("Creoles and pidgins", null, "crp");
        Iso639.registerLanguage("Creoles and pidgins, English based", null, "cpe");
        Iso639.registerLanguage("Creoles and pidgins, French-based", null, "cpf");
        Iso639.registerLanguage("Creoles and pidgins, Portuguese-based", null, "cpp");
        Iso639.registerLanguage("Crimean Tatar;Crimean Turkish", null, "crh");
        Iso639.registerLanguage("Croatian", "hr", "hrv");
        Iso639.registerLanguage("Cushitic;Cushitic languages", null, "cus");
        Iso639.registerLanguage("Czech", "cs", "cze", "ces");
        Iso639.registerLanguage("Dakota", null, "dak");
        Iso639.registerLanguage("Danish", "da", "dan");
        Iso639.registerLanguage("Dargwa", null, "dar");
        Iso639.registerLanguage("Delaware", null, "del");
        Iso639.registerLanguage("Dhivehi;Divehi;Maldivian", "dv", "div");
        Iso639.registerLanguage("Dholuo;Luo (Kenya and Tanzania)", null, "luo");
        Iso639.registerLanguage("Dimili;Dimli (macrolanguage);Kirdki;Kirmanjki (macrolanguage);Zaza;Zazaki", null, "zza");
        Iso639.registerLanguage("Dinka", null, "din");
        Iso639.registerLanguage("Dogri (macrolanguage)", null, "doi");
        Iso639.registerLanguage("Dogrib", null, "dgr");
        Iso639.registerLanguage("Dravidian;Dravidian languages", null, "dra");
        Iso639.registerLanguage("Duala", null, "dua");
        Iso639.registerLanguage("Dutch;Flemish", "nl", "dut", "nld");
        Iso639.registerLanguage("Dyula", null, "dyu");
        Iso639.registerLanguage("Dzongkha", "dz", "dzo");
        Iso639.registerLanguage("Eastern Frisian", null, "frs");
        Iso639.registerLanguage("Efik", null, "efi");
        Iso639.registerLanguage("Egyptian (Ancient)", null, "egy");
        Iso639.registerLanguage("Ekajuk", null, "eka");
        Iso639.registerLanguage("Elamite", null, "elx");
        Iso639.registerLanguage("English", "en", "eng");
        Iso639.registerLanguage("Erzya", null, "myv");
        Iso639.registerLanguage("Esperanto", "eo", "epo");
        Iso639.registerLanguage("Estonian", "et", "est");
        Iso639.registerLanguage("Ewe", "ee", "ewe");
        Iso639.registerLanguage("Ewondo", null, "ewo");
        Iso639.registerLanguage("Fang (Equatorial Guinea)", null, "fan");
        Iso639.registerLanguage("Fanti", null, "fat");
        Iso639.registerLanguage("Faroese", "fo", "fao");
        Iso639.registerLanguage("Fijian", "fj", "fij");
        Iso639.registerLanguage("Filipino;Pilipino", null, "fil");
        Iso639.registerLanguage("Finnish", "fi", "fin");
        Iso639.registerLanguage("Finno-Ugrian languages", null, "fiu");
        Iso639.registerLanguage("Fon", null, "fon");
        Iso639.registerLanguage("French", "fr", "fre", "fra");
        Iso639.registerLanguage("Friulian", null, "fur");
        Iso639.registerLanguage("Fulah", "ff", "ful");
        Iso639.registerLanguage("Ga", null, "gaa");
        Iso639.registerLanguage("Gaelic;Scottish Gaelic", "gd", "gla");
        Iso639.registerLanguage("Galibi Carib", null, "car");
        Iso639.registerLanguage("Galician", "gl", "glg");
        Iso639.registerLanguage("Ganda", "lg", "lug");
        Iso639.registerLanguage("Gayo", null, "gay");
        Iso639.registerLanguage("Gbaya (Central African Republic)", null, "gba");
        Iso639.registerLanguage("Geez", null, "gez");
        Iso639.registerLanguage("Georgian", "ka", "geo", "kat");
        Iso639.registerLanguage("German", "de", "ger", "deu");
        Iso639.registerLanguage("Germanic;Germanic languages", null, "gem");
        Iso639.registerLanguage("Gikuyu;Kikuyu", "ki", "kik");
        Iso639.registerLanguage("Gilbertese", null, "gil");
        Iso639.registerLanguage("Gondi", null, "gon");
        Iso639.registerLanguage("Gorontalo", null, "gor");
        Iso639.registerLanguage("Gothic", null, "got");
        Iso639.registerLanguage("Grebo", null, "grb");
        Iso639.registerLanguage("Greek;Modern Greek (1453-)", "el", "gre", "ell");
        Iso639.registerLanguage("Greenlandic;Kalaallisut", "kl", "kal");
        Iso639.registerLanguage("Guarani", "gn", "grn");
        Iso639.registerLanguage("Gujarati", "gu", "guj");
        Iso639.registerLanguage("Gwich\u02bcin", null, "gwi");
        Iso639.registerLanguage("Haida", null, "hai");
        Iso639.registerLanguage("Haitian;Haitian Creole", "ht", "hat");
        Iso639.registerLanguage("Hausa", "ha", "hau");
        Iso639.registerLanguage("Hawaiian", null, "haw");
        Iso639.registerLanguage("Hebrew", "he", "heb");
        Iso639.registerLanguage("Herero", "hz", "her");
        Iso639.registerLanguage("Hiligaynon", null, "hil");
        Iso639.registerLanguage("Himachali languages;Western Pahari languages", null, "him");
        Iso639.registerLanguage("Hindi", "hi", "hin");
        Iso639.registerLanguage("Hiri Motu", "ho", "hmo");
        Iso639.registerLanguage("Hittite", null, "hit");
        Iso639.registerLanguage("Hmong;Mong", null, "hmn");
        Iso639.registerLanguage("Hungarian", "hu", "hun");
        Iso639.registerLanguage("Hupa", null, "hup");
        Iso639.registerLanguage("Iban", null, "iba");
        Iso639.registerLanguage("Icelandic", "is", "ice", "isl");
        Iso639.registerLanguage("Ido", "io", "ido");
        Iso639.registerLanguage("Igbo", "ig", "ibo");
        Iso639.registerLanguage("Ijo;Ijo languages", null, "ijo");
        Iso639.registerLanguage("Iloko", null, "ilo");
        Iso639.registerLanguage("Imperial Aramaic (700-300 BCE);Official Aramaic (700-300 BCE)", null, "arc");
        Iso639.registerLanguage("Inari Sami", null, "smn");
        Iso639.registerLanguage("Indic;Indic languages", null, "inc");
        Iso639.registerLanguage("Indo-European languages", null, "ine");
        Iso639.registerLanguage("Indonesian", "id", "ind");
        Iso639.registerLanguage("Ingush", null, "inh");
        Iso639.registerLanguage("Interlingua (International Auxiliary Language Association)", "ia", "ina");
        Iso639.registerLanguage("Interlingue;Occidental", "ie", "ile");
        Iso639.registerLanguage("Inuktitut", "iu", "iku");
        Iso639.registerLanguage("Inupiaq", "ik", "ipk");
        Iso639.registerLanguage("Iranian;Iranian languages", null, "ira");
        Iso639.registerLanguage("Irish", "ga", "gle");
        Iso639.registerLanguage("Iroquoian;Iroquoian languages", null, "iro");
        Iso639.registerLanguage("Italian", "it", "ita");
        Iso639.registerLanguage("Japanese", "ja", "jpn");
        Iso639.registerLanguage("Javanese", "jv", "jav");
        Iso639.registerLanguage("Jingpho;Kachin", null, "kac");
        Iso639.registerLanguage("Judeo-Arabic", null, "jrb");
        Iso639.registerLanguage("Judeo-Persian", null, "jpr");
        Iso639.registerLanguage("Kabardian", null, "kbd");
        Iso639.registerLanguage("Kabyle", null, "kab");
        Iso639.registerLanguage("Kalmyk;Oirat", null, "xal");
        Iso639.registerLanguage("Kamba (Kenya)", null, "kam");
        Iso639.registerLanguage("Kannada", "kn", "kan");
        Iso639.registerLanguage("Kanuri", "kr", "kau");
        Iso639.registerLanguage("Kapampangan;Pampanga", null, "pam");
        Iso639.registerLanguage("Karachay-Balkar", null, "krc");
        Iso639.registerLanguage("Kara-Kalpak", null, "kaa");
        Iso639.registerLanguage("Karelian", null, "krl");
        Iso639.registerLanguage("Karen;Karen languages", null, "kar");
        Iso639.registerLanguage("Kashmiri", "ks", "kas");
        Iso639.registerLanguage("Kashubian", null, "csb");
        Iso639.registerLanguage("Kawi", null, "kaw");
        Iso639.registerLanguage("Kazakh", "kk", "kaz");
        Iso639.registerLanguage("Khasi", null, "kha");
        Iso639.registerLanguage("Khoisan;Khoisan languages", null, "khi");
        Iso639.registerLanguage("Khotanese;Sakan", null, "kho");
        Iso639.registerLanguage("Kimbundu", null, "kmb");
        Iso639.registerLanguage("Kinyarwanda", "rw", "kin");
        Iso639.registerLanguage("Kirghiz;Kyrgyz", "ky", "kir");
        Iso639.registerLanguage("Klingon;tlhIngan Hol", null, "tlh");
        Iso639.registerLanguage("Komi", "kv", "kom");
        Iso639.registerLanguage("Kongo", "kg", "kon");
        Iso639.registerLanguage("Konkani (macrolanguage)", null, "kok");
        Iso639.registerLanguage("Korean", "ko", "kor");
        Iso639.registerLanguage("Kosraean", null, "kos");
        Iso639.registerLanguage("Kpelle", null, "kpe");
        Iso639.registerLanguage("Kru;Kru languages", null, "kro");
        Iso639.registerLanguage("Kuanyama;Kwanyama", "kj", "kua");
        Iso639.registerLanguage("Kumyk", null, "kum");
        Iso639.registerLanguage("Kurdish", "ku", "kur");
        Iso639.registerLanguage("Kurukh", null, "kru");
        Iso639.registerLanguage("Kutenai", null, "kut");
        Iso639.registerLanguage("Ladino", null, "lad");
        Iso639.registerLanguage("Lahnda", null, "lah");
        Iso639.registerLanguage("Lamba", null, "lam");
        Iso639.registerLanguage("Land Dayak languages", null, "day");
        Iso639.registerLanguage("Lao", "lo", "lao");
        Iso639.registerLanguage("Latin", "la", "lat");
        Iso639.registerLanguage("Latvian", "lv", "lav");
        Iso639.registerLanguage("Letzeburgesch;Luxembourgish", "lb", "ltz");
        Iso639.registerLanguage("Lezghian", null, "lez");
        Iso639.registerLanguage("Limburgan;Limburger;Limburgish", "li", "lim");
        Iso639.registerLanguage("Lingala", "ln", "lin");
        Iso639.registerLanguage("Lithuanian", "lt", "lit");
        Iso639.registerLanguage("Lojban", null, "jbo");
        Iso639.registerLanguage("Low German;Low Saxon", null, "nds");
        Iso639.registerLanguage("Lower Sorbian", null, "dsb");
        Iso639.registerLanguage("Lozi", null, "loz");
        Iso639.registerLanguage("Luba-Katanga", "lu", "lub");
        Iso639.registerLanguage("Luba-Lulua", null, "lua");
        Iso639.registerLanguage("Luiseno", null, "lui");
        Iso639.registerLanguage("Lule Sami", null, "smj");
        Iso639.registerLanguage("Lunda", null, "lun");
        Iso639.registerLanguage("Lushai", null, "lus");
        Iso639.registerLanguage("Macedonian", "mk", "mac", "mkd");
        Iso639.registerLanguage("Madurese", null, "mad");
        Iso639.registerLanguage("Magahi", null, "mag");
        Iso639.registerLanguage("Maithili", null, "mai");
        Iso639.registerLanguage("Makasar", null, "mak");
        Iso639.registerLanguage("Malagasy", "mg", "mlg");
        Iso639.registerLanguage("Malay (macrolanguage)", "ms", "may", "msa");
        Iso639.registerLanguage("Malayalam", "ml", "mal");
        Iso639.registerLanguage("Maltese", "mt", "mlt");
        Iso639.registerLanguage("Manchu", null, "mnc");
        Iso639.registerLanguage("Mandar", null, "mdr");
        Iso639.registerLanguage("Manding;Mandingo", null, "man");
        Iso639.registerLanguage("Manipuri", null, "mni");
        Iso639.registerLanguage("Manobo;Manobo languages", null, "mno");
        Iso639.registerLanguage("Manx", "gv", "glv");
        Iso639.registerLanguage("Maori", "mi", "mao", "mri");
        Iso639.registerLanguage("Mapuche;Mapudungun", null, "arn");
        Iso639.registerLanguage("Marathi", "mr", "mar");
        Iso639.registerLanguage("Mari (Russia)", null, "chm");
        Iso639.registerLanguage("Marshallese", "mh", "mah");
        Iso639.registerLanguage("Marwari", null, "mwr");
        Iso639.registerLanguage("Masai", null, "mas");
        Iso639.registerLanguage("Mayan;Mayan languages", null, "myn");
        Iso639.registerLanguage("Mende (Sierra Leone)", null, "men");
        Iso639.registerLanguage("Micmac;Mi'kmaq", null, "mic");
        Iso639.registerLanguage("Middle Dutch (ca. 1050-1350)", null, "dum");
        Iso639.registerLanguage("Middle English (1100-1500)", null, "enm");
        Iso639.registerLanguage("Middle French (ca. 1400-1600)", null, "frm");
        Iso639.registerLanguage("Middle High German (ca. 1050-1500)", null, "gmh");
        Iso639.registerLanguage("Middle Irish (900-1200)", null, "mga");
        Iso639.registerLanguage("Minangkabau", null, "min");
        Iso639.registerLanguage("Mirandese", null, "mwl");
        Iso639.registerLanguage("Mohawk", null, "moh");
        Iso639.registerLanguage("Moksha", null, "mdf");
        Iso639.registerLanguage("Moldavian;Moldovan;Romanian", "ro", "rum", "ron");
        Iso639.registerLanguage("Mongo", null, "lol");
        Iso639.registerLanguage("Mongolian", "mn", "mon");
        Iso639.registerLanguage("Mon-Khmer languages", null, "mkh");
        Iso639.registerLanguage("Montenegrin", null, "cnr");
        Iso639.registerLanguage("Mossi", null, "mos");
        Iso639.registerLanguage("Multiple languages", null, "mul");
        Iso639.registerLanguage("Munda;Munda languages", null, "mun");
        Iso639.registerLanguage("Nahuatl;Nahuatl languages", null, "nah");
        Iso639.registerLanguage("Nauru", "na", "nau");
        Iso639.registerLanguage("Navaho;Navajo", "nv", "nav");
        Iso639.registerLanguage("Ndonga", "ng", "ndo");
        Iso639.registerLanguage("Neapolitan", null, "nap");
        Iso639.registerLanguage("Nepal Bhasa;Newari", null, "new");
        Iso639.registerLanguage("Nepali (macrolanguage)", "ne", "nep");
        Iso639.registerLanguage("Nias", null, "nia");
        Iso639.registerLanguage("Niger-Kordofanian languages", null, "nic");
        Iso639.registerLanguage("Nilo-Saharan languages", null, "ssa");
        Iso639.registerLanguage("Niuean", null, "niu");
        Iso639.registerLanguage("N'Ko", null, "nqo");
        Iso639.registerLanguage("No linguistic content;Not applicable", null, "zxx");
        Iso639.registerLanguage("Nogai", null, "nog");
        Iso639.registerLanguage("North American Indian languages", null, "nai");
        Iso639.registerLanguage("North Ndebele", "nd", "nde");
        Iso639.registerLanguage("Northern Frisian", null, "frr");
        Iso639.registerLanguage("Northern Sami", "se", "sme");
        Iso639.registerLanguage("Northern Sotho;Pedi;Sepedi", null, "nso");
        Iso639.registerLanguage("Norwegian Bokm\u00e5l", "nb", "nob");
        Iso639.registerLanguage("Norwegian Nynorsk", "nn", "nno");
        Iso639.registerLanguage("Norwegian", "no", "nor");
        Iso639.registerLanguage("Nubian;Nubian languages", null, "nub");
        Iso639.registerLanguage("Nuosu;Sichuan Yi", "ii", "iii");
        Iso639.registerLanguage("Nyamwezi", null, "nym");
        Iso639.registerLanguage("Nyankole", null, "nyn");
        Iso639.registerLanguage("Nyoro", null, "nyo");
        Iso639.registerLanguage("Nzima", null, "nzi");
        Iso639.registerLanguage("Occitan (post 1500)", "oc", "oci");
        Iso639.registerLanguage("Ojibwa", "oj", "oji");
        Iso639.registerLanguage("Old English (ca. 450-1100)", null, "ang");
        Iso639.registerLanguage("Old French (842-ca. 1400)", null, "fro");
        Iso639.registerLanguage("Old High German (ca. 750-1050)", null, "goh");
        Iso639.registerLanguage("Old Irish (to 900)", null, "sga");
        Iso639.registerLanguage("Old Norse", null, "non");
        Iso639.registerLanguage("Old Occitan (to 1500);Old Proven\u00e7al (to 1500)", null, "pro");
        Iso639.registerLanguage("Old Persian (ca. 600-400 B.C.)", null, "peo");
        Iso639.registerLanguage("Oriya (macrolanguage)", "or", "ori");
        Iso639.registerLanguage("Oromo", "om", "orm");
        Iso639.registerLanguage("Osage", null, "osa");
        Iso639.registerLanguage("Ossetian;Ossetic", "os", "oss");
        Iso639.registerLanguage("Otomian;Otomian languages", null, "oto");
        Iso639.registerLanguage("Ottoman Turkish (1500-1928)", null, "ota");
        Iso639.registerLanguage("Pahlavi", null, "pal");
        Iso639.registerLanguage("Palauan", null, "pau");
        Iso639.registerLanguage("Pali", "pi", "pli");
        Iso639.registerLanguage("Pangasinan", null, "pag");
        Iso639.registerLanguage("Panjabi;Punjabi", "pa", "pan");
        Iso639.registerLanguage("Papiamento", null, "pap");
        Iso639.registerLanguage("Papuan;Papuan languages", null, "paa");
        Iso639.registerLanguage("Pashto;Pushto", "ps", "pus");
        Iso639.registerLanguage("Persian", "fa", "per", "fas");
        Iso639.registerLanguage("Philippine;Philippine languages", null, "phi");
        Iso639.registerLanguage("Phoenician", null, "phn");
        Iso639.registerLanguage("Pohnpeian", null, "pon");
        Iso639.registerLanguage("Polish", "pl", "pol");
        Iso639.registerLanguage("Portuguese", "pt", "por");
        Iso639.registerLanguage("Prakrit;Prakrit languages", null, "pra");
        Iso639.registerLanguage("Quechua", "qu", "que");
        Iso639.registerLanguage("Rajasthani", null, "raj");
        Iso639.registerLanguage("Rapanui", null, "rap");
        Iso639.registerLanguage("Reserved for local use", null, "qaa-qtz");
        Iso639.registerLanguage("Romance;Romance languages", null, "roa");
        Iso639.registerLanguage("Romansh", "rm", "roh");
        Iso639.registerLanguage("Romany", null, "rom");
        Iso639.registerLanguage("Rundi", "rn", "run");
        Iso639.registerLanguage("Russian", "ru", "rus");
        Iso639.registerLanguage("Salishan;Salishan languages", null, "sal");
        Iso639.registerLanguage("Samaritan Aramaic", null, "sam");
        Iso639.registerLanguage("Sami;Sami languages", null, "smi");
        Iso639.registerLanguage("Samoan", "sm", "smo");
        Iso639.registerLanguage("Sandawe", null, "sad");
        Iso639.registerLanguage("Sango", "sg", "sag");
        Iso639.registerLanguage("Sanskrit", "sa", "san");
        Iso639.registerLanguage("Santali", null, "sat");
        Iso639.registerLanguage("Sardinian", "sc", "srd");
        Iso639.registerLanguage("Sasak", null, "sas");
        Iso639.registerLanguage("Scots", null, "sco");
        Iso639.registerLanguage("Selkup", null, "sel");
        Iso639.registerLanguage("Semitic languages", null, "sem");
        Iso639.registerLanguage("Serbian", "sr", "srp");
        Iso639.registerLanguage("Serer", null, "srr");
        Iso639.registerLanguage("Shan", null, "shn");
        Iso639.registerLanguage("Shona", "sn", "sna");
        Iso639.registerLanguage("Sicilian", null, "scn");
        Iso639.registerLanguage("Sidamo", null, "sid");
        Iso639.registerLanguage("Sign;Sign Languages", null, "sgn");
        Iso639.registerLanguage("Siksika", null, "bla");
        Iso639.registerLanguage("Sindhi", "sd", "snd");
        Iso639.registerLanguage("Sinhala;Sinhalese", "si", "sin");
        Iso639.registerLanguage("Sino-Tibetan languages", null, "sit");
        Iso639.registerLanguage("Siouan;Siouan languages", null, "sio");
        Iso639.registerLanguage("Skolt Sami", null, "sms");
        Iso639.registerLanguage("Slave (Athapascan)", null, "den");
        Iso639.registerLanguage("Slavic languages", null, "sla");
        Iso639.registerLanguage("Slovak", "sk", "slo", "slk");
        Iso639.registerLanguage("Slovenian", "sl", "slv");
        Iso639.registerLanguage("Sogdian", null, "sog");
        Iso639.registerLanguage("Somali", "so", "som");
        Iso639.registerLanguage("Songhai languages", null, "son");
        Iso639.registerLanguage("Soninke", null, "snk");
        Iso639.registerLanguage("Sorbian languages", null, "wen");
        Iso639.registerLanguage("South American Indian languages", null, "sai");
        Iso639.registerLanguage("South Ndebele", "nr", "nbl");
        Iso639.registerLanguage("Southern Altai", null, "alt");
        Iso639.registerLanguage("Southern Sami", null, "sma");
        Iso639.registerLanguage("Southern Sotho", "st", "sot");
        Iso639.registerLanguage("Sranan Tongo", null, "srn");
        Iso639.registerLanguage("Standard Moroccan Tamazight", null, "zgh");
        Iso639.registerLanguage("Sukuma", null, "suk");
        Iso639.registerLanguage("Sumerian", null, "sux");
        Iso639.registerLanguage("Sundanese", "su", "sun");
        Iso639.registerLanguage("Susu", null, "sus");
        Iso639.registerLanguage("Swahili (macrolanguage)", "sw", "swa");
        Iso639.registerLanguage("Swati", "ss", "ssw");
        Iso639.registerLanguage("Swedish", "sv", "swe");
        Iso639.registerLanguage("Syriac", null, "syr");
        Iso639.registerLanguage("Tagalog", "tl", "tgl");
        Iso639.registerLanguage("Tahitian", "ty", "tah");
        Iso639.registerLanguage("Tai;Tai languages", null, "tai");
        Iso639.registerLanguage("Tajik", "tg", "tgk");
        Iso639.registerLanguage("Tamashek", null, "tmh");
        Iso639.registerLanguage("Tamil", "ta", "tam");
        Iso639.registerLanguage("Tatar", "tt", "tat");
        Iso639.registerLanguage("Telugu", "te", "tel");
        Iso639.registerLanguage("Tereno", null, "ter");
        Iso639.registerLanguage("Tetum", null, "tet");
        Iso639.registerLanguage("Thai", "th", "tha");
        Iso639.registerLanguage("Tibetan", "bo", "tib", "bod");
        Iso639.registerLanguage("Tigre", null, "tig");
        Iso639.registerLanguage("Tigrinya", "ti", "tir");
        Iso639.registerLanguage("Timne", null, "tem");
        Iso639.registerLanguage("Tiv", null, "tiv");
        Iso639.registerLanguage("Tlingit", null, "tli");
        Iso639.registerLanguage("Tok Pisin", null, "tpi");
        Iso639.registerLanguage("Tokelau", null, "tkl");
        Iso639.registerLanguage("Tonga (Nyasa)", null, "tog");
        Iso639.registerLanguage("Tonga (Tonga Islands)", "to", "ton");
        Iso639.registerLanguage("Tsimshian", null, "tsi");
        Iso639.registerLanguage("Tsonga", "ts", "tso");
        Iso639.registerLanguage("Tswana", "tn", "tsn");
        Iso639.registerLanguage("Tumbuka", null, "tum");
        Iso639.registerLanguage("Tupi languages", null, "tup");
        Iso639.registerLanguage("Turkish", "tr", "tur");
        Iso639.registerLanguage("Turkmen", "tk", "tuk");
        Iso639.registerLanguage("Tuvalu", null, "tvl");
        Iso639.registerLanguage("Tuvinian", null, "tyv");
        Iso639.registerLanguage("Twi", "tw", "twi");
        Iso639.registerLanguage("Udmurt", null, "udm");
        Iso639.registerLanguage("Ugaritic", null, "uga");
        Iso639.registerLanguage("Uighur;Uyghur", "ug", "uig");
        Iso639.registerLanguage("Ukrainian", "uk", "ukr");
        Iso639.registerLanguage("Umbundu", null, "umb");
        Iso639.registerLanguage("Uncoded languages", null, "mis");
        Iso639.registerLanguage("Undetermined", null, "und");
        Iso639.registerLanguage("Upper Sorbian", null, "hsb");
        Iso639.registerLanguage("Urdu", "ur", "urd");
        Iso639.registerLanguage("Uzbek", "uz", "uzb");
        Iso639.registerLanguage("Vai", null, "vai");
        Iso639.registerLanguage("Venda", "ve", "ven");
        Iso639.registerLanguage("Vietnamese", "vi", "vie");
        Iso639.registerLanguage("Volap\u00fck", "vo", "vol");
        Iso639.registerLanguage("Votic", null, "vot");
        Iso639.registerLanguage("Wakashan languages", null, "wak");
        Iso639.registerLanguage("Walloon", "wa", "wln");
        Iso639.registerLanguage("Waray (Philippines)", null, "war");
        Iso639.registerLanguage("Washo", null, "was");
        Iso639.registerLanguage("Welsh", "cy", "wel", "cym");
        Iso639.registerLanguage("Western Frisian", "fy", "fry");
        Iso639.registerLanguage("Wolaitta;Wolaytta", null, "wal");
        Iso639.registerLanguage("Wolof", "wo", "wol");
        Iso639.registerLanguage("Xhosa", "xh", "xho");
        Iso639.registerLanguage("Yakut", null, "sah");
        Iso639.registerLanguage("Yao", null, "yao");
        Iso639.registerLanguage("Yapese", null, "yap");
        Iso639.registerLanguage("Yiddish", "yi", "yid");
        Iso639.registerLanguage("Yoruba", "yo", "yor");
        Iso639.registerLanguage("Yupik;Yupik languages", null, "ypk");
        Iso639.registerLanguage("Zande;Zande languages", null, "znd");
        Iso639.registerLanguage("Zapotec", null, "zap");
        Iso639.registerLanguage("Zenaga", null, "zen");
        Iso639.registerLanguage("Zulu", "zu", "zul");
        Iso639.registerLanguage("Zuni", null, "zun");
    }

    private static HashMap<String, String> buildMisspellings() {
        HashMap<String, String> misspellings = new HashMap<String, String>();
        misspellings.put("ameircan", "american");
        misspellings.put("artifical", "artificial");
        misspellings.put("brasillian", "brazilian");
        misspellings.put("carrib", "carib");
        misspellings.put("centeral", "central");
        misspellings.put("chineese", "chinese");
        misspellings.put("curch", "church");
        misspellings.put("dravadian", "dravidian");
        misspellings.put("enlish", "english");
        misspellings.put("euorpean", "european");
        misspellings.put("farsi", "persian");
        misspellings.put("hawaian", "hawaiian");
        misspellings.put("hebrwe", "hebrew");
        misspellings.put("japaneese", "japanese");
        misspellings.put("javaneese", "javanese");
        misspellings.put("laguage", "language");
        misspellings.put("madureese", "madurese");
        misspellings.put("malteese", "maltese");
        misspellings.put("maltesian", "maltese");
        misspellings.put("miscelaneous", "miscellaneous");
        misspellings.put("miscellanious", "miscellaneous");
        misspellings.put("miscellanous", "miscellaneous");
        misspellings.put("northen", "northern");
        misspellings.put("norweigan", "norwegian");
        misspellings.put("ottaman", "ottoman");
        misspellings.put("philipine", "philippine");
        misspellings.put("phonecian", "phoenician");
        misspellings.put("portugese", "portuguese");
        misspellings.put("rusian", "russian");
        misspellings.put("sinhaleese", "sinhalese");
        misspellings.put("sourth", "south");
        misspellings.put("spainish", "spanish");
        misspellings.put("sweedish", "swedish");
        misspellings.put("ukranian", "ukrainian");
        misspellings.put("vietnameese", "vietnamese");
        return misspellings;
    }

    static {
        LANGUAGE_REGEX_PATTERN = Pattern.compile(LANGUAGE_REGEX);
        Iso639.initLinks();
        CODES = Collections.unmodifiableList(Iso639.initCodes());
        COMMON_MISSPELLINGS = Collections.unmodifiableMap(Iso639.buildMisspellings());
    }

    public static class Iso639Entry {
        private final String[] names;
        private final String iso639_1;
        private final String iso639_2;
        private final String altIso639_2;

        public Iso639Entry(String[] names, String iso639_1, String iso639_2, String altIso639_2) {
            if (names.length == 0 || StringUtils.isBlank(names[0])) {
                throw new IllegalArgumentException("names cannot be empty");
            }
            this.names = new String[names.length];
            System.arraycopy(names, 0, this.names, 0, names.length);
            this.iso639_1 = iso639_1;
            this.iso639_2 = iso639_2;
            this.altIso639_2 = altIso639_2;
        }

        public String getFirstName() {
            return this.names[0];
        }

        public String[] getNames() {
            String[] result = new String[this.names.length];
            System.arraycopy(this.names, 0, result, 0, this.names.length);
            return result;
        }

        public String getIso639_1() {
            return this.iso639_1;
        }

        public String getIso639_2() {
            return this.iso639_2;
        }

        public boolean matches(String code) {
            if (code == null) {
                return false;
            }
            return code.equals(this.iso639_1) || code.equals(this.iso639_2) || code.equals(this.altIso639_2);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(" [");
            if (this.names.length > 1) {
                sb.append("Names=").append(StringUtil.createReadableCombinedString(this.names, true));
            } else {
                sb.append("Name=").append("\"").append(this.names[0]).append("\"");
            }
            if (StringUtils.isNotBlank(this.iso639_1)) {
                sb.append(", 639-1=").append(this.iso639_1);
            }
            sb.append(", 639-2=").append(this.iso639_2);
            if (StringUtils.isNotBlank(this.altIso639_2)) {
                sb.append(", alternative 639-2=").append(this.altIso639_2);
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.altIso639_2 == null ? 0 : this.altIso639_2.hashCode());
            result = 31 * result + (this.iso639_1 == null ? 0 : this.iso639_1.hashCode());
            result = 31 * result + (this.iso639_2 == null ? 0 : this.iso639_2.hashCode());
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Iso639Entry)) {
                return false;
            }
            Iso639Entry other = (Iso639Entry)obj;
            if (this.altIso639_2 == null ? other.altIso639_2 != null : !this.altIso639_2.equals(other.altIso639_2)) {
                return false;
            }
            if (this.iso639_1 == null ? other.iso639_1 != null : !this.iso639_1.equals(other.iso639_1)) {
                return false;
            }
            if (this.iso639_2 == null ? other.iso639_2 != null : !this.iso639_2.equals(other.iso639_2)) {
                return false;
            }
            return Arrays.equals(this.names, other.names);
        }
    }
}

