/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.dlna.DLNAThumbnail;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.formats.Format;
import net.pms.image.ImageFormat;
import net.pms.image.ImageIOTools;
import net.pms.image.ImagesUtil;
import net.pms.media.MediaInfo;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GenericIcons {
    INSTANCE;

    private final BufferedImage genericAudioIcon = GenericIcons.readBufferedImage("store/formats/audio.png");
    private final BufferedImage genericImageIcon = GenericIcons.readBufferedImage("store/formats/image.png");
    private final BufferedImage genericVideoIcon = GenericIcons.readBufferedImage("store/formats/video.png");
    private final BufferedImage genericUnknownIcon = GenericIcons.readBufferedImage("store/formats/unknown.png");
    private final DLNAThumbnail genericFolderThumbnail;
    private final ReentrantLock cacheLock = new ReentrantLock();
    private final Map<ImageFormat, Map<IconType, Map<String, DLNAThumbnail>>> cache = new HashMap<ImageFormat, Map<IconType, Map<String, DLNAThumbnail>>>();
    private static final Logger LOGGER;

    private GenericIcons() {
        DLNAThumbnail thumbnail;
        try {
            thumbnail = DLNAThumbnail.toThumbnail(GenericIcons.getResourceAsStream("store/folder.png"));
        }
        catch (IOException e) {
            thumbnail = null;
        }
        this.genericFolderThumbnail = thumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLNAThumbnailInputStream getGenericIcon(StoreResource resource) {
        Format format;
        ImageFormat imageFormat = ImageFormat.PNG;
        if (resource == null) {
            ImageIO.setUseCache(false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ImageIOTools.imageIOWrite(this.genericUnknownIcon, imageFormat.toString(), out);
                return DLNAThumbnailInputStream.toThumbnailInputStream(out.toByteArray());
            }
            catch (IOException e) {
                LOGGER.warn("Unexpected error while generating generic thumbnail for null resource: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                return null;
            }
        }
        IconType iconType = IconType.UNKNOWN;
        if (resource instanceof StoreItem) {
            StoreItem item = (StoreItem)resource;
            v0 = item.getFormat();
        } else {
            v0 = format = null;
        }
        if (resource.getMediaInfo() != null) {
            if (resource.getMediaInfo().isAudio()) {
                iconType = IconType.AUDIO;
            } else if (resource.getMediaInfo().isImage()) {
                iconType = IconType.IMAGE;
            } else if (resource.getMediaInfo().isVideo()) {
                iconType = format != null && format.isImage() ? IconType.IMAGE : IconType.VIDEO;
            }
        } else if (format != null) {
            if (format.isAudio()) {
                iconType = IconType.AUDIO;
            } else if (format.isImage()) {
                iconType = IconType.IMAGE;
            } else if (format.isVideo()) {
                iconType = IconType.VIDEO;
            }
        }
        DLNAThumbnail image = null;
        this.cacheLock.lock();
        try {
            Map<IconType, Map<String, DLNAThumbnail>> typeCache;
            if (!this.cache.containsKey((Object)imageFormat)) {
                this.cache.put(imageFormat, new HashMap());
            }
            if (!(typeCache = this.cache.get((Object)imageFormat)).containsKey((Object)iconType)) {
                typeCache.put(iconType, new HashMap());
            }
            Map<String, DLNAThumbnail> imageCache = typeCache.get((Object)iconType);
            String label = GenericIcons.getLabelFromImageFormat(resource.getMediaInfo());
            if (label == null) {
                label = GenericIcons.getLabelFromFormat(format);
            }
            if (label == null) {
                label = GenericIcons.getLabelFromContainer(resource.getMediaInfo());
            }
            if (label != null && label.length() < 5) {
                label = label.toUpperCase(Locale.ROOT);
            } else if (label != null && label.toLowerCase(Locale.ROOT).equals(label)) {
                label = StringUtils.capitalize(label);
            }
            if (StringUtils.isBlank(label)) {
                label = Messages.getString("Unknown");
            }
            if (imageCache.containsKey(label)) {
                DLNAThumbnailInputStream dLNAThumbnailInputStream = DLNAThumbnailInputStream.toThumbnailInputStream(imageCache.get(label));
                return dLNAThumbnailInputStream;
            }
            if (LOGGER.isTraceEnabled()) {
                if (label != null) {
                    LOGGER.trace("Creating generic {} {} thumbnail for {}", new Object[]{imageFormat, iconType.toString().toLowerCase(), label.toUpperCase()});
                } else {
                    LOGGER.warn("Creating generic {} {} thumbnail without label", (Object)imageFormat, (Object)iconType.toString().toLowerCase());
                }
            }
            try {
                image = this.createGenericIcon(label, imageFormat, iconType);
            }
            catch (IOException e) {
                LOGGER.warn("Unexpected error while generating generic thumbnail for \"{}\": {}", (Object)resource.getName(), (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            imageCache.put(label, image);
        }
        finally {
            this.cacheLock.unlock();
        }
        return DLNAThumbnailInputStream.toThumbnailInputStream(image);
    }

    public DLNAThumbnailInputStream getGenericFolderIcon() {
        return DLNAThumbnailInputStream.toThumbnailInputStream(this.genericFolderThumbnail);
    }

    private static String getLabelFromImageFormat(MediaInfo mediaInfo) {
        return mediaInfo != null && mediaInfo.isImage() && mediaInfo.getImageInfo() != null && mediaInfo.getImageInfo().getFormat() != null ? mediaInfo.getImageInfo().getFormat().toString() : null;
    }

    private static String getLabelFromFormat(Format format) {
        if (format == null || format.getIdentifier() == null) {
            return null;
        }
        return switch (format.getIdentifier()) {
            case Format.Identifier.AUDIO_AS_VIDEO -> "Audio as Video";
            case Format.Identifier.MICRODVD -> "MicroDVD";
            case Format.Identifier.SUBRIP -> "SubRip";
            case Format.Identifier.THREEG2A -> "3G2A";
            case Format.Identifier.THREEGA -> "3GA";
            case Format.Identifier.WEBVTT -> "WebVTT";
            case Format.Identifier.ISOVOB -> Messages.getString("DvdVideo");
            default -> format.getIdentifier().toString();
        };
    }

    private static String getLabelFromContainer(MediaInfo mediaInfo) {
        return mediaInfo != null ? mediaInfo.getContainer() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DLNAThumbnail createGenericIcon(String label, ImageFormat imageFormat, IconType iconType) throws IOException {
        BufferedImage image;
        switch (iconType) {
            case AUDIO: {
                BufferedImage bufferedImage = this.genericAudioIcon;
                break;
            }
            case IMAGE: {
                BufferedImage bufferedImage = this.genericImageIcon;
                break;
            }
            case VIDEO: {
                BufferedImage bufferedImage = this.genericVideoIcon;
                break;
            }
            default: {
                BufferedImage bufferedImage = image = this.genericUnknownIcon;
            }
        }
        if (image != null) {
            ColorModel colorModel = image.getColorModel();
            image = new BufferedImage(colorModel, image.copyData(null), colorModel.isAlphaPremultiplied(), null);
        }
        ByteArrayOutputStream out = null;
        if (label != null && image != null) {
            out = new ByteArrayOutputStream();
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            try {
                int size = 40;
                Font font = new Font("SansSerif", 1, size);
                FontMetrics metrics = g.getFontMetrics(font);
                while (size > 7 && metrics.stringWidth(label) > 135) {
                    font = new Font("SansSerif", 1, --size);
                    metrics = g.getFontMetrics(font);
                }
                int x = 127 - metrics.stringWidth(label) / 2;
                int y = 46 + metrics.getAscent() / 2;
                g.drawImage((Image)image, 0, 0, null);
                g.setColor(Color.WHITE);
                g.setFont(font);
                g.drawString(label, x, y);
                ImageIO.setUseCache(false);
                ImageIOTools.imageIOWrite(image, imageFormat.toString(), out);
            }
            finally {
                g.dispose();
            }
        } else if (image != null) {
            out = new ByteArrayOutputStream();
            ImageIOTools.imageIOWrite(image, imageFormat.toString(), out);
        }
        return out != null ? DLNAThumbnail.toThumbnail(out.toByteArray(), 0, 0, ImagesUtil.ScaleType.MAX, imageFormat, false) : null;
    }

    protected static BufferedImage readBufferedImage(String resourcePath) {
        InputStream inputStream = GenericIcons.getResourceAsStream(resourcePath);
        if (inputStream != null) {
            try {
                return ImageIO.read(inputStream);
            }
            catch (IOException e) {
                LOGGER.error("Could not read resource \"{}\": {}", (Object)resourcePath, (Object)e.getMessage());
                LOGGER.trace("", e);
                return null;
            }
        }
        return null;
    }

    protected static InputStream getResourceAsStream(String resourcePath) {
        return PMS.class.getResourceAsStream("/resources/images/" + resourcePath);
    }

    static {
        LOGGER = LoggerFactory.getLogger(GenericIcons.class);
    }

    public static enum IconType {
        AUDIO,
        IMAGE,
        UNKNOWN,
        VIDEO;

    }
}

