/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum FullyPlayedAction {
    NO_ACTION(0),
    MARK(1),
    HIDE_MEDIA(2),
    MOVE_FOLDER(3),
    MOVE_TRASH(4),
    MOVE_FOLDER_AND_MARK(5);

    private final int value;

    private FullyPlayedAction(int value) {
        this.value = value;
    }

    public String toString() {
        switch (this) {
            case HIDE_MEDIA: {
                return "Hide media";
            }
            case MARK: {
                return "Mark";
            }
            case MOVE_FOLDER: {
                return "Move to folder";
            }
            case MOVE_FOLDER_AND_MARK: {
                return "Move to folder and mark";
            }
            case MOVE_TRASH: {
                return "Move to trash";
            }
            case NO_ACTION: {
                return "No action";
            }
        }
        throw new IllegalStateException("Unimplemented value " + super.toString() + " in FullyPlayedAction");
    }

    public int getValue() {
        return this.value;
    }

    public static FullyPlayedAction typeOf(int value) {
        return FullyPlayedAction.typeOf(value, null);
    }

    public static FullyPlayedAction typeOf(int value, FullyPlayedAction defaultFullyPlayedAction) {
        for (FullyPlayedAction action : FullyPlayedAction.values()) {
            if (action.value != value) continue;
            return action;
        }
        return defaultFullyPlayedAction;
    }

    public static FullyPlayedAction toFullyPlayedAction(String sArg) {
        return FullyPlayedAction.toFullyPlayedAction(sArg, null);
    }

    public static FullyPlayedAction toFullyPlayedAction(String sArg, FullyPlayedAction defaultFullyPlayedAction) {
        if (StringUtils.isBlank(sArg)) {
            return defaultFullyPlayedAction;
        }
        if ((sArg = sArg.toLowerCase(Locale.ROOT)).contains("folder") && sArg.contains("mark")) {
            return MOVE_FOLDER_AND_MARK;
        }
        if (sArg.contains("action")) {
            return NO_ACTION;
        }
        if (sArg.contains("mark")) {
            return MARK;
        }
        if (sArg.contains("hide")) {
            return HIDE_MEDIA;
        }
        if (sArg.contains("folder")) {
            return MOVE_FOLDER;
        }
        if (sArg.contains("trash") || sArg.contains("recycle")) {
            return MOVE_TRASH;
        }
        return defaultFullyPlayedAction;
    }
}

