/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.util.DbHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDb.class);
    private static final String NULLOBJ_STR = "@@@NULLOBJ@@@";
    private Map<String, Object> db;
    private int minCnt;
    private String separator;
    private String encodedSeparator;
    private File file;
    private DbHandler handler;
    private boolean autoSync;
    private boolean overwrite;
    private boolean useNullObj;
    private static final Object NULL_OBJ = new Object();
    private boolean hasNulls;

    public FileDb(DbHandler h) {
        this(PMS.getConfiguration().getDataFile(h.name()), h);
    }

    public FileDb(String f, DbHandler h) {
        if (StringUtils.isEmpty(f)) {
            f = "UMS.db";
        }
        this.file = new File(f);
        this.handler = h;
        this.minCnt = 2;
        this.separator = ",";
        this.encodedSeparator = "&comma;";
        this.autoSync = true;
        this.overwrite = false;
        this.useNullObj = false;
        this.db = new HashMap<String, Object>();
        this.hasNulls = false;
    }

    public void setSep(String separator, String encodedSeparator) {
        if (separator == null || encodedSeparator == null) {
            throw new IllegalArgumentException("Neither argument can be null");
        }
        this.separator = separator;
        this.encodedSeparator = encodedSeparator;
    }

    public void setMinCnt(int c) {
        this.minCnt = c;
    }

    public void setAutoSync(boolean b) {
        this.autoSync = b;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public void setUseNullObj(boolean b) {
        this.useNullObj = b;
    }

    public static Object nullObj() {
        return NULL_OBJ;
    }

    public boolean isNull(Object obj) {
        return obj == null || obj == NULL_OBJ;
    }

    public boolean hasNulls() {
        return this.hasNulls;
    }

    public Set<String> keys() {
        return this.db.keySet();
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.db.entrySet().iterator();
    }

    private String recode(String str) {
        return Pattern.compile(this.encodedSeparator, 18).matcher(str).replaceAll(Matcher.quoteReplacement(this.separator));
    }

    public void init() {
        if (!this.file.exists()) {
            return;
        }
        this.hasNulls = false;
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                String re;
                if (StringUtils.isEmpty(line = line.trim()) || line.startsWith("#")) continue;
                if (this.useNullObj && line.matches(re = ".*" + this.separator + "@@@NULLOBJ@@@$")) {
                    this.hasNulls = true;
                    String[] key = Pattern.compile(this.separator, 16).split(line);
                    this.db.put(this.recode(key[0]), NULL_OBJ);
                    continue;
                }
                String[] entry = Pattern.compile(this.separator, 16).split(line);
                if (entry.length < this.minCnt) continue;
                for (int i = 0; i < entry.length; ++i) {
                    if (entry[i] == null) continue;
                    entry[i] = this.recode(entry[i]);
                }
                this.db.put(entry[0], this.handler.create(entry));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not read file database file \"{}\": {}", (Object)this.file.getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public void addNoSync(String key, Object obj) {
        if (!this.overwrite && this.get(key) != null) {
            return;
        }
        this.db.put(key, obj);
        this.hasNulls |= this.isNull(obj);
    }

    public void removeNoSync(String key) {
        this.db.remove(key);
    }

    public void add(String key, Object obj) {
        this.addNoSync(key, obj);
        if (this.autoSync) {
            this.sync();
        }
    }

    public void remove(String key) {
        this.db.remove(key);
        if (this.autoSync) {
            this.sync();
        }
    }

    public Object get(String key) {
        return this.db.get(key);
    }

    public void sync() {
        try (FileOutputStream out = new FileOutputStream(this.file);){
            Date now = new Date();
            StringBuilder data = new StringBuilder();
            data.append("#########################\n#### Db file generated ").append(now.toString()).append("\n").append("#### Edit with care\n#########################\n");
            out.write(data.toString().getBytes(StandardCharsets.UTF_8));
            this.hasNulls = false;
            for (Map.Entry<String, Object> entry : this.db.entrySet()) {
                Object obj = entry.getValue();
                data = new StringBuilder(Pattern.compile(this.separator, 16).matcher(entry.getKey()).replaceAll(Matcher.quoteReplacement(this.encodedSeparator)));
                if (this.isNull(obj)) {
                    this.hasNulls = true;
                    if (this.useNullObj) {
                        data.append(this.separator);
                        data.append(NULLOBJ_STR);
                    } else {
                        for (int i = 1; i < this.minCnt; ++i) {
                            data.append(this.separator);
                        }
                    }
                    data.append("\n");
                } else {
                    Object[] data1 = this.handler.format(obj);
                    for (int i = 0; i < data1.length; ++i) {
                        data1[i] = Pattern.compile(this.separator, 16).matcher((CharSequence)data1[i]).replaceAll(Matcher.quoteReplacement(this.encodedSeparator));
                    }
                    data.append(this.separator).append(StringUtils.join(data1, this.separator)).append("\n");
                }
                out.write(data.toString().getBytes(StandardCharsets.UTF_8));
            }
            out.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Could not write file database file \"{}\": {}", (Object)this.file.getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static String safeGetArg(String[] args, int i) {
        return i >= args.length ? "" : args[i];
    }
}

