/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.logging.LoggingConfig;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbgPacker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbgPacker.class);
    private final LinkedHashMap<File, Object> items = new LinkedHashMap();
    private String defaultLogFile;

    public DbgPacker() {
        Map<String, String> logFilePaths = LoggingConfig.getLogFilePaths();
        if (!logFilePaths.isEmpty()) {
            this.defaultLogFile = LoggingConfig.getLogFilePaths().get("default.log");
            if (this.defaultLogFile == null) {
                Map.Entry<String, String> entry = logFilePaths.entrySet().iterator().next();
                this.defaultLogFile = entry.getValue();
            }
        }
    }

    public void poll() {
        UmsConfiguration configuration = PMS.getConfiguration();
        LOGGER.debug("Checking dbgpack property in UMS.conf");
        String f = (String)configuration.getCustomProperty("dbgpack");
        if (f != null) {
            this.add(f.split(","));
        }
        for (Renderer renderer : ConnectedRenderers.getConnectedRenderers()) {
            this.add(renderer.getFile());
            if (!renderer.isCustomized()) continue;
            this.add(renderer.getParentFile());
        }
        String profileDirectory = UmsConfiguration.getProfileDirectory();
        this.add(new File(profileDirectory, "SHARED.conf"));
        this.add(new File(UmsConfiguration.getProfilePath()));
        if (this.defaultLogFile != null && !this.defaultLogFile.isEmpty()) {
            this.add(new File(this.defaultLogFile + ".prev.zip"));
            this.add(new File(this.defaultLogFile + ".zip"));
            this.add(new File(this.defaultLogFile));
        }
    }

    private void add(String[] files) {
        for (String file : files) {
            this.add(new File(file));
        }
    }

    private void add(File file) {
        if (file != null) {
            LOGGER.debug("adding {}", (Object)file.getAbsolutePath());
            try {
                this.items.put(file.getCanonicalFile(), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Set<File> getFiles() {
        this.poll();
        return this.items.keySet();
    }

    public Map<File, Object> getItems() {
        return this.items;
    }

    public static void writeToZip(ZipOutputStream out, File f) throws Exception {
        byte[] buf = new byte[1024];
        if (!f.exists()) {
            LOGGER.debug("DbgPack file {} does not exist - ignoring", (Object)f.getAbsolutePath());
            return;
        }
        try (FileInputStream in = new FileInputStream(f);){
            int len;
            out.putNextEntry(new ZipEntry(f.getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
    }
}

