/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <E> DiffResult<List<E>> diff(Collection<E> first, Collection<E> second) {
        if ((first == null || first.isEmpty()) && (second == null || second.isEmpty())) {
            return new DiffResult<List<E>>(new ArrayList(), new ArrayList());
        }
        if (first == null || first.isEmpty()) {
            return new DiffResult<List<E>>(new ArrayList(), new ArrayList<E>(second));
        }
        if (second == null || second.isEmpty()) {
            return new DiffResult<List<E>>(new ArrayList<E>(first), new ArrayList());
        }
        ArrayList<E> firstArray = new ArrayList<E>(first);
        firstArray.removeAll(second);
        ArrayList<E> secondArray = new ArrayList<E>(second);
        secondArray.removeAll(first);
        return new DiffResult<List<E>>(firstArray, secondArray);
    }

    public static <E> DiffResult<List<E>> diff(E[] first, E[] second) {
        if (!(first != null && first.length != 0 || second != null && second.length != 0)) {
            return new DiffResult<List<E>>(new ArrayList(), new ArrayList());
        }
        if (first == null || first.length == 0) {
            return new DiffResult<List<E>>(new ArrayList(), Arrays.asList(second));
        }
        if (second == null || second.length == 0) {
            return new DiffResult<List<E>>(Arrays.asList(first), new ArrayList());
        }
        ArrayList<E> firstArray = new ArrayList<E>(Arrays.asList(first));
        firstArray.removeAll(Arrays.asList(second));
        ArrayList<E> secondArray = new ArrayList<E>(Arrays.asList(second));
        secondArray.removeAll(Arrays.asList(first));
        return new DiffResult<List<E>>(firstArray, secondArray);
    }

    public static class DiffResult<T> {
        private final T firstOnly;
        private final T secondOnly;

        public DiffResult(T firstOnly, T secondOnly) {
            this.firstOnly = firstOnly;
            this.secondOnly = secondOnly;
        }

        public T getFirstOnly() {
            return this.firstOnly;
        }

        public T getSecondOnly() {
            return this.secondOnly;
        }
    }
}

