/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import net.pms.util.Range;
import net.pms.util.TimeRange;

public class ByteRange
implements Range {
    private Long start;
    private Long end;

    public ByteRange() {
    }

    public ByteRange(Long start, Long end) {
        this.start = start;
        this.end = end;
    }

    public Long getStart() {
        return this.start;
    }

    public long getStartOrZero() {
        return this.start != null ? this.start : 0L;
    }

    public ByteRange setStart(Long start) {
        this.start = start;
        return this;
    }

    public Long getEnd() {
        return this.end;
    }

    public ByteRange setEnd(Long end) {
        this.end = end;
        return this;
    }

    private void limitTime(ByteRange range) {
        if (range.start != null) {
            if (this.start != null) {
                this.start = Math.max(this.start, range.start);
            }
            if (this.end != null) {
                this.end = Math.max(this.end, range.start);
            }
        }
        if (range.end != null) {
            if (this.start != null) {
                this.start = Math.min(this.start, range.end);
            }
            if (this.end != null) {
                this.end = Math.min(this.end, range.end);
            }
        }
    }

    public String toString() {
        return "ByteRange [start=" + this.start + ", end=" + this.end + "]";
    }

    @Override
    public void limit(Range range) {
        this.limitTime((ByteRange)range);
    }

    @Override
    public boolean isStartOffsetAvailable() {
        return this.start != null;
    }

    @Override
    public boolean isEndLimitAvailable() {
        return this.end != null;
    }

    @Override
    public double getDuration() {
        return 0.0;
    }

    @Override
    public ByteRange asByteRange() {
        return this;
    }

    @Override
    public TimeRange createTimeRange() {
        return new TimeRange(null, null);
    }
}

