/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.HashMap;
import java.util.Map;

public enum BufferedImageType {
    TYPE_CUSTOM(0),
    TYPE_INT_RGB(1),
    TYPE_INT_ARGB(2),
    TYPE_INT_ARGB_PRE(3),
    TYPE_INT_BGR(4),
    TYPE_3BYTE_BGR(5),
    TYPE_4BYTE_ABGR(6),
    TYPE_4BYTE_ABGR_PRE(7),
    TYPE_USHORT_565_RGB(8),
    TYPE_USHORT_555_RGB(9),
    TYPE_BYTE_GRAY(10),
    TYPE_USHORT_GRAY(11),
    TYPE_BYTE_BINARY(12),
    TYPE_BYTE_INDEXED(13);

    private static final Map<Integer, BufferedImageType> MAP;
    private final int typeId;

    public static BufferedImageType toBufferedImageType(int typeId) {
        return MAP.get(typeId);
    }

    private BufferedImageType(int typeId) {
        this.typeId = typeId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    static {
        MAP = new HashMap<Integer, BufferedImageType>();
        for (BufferedImageType bufferedImageType : BufferedImageType.values()) {
            MAP.put(bufferedImageType.typeId, bufferedImageType);
        }
    }
}

