/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.status;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.gui.IRendererGuiListener;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.BasicPlayer;
import net.pms.renderers.devices.players.PlayerState;
import net.pms.swing.components.FixedPanel;
import net.pms.swing.components.MarqueeLabel;
import net.pms.swing.components.SimpleProgressUI;
import net.pms.swing.components.SmoothProgressBar;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.tabs.status.RendererFrame;
import net.pms.swing.gui.tabs.status.RendererImage;
import net.pms.util.StringUtil;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;

public class RendererPanel
implements ActionListener,
IRendererGuiListener {
    private static final int MINIMUM_FILENAME_DISPLAY_SIZE = 200;
    private static final Color BUF_COLOR = new Color(255, 128, 0, 128);
    private final RendererImage rendererImage;
    private final JLabel label;
    private final MarqueeLabel playingLabel;
    private final FixedPanel playing;
    private final JLabel time;
    private final int bufferSize;
    private final SmoothProgressBar rendererProgressBar;
    private RendererFrame rendererFrame;
    private String name = " ";
    private JPanel panel = null;

    public RendererPanel(final Renderer renderer) {
        this.rendererImage = new RendererImage(renderer);
        String rendererName = renderer.getRendererName();
        if ("UnknownRenderer".equals(rendererName)) {
            rendererName = Messages.getGuiString(rendererName);
        }
        this.label = new JLabel(rendererName);
        this.playingLabel = new MarqueeLabel(" ");
        this.playingLabel.setForeground(Color.gray);
        int h = (int)this.playingLabel.getSize().getHeight();
        this.playing = new FixedPanel(200, h);
        this.playing.add(this.playingLabel);
        this.time = new JLabel(" ");
        this.time.setForeground(Color.gray);
        this.bufferSize = renderer.getUmsConfiguration().getMaxMemoryBufferSize();
        this.rendererProgressBar = new SmoothProgressBar(0, 100, new SimpleProgressUI(Color.gray, Color.gray));
        this.rendererProgressBar.setStringPainted(true);
        this.rendererProgressBar.setBorderPainted(false);
        if (renderer.getAddress() != null) {
            this.rendererProgressBar.setString(renderer.getAddress().getHostAddress());
        }
        this.rendererProgressBar.setForeground(BUF_COLOR);
        this.rendererImage.enableRollover();
        this.rendererImage.setAction(new AbstractAction(){
            private static final long serialVersionUID = -6316055325551243347L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> {
                    if (RendererPanel.this.rendererFrame == null) {
                        JFrame top = (JFrame)SwingUtilities.getWindowAncestor(RendererPanel.this.getPanel());
                        RendererPanel.this.rendererFrame = new RendererFrame(top, renderer);
                    } else {
                        RendererPanel.this.rendererFrame.setExtendedState(0);
                        RendererPanel.this.rendererFrame.setVisible(true);
                        RendererPanel.this.rendererFrame.toFront();
                    }
                });
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String n;
        PlayerState state = ((BasicPlayer)e.getSource()).getState();
        this.time.setText(state.isStopped() || StringUtil.isZeroTime(state.getPosition()) ? " " : UMSUtils.playedDurationStr(state.getPosition(), state.getDuration()));
        this.rendererProgressBar.setValue((int)(100L * state.getBuffer() / (long)this.bufferSize));
        String string = n = state.isStopped() || StringUtils.isBlank(state.getName()) ? " " : state.getName();
        if (!this.name.equals(n)) {
            this.name = n;
            this.playingLabel.setText(this.name);
        }
        if (this.playing.getSize().width == 0) {
            int w = this.panel.getWidth() - this.panel.getInsets().left - this.panel.getInsets().right;
            if (w < 200) {
                w = 200;
            }
            this.playing.setSize(w, (int)this.playingLabel.getSize().getHeight());
            this.playingLabel.setMaxWidth(w);
        }
    }

    @Override
    public void refreshPlayerState(PlayerState state) {
        String n;
        this.time.setText(state.isStopped() || StringUtil.isZeroTime(state.getPosition()) ? " " : UMSUtils.playedDurationStr(state.getPosition(), state.getDuration()));
        this.rendererProgressBar.setValue((int)(100L * state.getBuffer() / (long)this.bufferSize));
        String string = n = state.isStopped() || StringUtils.isBlank(state.getName()) ? " " : state.getName();
        if (!this.name.equals(n)) {
            this.name = n;
            this.playingLabel.setText(this.name);
        }
    }

    public void addTo(Container parent) {
        parent.add(this.getPanel());
        parent.validate();
        int w = this.panel.getWidth() - this.panel.getInsets().left - this.panel.getInsets().right;
        this.playing.setSize(w, (int)this.playingLabel.getSize().getHeight());
        this.playingLabel.setMaxWidth(w);
    }

    @Override
    public void delete() {
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.rendererFrame != null) {
                    this.rendererFrame.dispose();
                    this.rendererFrame = null;
                }
                Container parent = this.panel.getParent();
                parent.remove(this.panel);
                parent.revalidate();
                parent.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            UmsFormBuilder b = UmsFormBuilder.create().layout(new FormLayout("center:pref", "max(140px;pref), 3dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
            b.opaque(true);
            CellConstraints cc = new CellConstraints();
            b.add(this.rendererImage).at(cc.xy(1, 1));
            b.add(this.label).at(cc.xy(1, 3, CellConstraints.CENTER, CellConstraints.DEFAULT));
            b.add(this.rendererProgressBar).at(cc.xy(1, 5));
            b.add(this.playing).at(cc.xy(1, 7, CellConstraints.CENTER, CellConstraints.DEFAULT));
            b.add(this.time).at(cc.xy(1, 9));
            this.panel = b.getPanel();
        }
        return this.panel;
    }

    @Override
    public void updateRenderer(Renderer renderer) {
        SwingUtilities.invokeLater(() -> {
            this.rendererImage.set(renderer);
            String rendererName = renderer.getRendererName();
            if ("UnknownRenderer".equals(rendererName)) {
                rendererName = Messages.getGuiString(rendererName);
            }
            this.label.setText(rendererName);
            if (this.rendererFrame != null) {
                this.rendererFrame.update();
            }
        });
    }

    @Override
    public void setActive(boolean active) {
        this.rendererImage.setGrey(!active);
    }

    @Override
    public void setAllowed(boolean allowed) {
    }

    @Override
    public void setUserId(int userId) {
    }
}

