/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.general;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.gui.GuiManager;
import net.pms.swing.components.CheckTreeManager;
import net.pms.swing.components.IllegalChildException;
import net.pms.swing.components.SearchableMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRenderers
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectRenderers.class);
    private static final long serialVersionUID = -2724796596060834064L;
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private CheckTreeManager checkTreeManager;
    private JTree srvTree;
    private SearchableMutableTreeNode allRenderers;
    private boolean init = false;

    public SelectRenderers() {
        super(new BorderLayout());
    }

    public void build() {
        JPanel checkPanel = new JPanel();
        checkPanel.applyComponentOrientation(ComponentOrientation.getOrientation(PMS.getLocale()));
        this.add((Component)checkPanel, "Before");
        this.allRenderers = new SearchableMutableTreeNode(Messages.getGuiString("SelectDeselectAllRenderers"));
        Pattern pattern = Pattern.compile("^\\s*([^\\s]*) ?([^\\s].*?)?\\s*$");
        for (String renderer : RendererConfigurations.getAllRenderersNames()) {
            Matcher match = pattern.matcher(renderer);
            if (match.find()) {
                SearchableMutableTreeNode node = null;
                try {
                    node = this.allRenderers.findChild(match.group(1));
                }
                catch (IllegalChildException illegalChildException) {
                    // empty catch block
                }
                if (node == null) {
                    node = new SearchableMutableTreeNode(match.group(1));
                    this.allRenderers.add(node);
                }
                if (match.groupCount() <= 1 || match.group(2) == null) continue;
                SearchableMutableTreeNode subNode = null;
                try {
                    subNode = node.findChild(match.group(2));
                }
                catch (IllegalChildException illegalChildException) {
                    // empty catch block
                }
                if (subNode != null) {
                    LOGGER.warn("Renderer {} found twice, ignoring repeated entry", (Object)renderer);
                    continue;
                }
                subNode = new SearchableMutableTreeNode(match.group(2));
                node.add(subNode);
                continue;
            }
            LOGGER.warn("Can't parse renderer name \"{}\"", (Object)renderer);
        }
        this.srvTree = new JTree(new DefaultTreeModel(this.allRenderers));
        this.checkTreeManager = new CheckTreeManager(this.srvTree);
        checkPanel.add(new JScrollPane(this.srvTree));
        checkPanel.setSize(400, 500);
    }

    public void showDialog() {
        if (!this.init) {
            this.build();
            this.init = true;
        }
        this.srvTree.validate();
        List<String> savedSelectedRenderers = CONFIGURATION.getSelectedRenderers();
        TreePath root = new TreePath(this.allRenderers);
        if (savedSelectedRenderers.isEmpty() || savedSelectedRenderers.size() == 1 && savedSelectedRenderers.get(0) == null) {
            this.checkTreeManager.getSelectionModel().clearSelection();
        } else if (savedSelectedRenderers.size() == 1 && savedSelectedRenderers.get(0).equals("All renderers")) {
            this.checkTreeManager.getSelectionModel().setSelectionPath(root);
        } else {
            Object object = root.getLastPathComponent();
            if (object instanceof SearchableMutableTreeNode) {
                SearchableMutableTreeNode rootNode = (SearchableMutableTreeNode)object;
                SearchableMutableTreeNode node = null;
                ArrayList<TreePath> selectedRenderersPath = new ArrayList<TreePath>(savedSelectedRenderers.size());
                for (String selectedRenderer : savedSelectedRenderers) {
                    try {
                        node = rootNode.findInBranch(selectedRenderer, true);
                    }
                    catch (IllegalChildException illegalChildException) {
                        // empty catch block
                    }
                    if (node == null) continue;
                    selectedRenderersPath.add(new TreePath(node.getPath()));
                }
                this.checkTreeManager.getSelectionModel().setSelectionPaths((TreePath[])selectedRenderersPath.toArray(TreePath[]::new));
            } else {
                LOGGER.error("Illegal node class in SelectRenderers.showDialog(): {}", (Object)root.getLastPathComponent().getClass().getSimpleName());
            }
        }
        int selectRenderers = JOptionPane.showOptionDialog(this, this, Messages.getGuiString("SelectRenderers"), 2, -1, null, null, null);
        if (selectRenderers == 0) {
            TreePath[] selected = this.checkTreeManager.getSelectionModel().getSelectionPaths();
            if (selected.length == 0) {
                if (CONFIGURATION.setSelectedRenderers("")) {
                    GuiManager.setReloadable(true);
                }
            } else if (selected.length == 1 && selected[0].getLastPathComponent() instanceof SearchableMutableTreeNode && ((SearchableMutableTreeNode)selected[0].getLastPathComponent()).getNodeName().equals(this.allRenderers.getNodeName())) {
                if (CONFIGURATION.setSelectedRenderers("All renderers")) {
                    GuiManager.setReloadable(true);
                }
            } else {
                ArrayList<String> selectedRenderers = new ArrayList<String>();
                for (TreePath path : selected) {
                    StringBuilder rendererName = new StringBuilder();
                    if (path.getPathComponent(0).equals(this.allRenderers)) {
                        for (int i = 1; i < path.getPathCount(); ++i) {
                            Object object = path.getPathComponent(i);
                            if (object instanceof SearchableMutableTreeNode) {
                                SearchableMutableTreeNode searchableMutableTreeNode = (SearchableMutableTreeNode)object;
                                if (!rendererName.isEmpty()) {
                                    rendererName.append(" ");
                                }
                                rendererName.append(searchableMutableTreeNode.getNodeName());
                                continue;
                            }
                            LOGGER.error("Invalid tree node component class {}", (Object)path.getPathComponent(i).getClass().getSimpleName());
                        }
                        if (rendererName.isEmpty()) continue;
                        selectedRenderers.add(rendererName.toString());
                        continue;
                    }
                    LOGGER.warn("Invalid renderer treepath encountered: {}", (Object)path.toString());
                }
                Collections.sort(selectedRenderers);
                if (CONFIGURATION.setSelectedRenderers(selectedRenderers)) {
                    GuiManager.setReloadable(true);
                }
            }
        }
    }
}

