/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui;

public class ViewLevel {
    public static final int NORMAL_INT = 0;
    public static final int ADVANCED_INT = 200;
    public static final int EXPERT_INT = 500;
    public static final int DEVELOPER_INT = 1000;
    public static final int UNKNOWN_INT = Integer.MIN_VALUE;
    public static final Integer NORMAL_INTEGER = 0;
    public static final Integer ADVANCED_INTEGER = 200;
    public static final Integer EXPERT_INTEGER = 500;
    public static final Integer DEVELOPER_INTEGER = 1000;
    public static final Integer UNKNOWN_INTEGER = Integer.MIN_VALUE;
    public static final ViewLevel NORMAL = new ViewLevel(0, "Normal");
    public static final ViewLevel ADVANCED = new ViewLevel(200, "Advanced");
    public static final ViewLevel EXPERT = new ViewLevel(500, "Expert");
    public static final ViewLevel DEVELOPER = new ViewLevel(1000, "Developer");
    public static final ViewLevel UNKNOWN = new ViewLevel(Integer.MIN_VALUE, "Unknown");
    public final int viewLevelInt;
    public final String viewLevelStr;

    private ViewLevel(int viewLevelInt, String viewLevelStr) {
        this.viewLevelInt = viewLevelInt;
        this.viewLevelStr = viewLevelStr;
    }

    public String toString() {
        return this.viewLevelStr;
    }

    public int toInt() {
        return this.viewLevelInt;
    }

    public Integer toInteger() {
        return switch (this.viewLevelInt) {
            case 0 -> NORMAL_INTEGER;
            case 200 -> ADVANCED_INTEGER;
            case 500 -> EXPERT_INTEGER;
            case 1000 -> DEVELOPER_INTEGER;
            case Integer.MIN_VALUE -> UNKNOWN_INTEGER;
            default -> throw new IllegalStateException("ViewLevel " + this.viewLevelStr + ", " + this.viewLevelInt + " is unknown.");
        };
    }

    public boolean isGreaterOrEqual(ViewLevel r) {
        return this.viewLevelInt >= r.viewLevelInt;
    }

    public static ViewLevel toViewLevel(String sArg) {
        return ViewLevel.toViewLevel(sArg, UNKNOWN);
    }

    public static ViewLevel toViewLevel(int val) {
        return ViewLevel.toViewLevel(val, UNKNOWN);
    }

    public static ViewLevel toViewLevel(int val, ViewLevel defaultViewLevel) {
        return switch (val) {
            case 0 -> NORMAL;
            case 200 -> ADVANCED;
            case 500 -> EXPERT;
            case 1000 -> DEVELOPER;
            case Integer.MIN_VALUE -> UNKNOWN;
            default -> defaultViewLevel;
        };
    }

    public static ViewLevel toViewLevel(String sArg, ViewLevel defaultViewLevel) {
        if (sArg == null) {
            return defaultViewLevel;
        }
        if (sArg.equalsIgnoreCase("Normal")) {
            return NORMAL;
        }
        if (sArg.equalsIgnoreCase("Advanced")) {
            return ADVANCED;
        }
        if (sArg.equalsIgnoreCase("Expert")) {
            return EXPERT;
        }
        if (sArg.equalsIgnoreCase("Developer")) {
            return DEVELOPER;
        }
        if (sArg.equalsIgnoreCase("Unknown")) {
            return UNKNOWN;
        }
        return defaultViewLevel;
    }
}

