/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui;

import com.jgoodies.looks.Options;
import com.sun.jna.Platform;
import jakarta.annotation.Nonnull;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.GuiConfiguration;
import net.pms.configuration.UmsConfiguration;
import net.pms.external.update.AutoUpdater;
import net.pms.gui.EConnectionState;
import net.pms.gui.IGui;
import net.pms.network.mediaserver.MediaServer;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.swing.AutoUpdateDialog;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.AnimatedIcon;
import net.pms.swing.components.CustomTabbedPaneUI;
import net.pms.swing.components.JAnimatedButton;
import net.pms.swing.components.JImageButton;
import net.pms.swing.gui.ViewLevel;
import net.pms.swing.gui.tabs.about.AboutTab;
import net.pms.swing.gui.tabs.general.GeneralTab;
import net.pms.swing.gui.tabs.navigation.NavigationShareTab;
import net.pms.swing.gui.tabs.shared.SharedContentTab;
import net.pms.swing.gui.tabs.status.StatusTab;
import net.pms.swing.gui.tabs.traces.TracesTab;
import net.pms.swing.gui.tabs.transcoding.TranscodingTab;
import net.pms.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGui
extends JFrame
implements IGui {
    private static final long serialVersionUID = 8723727186288427690L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaGui.class);
    private static final String ICON_BUTTON_QUIT = "button-quit.svg";
    private static final String ICON_BUTTON_RESTART = "button-restart.svg";
    private static final String ICON_BUTTON_RESTART_REQUIRED = "button-restart-requiredF%d.svg";
    private static final String ICON_BUTTON_WIF = "button-wif.svg";
    private static final Dimension STANDARD_SIZE = new Dimension(1000, 750);
    private static final Dimension MINIMUM_SIZE = new Dimension(640, 480);
    public static final String START_SERVICE = "start.service";
    private final AutoUpdater autoUpdater;
    private final UmsConfiguration configuration;
    private final GuiConfiguration guiConfiguration;
    private final JAnimatedButton reload = this.createAnimatedToolBarButton(Messages.getGuiString("RestartServer"), "button-restart.svg");
    private final AnimatedIcon restartRequiredIcon = new AnimatedIcon((JComponent)this.reload, true, AnimatedIcon.buildAnimation("button-restart-requiredF%d.svg", 0, 25, true, 800, 300, 15));
    private JTabbedPane tabbedPane;
    private GeneralTab generalTab;
    private NavigationShareTab navigationSettingsTab;
    private StatusTab statusTab;
    private TracesTab tracesTab;
    private SharedContentTab sharedContentTab;
    private TranscodingTab transcodingTab;
    private AboutTab aboutTab;
    private AnimatedIcon restartIcon;
    private AbstractButton webinterface;
    private JLabel status;
    private ViewLevel viewLevel = ViewLevel.UNKNOWN;
    private String statusLine = null;
    private Rectangle effectiveScreenBounds;
    private AbstractButton quit;

    public JavaGui(@Nonnull UmsConfiguration configuration, @Nonnull GuiConfiguration guiConfiguration) {
        super(guiConfiguration.getGraphicsConfiguration());
        String showScrollbars;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration can't be null");
        }
        this.setResizable(true);
        this.guiConfiguration = guiConfiguration;
        this.setGuiConfiguration();
        this.autoUpdater = PMS.getAutoUpdater();
        this.configuration = configuration;
        assert (this.configuration != null);
        Options.setDefaultIconSize(new Dimension(18, 18));
        Options.setUseNarrowButtons(true);
        this.viewLevel = configuration.isHideAdvancedOptions() ? ViewLevel.NORMAL : ViewLevel.ADVANCED;
        Options.setTabIconsEnabled(true);
        UIManager.put("jgoodies.popupDropShadowEnabled", null);
        SwingUtil.initializeLookAndFeel();
        if (this.autoUpdater != null) {
            this.autoUpdater.pollServer();
        }
        Integer twelve = 12;
        Integer fontPlain = 0;
        Integer fontBold = 1;
        UIDefaults.LazyValue dialogPlain12 = t -> new FontUIResource("Dialog", fontPlain, twelve);
        UIDefaults.LazyValue sansSerifPlain12 = t -> new FontUIResource("SansSerif", fontPlain, twelve);
        UIDefaults.LazyValue monospacedPlain12 = t -> new FontUIResource("Monospaced", fontPlain, twelve);
        UIDefaults.LazyValue dialogBold12 = t -> new FontUIResource("Dialog", fontBold, twelve);
        UIDefaults.LazyValue menuFont = dialogPlain12;
        UIDefaults.LazyValue fixedControlFont = monospacedPlain12;
        UIDefaults.LazyValue controlFont = dialogPlain12;
        UIDefaults.LazyValue messageFont = dialogPlain12;
        UIDefaults.LazyValue windowFont = dialogBold12;
        UIDefaults.LazyValue toolTipFont = sansSerifPlain12;
        UIDefaults.LazyValue iconFont = controlFont;
        String language = configuration.getLanguageTag();
        if (language != null && (language.equals("ja") || language.startsWith("zh") || language.equals("ko"))) {
            menuFont = sansSerifPlain12;
            fixedControlFont = sansSerifPlain12;
            controlFont = sansSerifPlain12;
            messageFont = sansSerifPlain12;
            windowFont = sansSerifPlain12;
            iconFont = sansSerifPlain12;
        }
        UIManager.put("Button.font", controlFont);
        UIManager.put("CheckBox.font", controlFont);
        UIManager.put("CheckBoxMenuItem.font", menuFont);
        UIManager.put("ComboBox.font", controlFont);
        UIManager.put("EditorPane.font", controlFont);
        UIManager.put("FileChooser.listFont", iconFont);
        UIManager.put("FormattedTextField.font", controlFont);
        UIManager.put("InternalFrame.titleFont", windowFont);
        UIManager.put("Label.font", controlFont);
        UIManager.put("List.font", controlFont);
        UIManager.put("PopupMenu.font", menuFont);
        UIManager.put("Menu.font", menuFont);
        UIManager.put("MenuBar.font", menuFont);
        UIManager.put("MenuItem.font", menuFont);
        UIManager.put("MenuItem.acceleratorFont", menuFont);
        UIManager.put("RadioButton.font", controlFont);
        UIManager.put("RadioButtonMenuItem.font", menuFont);
        UIManager.put("OptionPane.font", messageFont);
        UIManager.put("OptionPane.messageFont", messageFont);
        UIManager.put("OptionPane.buttonFont", messageFont);
        UIManager.put("Panel.font", controlFont);
        UIManager.put("PasswordField.font", controlFont);
        UIManager.put("ProgressBar.font", controlFont);
        UIManager.put("ScrollPane.font", controlFont);
        UIManager.put("Slider.font", controlFont);
        UIManager.put("Spinner.font", controlFont);
        UIManager.put("TabbedPane.font", controlFont);
        UIManager.put("Table.font", controlFont);
        UIManager.put("TableHeader.font", controlFont);
        UIManager.put("TextArea.font", fixedControlFont);
        UIManager.put("TextField.font", controlFont);
        UIManager.put("TextPane.font", controlFont);
        UIManager.put("TitledBorder.font", controlFont);
        UIManager.put("ToggleButton.font", controlFont);
        UIManager.put("ToolBar.font", menuFont);
        UIManager.put("ToolTip.font", toolTipFont);
        UIManager.put("Tree.font", controlFont);
        UIManager.put("Viewport.font", controlFont);
        this.setTitle(PMS.NAME);
        Image image = SwingUtil.getAppIconImage();
        if (image != null) {
            this.setIconImage(image);
        }
        this.setDefaultCloseOperation(2);
        JComponent jp = this.buildContent();
        switch (showScrollbars = System.getProperty("scrollbars", "").toLowerCase()) {
            case "true": {
                this.setContentPane(new JScrollPane(jp, 22, 32));
                break;
            }
            case "optional": {
                this.setContentPane(new JScrollPane(jp, 20, 30));
                break;
            }
            default: {
                this.setContentPane(jp);
            }
        }
        this.setTitle();
        this.setDefaultCloseOperation(1);
        if (Platform.isMac()) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JavaGui.this.setDefaultCloseOperation(0);
                    JavaGui.this.setExtendedState(1);
                }
            });
        }
        ToolTipManager.sharedInstance().setInitialDelay(400);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        ToolTipManager.sharedInstance().setReshowDelay(400);
        if (!configuration.isMinimized() && System.getProperty(START_SERVICE) == null) {
            this.setVisible(true);
        }
        if (configuration.isMinimized() && Platform.isMac()) {
            this.setVisible(true);
            this.setExtendedState(1);
        }
        if (configuration.isAutoUpdate()) {
            Timer t2 = new Timer();
            t2.schedule(new TimerTask(){

                @Override
                public void run() {
                    JavaGui.this.checkForUpdates(true);
                }
            }, 5000L);
        }
    }

    private void setTitle() {
        String projectName = PropertiesUtil.getProjectProperties().get("project.name");
        String projectVersion = PropertiesUtil.getProjectProperties().get("project.version");
        String title = projectName + " " + projectVersion;
        if (projectVersion.indexOf(45) > -1) {
            title = title + " - " + Messages.getGuiString("ForTestingOnly");
        }
        if (PMS.getTraceMode() == 2) {
            title = title + "  [" + Messages.getGuiString("Trace").toUpperCase() + "]";
        }
        this.setTitle(title);
    }

    private void setGuiConfiguration() {
        this.setMinimumSize(MINIMUM_SIZE);
        if (this.guiConfiguration != null) {
            Rectangle screenBounds = this.guiConfiguration.getScreenBounds();
            Rectangle windowBounds = this.guiConfiguration.getWindowBounds();
            String graphicsDevice = this.guiConfiguration.getGraphicsDevice();
            this.updateEffectiveScreenBounds(screenBounds, this.guiConfiguration.getScreenInsets());
            GraphicsConfiguration windowGraphicsConfiguration = this.getGraphicsConfiguration();
            if (windowBounds != null && this.effectiveScreenBounds != null && graphicsDevice != null && graphicsDevice.equals(windowGraphicsConfiguration.getDevice().getIDstring()) && screenBounds != null && screenBounds.equals(windowGraphicsConfiguration.getBounds())) {
                this.setWindowBounds(windowBounds);
            } else {
                Rectangle screen;
                Rectangle rectangle = screen = this.effectiveScreenBounds != null ? this.effectiveScreenBounds : windowGraphicsConfiguration.getBounds();
                if (screen.width >= JavaGui.STANDARD_SIZE.width && screen.height >= JavaGui.STANDARD_SIZE.height) {
                    this.setSize(STANDARD_SIZE);
                } else if (this.getWidth() < JavaGui.MINIMUM_SIZE.width || (double)this.getHeight() < MINIMUM_SIZE.getHeight()) {
                    this.setSize(MINIMUM_SIZE);
                }
                this.setLocationByPlatform(true);
            }
            int maximizedState = this.guiConfiguration.getWindowState() & 6;
            if (maximizedState != 0) {
                this.setExtendedState(this.getExtendedState() | maximizedState);
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (e.getSource() instanceof JavaGui) {
                        JavaGui.this.updateGuiConfiguration();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (e.getSource() instanceof JavaGui) {
                        JavaGui.this.updateGuiConfiguration();
                    }
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (e.getSource() instanceof JavaGui) {
                        JavaGui.this.updateGuiConfiguration();
                    }
                }
            });
        }
    }

    public ViewLevel getViewLevel() {
        return this.viewLevel;
    }

    public void setViewLevel(ViewLevel viewLevel) {
        if (viewLevel != ViewLevel.UNKNOWN) {
            this.viewLevel = viewLevel;
            this.applyViewLevel();
        }
    }

    public TranscodingTab getTranscodingTab() {
        return this.transcodingTab;
    }

    @Override
    public void enableWebUiButton() {
        if (PMS.getConfiguration().useWebPlayerServer()) {
            this.webinterface.setEnabled(true);
        }
    }

    public static URL getImageResource(String filename) {
        return SwingUtil.getImageResource("swing/" + filename);
    }

    public static ImageIcon readImageIcon(String filename) {
        return SwingUtil.getImageIcon("swing/" + filename);
    }

    public final JComponent buildContent() {
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(new JPanel());
        if (PMS.getConfiguration().useWebPlayerServer()) {
            this.webinterface = this.createToolBarButton(Messages.getGuiString("WebSettings"), ICON_BUTTON_WIF, Messages.getGuiString("ThisLaunchesOurWebSettings"));
            this.webinterface.setCursor(Cursor.getPredefinedCursor(12));
            this.webinterface.addActionListener(e -> {
                String error = null;
                if (PMS.get().getGuiServer() != null && StringUtils.isNotBlank(PMS.get().getGuiServer().getUrl())) {
                    try {
                        URI uri = new URI(PMS.get().getGuiServer().getUrl());
                        if (!PlatformUtils.INSTANCE.browseURI(uri.toString())) {
                            error = Messages.getGuiString("ErrorOccurredTryingLaunchBrowser");
                        }
                    }
                    catch (URISyntaxException se) {
                        LOGGER.error("Could not form a valid web gui server URI from \"{}\": {}", (Object)PMS.get().getGuiServer().getUrl(), (Object)se.getMessage());
                        LOGGER.trace("", se);
                        error = Messages.getGuiString("CouldNotFormValidUrl");
                    }
                } else {
                    error = Messages.getGuiString("CouldNotFormValidUrl");
                }
                if (error != null) {
                    JOptionPane.showMessageDialog(null, error, Messages.getGuiString("Error"), 0);
                }
            });
            this.webinterface.setEnabled(false);
            toolBar.add(this.webinterface);
            toolBar.addSeparator(new Dimension(20, 1));
        }
        this.restartIcon = (AnimatedIcon)this.reload.getIcon();
        this.restartRequiredIcon.start();
        this.setReloadable(false);
        this.reload.addActionListener(e -> {
            this.reload.setEnabled(false);
            PMS.get().resetMediaServer();
        });
        this.reload.setToolTipText(Messages.getGuiString("ThisRestartsMediaServices"));
        this.reload.setCursor(Cursor.getPredefinedCursor(12));
        toolBar.add(this.reload);
        toolBar.addSeparator(new Dimension(20, 1));
        this.quit = this.createToolBarButton(Messages.getGuiString("Quit"), ICON_BUTTON_QUIT);
        this.quit.setCursor(Cursor.getPredefinedCursor(12));
        this.quit.addActionListener(e -> PMS.quit());
        this.quit.getSize();
        toolBar.add(this.quit);
        if (System.getProperty(START_SERVICE) != null) {
            this.quit.setEnabled(false);
        }
        toolBar.add(new JPanel());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        toolBar.applyComponentOrientation(orientation);
        toolBar.setBorder(new EmptyBorder(new Insets(8, 0, 0, 0)));
        panel.add((Component)toolBar, "North");
        panel.add((Component)this.buildMain(), "Center");
        this.status = new JLabel("");
        this.status.setComponentOrientation(orientation);
        this.status.setBorder(BorderFactory.createEmptyBorder(0, 9, 8, 0));
        panel.add((Component)this.status, "South");
        return panel;
    }

    public JComponent buildMain() {
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setUI(new CustomTabbedPaneUI());
        this.statusTab = new StatusTab();
        this.tracesTab = new TracesTab(this.configuration, this);
        this.generalTab = new GeneralTab(this.configuration, this);
        this.navigationSettingsTab = new NavigationShareTab(this.configuration, this);
        this.sharedContentTab = new SharedContentTab(this.configuration, this);
        this.transcodingTab = new TranscodingTab(this.configuration, this);
        this.aboutTab = new AboutTab();
        this.tabbedPane.addTab(Messages.getGuiString("Status"), this.statusTab.build());
        this.tabbedPane.addTab(Messages.getGuiString("Logs"), this.tracesTab.build());
        this.tabbedPane.addTab(Messages.getGuiString("GeneralSettings"), this.generalTab.build());
        if (!this.configuration.isHideAdvancedOptions()) {
            this.tabbedPane.addTab(Messages.getGuiString("NavigationSettings"), this.navigationSettingsTab.build());
        }
        this.tabbedPane.addTab(Messages.getGuiString("SharedContent"), this.sharedContentTab.build());
        this.tabbedPane.addTab(Messages.getGuiString("TranscodingSettings"), this.transcodingTab.build());
        this.tabbedPane.addTab(Messages.getGuiString("About"), this.aboutTab.build());
        this.tabbedPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        this.tabbedPane.setComponentOrientation(orientation);
        return this.tabbedPane;
    }

    private void applyViewLevel() {
        this.tracesTab.applyViewLevel();
        this.tabbedPane.setComponentAt(2, this.generalTab.build());
        if (this.configuration.isHideAdvancedOptions()) {
            if (this.tabbedPane.getComponentAt(3) == this.navigationSettingsTab.getComponent()) {
                this.tabbedPane.remove(3);
            }
            this.tabbedPane.setComponentAt(4, this.transcodingTab.build());
        } else {
            if (this.tabbedPane.getComponentAt(3) != this.navigationSettingsTab.getComponent()) {
                this.tabbedPane.insertTab(Messages.getGuiString("NavigationSettings"), null, this.navigationSettingsTab.build(), null, 3);
            }
            this.tabbedPane.setComponentAt(5, this.transcodingTab.build());
        }
    }

    public void applyLanguage() {
        this.setTitle();
        this.webinterface.setText(Messages.getGuiString("WebSettings"));
        this.webinterface.setToolTipText(Messages.getGuiString("ThisLaunchesOurWebSettings"));
        this.reload.setText(Messages.getGuiString("RestartServer"));
        if (this.reload.getIcon() == this.restartRequiredIcon) {
            this.reload.setToolTipText(Messages.getGuiString("TheServerHasToRestarted"));
        } else {
            this.reload.setToolTipText(Messages.getGuiString("ThisRestartsMediaServices"));
        }
        this.quit.setText(Messages.getGuiString("Quit"));
        int tabIndex = 0;
        this.tabbedPane.setTitleAt(tabIndex, Messages.getGuiString("Status"));
        this.statusTab.applyLanguage();
        this.tabbedPane.setTitleAt(++tabIndex, Messages.getGuiString("Logs"));
        this.tracesTab.applyLanguage();
        this.tabbedPane.setTitleAt(++tabIndex, Messages.getGuiString("GeneralSettings"));
        this.tabbedPane.setComponentAt(tabIndex, this.generalTab.build());
        if (!this.configuration.isHideAdvancedOptions()) {
            this.tabbedPane.setTitleAt(++tabIndex, Messages.getGuiString("NavigationSettings"));
            this.tabbedPane.setComponentAt(tabIndex, this.navigationSettingsTab.build());
        }
        this.tabbedPane.setTitleAt(++tabIndex, Messages.getGuiString("SharedContent"));
        this.tabbedPane.setComponentAt(tabIndex, this.sharedContentTab.build());
        this.tabbedPane.setTitleAt(++tabIndex, Messages.getGuiString("TranscodingSettings"));
        this.tabbedPane.setComponentAt(tabIndex, this.transcodingTab.build());
        this.tabbedPane.setTitleAt(++tabIndex, Messages.getGuiString("About"));
        this.tabbedPane.setComponentAt(tabIndex, this.aboutTab.build());
    }

    protected JImageButton createToolBarButton(String text, String iconName) {
        JImageButton button = new JImageButton(text, iconName);
        button.setFocusable(false);
        return button;
    }

    protected JAnimatedButton createAnimatedToolBarButton(String text, String iconName) {
        JAnimatedButton button = new JAnimatedButton(text, iconName);
        button.setFocusable(false);
        return button;
    }

    protected JImageButton createToolBarButton(String text, String iconName, String toolTipText) {
        JImageButton button = this.createToolBarButton(text, iconName);
        button.setToolTipText(toolTipText);
        button.setBorderPainted(false);
        return button;
    }

    @Override
    public void appendLog(String msg) {
        SwingUtilities.invokeLater(() -> this.tracesTab.append(msg));
    }

    @Override
    public void setConnectionState(EConnectionState connectionState) {
        SwingUtilities.invokeLater(() -> this.statusTab.setConnectionState(connectionState));
    }

    @Override
    public void setCurrentBitrate(int sizeinMb) {
        this.statusTab.setCurrentBitrate(sizeinMb);
    }

    @Override
    public void setPeakBitrate(int sizeinMb) {
        this.statusTab.setPeakBitrate(sizeinMb);
    }

    @Override
    public void setReloadable(boolean required) {
        SwingUtilities.invokeLater(() -> {
            if (required) {
                if (this.reload.getIcon() == this.restartIcon) {
                    this.restartIcon.setNextStage(new AnimatedIcon.AnimatedIconStage(AnimatedIcon.AnimatedIconType.DEFAULTICON, this.restartRequiredIcon, false));
                    this.reload.setToolTipText(Messages.getGuiString("TheServerHasToRestarted"));
                }
            } else if (this.restartRequiredIcon == this.reload.getIcon()) {
                this.reload.setToolTipText(Messages.getGuiString("ThisRestartsMediaServices"));
                this.restartRequiredIcon.setNextStage(new AnimatedIcon.AnimatedIconStage(AnimatedIcon.AnimatedIconType.DEFAULTICON, this.restartIcon, false));
            }
            this.reload.setEnabled(true);
        });
    }

    @Override
    public void addEngines() {
        this.transcodingTab.addEngines();
    }

    public void checkForUpdates(boolean isStartup) {
        if (this.autoUpdater != null) {
            try {
                if (!isStartup) {
                    this.autoUpdater.pollServer();
                }
                AutoUpdateDialog.showIfNecessary(this, this.autoUpdater, isStartup);
            }
            catch (NoClassDefFoundError ncdfe) {
                LOGGER.error("Error displaying AutoUpdateDialog", ncdfe);
            }
        }
    }

    @Override
    public void setStatusLine(String line) {
        this.statusLine = line;
        if (line == null) {
            line = " ";
        }
        this.status.setBorder(BorderFactory.createEmptyBorder(0, 12, 9, 0));
        this.status.setText(line);
    }

    @Override
    public void setSecondaryStatusLine(String line) {
        if (line == null) {
            line = this.statusLine != null ? this.statusLine : " ";
        }
        this.status.setBorder(BorderFactory.createEmptyBorder(0, 12, 9, 0));
        this.status.setText(line);
    }

    @Override
    public void addRenderer(Renderer renderer) {
        this.statusTab.addRenderer(renderer);
    }

    @Override
    public void serverReady() {
        this.generalTab.addRenderers();
    }

    @Override
    public void updateServerStatus() {
        if (MediaServer.isStarted()) {
            this.statusTab.setMediaServerBind(MediaServer.getAddress());
        } else {
            this.statusTab.setMediaServerBind("-");
        }
        if (PMS.get().getWebPlayerServer() != null && PMS.get().getWebPlayerServer().getServer() != null) {
            this.statusTab.setInterfaceServerBind(PMS.get().getWebPlayerServer().getAddress());
        } else {
            this.statusTab.setInterfaceServerBind("-");
        }
    }

    @Override
    public void setMediaScanStatus(boolean running) {
        this.sharedContentTab.setMediaScanEnabled(running);
    }

    @Override
    public void showErrorMessage(String message, String title) {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), message, title, 0);
    }

    @Override
    public void setConfigurationChanged(String key) {
    }

    @Override
    public void setMemoryUsage(int maxMemory, int usedMemory, int dbCacheMemory, int bufferMemory) {
        this.statusTab.setMemoryUsage(maxMemory, usedMemory, dbCacheMemory, bufferMemory);
    }

    private void updateGuiConfiguration() {
        Rectangle windowBounds;
        if (this.guiConfiguration == null) {
            return;
        }
        int state = this.getExtendedState();
        this.guiConfiguration.setWindowState(state);
        if (state == 0) {
            this.guiConfiguration.setWindowBounds(this.getBounds());
        } else if ((state & 6) != 6) {
            Rectangle windowBounds2 = this.getBounds();
            Rectangle storedBounds = this.guiConfiguration.getWindowBounds();
            if ((state & 2) != 0) {
                windowBounds2.x = storedBounds.x;
                windowBounds2.width = storedBounds.width;
            } else if ((state & 4) != 0) {
                windowBounds2.y = storedBounds.y;
                windowBounds2.height = storedBounds.height;
            }
            this.guiConfiguration.setWindowBounds(windowBounds2);
        }
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        this.guiConfiguration.setScreenBounds(screenBounds);
        Insets screenInsets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
        this.guiConfiguration.setScreenInsets(screenInsets);
        if (this.guiConfiguration.isDirty() && this.updateEffectiveScreenBounds(screenBounds, screenInsets) && (windowBounds = this.guiConfiguration.getWindowBounds()) != null && this.effectiveScreenBounds != null && !this.effectiveScreenBounds.contains(windowBounds)) {
            this.setWindowBounds(windowBounds);
        }
        String deviceString = this.getGraphicsConfiguration().getDevice().getIDstring();
        this.guiConfiguration.setGraphicsDevice(deviceString);
        this.guiConfiguration.save();
    }

    private boolean updateEffectiveScreenBounds(Rectangle screenBounds, Insets screenInsets) {
        if (screenBounds == null) {
            return false;
        }
        Insets tmpInsets = screenInsets == null ? new Insets(0, 0, 0, 0) : screenInsets;
        Rectangle newEffectiveScreenBounds = new Rectangle(screenBounds.x, screenBounds.y, screenBounds.width - tmpInsets.left - tmpInsets.right, screenBounds.height - tmpInsets.top - tmpInsets.bottom);
        if (!newEffectiveScreenBounds.equals(this.effectiveScreenBounds)) {
            this.effectiveScreenBounds = newEffectiveScreenBounds;
            return true;
        }
        return false;
    }

    private void setWindowBounds(Rectangle windowBounds) {
        if (windowBounds == null) {
            return;
        }
        if (this.effectiveScreenBounds == null) {
            this.setBounds(windowBounds);
            return;
        }
        int deltaX = 0;
        if (windowBounds.x + windowBounds.width > this.effectiveScreenBounds.x + this.effectiveScreenBounds.width) {
            deltaX = this.effectiveScreenBounds.x + this.effectiveScreenBounds.width - windowBounds.x - windowBounds.width;
        }
        if (windowBounds.x < this.effectiveScreenBounds.x) {
            deltaX = this.effectiveScreenBounds.x - windowBounds.x;
        }
        int deltaY = 0;
        if (windowBounds.y + windowBounds.height > this.effectiveScreenBounds.y + this.effectiveScreenBounds.height) {
            deltaY = this.effectiveScreenBounds.y + this.effectiveScreenBounds.height - windowBounds.y - windowBounds.height;
        }
        if (windowBounds.y < this.effectiveScreenBounds.y) {
            deltaY = this.effectiveScreenBounds.y - windowBounds.y;
        }
        if (deltaX != 0 || deltaY != 0) {
            windowBounds.translate(deltaX, deltaY);
        }
        if (!this.effectiveScreenBounds.contains(windowBounds)) {
            Rectangle newWindowBounds = windowBounds.intersection(this.effectiveScreenBounds);
            if (newWindowBounds.width < JavaGui.MINIMUM_SIZE.width) {
                newWindowBounds.width = JavaGui.MINIMUM_SIZE.width;
            }
            if (newWindowBounds.height < JavaGui.MINIMUM_SIZE.height) {
                newWindowBounds.height = JavaGui.MINIMUM_SIZE.height;
            }
            windowBounds = newWindowBounds;
        }
        this.setBounds(windowBounds);
    }
}

