/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import jakarta.annotation.Nonnull;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import net.pms.PMS;
import net.pms.swing.components.SpinnerIntModel;

public class CustomJSpinner
extends JSpinner {
    public CustomJSpinner(boolean enterMoveFocus) {
        this(new SpinnerIntModel(0), enterMoveFocus);
    }

    public CustomJSpinner(@Nonnull SpinnerModel model, boolean enterMoveFocus) {
        super(model);
        if (model instanceof SpinnerIntModel) {
            this.addMouseWheelListener(new MouseWheelRoll(this, ((SpinnerIntModel)model).getMinimum(), ((SpinnerIntModel)model).getMaximum(), ((SpinnerIntModel)model).getStepSize()));
        }
        if (enterMoveFocus && this.getEditor() instanceof IntegerEditor) {
            ((IntegerEditor)this.getEditor()).getTextField().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        FocusManager.getCurrentManager().focusNextComponent();
                    }
                }
            });
        }
    }

    @Override
    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof SpinnerDateModel) {
            return new JSpinner.DateEditor(this);
        }
        if (model instanceof SpinnerNumberModel) {
            return new JSpinner.NumberEditor(this);
        }
        if (model instanceof SpinnerListModel) {
            return new JSpinner.ListEditor(this);
        }
        if (model instanceof SpinnerIntModel) {
            return new IntegerEditor(this);
        }
        return new JSpinner.DefaultEditor(this);
    }

    protected static class MouseWheelRoll
    implements MouseWheelListener {
        private int minimum;
        private int maximum;
        private int stepSize;
        private CustomJSpinner spinner;

        private MouseWheelRoll(CustomJSpinner spinner, int minimum, int maximum, int stepSize) {
            this.spinner = spinner;
            this.minimum = minimum;
            this.maximum = maximum;
            this.stepSize = stepSize;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!this.spinner.isEnabled()) {
                return;
            }
            if (e.getScrollType() != 0) {
                return;
            }
            int value = (Integer)this.spinner.getValue();
            if (e.getWheelRotation() < 0 && (value -= e.getWheelRotation() * this.stepSize) == this.minimum + this.stepSize && this.minimum % this.stepSize != 0) {
                value = this.minimum / this.stepSize * this.stepSize + this.stepSize;
            } else if (e.getWheelRotation() > 0 && value == this.maximum - this.stepSize && this.maximum % this.stepSize != 0) {
                value = this.maximum / this.stepSize * this.stepSize;
            }
            value = Math.min(Math.max(value, this.minimum), this.maximum);
            this.spinner.setValue(value);
        }
    }

    public static class IntegerEditor
    extends JSpinner.DefaultEditor {
        public IntegerEditor(JSpinner spinner) {
            this(spinner, NumberFormat.getIntegerInstance(PMS.getLocale()));
        }

        private IntegerEditor(JSpinner spinner, NumberFormat format) {
            super(spinner);
            if (!(spinner.getModel() instanceof SpinnerIntModel)) {
                throw new IllegalArgumentException("model not a SpinnerIntModel");
            }
            format.setGroupingUsed(false);
            format.setMaximumFractionDigits(0);
            SpinnerIntModel model = (SpinnerIntModel)spinner.getModel();
            IntegerEditorFormatter formatter = new IntegerEditorFormatter(model, format);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            JFormattedTextField ftf = this.getTextField();
            ftf.setEditable(true);
            ftf.setFormatterFactory(factory);
            ftf.setHorizontalAlignment(4);
            try {
                String minString = formatter.valueToString(model.getMinimum());
                String maxString = formatter.valueToString(model.getMaximum());
                ftf.setColumns((int)Math.round(0.7 * (double)Math.max(maxString.length(), minString.length())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public SpinnerIntModel getModel() {
            return (SpinnerIntModel)this.getSpinner().getModel();
        }

        private static class IntegerEditorFormatter
        extends NumberFormatter {
            private final SpinnerIntModel model;

            IntegerEditorFormatter(SpinnerIntModel model, NumberFormat format) {
                super(format);
                this.model = model;
                this.setValueClass(model.getValue().getClass());
            }

            public Comparable getMinimum() {
                return Integer.valueOf(this.model.getMinimum());
            }

            public Comparable getMaximum() {
                return Integer.valueOf(this.model.getMaximum());
            }
        }
    }
}

