/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.external.update.AutoUpdater;
import net.pms.gui.GuiManager;
import net.pms.platform.PlatformUtils;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.SvgMultiResolutionImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SysTray {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTray.class);
    private static SysTray instance = null;
    private boolean updateAvailable = false;
    private SystemTray systemTray;
    private TrayIcon trayIcon;

    private SysTray() {
        if (SystemTray.isSupported()) {
            this.systemTray = SystemTray.getSystemTray();
            Image trayIconImage = SysTray.resolveTrayIcon(this.updateAvailable);
            PopupMenu popup = new PopupMenu();
            if (PMS.getConfiguration().useWebPlayerServer()) {
                MenuItem webPlayerItem = new MenuItem(Messages.getGuiString("WebPlayer"));
                webPlayerItem.addActionListener(e -> PlatformUtils.INSTANCE.browseURI(PMS.get().getWebPlayerServer().getUrl()));
                popup.add(webPlayerItem);
            }
            MenuItem webGuiItem = new MenuItem(Messages.getGuiString("Settings"));
            webGuiItem.addActionListener(e -> PlatformUtils.INSTANCE.browseURI(PMS.get().getGuiServer().getUrl()));
            popup.add(webGuiItem);
            MenuItem oldGuiItem = new MenuItem(Messages.getGuiString("SettingsOld"));
            oldGuiItem.addActionListener(e -> GuiManager.showSwingFrame());
            popup.add(oldGuiItem);
            MenuItem quitItem = new MenuItem(Messages.getGuiString("Quit"));
            quitItem.addActionListener(e -> PMS.quit());
            popup.add(quitItem);
            this.trayIcon = new TrayIcon(trayIconImage, PMS.getConfiguration().getServerName(), popup);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(e -> PlatformUtils.INSTANCE.browseURI(PMS.get().getGuiServer().getUrl()));
            try {
                if (this.systemTray.getTrayIcons().length > 0) {
                    this.systemTray.remove(this.systemTray.getTrayIcons()[0]);
                }
                this.systemTray.add(this.trayIcon);
            }
            catch (AWTException e2) {
                LOGGER.debug("Caught exception", e2);
            }
            AutoUpdater.addChangeListener(e -> {
                Object patt3615$temp;
                if (this.systemTray != null && (patt3615$temp = e.getSource()) instanceof AutoUpdater) {
                    boolean isUpdateAvailable;
                    AutoUpdater autoUpdater = (AutoUpdater)patt3615$temp;
                    boolean bl = isUpdateAvailable = autoUpdater.getState() == AutoUpdater.State.UPDATE_AVAILABLE;
                    if (this.updateAvailable != isUpdateAvailable) {
                        this.updateAvailable = isUpdateAvailable;
                        SwingUtilities.invokeLater(() -> {
                            if (this.trayIcon != null) {
                                Image oldImage = this.trayIcon.getImage();
                                Image trayIconImage1 = SysTray.resolveTrayIcon(this.updateAvailable);
                                this.trayIcon.setImage(trayIconImage1);
                                oldImage.flush();
                            }
                        });
                    }
                }
            });
        }
    }

    public static void addSystemTray() {
        if (SystemTray.isSupported() && instance == null) {
            instance = new SysTray();
        }
    }

    private static Image resolveTrayIcon(boolean updateAvailable) {
        Element elem;
        String icon = PlatformUtils.INSTANCE.getTrayIcon();
        SVGDocument document = SvgMultiResolutionImage.getSVGDocument(SwingUtil.getImageResource(icon + ".svg"));
        if (updateAvailable && (elem = document.getElementById("updatable")) != null) {
            elem.setAttribute("opacity", "1");
        }
        return new SvgMultiResolutionImage(document);
    }

    private static /* synthetic */ BufferedImage[] lambda$resolveTrayIcon$7(int x$0) {
        return new BufferedImage[x$0];
    }
}

