/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.pms.renderers.Renderer;
import net.pms.store.item.ArchiveEntry;
import net.pms.util.ArchiveFileInputStream;
import net.pms.util.IPushOutput;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenZipEntry
extends ArchiveEntry
implements IPushOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(SevenZipEntry.class);

    public SevenZipEntry(Renderer renderer, File file, String entryName, long length) {
        super(renderer, file, entryName, length);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return ArchiveFileInputStream.getSevenZipEntryInputStream(this.file, this.entryName);
    }

    @Override
    public void push(OutputStream out) throws IOException {
        Runnable r = () -> {
            try (RandomAccessFile rf = new RandomAccessFile(this.file, "r");
                 IInArchive arc = SevenZip.openInArchive(null, new RandomAccessFileInStream(rf));){
                ISimpleInArchive simpleInArchive = arc.getSimpleInterface();
                ISimpleInArchiveItem realItem = null;
                for (ISimpleInArchiveItem item : simpleInArchive.getArchiveItems()) {
                    if (!item.getPath().equals(this.entryName)) continue;
                    realItem = item;
                    break;
                }
                if (realItem == null) {
                    LOGGER.trace("No such item " + this.entryName + " found in archive");
                    return;
                }
                realItem.extractSlow(data -> {
                    try {
                        out.write(data);
                    }
                    catch (IOException e) {
                        LOGGER.debug("Caught exception", e);
                        throw new SevenZipException();
                    }
                    return data.length;
                });
            }
            catch (FileNotFoundException | SevenZipException e) {
                LOGGER.debug("Unpack error. Possibly harmless.", (Object)e.getMessage());
            }
            catch (IOException e) {
                LOGGER.error("Unpack error. Possibly harmless.", (Object)e.getMessage());
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exception", e);
                }
            }
        };
        new Thread(r, "7Zip Extractor").start();
    }
}

