/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import com.sun.jna.Platform;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Set;
import net.pms.database.MediaTableCoverArtArchive;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.formats.FormatFactory;
import net.pms.media.MediaType;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.parsers.FFmpegParser;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.store.MediaInfoStore;
import net.pms.store.MediaStatusStore;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.SystemFileResource;
import net.pms.store.SystemFilesHelper;
import net.pms.store.container.ChapterFileTranscodeVirtualFolder;
import net.pms.store.container.VirtualFolder;
import net.pms.util.FileUtil;
import net.pms.util.InputFile;
import net.pms.util.ProcessUtil;
import org.apache.commons.lang3.StringUtils;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealFile
extends StoreItem
implements SystemFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealFile.class);
    private final Object displayNameBaseLock = new Object();
    private String lang;
    private volatile String baseNamePrettified;
    private final File file;
    private boolean addToMediaLibrary = true;
    private String name;
    private volatile String baseNameWithoutExtension;
    private int splitTrack;

    public RealFile(Renderer renderer, File file) {
        this(renderer, file, null);
    }

    public RealFile(Renderer renderer, File file, String name) {
        super(renderer);
        this.file = file;
        this.name = name;
        this.setLastModified(file.lastModified());
    }

    private static boolean isUploadResource(File file, int type) {
        if (type == 1 || type == 4) {
            try {
                if (Files.size(file.toPath()) == (long)"<UPLOAD RESOURCE>".length()) {
                    LOGGER.trace("isUploadResource true for {}", (Object)file.getAbsolutePath());
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error("cannot check file size", e);
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        boolean valid;
        if (this.file == null || !this.file.exists() || !this.file.isFile()) {
            return false;
        }
        this.resolveFormat();
        if (this.getType() == 64) {
            return false;
        }
        if (RealFile.isUploadResource(this.file, this.getType())) {
            return true;
        }
        boolean bl = valid = this.getFormat() != null;
        if (valid && this.getParent() != null && this.getParent().getDefaultRenderer() != null && this.getParent().getDefaultRenderer().isUseMediaInfo()) {
            this.run();
            if (this.getType() != 8 && this.getMediaInfo() != null) {
                if (this.getMediaInfo().getDefaultVideoTrack() != null && this.getMediaInfo().getDefaultVideoTrack().isEncrypted()) {
                    valid = false;
                    LOGGER.info("The file {} is encrypted. It will be hidden", (Object)this.file.getAbsolutePath());
                } else if (this.getMediaInfo().getContainer() == null || this.getMediaInfo().getContainer().equals("und")) {
                    this.getMediaInfo().setMediaParser(null);
                    InputFile inputfile = new InputFile();
                    inputfile.setFile(this.file);
                    this.getMediaInfo().setContainer(null);
                    FFmpegParser.parse(this.getMediaInfo(), inputfile, this.getFormat(), this.getType());
                    if (this.getMediaInfo().getContainer() == null) {
                        valid = false;
                        LOGGER.info("The file {} could not be parsed. It will be hidden", (Object)this.file.getAbsolutePath());
                    }
                }
            }
            if (this.getParent().getDefaultRenderer().isMediaInfoThumbnailGeneration()) {
                this.checkThumbnail();
            }
        } else if (this.getType() == 8) {
            return false;
        }
        return valid;
    }

    @Override
    public boolean isRendererAllowed() {
        return this.renderer.hasShareAccess(this.getFile());
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("File not found: {}", (Object)this.getFile().getAbsolutePath());
            return null;
        }
    }

    @Override
    public long length() {
        if (this.isTranscoded() && this.getTranscodingSettings().getEngine().type() != 2) {
            return 0x7FFFFFFF7FFFFFFFL;
        }
        if (this.getMediaInfo() != null && this.getMediaInfo().isMediaParsed()) {
            return this.getMediaInfo().getSize();
        }
        return this.getFile().length();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void resolveFormat() {
        if (this.getFormat() == null) {
            this.setFormat(FormatFactory.getAssociatedFormat(this.getFile().getAbsolutePath()));
        }
        super.resolveFormat();
    }

    @Override
    public String getFileName() {
        return ProcessUtil.getSystemPathName(this.getFile().getAbsolutePath());
    }

    @Override
    public String getSystemName() {
        String filename = this.getFileName();
        if (this.isInsideTranscodeFolder() || this.getParent() instanceof ChapterFileTranscodeVirtualFolder) {
            if (this.isTranscoded()) {
                filename = filename.concat(">e").concat(this.getTranscodingSettings().getEngine().getName());
            }
            if (this.getMediaAudio() != null && this.getMediaAudio().getId() != 0) {
                filename = filename.concat(">a").concat(String.valueOf(this.getMediaAudio().getId()));
            }
            if (this.getMediaSubtitle() != null && this.getMediaSubtitle().getId() != 0) {
                filename = filename.concat(">s").concat(String.valueOf(this.getMediaSubtitle().getId()));
            }
            if (this.getSplitRange() != null) {
                filename = filename.concat(">c").concat(String.valueOf(this.getSplitRange().getStartOrZero()));
            }
        }
        return filename;
    }

    @Override
    public synchronized void resolve() {
        if (this.file == null) {
            LOGGER.error("RealFile points to no physical file. ");
            return;
        }
        if (this.file.isFile() && (this.getMediaInfo() == null || !this.getMediaInfo().isMediaParsed())) {
            Boolean useSymlinks = this.renderer.getUmsConfiguration().isUseSymlinksTargetFile();
            Object filename = useSymlinks != false && FileUtil.isSymbolicLink(this.file) ? FileUtil.getRealFile(this.file).getAbsolutePath() : this.file.getAbsolutePath();
            if (this.getSplitTrack() > 0) {
                filename = (String)filename + "#SplitTrack" + this.getSplitTrack();
            }
            InputFile input = new InputFile();
            input.setFile(this.file);
            this.resolveFormat();
            this.setMediaInfo(MediaInfoStore.getMediaInfo((String)filename, this.file, this.getFormat(), this.getType()));
            this.setMediaStatus(MediaStatusStore.getMediaStatus(this.renderer.getAccountUserId(), (String)filename));
        }
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        MediaType mediaType;
        File cachedThumbnail = null;
        MediaType mediaType2 = mediaType = this.getMediaInfo() != null ? this.getMediaInfo().getMediaType() : MediaType.UNKNOWN;
        if (mediaType == MediaType.AUDIO || mediaType == MediaType.VIDEO) {
            StoreContainer storeContainer;
            Object thumbFolder;
            String alternativeFolder = this.renderer.getUmsConfiguration().getAlternateThumbFolder();
            ArrayList<Object> folders = new ArrayList<Object>(2);
            if (this.file.getParentFile() != null) {
                folders.add(null);
            }
            if (StringUtils.isNotBlank(alternativeFolder) && ((File)(thumbFolder = new File(alternativeFolder))).isDirectory() && ((File)thumbFolder).exists()) {
                folders.add(thumbFolder);
            }
            for (File storeContainer2 : folders) {
                File audioVideoFile = storeContainer2 == null ? this.file : new File(storeContainer2, this.file.getName());
                Set<File> potentials = SystemFilesHelper.getPotentialFileThumbnails(audioVideoFile, true);
                if (potentials.isEmpty()) continue;
                cachedThumbnail = potentials.iterator().next();
                break;
            }
            if (cachedThumbnail == null && mediaType == MediaType.AUDIO && (storeContainer = this.getParent()) instanceof VirtualFolder) {
                VirtualFolder virtualFolder = (VirtualFolder)storeContainer;
                cachedThumbnail = virtualFolder.getPotentialCover();
            }
        }
        boolean hasAlreadyEmbeddedCoverArt = this.getType() == 1 && this.getMediaInfo() != null && this.getMediaInfo().getThumbnail() != null;
        DLNAThumbnailInputStream result = null;
        try {
            if (cachedThumbnail != null && !hasAlreadyEmbeddedCoverArt) {
                result = DLNAThumbnailInputStream.toThumbnailInputStream(new FileInputStream(cachedThumbnail));
            } else if (this.getMediaInfo() != null && this.getMediaInfo().getThumbnail() != null) {
                result = this.getMediaInfo().getThumbnailInputStream();
            }
        }
        catch (IOException e) {
            LOGGER.debug("An error occurred while getting thumbnail for \"{}\", using generic thumbnail instead: {}", (Object)this.getName(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result != null ? result : super.getThumbnailInputStream();
    }

    @Override
    public void checkThumbnail() {
        InputFile input = new InputFile();
        input.setFile(this.getFile());
        this.checkThumbnail(input);
    }

    @Override
    public String getThumbnailURL(DLNAImageProfile profile) {
        if (this.getType() == 2 && !this.renderer.getUmsConfiguration().getImageThumbnailsEnabled()) {
            return null;
        }
        return super.getThumbnailURL(profile);
    }

    @Override
    public boolean isSubSelectable() {
        return true;
    }

    @Override
    public String write() {
        return this.getName() + ">" + this.getFile().getAbsolutePath();
    }

    @Override
    public synchronized void syncResolve() {
        super.syncResolve();
        if (this.mediaInfo != null && this.mediaInfo.isVideo() && this.getFile() != null) {
            MediaInfoStore.setMetadataFromFileName(this.getFile(), this.mediaInfo);
        }
        this.checkCoverThumb();
    }

    protected void checkCoverThumb() {
        String mbReleaseId;
        if (this.getMediaInfo() != null && this.getMediaInfo().isAudio() && this.getMediaInfo().hasAudioMetadata() && !StringUtils.isAllBlank(mbReleaseId = this.getMediaInfo().getAudioMetadata().getMbidRecord())) {
            try {
                if (!MediaTableCoverArtArchive.hasCover(mbReleaseId)) {
                    AudioFile af = "mp2".equalsIgnoreCase(FileUtil.getExtension(this.getFile())) ? AudioFileIO.readAs(this.getFile(), "mp3") : AudioFileIO.read(this.getFile());
                    Tag t = af.getTag();
                    LOGGER.trace("no artwork in MediaTableCoverArtArchive table");
                    if (t.getFirstArtwork() != null) {
                        byte[] artBytes = t.getFirstArtwork().getBinaryData();
                        MediaTableCoverArtArchive.writeMBID(mbReleaseId, new ByteArrayInputStream(artBytes));
                        LOGGER.trace("added cover to MediaTableCoverArtArchive");
                    } else {
                        LOGGER.trace("no artwork in TAG");
                    }
                } else {
                    LOGGER.trace("cover already exists in MediaTableCoverArtArchive");
                }
            }
            catch (IOException | CannotReadException | InvalidAudioFrameException | ReadOnlyFileException | TagException e) {
                LOGGER.trace("checkCoverThumb failed.", e);
            }
        }
    }

    @Override
    public boolean isFullyPlayedAware() {
        return true;
    }

    @Override
    public boolean isFullyPlayed() {
        return this.getFile() != null && this.getMediaStatus() != null && this.getMediaStatus().isFullyPlayed();
    }

    @Override
    public void setFullyPlayed(boolean fullyPlayed) {
        if (this.getFile() != null) {
            MediaStatusStore.setFullyPlayed(this.getFile().getAbsolutePath(), this.renderer.getAccountUserId(), fullyPlayed, null);
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.file == null) {
                return null;
            }
            if (this.file.getName().trim().isEmpty()) {
                if (Platform.isWindows()) {
                    this.name = PlatformUtils.INSTANCE.getDiskLabel(this.file);
                }
                this.name = this.name != null && this.name.length() > 0 ? this.file.getAbsolutePath().substring(0, 1) + ":\\ [" + this.name + "]" : this.file.getAbsolutePath().substring(0, 1);
            } else {
                this.name = this.file.getName();
            }
        }
        return this.name.replaceAll("_imdb([^_]+)_", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocalizedDisplayName(String lang) {
        Object object = this.displayNameBaseLock;
        synchronized (object) {
            lang = CONFIGURATION.getTranslationLanguage(lang);
            if (lang != null && !lang.equals(this.lang) || this.lang != null) {
                this.lang = lang;
                this.baseNamePrettified = null;
            }
        }
        return this.getDisplayName();
    }

    @Override
    public String getDisplayNameBase() {
        if (this.isFolder()) {
            return super.getDisplayNameBase();
        }
        if (this.renderer.getUmsConfiguration().isPrettifyFilenames() && this.getFormat() != null && this.getFormat().isVideo()) {
            return this.getBaseNamePrettified();
        }
        if (this.renderer.getUmsConfiguration().isHideExtensions()) {
            return this.getBaseNameWithoutExtension();
        }
        return super.getDisplayNameBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBaseNamePrettified(boolean isEpisodeWithinSeasonFolder, boolean isEpisodeWithinTVSeriesFolder) {
        Object object = this.displayNameBaseLock;
        synchronized (object) {
            if (this.baseNamePrettified == null) {
                MediaVideoMetadata videoMetadata = this.getMediaInfo() != null ? this.getMediaInfo().getVideoMetadata() : null;
                this.baseNamePrettified = FileUtil.getFileNamePrettified(super.getDisplayNameBase(), videoMetadata, isEpisodeWithinSeasonFolder, isEpisodeWithinTVSeriesFolder, this.file.getAbsolutePath(), this.lang);
            }
            return this.baseNamePrettified;
        }
    }

    protected String getBaseNamePrettified() {
        return this.getBaseNamePrettified(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseNameWithoutExtension() {
        Object object = this.displayNameBaseLock;
        synchronized (object) {
            if (this.baseNameWithoutExtension == null) {
                this.baseNameWithoutExtension = FileUtil.getFileNameWithoutExtension(super.getDisplayNameBase());
            }
            return this.baseNameWithoutExtension;
        }
    }

    public void setAddToMediaLibrary(boolean value) {
        this.addToMediaLibrary = value;
    }

    @Override
    public boolean isAddToMediaLibrary() {
        return this.addToMediaLibrary;
    }

    protected int getSplitTrack() {
        return this.splitTrack;
    }

    public void setSplitTrack(int splitTrack) {
        this.splitTrack = splitTrack;
    }

    @Override
    public File getSystemFile() {
        return this.getFile();
    }
}

