/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.pms.Messages;
import net.pms.iam.User;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserVirtualFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserVirtualFolder.class);
    private static final String JWT_SECRET = CONFIGURATION.getJwtSecret();

    public UserVirtualFolder(Renderer renderer, User user, boolean isLogOut) {
        super(renderer, isLogOut ? Messages.getString("LogOut") : user.getDisplayName(), null);
        String encrypted = UserVirtualFolder.encrypt(user.getId());
        this.setId((String)(isLogOut ? "$LogOut/" : "$LogIn/" + encrypted));
    }

    private static String encrypt(int value) {
        byte[] bytes = UserVirtualFolder.encryptor(ByteBuffer.allocate(4).putInt(value).array(), JWT_SECRET, false);
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static Integer decrypt(String value) {
        try {
            byte[] bytes = new byte[value.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                int index = i * 2;
                int val = Integer.parseInt(value.substring(index, index + 2), 16);
                bytes[i] = (byte)val;
            }
            byte[] decrypted = UserVirtualFolder.encryptor(bytes, JWT_SECRET, true);
            return ByteBuffer.wrap(decrypted).getInt();
        }
        catch (NumberFormatException | BufferUnderflowException e) {
            return null;
        }
    }

    private static byte[] encryptor(byte[] value, String secret, boolean decrypt) {
        try {
            byte[] key = secret.getBytes(StandardCharsets.UTF_8);
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            if (decrypt) {
                cipher.init(2, secretKey);
            } else {
                cipher.init(1, secretKey);
            }
            return cipher.doFinal(value);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.debug("Error while {}: {}", (Object)(decrypt ? "decrypting" : "encrypting"), (Object)e.toString());
            return new byte[0];
        }
    }
}

