/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.IOException;
import net.pms.database.MediaTableCoverArtArchive;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.media.MediaInfo;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.media.audio.metadata.MusicBrainzAlbum;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdMediaType;
import net.pms.store.DbIdTypeAndIdent;
import net.pms.store.container.VirtualFolderDbIdNamed;

public class MusicBrainzAlbumFolder
extends VirtualFolderDbIdNamed {
    public MusicBrainzAlbumFolder(Renderer renderer, String mbid) {
        super(renderer, null, MusicBrainzAlbumFolder.getTypeIdentForMbid(mbid));
        this.setParent(renderer.getMediaStore().getMediaLibrary());
    }

    public MusicBrainzAlbumFolder(Renderer renderer, MusicBrainzAlbum album) {
        this(renderer, album.getMbReleaseid(), album.getAlbum(), album.getMbReleaseid(), album.getAlbum(), album.getArtist(), album.getYear(), album.getGenre());
    }

    public MusicBrainzAlbumFolder(Renderer renderer, String mbid, String folderName, String mbReleaseid, String album, String artist, String year, String genre) {
        super(renderer, folderName, MusicBrainzAlbumFolder.getTypeIdentForMbid(mbid));
        MediaInfo fakeMediaInfo = new MediaInfo();
        MediaAudioMetadata fakeAudioMetadata = new MediaAudioMetadata();
        fakeAudioMetadata.setAlbum(album);
        fakeAudioMetadata.setArtist(artist);
        if (MusicBrainzAlbumFolder.extractYear(year) != null) {
            fakeAudioMetadata.setYear(MusicBrainzAlbumFolder.extractYear(year));
        }
        fakeAudioMetadata.setGenre(genre);
        fakeMediaInfo.setAudioMetadata(fakeAudioMetadata);
        this.setMediaInfo(fakeMediaInfo);
    }

    private static Integer extractYear(String year) {
        try {
            return Integer.valueOf(year);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        MediaTableCoverArtArchive.CoverArtArchiveResult res = MediaTableCoverArtArchive.findMBID(this.getMediaIdent());
        if (res.isFound()) {
            return DLNAThumbnailInputStream.toThumbnailInputStream(res.getCoverBytes());
        }
        return super.getThumbnailInputStream();
    }

    private static DbIdTypeAndIdent getTypeIdentForMbid(String mbid) {
        return new DbIdTypeAndIdent(DbIdMediaType.TYPE_MUSICBRAINZ_RECORDID, mbid);
    }
}

