/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import com.sun.jna.Platform;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.text.Normalizer;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.pms.Messages;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.item.RealFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xmlwise.Plist;

public class ITunesLibrary
extends LocalizedStoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ITunesLibrary.class);

    public ITunesLibrary(Renderer renderer) {
        super(renderer, "ItunesLibrary");
    }

    /*
     * WARNING - void declaration
     */
    public static ITunesLibrary getiTunesFolder(Renderer renderer, String path) {
        ITunesLibrary res = null;
        if (Platform.isMac() || Platform.isWindows()) {
            try {
                String iTunesFile = ITunesLibrary.getiTunesFile(path);
                if (iTunesFile != null && new File(iTunesFile).exists()) {
                    Map<String, Object> iTunesLib = Plist.load(URLDecoder.decode(iTunesFile, System.getProperty("file.encoding")));
                    Map tracks = (Map)iTunesLib.get("Tracks");
                    List playlists = (List)iTunesLib.get("Playlists");
                    res = new ITunesLibrary(renderer);
                    StoreContainer playlistsFolder = null;
                    for (Object item : playlists) {
                        int kind;
                        Map track;
                        List playlistTracks;
                        Map playlist = (Map)item;
                        if (playlist.containsKey("Visible") && playlist.get("Visible").equals(Boolean.FALSE)) continue;
                        if (playlist.containsKey("Music") && playlist.get("Music").equals(Boolean.TRUE)) {
                            StoreContainer musicFolder = new StoreContainer(renderer, playlist.get("Name").toString(), null);
                            res.addChild(musicFolder);
                            LocalizedStoreContainer virtualFolderArtists = new LocalizedStoreContainer(renderer, "BrowseByArtist");
                            LocalizedStoreContainer virtualFolderAlbums = new LocalizedStoreContainer(renderer, "BrowseByAlbum");
                            LocalizedStoreContainer virtualFolderGenres = new LocalizedStoreContainer(renderer, "BrowseByGenre");
                            LocalizedStoreContainer virtualFolderAllTracks = new LocalizedStoreContainer(renderer, "AllAudioTracks");
                            playlistTracks = (List)playlist.get("Playlist Items");
                            if (playlistTracks != null) {
                                for (Object t : playlistTracks) {
                                    void var33_35;
                                    void var33_41;
                                    StoreContainer individualArtistAllTracksFolder;
                                    Map td = (Map)t;
                                    track = (Map)tracks.get(td.get("Track ID").toString());
                                    if (track == null || track.get("Location") == null || !track.get("Location").toString().startsWith("file://")) continue;
                                    Object name = Normalizer.normalize((String)track.get("Name"), Normalizer.Form.NFC);
                                    name = ((String)name).replace('.', '-');
                                    if (track.containsKey("Protected") && track.get("Protected").equals(Boolean.TRUE)) {
                                        name = (String)name + "-" + Messages.getString("Protected_lowercase");
                                    }
                                    boolean isCompilation = track.containsKey("Compilation") && track.get("Compilation").equals(Boolean.TRUE);
                                    String artistName = (String)track.get("Artist");
                                    if (isCompilation) {
                                        artistName = "Compilation";
                                    } else if (track.containsKey("Album Artist")) {
                                        artistName = (String)track.get("Album Artist");
                                    }
                                    Object albumName = (String)track.get("Album");
                                    String genreName = (String)track.get("Genre");
                                    artistName = artistName == null ? "Unknown Artist" : Normalizer.normalize(artistName, Normalizer.Form.NFC);
                                    albumName = albumName == null ? "Unknown Album" : Normalizer.normalize((CharSequence)albumName, Normalizer.Form.NFC);
                                    genreName = genreName == null || "".equals(genreName.replaceAll("[^a-zA-Z]", "")) ? "Unknown Genre" : Normalizer.normalize(genreName, Normalizer.Form.NFC);
                                    artistName = artistName.replace('\u0160', ' ').trim();
                                    albumName = ((String)albumName).replace('\u0160', ' ').trim();
                                    genreName = genreName.replace('\u0160', ' ').trim();
                                    URI tURI2 = new URI(track.get("Location").toString());
                                    File refFile = new File(URLDecoder.decode(tURI2.toURL().getFile(), StandardCharsets.UTF_8));
                                    RealFile file = new RealFile(renderer, refFile, (String)name);
                                    StoreContainer individualArtistFolder = null;
                                    StoreContainer individualArtistAlbumFolder = null;
                                    for (StoreResource storeResource : virtualFolderArtists.getChildren()) {
                                        if (!ITunesLibrary.areNamesEqual(storeResource.getName(), artistName)) continue;
                                        individualArtistFolder = (StoreContainer)storeResource;
                                        for (StoreResource album : individualArtistFolder.getChildren()) {
                                            if (!ITunesLibrary.areNamesEqual(album.getName(), (String)albumName)) continue;
                                            individualArtistAlbumFolder = (StoreContainer)album;
                                        }
                                    }
                                    if (individualArtistFolder == null) {
                                        individualArtistFolder = new StoreContainer(renderer, artistName, null);
                                        virtualFolderArtists.addChild(individualArtistFolder);
                                        individualArtistAllTracksFolder = new LocalizedStoreContainer(renderer, "AllAudioTracks");
                                        individualArtistFolder.addChild(individualArtistAllTracksFolder);
                                    } else {
                                        individualArtistAllTracksFolder = (StoreContainer)individualArtistFolder.getChildren().get(0);
                                    }
                                    if (individualArtistAlbumFolder == null) {
                                        individualArtistAlbumFolder = new StoreContainer(renderer, (String)albumName, null);
                                        individualArtistFolder.addChild(individualArtistAlbumFolder);
                                    }
                                    individualArtistAlbumFolder.addChild(file.clone());
                                    individualArtistAllTracksFolder.addChild(file);
                                    if (!isCompilation) {
                                        albumName = (String)albumName + " - " + artistName;
                                    }
                                    StoreContainer individualAlbumFolder = null;
                                    for (StoreResource album : virtualFolderAlbums.getChildren()) {
                                        if (!ITunesLibrary.areNamesEqual(album.getName(), (String)albumName)) continue;
                                        individualAlbumFolder = (StoreContainer)album;
                                        break;
                                    }
                                    if (individualAlbumFolder == null) {
                                        individualAlbumFolder = new StoreContainer(renderer, (String)albumName, null);
                                        virtualFolderAlbums.addChild(individualAlbumFolder);
                                    }
                                    individualAlbumFolder.addChild(file.clone());
                                    Object var33_39 = null;
                                    for (StoreResource genre : virtualFolderGenres.getChildren()) {
                                        if (!ITunesLibrary.areNamesEqual(genre.getName(), genreName)) continue;
                                        StoreContainer storeContainer = (StoreContainer)genre;
                                        break;
                                    }
                                    if (var33_41 == null) {
                                        StoreContainer storeContainer = new StoreContainer(renderer, genreName, null);
                                        virtualFolderGenres.addChild(storeContainer);
                                    }
                                    var33_35.addChild(file.clone());
                                    virtualFolderAllTracks.addChild(file.clone());
                                }
                            }
                            musicFolder.addChild(virtualFolderArtists);
                            musicFolder.addChild(virtualFolderAlbums);
                            musicFolder.addChild(virtualFolderGenres);
                            musicFolder.addChild(virtualFolderAllTracks);
                            Collections.sort(virtualFolderArtists.getChildren(), (o1, o2) -> {
                                StoreContainer a = (StoreContainer)o1;
                                StoreContainer b = (StoreContainer)o2;
                                return a.getName().compareToIgnoreCase(b.getName());
                            });
                            Collections.sort(virtualFolderAlbums.getChildren(), (o1, o2) -> {
                                StoreContainer a = (StoreContainer)o1;
                                StoreContainer b = (StoreContainer)o2;
                                return a.getName().compareToIgnoreCase(b.getName());
                            });
                            Collections.sort(virtualFolderGenres.getChildren(), (o1, o2) -> {
                                StoreContainer a = (StoreContainer)o1;
                                StoreContainer b = (StoreContainer)o2;
                                return a.getName().compareToIgnoreCase(b.getName());
                            });
                            continue;
                        }
                        StoreContainer pf = new StoreContainer(renderer, playlist.get("Name").toString(), null);
                        playlistTracks = (List)playlist.get("Playlist Items");
                        if (playlistTracks != null) {
                            for (Object t : playlistTracks) {
                                Map td = (Map)t;
                                track = (Map)tracks.get(td.get("Track ID").toString());
                                if (track == null || track.get("Location") == null || !track.get("Location").toString().startsWith("file://")) continue;
                                Object name = Normalizer.normalize(track.get("Name").toString(), Normalizer.Form.NFC);
                                name = ((String)name).replace('.', '-');
                                if (track.containsKey("Protected") && track.get("Protected").equals(Boolean.TRUE)) {
                                    name = (String)name + "-" + Messages.getString("Protected_lowercase");
                                }
                                URI tURI2 = new URI(track.get("Location").toString());
                                RealFile file = new RealFile(renderer, new File(URLDecoder.decode(tURI2.toURL().getFile(), StandardCharsets.UTF_8)), (String)name);
                                pf.addChild(file);
                            }
                        }
                        int n = kind = playlist.containsKey("Distinguished Kind") ? ((Number)playlist.get("Distinguished Kind")).intValue() : -1;
                        if (kind >= 0 && kind != 17 && kind != 19 && kind != 20) {
                            res.addChild(pf);
                            continue;
                        }
                        if (playlistsFolder == null) {
                            playlistsFolder = new StoreContainer(renderer, "Playlists", null);
                            res.addChild(playlistsFolder);
                        }
                        playlistsFolder.addChild(pf);
                    }
                } else {
                    LOGGER.info("Could not find the iTunes file");
                }
            }
            catch (Exception e) {
                LOGGER.error("Something went wrong with the iTunes Library scan: ", e);
            }
        }
        return res;
    }

    private static String getiTunesFile(String path) throws Exception {
        if (StringUtils.isNotBlank(path)) {
            return path;
        }
        return PlatformUtils.INSTANCE.getiTunesFile();
    }

    private static boolean areNamesEqual(String aThis, String aThat) {
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(0);
        int comparison = collator.compare(aThis, aThat);
        return comparison == 0;
    }
}

